/*
 * Decompiled with CFR 0.152.
 */
package net.java.sip.communicator.plugin.desktoputil;

import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.FlowLayout;
import java.awt.GridLayout;
import java.awt.Toolkit;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.KeyEvent;
import java.awt.event.KeyListener;
import javax.swing.BorderFactory;
import javax.swing.Box;
import javax.swing.BoxLayout;
import javax.swing.JButton;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.JPasswordField;
import javax.swing.JProgressBar;
import javax.swing.JTextArea;
import net.java.sip.communicator.plugin.desktoputil.DesktopUtilActivator;
import net.java.sip.communicator.plugin.desktoputil.SIPCommDialog;
import net.java.sip.communicator.plugin.desktoputil.TransparentPanel;
import net.java.sip.communicator.util.PasswordQualityMeter;
import org.jitsi.service.resources.ResourceManagementService;

public class PasswordChangeDialog
extends SIPCommDialog
implements KeyListener {
    private static final long serialVersionUID = 0L;
    protected final ResourceManagementService resources = DesktopUtilActivator.getResources();
    private PasswordQualityMeter passwordMeter = new PasswordQualityMeter();
    private boolean showCurrentPassword = false;
    private JPasswordField currentPasswdField;
    private JPasswordField newPasswordField;
    private JPasswordField newAgainPasswordField;
    private JButton okButton;
    private JButton cancelButton;
    private JTextArea infoTextArea;
    private JProgressBar passwordQualityBar;
    private JPanel textFieldsPanel;
    private JPanel labelsPanel;
    private JPanel buttonsPanel;
    private JPanel qualityPanel;
    private JPanel dataPanel;

    public PasswordChangeDialog() {
        this(false);
    }

    public PasswordChangeDialog(boolean showCurrentPassword) {
        super(false);
        this.showCurrentPassword = showCurrentPassword;
        this.initComponents();
        this.setTitle(this.resources.getI18NString("service.gui.CHANGE_PASSWORD"));
        this.setResizable(false);
        JPanel mainPanel = new JPanel(new BorderLayout(10, 10));
        mainPanel.setBorder(BorderFactory.createEmptyBorder(10, 10, 10, 10));
        mainPanel.add(PasswordChangeDialog.createIconComponent(), "West");
        mainPanel.add(this.dataPanel);
        this.getContentPane().add(mainPanel);
        this.pack();
        Toolkit toolkit = Toolkit.getDefaultToolkit();
        Dimension screenSize = toolkit.getScreenSize();
        int x = (screenSize.width - this.getWidth()) / 2;
        int y = (screenSize.height - this.getHeight()) / 2;
        this.setLocation(x, y);
        if (showCurrentPassword) {
            this.currentPasswdField.requestFocusInWindow();
        } else {
            this.newPasswordField.requestFocusInWindow();
        }
    }

    private void initComponents() {
        this.dataPanel = new TransparentPanel(new BorderLayout(10, 10));
        this.dataPanel.setBorder(BorderFactory.createEmptyBorder(0, 8, 0, 8));
        this.infoTextArea = new JTextArea();
        this.infoTextArea.setEditable(false);
        this.infoTextArea.setOpaque(false);
        this.infoTextArea.setLineWrap(true);
        this.infoTextArea.setWrapStyleWord(true);
        this.infoTextArea.setFont(this.infoTextArea.getFont().deriveFont(1));
        this.infoTextArea.setText(this.resources.getI18NString("service.gui.CHANGE_PASSWORD"));
        this.labelsPanel = new TransparentPanel(new GridLayout(0, 1, 8, 8));
        if (this.showCurrentPassword) {
            this.labelsPanel.add(new JLabel(this.resources.getI18NString("plugin.securityconfig.masterpassword.CURRENT_PASSWORD")));
        }
        this.labelsPanel.add(new JLabel(this.resources.getI18NString("plugin.securityconfig.masterpassword.ENTER_PASSWORD")));
        this.labelsPanel.add(new JLabel(this.resources.getI18NString("plugin.securityconfig.masterpassword.REENTER_PASSWORD")));
        ActionListener clickOkButton = new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                if (PasswordChangeDialog.this.okButton.isEnabled()) {
                    PasswordChangeDialog.this.okButton.doClick();
                }
            }
        };
        if (this.showCurrentPassword) {
            this.currentPasswdField = new JPasswordField(15);
            this.currentPasswdField.addActionListener(clickOkButton);
        }
        this.newPasswordField = new JPasswordField(15);
        this.newPasswordField.addKeyListener(this);
        this.newPasswordField.addActionListener(clickOkButton);
        this.newAgainPasswordField = new JPasswordField(15);
        this.newAgainPasswordField.addKeyListener(this);
        this.newAgainPasswordField.addActionListener(clickOkButton);
        this.textFieldsPanel = new TransparentPanel(new GridLayout(0, 1, 8, 8));
        if (this.showCurrentPassword) {
            this.textFieldsPanel.add(this.currentPasswdField);
        }
        this.textFieldsPanel.add(this.newPasswordField);
        this.textFieldsPanel.add(this.newAgainPasswordField);
        this.okButton = new JButton(this.resources.getI18NString("service.gui.OK"));
        this.okButton.setMnemonic(this.resources.getI18nMnemonic("service.gui.OK"));
        this.okButton.setEnabled(false);
        this.cancelButton = new JButton(this.resources.getI18NString("service.gui.CANCEL"));
        this.cancelButton.setMnemonic(this.resources.getI18nMnemonic("service.gui.CANCEL"));
        this.cancelButton.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                PasswordChangeDialog.this.dispose();
            }
        });
        this.passwordQualityBar = new JProgressBar(0, 42);
        this.passwordQualityBar.setValue(0);
        this.qualityPanel = new TransparentPanel();
        this.qualityPanel.setLayout(new BoxLayout(this.qualityPanel, 1));
        JLabel qualityMeterLabel = new JLabel(this.resources.getI18NString("plugin.securityconfig.masterpassword.PASSWORD_QUALITY_METER"));
        qualityMeterLabel.setAlignmentX(0.5f);
        this.qualityPanel.add(qualityMeterLabel);
        this.qualityPanel.add(this.passwordQualityBar);
        this.qualityPanel.add(Box.createVerticalStrut(15));
        this.buttonsPanel = new TransparentPanel(new FlowLayout(2, 0, 5));
        this.buttonsPanel.add(this.okButton);
        this.buttonsPanel.add(this.cancelButton);
        this.qualityPanel.add(this.buttonsPanel);
        this.dataPanel.add((Component)this.infoTextArea, "North");
        this.dataPanel.add((Component)this.labelsPanel, "West");
        this.dataPanel.add((Component)this.textFieldsPanel, "Center");
        this.dataPanel.add((Component)this.qualityPanel, "South");
    }

    protected void displayPopupError(String message) {
        DesktopUtilActivator.getUIService().getPopupDialog().showMessagePopupDialog((Object)message, this.resources.getI18NString("service.gui.PASSWORD_CHANGE_FAILURE"), 0);
    }

    protected void displayPopupInfo(String message) {
        DesktopUtilActivator.getUIService().getPopupDialog().showMessagePopupDialog((Object)message, this.resources.getI18NString("service.gui.PASSWORD_CHANGE_SUCCESS"), 1);
    }

    @Override
    protected void close(boolean isEscaped) {
        this.cancelButton.doClick();
    }

    @Override
    public void keyReleased(KeyEvent event) {
        JPasswordField source = (JPasswordField)event.getSource();
        if (this.newPasswordField.equals(source) || this.newAgainPasswordField.equals(source)) {
            String password1 = new String(this.newPasswordField.getPassword());
            String password2 = new String(this.newAgainPasswordField.getPassword());
            this.passwordQualityBar.setValue(this.passwordMeter.assessPassword(password1));
            boolean eq = password1.length() != 0 && password1.equals(password2);
            this.okButton.setEnabled(eq);
            password1 = null;
            password2 = null;
        }
    }

    @Override
    public void keyPressed(KeyEvent arg0) {
    }

    @Override
    public void keyTyped(KeyEvent arg0) {
    }

    private static Component createIconComponent() {
        JPanel wrapIconPanel = new JPanel(new BorderLayout());
        JLabel iconLabel = new JLabel();
        iconLabel.setIcon(DesktopUtilActivator.getResources().getImage("service.gui.icons.AUTHORIZATION_ICON"));
        wrapIconPanel.add((Component)iconLabel, "North");
        return wrapIconPanel;
    }

    protected JButton getOkButton() {
        return this.okButton;
    }

    protected JButton getCancelButton() {
        return this.cancelButton;
    }

    protected String getNewPassword() {
        return new String(this.newPasswordField.getPassword());
    }

    protected String getCurrentPassword() {
        if (this.currentPasswdField == null) {
            return null;
        }
        return new String(this.currentPasswdField.getPassword());
    }

    protected void setInfoText(String infoText) {
        this.infoTextArea.setText(infoText);
    }
}

