/*
 * Decompiled with CFR 0.152.
 */
package net.java.sip.communicator.plugin.otr.authdialog;

import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.Container;
import java.awt.Dimension;
import java.awt.FlowLayout;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.GridLayout;
import java.awt.Insets;
import java.awt.LayoutManager;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.util.List;
import javax.swing.BorderFactory;
import javax.swing.BoxLayout;
import javax.swing.JButton;
import javax.swing.JCheckBox;
import javax.swing.JComboBox;
import javax.swing.JComponent;
import javax.swing.JLabel;
import javax.swing.JTextField;
import net.java.otr4j.OtrPolicy;
import net.java.sip.communicator.plugin.desktoputil.SIPCommCheckBox;
import net.java.sip.communicator.plugin.desktoputil.TransparentPanel;
import net.java.sip.communicator.plugin.otr.OtrActivator;
import net.java.sip.communicator.plugin.otr.authdialog.KnownFingerprintsPanel;
import net.java.sip.communicator.service.protocol.AccountID;

public class OtrConfigurationPanel
extends TransparentPanel {
    public OtrConfigurationPanel() {
        this.initComponents();
    }

    private void initComponents() {
        this.setLayout(new GridBagLayout());
        GridBagConstraints c = new GridBagConstraints();
        c.fill = 2;
        c.weightx = 1.0;
        c.insets = new Insets(0, 0, 10, 0);
        c.anchor = 19;
        PrivateKeysPanel pnlPrivateKeys = new PrivateKeysPanel();
        c.gridy = 0;
        this.add((Component)((Object)pnlPrivateKeys), c);
        KnownFingerprintsPanel pnlFingerprints = new KnownFingerprintsPanel();
        ((JComponent)((Object)pnlFingerprints)).setMinimumSize(new Dimension(Short.MAX_VALUE, 160));
        c.weighty = 1.0;
        c.gridy = 1;
        this.add((Component)((Object)pnlFingerprints), c);
        DefaultOtrPolicyPanel pnlPolicy = new DefaultOtrPolicyPanel();
        c.gridy = 2;
        this.add((Component)((Object)pnlPolicy), c);
    }

    private static class DefaultOtrPolicyPanel
    extends TransparentPanel {
        private SIPCommCheckBox cbEnable;
        private SIPCommCheckBox cbAutoInitiate;
        private SIPCommCheckBox cbRequireOtr;

        public DefaultOtrPolicyPanel() {
            this.initComponents();
            this.loadPolicy();
        }

        public void loadPolicy() {
            OtrPolicy otrPolicy = OtrActivator.scOtrEngine.getGlobalPolicy();
            boolean otrEnabled = otrPolicy.getEnableManual();
            this.cbEnable.setSelected(otrEnabled);
            this.cbAutoInitiate.setEnabled(otrEnabled);
            this.cbRequireOtr.setEnabled(otrEnabled);
            boolean isAutoInit = otrPolicy.getEnableAlways();
            this.cbAutoInitiate.setSelected(isAutoInit);
            String otrMandatoryPropValue = OtrActivator.configService.getString("net.java.sip.communicator.plugin.otr.PRIVATE_MESSAGING_MANDATORY");
            String defaultOtrPropValue = OtrActivator.resourceService.getSettingsString("net.java.sip.communicator.plugin.otr.PRIVATE_MESSAGING_MANDATORY");
            boolean isMandatory = otrPolicy.getRequireEncryption();
            if (otrMandatoryPropValue != null) {
                isMandatory = Boolean.parseBoolean(otrMandatoryPropValue);
            } else if (!isMandatory && defaultOtrPropValue != null) {
                isMandatory = Boolean.parseBoolean(defaultOtrPropValue);
            }
            this.cbRequireOtr.setSelected(isMandatory);
        }

        private void initComponents() {
            this.setLayout(new BoxLayout((Container)((Object)this), 1));
            this.cbEnable = new SIPCommCheckBox(OtrActivator.resourceService.getI18NString("plugin.otr.configform.CB_ENABLE"));
            this.cbEnable.addActionListener(new ActionListener(){

                @Override
                public void actionPerformed(ActionEvent e) {
                    OtrPolicy otrPolicy = OtrActivator.scOtrEngine.getGlobalPolicy();
                    otrPolicy.setEnableManual(((JCheckBox)e.getSource()).isSelected());
                    OtrActivator.scOtrEngine.setGlobalPolicy(otrPolicy);
                    DefaultOtrPolicyPanel.this.loadPolicy();
                }
            });
            this.add((Component)this.cbEnable);
            this.cbAutoInitiate = new SIPCommCheckBox(OtrActivator.resourceService.getI18NString("plugin.otr.configform.CB_AUTO"));
            this.cbAutoInitiate.addActionListener(new ActionListener(){

                @Override
                public void actionPerformed(ActionEvent e) {
                    OtrPolicy otrPolicy = OtrActivator.scOtrEngine.getGlobalPolicy();
                    boolean isAutoInit = ((JCheckBox)e.getSource()).isSelected();
                    otrPolicy.setSendWhitespaceTag(isAutoInit);
                    OtrActivator.scOtrEngine.setGlobalPolicy(otrPolicy);
                    DefaultOtrPolicyPanel.this.loadPolicy();
                }
            });
            this.add((Component)this.cbAutoInitiate);
            this.cbRequireOtr = new SIPCommCheckBox(OtrActivator.resourceService.getI18NString("plugin.otr.configform.CB_REQUIRE"));
            this.cbRequireOtr.addActionListener(new ActionListener(){

                @Override
                public void actionPerformed(ActionEvent e) {
                    OtrPolicy otrPolicy = OtrActivator.scOtrEngine.getGlobalPolicy();
                    boolean isRequired = ((JCheckBox)e.getSource()).isSelected();
                    otrPolicy.setRequireEncryption(isRequired);
                    OtrActivator.configService.setProperty("net.java.sip.communicator.plugin.otr.PRIVATE_MESSAGING_MANDATORY", (Object)Boolean.toString(isRequired));
                    OtrActivator.scOtrEngine.setGlobalPolicy(otrPolicy);
                    DefaultOtrPolicyPanel.this.loadPolicy();
                }
            });
            this.add((Component)this.cbRequireOtr);
        }
    }

    private static class PrivateKeysPanel
    extends TransparentPanel {
        private AccountsComboBox cbAccounts;
        private JTextField lblFingerprint;
        private JButton btnGenerate;

        public PrivateKeysPanel() {
            super((LayoutManager)new BorderLayout());
            this.initComponents();
            this.openAccount(this.cbAccounts.getSelectedAccountID());
        }

        private void openAccount(AccountID account) {
            if (account == null) {
                this.lblFingerprint.setEnabled(false);
                this.btnGenerate.setEnabled(false);
                this.lblFingerprint.setText(OtrActivator.resourceService.getI18NString("plugin.otr.configform.NO_KEY_PRESENT"));
                this.btnGenerate.setText(OtrActivator.resourceService.getI18NString("plugin.otr.configform.GENERATE"));
            } else {
                this.lblFingerprint.setEnabled(true);
                this.btnGenerate.setEnabled(true);
                String fingerprint = OtrActivator.scOtrKeyManager.getLocalFingerprint(account);
                if (fingerprint == null || fingerprint.length() < 1) {
                    this.lblFingerprint.setText(OtrActivator.resourceService.getI18NString("plugin.otr.configform.NO_KEY_PRESENT"));
                    this.btnGenerate.setText(OtrActivator.resourceService.getI18NString("plugin.otr.configform.GENERATE"));
                } else {
                    this.lblFingerprint.setText(fingerprint);
                    this.btnGenerate.setText(OtrActivator.resourceService.getI18NString("plugin.otr.configform.REGENERATE"));
                }
            }
        }

        private void initComponents() {
            this.setBorder(BorderFactory.createTitledBorder(BorderFactory.createEtchedBorder(1), OtrActivator.resourceService.getI18NString("plugin.otr.configform.MY_PRIVATE_KEYS")));
            TransparentPanel labelsPanel = new TransparentPanel((LayoutManager)new GridLayout(0, 1));
            labelsPanel.add(new JLabel(OtrActivator.resourceService.getI18NString("service.gui.ACCOUNT") + ": "));
            labelsPanel.add(new JLabel(OtrActivator.resourceService.getI18NString("plugin.otr.configform.FINGERPRINT") + ": "));
            TransparentPanel valuesPanel = new TransparentPanel((LayoutManager)new GridLayout(0, 1));
            this.cbAccounts = new AccountsComboBox();
            this.cbAccounts.addActionListener(new ActionListener(){

                @Override
                public void actionPerformed(ActionEvent e) {
                    PrivateKeysPanel.this.openAccount(((AccountsComboBox)e.getSource()).getSelectedAccountID());
                }
            });
            valuesPanel.add(this.cbAccounts);
            this.lblFingerprint = new JTextField();
            this.lblFingerprint.setEditable(false);
            this.lblFingerprint.setOpaque(false);
            this.lblFingerprint.setBorder(BorderFactory.createEmptyBorder());
            valuesPanel.add(this.lblFingerprint);
            TransparentPanel buttonPanel = new TransparentPanel((LayoutManager)new FlowLayout(3, 0, 0));
            this.btnGenerate = new JButton();
            buttonPanel.add(this.btnGenerate);
            this.btnGenerate.addActionListener(new ActionListener(){

                @Override
                public void actionPerformed(ActionEvent e) {
                    AccountID account = PrivateKeysPanel.this.cbAccounts.getSelectedAccountID();
                    if (account == null) {
                        return;
                    }
                    OtrActivator.scOtrKeyManager.generateKeyPair(account);
                    PrivateKeysPanel.this.openAccount(account);
                }
            });
            this.add((Component)labelsPanel, "West");
            this.add((Component)valuesPanel, "Center");
            this.add((Component)buttonPanel, "East");
        }

        private static class AccountsComboBox
        extends JComboBox {
            public AccountsComboBox() {
                List<AccountID> accountIDs = OtrActivator.getAllAccountIDs();
                if (accountIDs == null) {
                    return;
                }
                for (AccountID accountID : accountIDs) {
                    this.addItem(new AccountsComboBoxItem(accountID));
                }
            }

            public AccountID getSelectedAccountID() {
                Object selectedItem = this.getSelectedItem();
                if (selectedItem instanceof AccountsComboBoxItem) {
                    return ((AccountsComboBoxItem)selectedItem).accountID;
                }
                return null;
            }

            private static class AccountsComboBoxItem {
                public final AccountID accountID;

                public AccountsComboBoxItem(AccountID accountID) {
                    this.accountID = accountID;
                }

                public String toString() {
                    return this.accountID.getDisplayName();
                }
            }
        }
    }
}

