/*
 * Decompiled with CFR 0.152.
 */
package net.java.sip.communicator.plugin.otr.authdialog;

import java.awt.CardLayout;
import java.awt.Component;
import java.awt.Container;
import java.awt.Dimension;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.Insets;
import java.awt.LayoutManager;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.ItemEvent;
import java.awt.event.ItemListener;
import java.security.PublicKey;
import javax.swing.BorderFactory;
import javax.swing.Box;
import javax.swing.BoxLayout;
import javax.swing.JButton;
import javax.swing.JComboBox;
import javax.swing.JLabel;
import javax.swing.JPanel;
import net.java.sip.communicator.plugin.desktoputil.SIPCommDialog;
import net.java.sip.communicator.plugin.desktoputil.TransparentPanel;
import net.java.sip.communicator.plugin.otr.OtrActivator;
import net.java.sip.communicator.plugin.otr.OtrContactManager;
import net.java.sip.communicator.plugin.otr.authdialog.CustomTextArea;
import net.java.sip.communicator.plugin.otr.authdialog.FingerprintAuthenticationPanel;
import net.java.sip.communicator.plugin.otr.authdialog.SecretQuestionAuthenticationPanel;
import net.java.sip.communicator.plugin.otr.authdialog.SharedSecretAuthenticationPanel;

public class OtrBuddyAuthenticationDialog
extends SIPCommDialog {
    private final OtrContactManager.OtrContact contact;

    public OtrBuddyAuthenticationDialog(OtrContactManager.OtrContact contact) {
        super(false);
        this.contact = contact;
        this.initComponents();
    }

    private void initComponents() {
        this.setTitle(OtrActivator.resourceService.getI18NString("plugin.otr.authbuddydialog.TITLE"));
        TransparentPanel mainPanel = new TransparentPanel();
        mainPanel.setLayout((LayoutManager)new BoxLayout((Container)mainPanel, 1));
        mainPanel.setBorder(BorderFactory.createEmptyBorder(10, 10, 10, 10));
        mainPanel.setPreferredSize(new Dimension(350, 400));
        CustomTextArea generalInformation = new CustomTextArea();
        generalInformation.setText(OtrActivator.resourceService.getI18NString("plugin.otr.authbuddydialog.AUTHENTICATION_INFO"));
        mainPanel.add((Component)generalInformation);
        mainPanel.add(Box.createVerticalStrut(10));
        final String[] am = new String[]{OtrActivator.resourceService.getI18NString("plugin.otr.authbuddydialog.AUTHENTICATION_METHOD_QUESTION"), OtrActivator.resourceService.getI18NString("plugin.otr.authbuddydialog.AUTHENTICATION_METHOD_SECRET"), OtrActivator.resourceService.getI18NString("plugin.otr.authbuddydialog.AUTHENTICATION_METHOD_FINGERPRINT")};
        final JComboBox<String> authenticationMethodComboBox = new JComboBox<String>(am);
        CustomTextArea authMethodLabel = new CustomTextArea();
        authMethodLabel.setText(OtrActivator.resourceService.getI18NString("plugin.otr.authbuddydialog.AUTHENTICATION_METHOD"));
        mainPanel.add((Component)authMethodLabel);
        mainPanel.add(authenticationMethodComboBox);
        mainPanel.add(Box.createVerticalStrut(10));
        TransparentPanel authenticationPanel = new TransparentPanel((LayoutManager)new CardLayout());
        final FingerprintAuthenticationPanel fingerprintPanel = new FingerprintAuthenticationPanel(this.contact);
        final SecretQuestionAuthenticationPanel secretQuestionPanel = new SecretQuestionAuthenticationPanel();
        final SharedSecretAuthenticationPanel sharedSecretPanel = new SharedSecretAuthenticationPanel();
        authenticationPanel.add((Component)((Object)secretQuestionPanel), am[0]);
        authenticationPanel.add((Component)((Object)sharedSecretPanel), am[1]);
        authenticationPanel.add((Component)((Object)fingerprintPanel), am[2]);
        authenticationMethodComboBox.addItemListener(new ItemListener((JPanel)authenticationPanel){
            final /* synthetic */ JPanel val$authenticationPanel;
            {
                this.val$authenticationPanel = jPanel;
            }

            @Override
            public void itemStateChanged(ItemEvent e) {
                if (e.getStateChange() == 1) {
                    CardLayout cl = (CardLayout)this.val$authenticationPanel.getLayout();
                    cl.show(this.val$authenticationPanel, (String)e.getItem());
                }
            }
        });
        authenticationMethodComboBox.setSelectedIndex(0);
        mainPanel.add((Component)authenticationPanel);
        GridBagConstraints c = new GridBagConstraints();
        c.insets = new Insets(5, 5, 5, 5);
        c.weightx = 1.0;
        c.gridwidth = 1;
        TransparentPanel buttonPanel = new TransparentPanel((LayoutManager)new GridBagLayout());
        buttonPanel.setBorder(BorderFactory.createEmptyBorder(0, 5, 5, 5));
        JButton helpButton = new JButton(OtrActivator.resourceService.getI18NString("plugin.otr.authbuddydialog.HELP"));
        helpButton.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent arg0) {
                OtrActivator.scOtrEngine.launchHelp();
            }
        });
        buttonPanel.add((Component)helpButton, c);
        c.weightx = 1.0;
        buttonPanel.add((Component)new JLabel(), c);
        c.weightx = 0.0;
        JButton cancelButton = new JButton(OtrActivator.resourceService.getI18NString("plugin.otr.authbuddydialog.CANCEL"));
        cancelButton.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                OtrBuddyAuthenticationDialog.this.dispose();
            }
        });
        buttonPanel.add((Component)cancelButton, c);
        JButton authenticateButton = new JButton(OtrActivator.resourceService.getI18NString("plugin.otr.authbuddydialog.AUTHENTICATE_BUDDY"));
        authenticateButton.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                String authenticationMethod = (String)authenticationMethodComboBox.getSelectedItem();
                if (authenticationMethod.equals(am[0])) {
                    String secret = secretQuestionPanel.getSecret();
                    String question = secretQuestionPanel.getQuestion();
                    OtrActivator.scOtrEngine.initSmp(OtrBuddyAuthenticationDialog.this.contact, question, secret);
                    OtrBuddyAuthenticationDialog.this.dispose();
                } else if (authenticationMethod.equals(am[1])) {
                    String secret = sharedSecretPanel.getSecret();
                    String question = null;
                    OtrActivator.scOtrEngine.initSmp(OtrBuddyAuthenticationDialog.this.contact, question, secret);
                    OtrBuddyAuthenticationDialog.this.dispose();
                } else if (authenticationMethod.equals(am[2])) {
                    FingerprintAuthenticationPanel.ActionComboBoxItem actionItem = (FingerprintAuthenticationPanel.ActionComboBoxItem)fingerprintPanel.getCbAction().getSelectedItem();
                    PublicKey pubKey = OtrActivator.scOtrEngine.getRemotePublicKey(OtrBuddyAuthenticationDialog.this.contact);
                    String fingerprint = OtrActivator.scOtrKeyManager.getFingerprintFromPublicKey(pubKey);
                    switch (actionItem.action) {
                        case I_HAVE: {
                            OtrActivator.scOtrKeyManager.verify(OtrBuddyAuthenticationDialog.this.contact, fingerprint);
                            break;
                        }
                        case I_HAVE_NOT: {
                            OtrActivator.scOtrKeyManager.unverify(OtrBuddyAuthenticationDialog.this.contact, fingerprint);
                        }
                    }
                    OtrBuddyAuthenticationDialog.this.dispose();
                }
            }
        });
        buttonPanel.add((Component)authenticateButton, c);
        this.getContentPane().add((Component)mainPanel, "North");
        this.getContentPane().add((Component)buttonPanel, "South");
        this.pack();
    }
}

