/*
 * Decompiled with CFR 0.152.
 */
package net.java.sip.communicator.plugin.otr.authdialog;

import java.awt.AlphaComposite;
import java.awt.Dimension;
import java.awt.Graphics;
import java.awt.Graphics2D;
import java.awt.Image;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.image.ImageObserver;
import java.io.IOException;
import java.security.PublicKey;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import javax.imageio.ImageIO;
import javax.swing.ButtonGroup;
import javax.swing.Icon;
import javax.swing.ImageIcon;
import javax.swing.JMenu;
import javax.swing.JMenuItem;
import javax.swing.JRadioButtonMenuItem;
import javax.swing.Timer;
import net.java.otr4j.session.Session;
import net.java.sip.communicator.plugin.desktoputil.SIPCommMenu;
import net.java.sip.communicator.plugin.desktoputil.SIPCommMenuBar;
import net.java.sip.communicator.plugin.desktoputil.SelectedObject;
import net.java.sip.communicator.plugin.otr.OtrActivator;
import net.java.sip.communicator.plugin.otr.OtrContactManager;
import net.java.sip.communicator.plugin.otr.OtrWeakListener;
import net.java.sip.communicator.plugin.otr.ScOtrEngineListener;
import net.java.sip.communicator.plugin.otr.ScOtrKeyManagerListener;
import net.java.sip.communicator.service.contactlist.MetaContact;
import net.java.sip.communicator.service.contactlist.MetaContactGroup;
import net.java.sip.communicator.service.gui.Container;
import net.java.sip.communicator.service.gui.PluginComponent;
import net.java.sip.communicator.service.gui.PluginComponentFactory;
import net.java.sip.communicator.service.protocol.AccountID;
import net.java.sip.communicator.service.protocol.Contact;
import net.java.sip.communicator.service.protocol.ContactResource;
import net.java.sip.communicator.util.Logger;

public class OTRv3OutgoingSessionSwitcher
extends SIPCommMenuBar
implements PluginComponent,
ActionListener,
ScOtrEngineListener,
ScOtrKeyManagerListener {
    private static final Logger logger = Logger.getLogger(OTRv3OutgoingSessionSwitcher.class);
    private final PluginComponentFactory parentFactory;
    private static final long serialVersionUID = 0L;
    private final SelectorMenu menu = new SelectorMenu();
    private ButtonGroup buttonGroup = new ButtonGroup();
    private OtrContactManager.OtrContact contact;
    private final Map<Session, JMenuItem> outgoingSessions = new HashMap<Session, JMenuItem>();
    private ImageIcon verifiedLockedPadlockImage;
    private ImageIcon unverifiedLockedPadlockImage;
    private ImageIcon finishedPadlockImage;
    private ImageIcon unlockedPadlockImage;

    public OTRv3OutgoingSessionSwitcher(Container container, PluginComponentFactory parentFactory) {
        this.parentFactory = parentFactory;
        this.setPreferredSize(new Dimension(30, 28));
        this.setMaximumSize(new Dimension(30, 28));
        this.setMinimumSize(new Dimension(30, 28));
        this.menu.setPreferredSize(new Dimension(30, 45));
        this.menu.setMaximumSize(new Dimension(30, 45));
        this.add((JMenu)((Object)this.menu));
        this.setBorder(null);
        this.menu.setBorder(null);
        this.menu.setOpaque(false);
        this.setOpaque(false);
        this.menu.setVisible(false);
        new OtrWeakListener<OTRv3OutgoingSessionSwitcher>(this, OtrActivator.scOtrEngine, OtrActivator.scOtrKeyManager);
        try {
            this.finishedPadlockImage = new ImageIcon(ImageIO.read(OtrActivator.resourceService.getImageURL("plugin.otr.FINISHED_ICON_BLACK_16x16")));
            this.verifiedLockedPadlockImage = new ImageIcon(ImageIO.read(OtrActivator.resourceService.getImageURL("plugin.otr.ENCRYPTED_ICON_BLACK_16x16")));
            this.unverifiedLockedPadlockImage = new ImageIcon(ImageIO.read(OtrActivator.resourceService.getImageURL("plugin.otr.ENCRYPTED_UNVERIFIED_ICON_BLACK_16x16")));
            this.unlockedPadlockImage = new ImageIcon(ImageIO.read(OtrActivator.resourceService.getImageURL("plugin.otr.PLAINTEXT_ICON_16x16")));
        }
        catch (IOException e) {
            logger.debug((Object)"Failed to load padlock image");
        }
        this.buildMenu(this.contact);
    }

    public int getPositionIndex() {
        return -1;
    }

    public void setCurrentContact(Contact contact) {
        if (this.contact != null && this.contact.contact == contact) {
            return;
        }
        this.contact = OtrContactManager.getOtrContact(contact, null);
        this.buildMenu(this.contact);
    }

    public void setCurrentContact(MetaContact metaContact) {
        this.setCurrentContact(metaContact == null ? null : metaContact.getDefaultContact());
    }

    public void setCurrentContact(Contact contact, String resourceName) {
        if (resourceName == null) {
            this.contact = OtrContactManager.getOtrContact(contact, null);
            this.buildMenu(this.contact);
        } else {
            for (ContactResource resource : contact.getResources()) {
                if (!resource.getResourceName().equals(resourceName)) continue;
                OtrContactManager.OtrContact otrContact = OtrContactManager.getOtrContact(contact, resource);
                if (this.contact == otrContact) {
                    return;
                }
                this.contact = otrContact;
                this.buildMenu(this.contact);
            }
        }
    }

    public void setCurrentContactGroup(MetaContactGroup metaGroup) {
    }

    public void setCurrentAccountID(AccountID accountID) {
    }

    public PluginComponentFactory getParentFactory() {
        return this.parentFactory;
    }

    @Override
    public void contactVerificationStatusChanged(OtrContactManager.OtrContact contact) {
        this.buildMenu(contact);
        if (this.menu.isVisible()) {
            this.menu.fadeAnimation();
        }
    }

    @Override
    public void contactPolicyChanged(Contact contact) {
    }

    @Override
    public void globalPolicyChanged() {
    }

    @Override
    public void sessionStatusChanged(OtrContactManager.OtrContact contact) {
        this.buildMenu(contact);
        if (this.menu.isVisible()) {
            this.menu.fadeAnimation();
        }
    }

    @Override
    public void multipleInstancesDetected(OtrContactManager.OtrContact contact) {
        this.buildMenu(contact);
        if (this.menu.isVisible()) {
            this.menu.fadeAnimation();
        }
    }

    @Override
    public void outgoingSessionChanged(OtrContactManager.OtrContact contact) {
        this.buildMenu(contact);
    }

    private void buildMenu(OtrContactManager.OtrContact otrContact) {
        if (otrContact == null || !this.contact.equals(otrContact)) {
            return;
        }
        this.menu.removeAll();
        List<Session> multipleInstances = OtrActivator.scOtrEngine.getSessionInstances(otrContact);
        Session outgoingSession = OtrActivator.scOtrEngine.getOutgoingSession(otrContact);
        int index = 0;
        for (Session session : multipleInstances) {
            JMenuItem menuItem;
            ++index;
            if (!this.outgoingSessions.containsKey(session)) {
                menuItem = new JRadioButtonMenuItem();
                this.outgoingSessions.put(session, menuItem);
                menuItem.addActionListener(this);
            }
            menuItem = this.outgoingSessions.get(session);
            menuItem.setText("Session " + index);
            ImageIcon imageIcon = null;
            switch (session.getSessionStatus(session.getReceiverInstanceTag())) {
                case ENCRYPTED: {
                    PublicKey pubKey = session.getRemotePublicKey(session.getReceiverInstanceTag());
                    String fingerprint = OtrActivator.scOtrKeyManager.getFingerprintFromPublicKey(pubKey);
                    imageIcon = OtrActivator.scOtrKeyManager.isVerified(otrContact.contact, fingerprint) ? this.verifiedLockedPadlockImage : this.unverifiedLockedPadlockImage;
                    break;
                }
                case FINISHED: {
                    imageIcon = this.finishedPadlockImage;
                    break;
                }
                case PLAINTEXT: {
                    imageIcon = this.unlockedPadlockImage;
                }
            }
            menuItem.setIcon(imageIcon);
            this.menu.add(menuItem);
            SelectedObject selectedObject = new SelectedObject((Icon)imageIcon, (Object)session);
            this.buttonGroup.add(menuItem);
            menuItem.repaint();
            if (session != outgoingSession) continue;
            this.menu.setSelected(selectedObject);
            this.setSelected(this.menu.getItem(index - 1));
        }
        this.updateEnableStatus();
        this.menu.repaint();
    }

    @Override
    public void actionPerformed(ActionEvent e) {
        for (Map.Entry<Session, JMenuItem> entry : this.outgoingSessions.entrySet()) {
            JRadioButtonMenuItem menuItem = (JRadioButtonMenuItem)e.getSource();
            if (!menuItem.equals(entry.getValue())) continue;
            OtrActivator.scOtrEngine.setOutgoingSession(this.contact, entry.getKey().getReceiverInstanceTag());
            break;
        }
    }

    private void updateEnableStatus() {
        this.menu.setEnabled(this.menu.getItemCount() > 1);
        this.menu.setVisible(true);
    }

    private static class SelectorMenu
    extends SIPCommMenu {
        private static final long serialVersionUID = 0L;
        Image image = OtrActivator.resourceService.getImage("service.gui.icons.DOWN_ARROW_ICON").getImage();
        private static float alpha = 0.95f;
        private final Timer alphaChanger = new Timer(20, new ActionListener(){
            private float incrementer = -0.03f;
            private int fadeCycles = 0;

            @Override
            public void actionPerformed(ActionEvent e) {
                float newAlpha = alpha + this.incrementer;
                if (newAlpha < 0.2f) {
                    newAlpha = 0.2f;
                    this.incrementer = -this.incrementer;
                } else if (newAlpha > 0.85f) {
                    newAlpha = 0.85f;
                    this.incrementer = -this.incrementer;
                    ++this.fadeCycles;
                }
                alpha = newAlpha;
                if (this.fadeCycles >= 3) {
                    SelectorMenu.this.alphaChanger.stop();
                    this.fadeCycles = 0;
                    alpha = 1.0f;
                }
                SelectorMenu.this.repaint();
            }
        });

        private SelectorMenu() {
        }

        public void paintComponent(Graphics g) {
            Graphics2D g2d = (Graphics2D)g;
            g2d.setComposite(AlphaComposite.getInstance(3, alpha));
            g.drawImage(this.image, this.getWidth() - this.image.getWidth((ImageObserver)((Object)this)) - 1, (this.getHeight() - this.image.getHeight((ImageObserver)((Object)this)) - 1) / 2, (ImageObserver)((Object)this));
            super.paintComponent((Graphics)g2d);
        }

        public void fadeAnimation() {
            this.alphaChanger.stop();
            alpha = 0.85f;
            this.repaint();
            this.alphaChanger.start();
        }
    }
}

