/*
 * Decompiled with CFR 0.152.
 */
package net.java.sip.communicator.plugin.otr;

import java.awt.Component;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.util.Collection;
import java.util.Iterator;
import javax.swing.ImageIcon;
import javax.swing.JMenu;
import javax.swing.JMenuItem;
import javax.swing.event.PopupMenuEvent;
import javax.swing.event.PopupMenuListener;
import net.java.sip.communicator.plugin.desktoputil.SIPCommMenu;
import net.java.sip.communicator.plugin.otr.OtrActivator;
import net.java.sip.communicator.plugin.otr.OtrContactManager;
import net.java.sip.communicator.plugin.otr.OtrContactMenu;
import net.java.sip.communicator.service.contactlist.MetaContact;
import net.java.sip.communicator.service.gui.AbstractPluginComponent;
import net.java.sip.communicator.service.gui.Container;
import net.java.sip.communicator.service.gui.PluginComponentFactory;
import net.java.sip.communicator.service.protocol.Contact;
import net.java.sip.communicator.service.protocol.ContactResource;

public class OtrMetaContactMenu
extends AbstractPluginComponent
implements ActionListener,
PopupMenuListener {
    private MetaContact currentContact;
    private final boolean inMacOSXScreenMenuBar;
    private JMenu menu;
    private JMenuItem whatsThis;

    public OtrMetaContactMenu(Container container, PluginComponentFactory parentFactory) {
        super(container, parentFactory);
        this.inMacOSXScreenMenuBar = Container.CONTAINER_CHAT_MENU_BAR.equals((Object)container) && OtrActivator.uiService.useMacOSXScreenMenuBar();
    }

    @Override
    public void actionPerformed(ActionEvent e) {
        OtrActivator.scOtrEngine.launchHelp();
    }

    private void createOtrContactMenus(MetaContact metaContact) {
        block8: {
            JMenu menu = this.getMenu();
            menu.removeAll();
            if (metaContact == null) break block8;
            Iterator contacts = metaContact.getContacts();
            if (metaContact.getContactCount() == 1) {
                Contact contact = (Contact)contacts.next();
                Collection resources = contact.getResources();
                if (contact.supportResources() && resources != null && resources.size() > 0) {
                    for (ContactResource resource : resources) {
                        new OtrContactMenu(OtrContactManager.getOtrContact(contact, resource), this.inMacOSXScreenMenuBar, menu, true);
                    }
                } else {
                    new OtrContactMenu(OtrContactManager.getOtrContact(contact, null), this.inMacOSXScreenMenuBar, menu, false);
                }
            } else {
                while (contacts.hasNext()) {
                    Contact contact = (Contact)contacts.next();
                    Collection resources = contact.getResources();
                    if (contact.supportResources() && resources != null && resources.size() > 0) {
                        for (ContactResource resource : resources) {
                            new OtrContactMenu(OtrContactManager.getOtrContact(contact, resource), this.inMacOSXScreenMenuBar, menu, true);
                        }
                        continue;
                    }
                    new OtrContactMenu(OtrContactManager.getOtrContact(contact, null), this.inMacOSXScreenMenuBar, menu, true);
                }
            }
        }
    }

    public Component getComponent() {
        return this.getMenu();
    }

    private JMenu getMenu() {
        if (this.menu == null) {
            ImageIcon icon;
            this.menu = new SIPCommMenu();
            this.menu.setText(this.getName());
            if (Container.CONTAINER_CONTACT_RIGHT_BUTTON_MENU.equals((Object)this.getContainer()) && (icon = OtrActivator.resourceService.getImage("plugin.otr.MENU_ITEM_ICON_16x16")) != null) {
                this.menu.setIcon(icon);
            }
            if (!this.inMacOSXScreenMenuBar) {
                this.menu.getPopupMenu().addPopupMenuListener(this);
            }
        }
        return this.menu;
    }

    public String getName() {
        return OtrActivator.resourceService.getI18NString("plugin.otr.menu.TITLE");
    }

    @Override
    public void popupMenuCanceled(PopupMenuEvent e) {
        this.createOtrContactMenus(null);
    }

    @Override
    public void popupMenuWillBecomeInvisible(PopupMenuEvent e) {
        this.popupMenuCanceled(e);
    }

    @Override
    public void popupMenuWillBecomeVisible(PopupMenuEvent e) {
        this.createOtrContactMenus(this.currentContact);
        JMenu menu = this.getMenu();
        menu.addSeparator();
        this.whatsThis = new JMenuItem();
        this.whatsThis.setIcon(OtrActivator.resourceService.getImage("plugin.otr.HELP_ICON_15x15"));
        this.whatsThis.setText(OtrActivator.resourceService.getI18NString("plugin.otr.menu.WHATS_THIS"));
        this.whatsThis.addActionListener(this);
        menu.add(this.whatsThis);
    }

    public void setCurrentContact(MetaContact metaContact) {
        if (this.currentContact != metaContact) {
            this.currentContact = metaContact;
            if (this.inMacOSXScreenMenuBar) {
                this.popupMenuWillBecomeVisible(null);
            } else if (this.menu != null && this.menu.isPopupMenuVisible()) {
                this.createOtrContactMenus(this.currentContact);
            }
        }
    }
}

