/*
 * Decompiled with CFR 0.152.
 */
package net.java.sip.communicator.plugin.certconfig;

import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.Dialog;
import java.awt.Dimension;
import java.awt.FlowLayout;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.Insets;
import java.awt.LayoutManager;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.ItemEvent;
import java.awt.event.ItemListener;
import java.io.ByteArrayInputStream;
import java.io.File;
import java.io.IOException;
import java.io.InputStream;
import java.lang.reflect.Constructor;
import java.security.KeyStore;
import java.security.KeyStoreException;
import java.security.Provider;
import java.security.ProviderException;
import java.security.Security;
import java.security.cert.Certificate;
import java.security.cert.X509Certificate;
import java.util.Enumeration;
import javax.security.auth.callback.Callback;
import javax.security.auth.callback.CallbackHandler;
import javax.security.auth.callback.PasswordCallback;
import javax.security.auth.callback.UnsupportedCallbackException;
import javax.swing.JButton;
import javax.swing.JCheckBox;
import javax.swing.JComboBox;
import javax.swing.JLabel;
import javax.swing.JOptionPane;
import javax.swing.JPasswordField;
import javax.swing.JScrollPane;
import javax.swing.JTextField;
import javax.swing.SwingUtilities;
import javax.swing.event.ChangeEvent;
import javax.swing.event.ChangeListener;
import net.java.sip.communicator.plugin.certconfig.CertConfigActivator;
import net.java.sip.communicator.plugin.desktoputil.AuthenticationWindow;
import net.java.sip.communicator.plugin.desktoputil.GenericFileDialog;
import net.java.sip.communicator.plugin.desktoputil.SIPCommCheckBox;
import net.java.sip.communicator.plugin.desktoputil.SIPCommDialog;
import net.java.sip.communicator.plugin.desktoputil.SipCommFileChooser;
import net.java.sip.communicator.plugin.desktoputil.SipCommFileFilter;
import net.java.sip.communicator.plugin.desktoputil.TransparentPanel;
import net.java.sip.communicator.plugin.desktoputil.X509CertificatePanel;
import net.java.sip.communicator.service.certificate.CertificateConfigEntry;
import net.java.sip.communicator.service.certificate.CertificateService;
import net.java.sip.communicator.service.certificate.KeyStoreType;
import net.java.sip.communicator.util.Logger;
import org.jitsi.service.resources.ResourceManagementService;
import org.jitsi.util.StringUtils;

public class CertConfigEntryDialog
extends SIPCommDialog
implements ActionListener,
ItemListener,
ChangeListener {
    private static final long serialVersionUID = 8361336563239745007L;
    private static final Logger logger = Logger.getLogger(CertConfigEntryDialog.class);
    private ResourceManagementService R = CertConfigActivator.R;
    private CertificateService cs = CertConfigActivator.getCertService();
    private CertificateConfigEntry entry;
    private boolean success = false;
    private JButton cmdOk;
    private JButton cmdCancel;
    private JButton cmdBrowse;
    private JTextField txtDisplayName;
    private JTextField txtKeyStore;
    private JComboBox cboKeyStoreTypes;
    private JCheckBox chkSavePassword;
    private JPasswordField txtKeyStorePassword;
    private JComboBox cboAlias;
    private JButton cmdShowCert;
    private KeyStore keyStore;

    public CertConfigEntryDialog(CertificateConfigEntry e) {
        super(false);
        this.entry = e;
        this.initComponents();
        this.setPreferredSize(new Dimension(650, 270));
        try {
            if (this.entry.getKeyStore() != null) {
                this.txtKeyStorePassword.setText(this.entry.getKeyStorePassword());
                this.chkSavePassword.setSelected(this.entry.isSavePassword());
                this.cboKeyStoreTypes.setEnabled(true);
                this.cboKeyStoreTypes.setSelectedItem(this.entry.getKeyStoreType());
                if (this.keyStore == null) {
                    this.keyStore = this.loadKeyStore();
                }
                this.cboAlias.setEnabled(true);
                this.loadAliases();
                this.cboAlias.setSelectedItem(this.entry.getAlias());
            }
        }
        catch (KeyStoreException ex) {
            logger.error((Object)"Unable to load all data", (Throwable)ex);
            this.showGenericError("plugin.certconfig.KEYSTORE_EXCEPTION", ex);
        }
        catch (ProviderException ex) {
            logger.error((Object)"Unable to load all data", (Throwable)ex);
            this.showGenericError("plugin.certconfig.KEYSTORE_EXCEPTION", ex);
        }
    }

    private void initComponents() {
        this.setTitle(this.R.getI18NString("plugin.certconfig.EDIT_ENTRY"));
        this.setLayout(new BorderLayout());
        TransparentPanel fields = new TransparentPanel();
        fields.setLayout(new GridBagLayout());
        JLabel lblDisplayName = new JLabel();
        lblDisplayName.setText(this.R.getI18NString("service.gui.DISPLAY_NAME"));
        this.txtDisplayName = new JTextField();
        this.txtDisplayName.setText(this.entry.getDisplayName());
        JLabel lblKeyStore = new JLabel();
        lblKeyStore.setText(this.R.getI18NString("plugin.certconfig.KEYSTORE"));
        this.txtKeyStore = new JTextField();
        this.txtKeyStore.setText(this.entry.getKeyStore());
        this.txtKeyStore.setEditable(false);
        this.cmdBrowse = new JButton();
        this.cmdBrowse.setText(this.R.getI18NString("service.gui.BROWSE"));
        this.cmdBrowse.addActionListener(this);
        JLabel lblKeyStorePassword = new JLabel();
        lblKeyStorePassword.setText(this.R.getI18NString("plugin.certconfig.KEYSTORE_PASSWORD"));
        this.txtKeyStorePassword = new JPasswordField();
        this.txtKeyStorePassword.setEditable(false);
        this.chkSavePassword = new SIPCommCheckBox();
        this.chkSavePassword.setText(this.R.getI18NString("service.gui.REMEMBER_PASSWORD"));
        this.chkSavePassword.addChangeListener(this);
        this.chkSavePassword.setEnabled(false);
        JLabel lblKeyStoreType = new JLabel();
        lblKeyStoreType.setText(this.R.getI18NString("plugin.certconfig.KEYSTORE_TYPE"));
        this.cboKeyStoreTypes = new JComboBox<Object>(this.cs.getSupportedKeyStoreTypes().toArray());
        this.cboKeyStoreTypes.addItemListener(this);
        this.cboKeyStoreTypes.setEnabled(false);
        JLabel lblAlias = new JLabel();
        lblAlias.setText(this.R.getI18NString("plugin.certconfig.ALIAS"));
        this.cboAlias = new JComboBox();
        this.cboAlias.addItemListener(this);
        this.cboAlias.setEnabled(false);
        this.cmdShowCert = new JButton();
        this.cmdShowCert.setText(this.R.getI18NString("service.gui.SHOW_CERT") + "...");
        this.cmdShowCert.addActionListener(this);
        this.cmdShowCert.setEnabled(false);
        this.cmdCancel = new JButton();
        this.cmdCancel.setText(this.R.getI18NString("service.gui.CANCEL"));
        this.cmdCancel.addActionListener(this);
        this.cmdOk = new JButton();
        this.cmdOk.setText(this.R.getI18NString("service.gui.OK"));
        this.cmdOk.addActionListener(this);
        this.cmdOk.setPreferredSize(this.cmdCancel.getPreferredSize());
        TransparentPanel buttons = new TransparentPanel();
        buttons.setLayout((LayoutManager)new FlowLayout(2));
        buttons.add((Component)this.cmdOk);
        buttons.add((Component)this.cmdCancel);
        GridBagConstraints first = new GridBagConstraints();
        first.gridx = 0;
        first.gridy = 0;
        first.weightx = 0.0;
        first.anchor = 21;
        first.gridwidth = 1;
        first.insets = new Insets(2, 4, 2, 4);
        first.fill = 2;
        GridBagConstraints second = new GridBagConstraints();
        second.gridx = 1;
        second.gridy = 0;
        second.weightx = 2.0;
        second.anchor = 21;
        second.gridwidth = 1;
        second.insets = first.insets;
        second.fill = 2;
        GridBagConstraints third = new GridBagConstraints();
        third.gridx = 2;
        third.gridy = 0;
        third.weightx = 1.0;
        third.anchor = 22;
        third.gridwidth = 1;
        third.insets = first.insets;
        third.fill = 2;
        fields.add((Component)lblDisplayName, first);
        fields.add((Component)this.txtDisplayName, second);
        second.gridy = ++third.gridy;
        first.gridy = third.gridy++;
        fields.add((Component)lblKeyStore, first);
        fields.add((Component)this.txtKeyStore, second);
        fields.add((Component)this.cmdBrowse, third);
        second.gridy = third.gridy;
        first.gridy = third.gridy++;
        fields.add((Component)lblKeyStoreType, first);
        fields.add((Component)this.cboKeyStoreTypes, second);
        second.gridy = third.gridy;
        first.gridy = third.gridy++;
        fields.add((Component)lblKeyStorePassword, first);
        fields.add((Component)this.txtKeyStorePassword, second);
        second.gridy = third.gridy;
        first.gridy = third.gridy++;
        fields.add((Component)this.chkSavePassword, second);
        second.gridy = third.gridy;
        first.gridy = third.gridy;
        fields.add((Component)lblAlias, first);
        fields.add((Component)this.cboAlias, second);
        fields.add((Component)this.cmdShowCert, third);
        this.add((Component)fields, "Center");
        this.add((Component)buttons, "South");
    }

    protected void close(boolean escaped) {
        this.cmdCancel.doClick();
    }

    @Override
    public void actionPerformed(ActionEvent e) {
        if (e.getSource() == this.cmdOk) {
            if (this.cboAlias.getSelectedItem() == null || StringUtils.isNullOrEmpty((String)this.txtDisplayName.getText()) || StringUtils.isNullOrEmpty((String)this.txtKeyStore.getText())) {
                JOptionPane.showMessageDialog((Component)((Object)this), this.R.getI18NString("plugin.certconfig.INCOMPLETE"), this.R.getI18NString("service.gui.ERROR"), 0);
                return;
            }
            this.entry.setAlias(this.cboAlias.getSelectedItem().toString());
            this.entry.setDisplayName(this.txtDisplayName.getText());
            this.entry.setSavePassword(this.chkSavePassword.isSelected());
            this.entry.setKeyStorePassword(new String(this.txtKeyStorePassword.getPassword()));
            this.entry.setKeyStoreType((KeyStoreType)this.cboKeyStoreTypes.getSelectedItem());
            this.entry.setKeyStore(this.txtKeyStore.getText());
            this.success = true;
            this.dispose();
        }
        if (e.getSource() == this.cmdCancel) {
            this.dispose();
        }
        if (e.getSource() == this.cmdBrowse) {
            this.browseKeyStore();
        }
        if (e.getSource() == this.cmdShowCert) {
            this.showSelectedCertificate();
        }
    }

    private void showSelectedCertificate() {
        try {
            SIPCommDialog dlg = new SIPCommDialog((Dialog)((Object)this), false){
                private JButton cmdClose;
                {
                    this.setTitle(CertConfigEntryDialog.this.cboAlias.getSelectedItem().toString());
                    this.setLayout(new BorderLayout());
                    final JScrollPane certScroll = new JScrollPane((Component)new X509CertificatePanel((Certificate)((X509Certificate)CertConfigEntryDialog.this.keyStore.getCertificate(CertConfigEntryDialog.this.cboAlias.getSelectedItem().toString()))));
                    certScroll.setPreferredSize(new Dimension(600, 300));
                    certScroll.getVerticalScrollBar().setValue(0);
                    this.add(certScroll, "Center");
                    SwingUtilities.invokeLater(new Runnable(){

                        @Override
                        public void run() {
                            certScroll.getVerticalScrollBar().setValue(0);
                        }
                    });
                    this.cmdClose = new JButton();
                    this.cmdClose.setText(CertConfigEntryDialog.this.R.getI18NString("service.gui.CLOSE"));
                    this.cmdClose.addActionListener(new ActionListener(){

                        @Override
                        public void actionPerformed(ActionEvent e) {
                            this.dispose();
                        }
                    });
                    TransparentPanel buttons = new TransparentPanel((LayoutManager)new FlowLayout(2));
                    buttons.add((Component)this.cmdClose);
                    this.add((Component)buttons, "South");
                    this.setLocationRelativeTo(CertConfigEntryDialog.this.cmdShowCert);
                }

                protected void close(boolean escaped) {
                    this.cmdClose.doClick();
                }
            };
            dlg.setModal(true);
            dlg.setVisible(true);
        }
        catch (KeyStoreException e1) {
            logger.error((Object)"Unable to show the selected certificate", (Throwable)e1);
            this.showGenericError("plugin.certconfig.SHOW_CERT_EXCEPTION", e1);
        }
    }

    private void browseKeyStore() {
        SipCommFileChooser dlg = GenericFileDialog.create(null, (String)this.R.getI18NString("plugin.certconfig.BROWSE_KEYSTORE"), (int)0);
        dlg.setSelectionMode(0);
        dlg.addFilter(new SipCommFileFilter(){

            public String getDescription() {
                return CertConfigEntryDialog.this.R.getI18NString("plugin.certconfig.FILE_TYPE_DESCRIPTION");
            }

            public boolean accept(File f) {
                for (KeyStoreType kt : CertConfigEntryDialog.this.cs.getSupportedKeyStoreTypes()) {
                    for (String ext : kt.getFileExtensions()) {
                        if (!f.getName().endsWith(ext)) continue;
                        return true;
                    }
                }
                return false;
            }
        });
        File f = dlg.getFileFromDialog();
        if (f != null) {
            this.cboKeyStoreTypes.setEnabled(true);
            this.cboKeyStoreTypes.setSelectedItem(null);
            this.cboAlias.setEnabled(true);
            this.txtKeyStore.setText(f.getAbsolutePath());
            for (KeyStoreType kt : this.cs.getSupportedKeyStoreTypes()) {
                for (String ext : kt.getFileExtensions()) {
                    if (!f.getName().endsWith(ext)) continue;
                    this.cboKeyStoreTypes.setSelectedItem(kt);
                }
            }
        }
    }

    private KeyStore loadKeyStore() throws KeyStoreException {
        final File f = new File(this.txtKeyStore.getText());
        final KeyStoreType kt = (KeyStoreType)this.cboKeyStoreTypes.getSelectedItem();
        if ("PKCS11".equals(kt.getName())) {
            String config = "name=" + f.getName() + "\nlibrary=" + f.getAbsoluteFile();
            try {
                Class<?> pkcs11c = Class.forName("sun.security.pkcs11.SunPKCS11");
                Constructor<?> c = pkcs11c.getConstructor(InputStream.class);
                Provider p = (Provider)c.newInstance(new ByteArrayInputStream(config.getBytes()));
                Security.insertProviderAt(p, 0);
            }
            catch (Exception e) {
                logger.error((Object)"Tried to access the PKCS11 provider on an unsupported platform or the load failed", (Throwable)e);
            }
        }
        KeyStore.Builder ksBuilder = KeyStore.Builder.newInstance(kt.getName(), null, f, new KeyStore.CallbackHandlerProtection(new CallbackHandler(){

            @Override
            public void handle(Callback[] callbacks) throws IOException, UnsupportedCallbackException {
                for (Callback cb : callbacks) {
                    if (!(cb instanceof PasswordCallback)) {
                        throw new UnsupportedCallbackException(cb);
                    }
                    PasswordCallback pwcb = (PasswordCallback)cb;
                    if (CertConfigEntryDialog.this.txtKeyStorePassword.getPassword() != null && CertConfigEntryDialog.this.txtKeyStorePassword.getPassword().length > 0 || CertConfigEntryDialog.this.chkSavePassword.isSelected()) {
                        pwcb.setPassword(CertConfigEntryDialog.this.txtKeyStorePassword.getPassword());
                        return;
                    }
                    AuthenticationWindow aw = new AuthenticationWindow((Dialog)((Object)CertConfigEntryDialog.this), f.getName(), null, kt.getName(), false, null);
                    aw.setAllowSavePassword(!"PKCS11".equals(kt.getName()));
                    aw.setVisible(true);
                    if (!aw.isCanceled()) {
                        pwcb.setPassword(aw.getPassword());
                        if (!"PKCS11".equals(kt.getName()) && aw.isRememberPassword()) {
                            CertConfigEntryDialog.this.txtKeyStorePassword.setText(new String(aw.getPassword()));
                        }
                    } else {
                        throw new IOException("User cancel");
                    }
                    CertConfigEntryDialog.this.chkSavePassword.setSelected(aw.isRememberPassword());
                }
            }
        }));
        return ksBuilder.getKeyStore();
    }

    private void loadAliases() {
        String currentDisplayName = this.txtDisplayName.getText();
        String currentAlias = this.cboAlias.getSelectedItem() == null ? null : this.cboAlias.getSelectedItem().toString();
        try {
            this.cboAlias.removeAllItems();
            Enumeration<String> e = this.keyStore.aliases();
            while (e.hasMoreElements()) {
                this.cboAlias.addItem(e.nextElement());
            }
            if ((StringUtils.isNullOrEmpty((String)currentDisplayName) || currentDisplayName != null && currentDisplayName.equals(currentAlias)) && this.cboAlias.getSelectedItem() != null) {
                this.txtDisplayName.setText(this.cboAlias.getSelectedItem().toString());
            }
        }
        catch (KeyStoreException e) {
            this.cboAlias.removeAllItems();
            logger.error((Object)"Unable to obtain aliases from keystore", (Throwable)e);
            this.showGenericError("plugin.certconfig.ALIAS_LOAD_EXCEPTION", e);
        }
    }

    private void showGenericError(String msg, Throwable e) {
        JOptionPane.showMessageDialog((Component)((Object)this), this.R.getI18NString(msg, new String[]{e.getMessage()}), this.R.getI18NString("service.gui.ERROR"), 0);
    }

    public boolean showDialog() {
        this.setModal(true);
        this.setVisible(true);
        this.setVisible(false);
        return this.success;
    }

    @Override
    public void itemStateChanged(ItemEvent e) {
        if (e.getStateChange() != 1) {
            return;
        }
        if (e.getSource() == this.cboKeyStoreTypes) {
            KeyStoreType kt = (KeyStoreType)this.cboKeyStoreTypes.getSelectedItem();
            if (kt == null) {
                return;
            }
            try {
                if (!"PKCS11".equals(kt.getName())) {
                    this.chkSavePassword.setEnabled(true);
                }
                this.txtKeyStorePassword.setEditable(kt.hasKeyStorePassword() && this.chkSavePassword.isSelected());
                this.keyStore = this.loadKeyStore();
                this.loadAliases();
            }
            catch (KeyStoreException ex) {
                this.cboAlias.removeAllItems();
                this.showGenericError("plugin.certconfig.INVALID_KEYSTORE_TYPE", ex);
            }
        }
        if (e.getSource() == this.cboAlias) {
            this.cmdShowCert.setEnabled(this.cboAlias.getSelectedItem() != null);
        }
    }

    @Override
    public void stateChanged(ChangeEvent e) {
        if (e.getSource() == this.chkSavePassword) {
            this.txtKeyStorePassword.setEditable(this.chkSavePassword.isSelected() && ((KeyStoreType)this.cboKeyStoreTypes.getSelectedItem()).hasKeyStorePassword());
        }
    }
}

