/*
 * Decompiled with CFR 0.152.
 */
package net.java.sip.communicator.slick.popupmessagehandler;

import junit.framework.Assert;
import junit.framework.Test;
import junit.framework.TestCase;
import junit.framework.TestSuite;
import net.java.sip.communicator.service.notification.NotificationService;
import net.java.sip.communicator.service.systray.PopupMessage;
import net.java.sip.communicator.service.systray.PopupMessageHandler;
import net.java.sip.communicator.service.systray.SystrayService;
import net.java.sip.communicator.service.systray.event.SystrayPopupMessageListener;
import net.java.sip.communicator.slick.popupmessagehandler.PopupMessageHandlerSLick;
import org.osgi.framework.BundleContext;
import org.osgi.framework.ServiceReference;

public class TestPopupMessageHandler
extends TestCase {
    private static SystrayService systrayService = null;
    private static ServiceReference serviceReference = null;
    private static NotificationService notificationService = null;
    private String messageStart = "Lorem ipsum dolor sit amet.";
    private PopupMessageHandler handler1 = new MockPopupMessageHandler();
    private PopupMessageHandler handler2 = new MockPopupMessageHandler();
    private BundleContext bc = PopupMessageHandlerSLick.bundleContext;

    public TestPopupMessageHandler(String name) {
        super(name);
    }

    public static Test suite() {
        TestSuite suite = new TestSuite();
        suite.addTest((Test)new TestPopupMessageHandler("testHandlerModification"));
        suite.addTest((Test)new TestPopupMessageHandler("testNotificationHandling"));
        return suite;
    }

    public void testHandlerModification() {
        serviceReference = this.bc.getServiceReference(SystrayService.class.getName());
        systrayService = (SystrayService)this.bc.getService(serviceReference);
        systrayService.setActivePopupMessageHandler(this.handler1);
        TestPopupMessageHandler.assertEquals((Object)this.handler1, (Object)systrayService.getActivePopupMessageHandler());
        TestPopupMessageHandler.assertEquals((Object)this.handler1, (Object)systrayService.setActivePopupMessageHandler(this.handler2));
        TestPopupMessageHandler.assertEquals((Object)this.handler2, (Object)systrayService.getActivePopupMessageHandler());
    }

    public void testNotificationHandling() {
        serviceReference = this.bc.getServiceReference(NotificationService.class.getName());
        notificationService = (NotificationService)this.bc.getService(serviceReference);
        notificationService.fireNotification("PopupMessageAction", this.messageStart, this.messageStart, null);
    }

    private class MockPopupMessageHandler
    implements PopupMessageHandler {
        private MockPopupMessageHandler() {
        }

        public void addPopupMessageListener(SystrayPopupMessageListener listener) {
        }

        public void removePopupMessageListener(SystrayPopupMessageListener listener) {
        }

        public void showPopupMessage(PopupMessage popupMsg) {
            Assert.assertEquals((String)TestPopupMessageHandler.this.messageStart, (String)popupMsg.getMessage());
            Assert.assertEquals((String)TestPopupMessageHandler.this.messageStart, (String)popupMsg.getMessageTitle());
            Assert.assertEquals((Object)TestPopupMessageHandler.this.handler2, (Object)this);
        }

        public int getPreferenceIndex() {
            return 0;
        }
    }
}

