/*
 * Decompiled with CFR 0.152.
 */
package org.jitsi.util.swing;

import java.awt.Component;
import java.awt.Container;
import java.awt.Dimension;
import java.awt.LayoutManager;
import java.awt.Rectangle;
import javax.swing.JPanel;
import org.jitsi.util.swing.VideoContainer;

public class FitLayout
implements LayoutManager {
    protected static final int DEFAULT_HEIGHT_OR_WIDTH = 16;

    @Override
    public void addLayoutComponent(String name, Component comp) {
    }

    protected Component getComponent(Container parent) {
        Component[] components = parent.getComponents();
        return components.length > 0 ? components[0] : null;
    }

    protected void layoutComponent(Component component, Rectangle bounds, float alignmentX, float alignmentY) {
        Dimension size;
        if (component instanceof JPanel && !component.isOpaque() && ((Container)component).getComponentCount() > 1 || component instanceof VideoContainer || (size = component.getPreferredSize()) == null) {
            size = bounds.getSize();
        } else {
            double heightRatio;
            double widthRatio;
            boolean scale = false;
            if (size.width != bounds.width && size.width > 0) {
                scale = true;
                widthRatio = (double)bounds.width / (double)size.width;
            } else {
                widthRatio = 1.0;
            }
            if (size.height != bounds.height && size.height > 0) {
                scale = true;
                heightRatio = (double)bounds.height / (double)size.height;
            } else {
                heightRatio = 1.0;
            }
            if (scale) {
                double ratio = Math.min(widthRatio, heightRatio);
                size.width = (int)((double)size.width * ratio);
                size.height = (int)((double)size.height * ratio);
            }
        }
        if (component.isMaximumSizeSet()) {
            Dimension maxSize = component.getMaximumSize();
            if (size.width > maxSize.width) {
                size.width = maxSize.width;
            }
            if (size.height > maxSize.height) {
                size.height = maxSize.height;
            }
        }
        if (size.height < 1) {
            size.height = 1;
        }
        if (size.width < 1) {
            size.width = 1;
        }
        component.setBounds(bounds.x + Math.round((float)(bounds.width - size.width) * alignmentX), bounds.y + Math.round((float)(bounds.height - size.height) * alignmentY), size.width, size.height);
    }

    @Override
    public void layoutContainer(Container parent) {
        this.layoutContainer(parent, 0.5f);
    }

    protected void layoutContainer(Container parent, float componentAlignmentX) {
        Component component = this.getComponent(parent);
        if (component != null) {
            this.layoutComponent(component, new Rectangle(parent.getSize()), componentAlignmentX, 0.5f);
        }
    }

    @Override
    public Dimension minimumLayoutSize(Container parent) {
        Component component = this.getComponent(parent);
        return component != null ? component.getMinimumSize() : new Dimension(16, 16);
    }

    @Override
    public Dimension preferredLayoutSize(Container parent) {
        Component component = this.getComponent(parent);
        return component != null ? component.getPreferredSize() : new Dimension(16, 16);
    }

    @Override
    public void removeLayoutComponent(Component comp) {
    }
}

