/*
 * Decompiled with CFR 0.152.
 */
package org.jitsi.util;

import java.io.File;
import org.jitsi.service.configuration.ConfigurationService;

public class ConfigUtils {
    public static File getAbsoluteFile(String path, ConfigurationService cfg) {
        File file = new File(path);
        if (!file.isAbsolute()) {
            String scHomeDirName;
            String scHomeDirLocation;
            if (cfg == null) {
                scHomeDirLocation = System.getProperty("net.java.sip.communicator.SC_HOME_DIR_LOCATION");
                scHomeDirName = System.getProperty("net.java.sip.communicator.SC_HOME_DIR_NAME");
            } else {
                scHomeDirLocation = cfg.getScHomeDirLocation();
                scHomeDirName = cfg.getScHomeDirName();
            }
            if (scHomeDirLocation == null && (scHomeDirLocation = System.getProperty("user.home")) == null) {
                scHomeDirLocation = ".";
            }
            if (scHomeDirName == null) {
                scHomeDirName = ".";
            }
            file = new File(new File(scHomeDirLocation, scHomeDirName), path).getAbsoluteFile();
        }
        return file;
    }

    public static boolean getBoolean(ConfigurationService cfg, String property, boolean defaultValue) {
        String s;
        boolean b = cfg == null ? ((s = System.getProperty(property)) == null || s.length() == 0 ? defaultValue : Boolean.parseBoolean(s)) : cfg.getBoolean(property, defaultValue);
        return b;
    }

    public static int getInt(ConfigurationService cfg, String property, int defaultValue) {
        int i;
        if (cfg == null) {
            String s = System.getProperty(property);
            if (s == null || s.length() == 0) {
                i = defaultValue;
            } else {
                try {
                    i = Integer.parseInt(s);
                }
                catch (NumberFormatException nfe) {
                    i = defaultValue;
                }
            }
        } else {
            i = cfg.getInt(property, defaultValue);
        }
        return i;
    }

    public static long getLong(ConfigurationService cfg, String property, long defaultValue) {
        long i;
        if (cfg == null) {
            String s = System.getProperty(property);
            if (s == null || s.length() == 0) {
                i = defaultValue;
            } else {
                try {
                    i = Long.parseLong(s);
                }
                catch (NumberFormatException nfe) {
                    i = defaultValue;
                }
            }
        } else {
            i = cfg.getLong(property, defaultValue);
        }
        return i;
    }

    public static String getString(ConfigurationService cfg, String property, String defaultValue) {
        String s = cfg == null ? System.getProperty(property, defaultValue) : cfg.getString(property, defaultValue);
        return s;
    }
}

