/*
 * Decompiled with CFR 0.152.
 */
package net.java.sip.communicator.plugin.addrbook;

import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.Container;
import java.awt.LayoutManager;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.FocusAdapter;
import java.awt.event.FocusEvent;
import java.awt.event.FocusListener;
import javax.swing.Box;
import javax.swing.BoxLayout;
import javax.swing.JCheckBox;
import javax.swing.JComponent;
import javax.swing.JLabel;
import javax.swing.JTextPane;
import net.java.sip.communicator.plugin.addrbook.AddrBookActivator;
import net.java.sip.communicator.plugin.desktoputil.SIPCommCheckBox;
import net.java.sip.communicator.plugin.desktoputil.SIPCommTextField;
import net.java.sip.communicator.plugin.desktoputil.TransparentPanel;
import org.jitsi.util.OSUtils;

public class AdvancedConfigForm
extends TransparentPanel {
    private static final long serialVersionUID = 0L;

    public AdvancedConfigForm() {
        super((LayoutManager)new BorderLayout());
        TransparentPanel propertiesPanel = new TransparentPanel();
        propertiesPanel.setLayout(new BoxLayout((Container)propertiesPanel, 1));
        JTextPane descriptionTextPane = new JTextPane();
        descriptionTextPane.setEditable(false);
        descriptionTextPane.setOpaque(false);
        descriptionTextPane.setText(AddrBookActivator.getResources().getI18NString("plugin.addrbook.DESCRIPTION"));
        descriptionTextPane.setAlignmentX(0.0f);
        propertiesPanel.add(descriptionTextPane);
        propertiesPanel.add(Box.createVerticalStrut(15));
        if (OSUtils.IS_MAC) {
            propertiesPanel.add(this.createEnableCheckBox("plugin.addrbook.ENABLE_MACOSX_ADDRESS_BOOK_SEARCH", "plugin.addrbook.ENABLE_MACOSX_ADDRESSBOOK"));
        }
        if (OSUtils.IS_WINDOWS) {
            propertiesPanel.add(this.createEnableCheckBox("plugin.addrbook.ENABLE_MICROSOFT_OUTLOOK_SEARCH", "plugin.addrbook.ENABLE_MICROSOFT_OUTLOOK"));
            if (AddrBookActivator.getConfigService().getBoolean("plugin.addrbook.ENABLE_DEFAULT_IM_APPLICATION_CHANGE", true)) {
                propertiesPanel.add(this.createDefaultIMApplicationCheckBox("plugin.addrbook.REGISTER_AS_DEFAULT_IM_PROVIDER", "plugin.addrbook.DEFAULT_IM_APP"));
            }
        }
        propertiesPanel.add(Box.createVerticalStrut(15));
        propertiesPanel.add(this.createPrefixPanel());
        this.add((Component)propertiesPanel, "North");
    }

    private Component createEnableCheckBox(final String configPropName, String labelNameKey) {
        SIPCommCheckBox checkBox = new SIPCommCheckBox(AddrBookActivator.getResources().getI18NString(labelNameKey), AddrBookActivator.getConfigService().getBoolean(configPropName, true));
        checkBox.setAlignmentX(0.0f);
        checkBox.addActionListener(new ActionListener((JCheckBox)checkBox){
            final /* synthetic */ JCheckBox val$checkBox;
            {
                this.val$checkBox = jCheckBox;
            }

            @Override
            public void actionPerformed(ActionEvent arg0) {
                AddrBookActivator.getConfigService().setProperty(configPropName, (Object)new Boolean(this.val$checkBox.isSelected()).toString());
                if (this.val$checkBox.isSelected()) {
                    AddrBookActivator.startService();
                } else {
                    AddrBookActivator.stopService();
                }
            }
        });
        return checkBox;
    }

    private Component createDefaultIMApplicationCheckBox(final String configPropName, String labelNameKey) {
        SIPCommCheckBox checkBox = new SIPCommCheckBox(AddrBookActivator.getResources().getI18NString(labelNameKey), AddrBookActivator.getConfigService().getBoolean(configPropName, false));
        checkBox.setAlignmentX(0.0f);
        checkBox.addActionListener(new ActionListener((JCheckBox)checkBox){
            final /* synthetic */ JCheckBox val$checkBox;
            {
                this.val$checkBox = jCheckBox;
            }

            @Override
            public void actionPerformed(ActionEvent arg0) {
                AddrBookActivator.getConfigService().setProperty(configPropName, (Object)new Boolean(this.val$checkBox.isSelected()).toString());
                if (this.val$checkBox.isSelected()) {
                    AddrBookActivator.setAsDefaultIMApplication();
                } else {
                    AddrBookActivator.unsetDefaultIMApplication();
                }
            }
        });
        return checkBox;
    }

    private JComponent createPrefixPanel() {
        JLabel prefixLabel = new JLabel(AddrBookActivator.getResources().getI18NString("plugin.addrbook.PREFIX"));
        final SIPCommTextField prefixField = new SIPCommTextField(AddrBookActivator.getResources().getI18NString("plugin.addrbook.PREFIX_EXAMPLE"));
        String storedPrefix = null;
        if (OSUtils.IS_MAC) {
            storedPrefix = AddrBookActivator.getConfigService().getString("net.java.sip.communicator.plugin.addrbook.MACOSX_ADDR_BOOK_PREFIX");
        }
        if (OSUtils.IS_WINDOWS) {
            storedPrefix = AddrBookActivator.getConfigService().getString("net.java.sip.communicator.plugin.addrbook.OUTLOOK_ADDR_BOOK_PREFIX");
        }
        if (storedPrefix != null && storedPrefix.length() > 0) {
            prefixField.setText(storedPrefix);
        }
        TransparentPanel prefixPanel = new TransparentPanel();
        prefixPanel.setLayout(new BoxLayout((Container)prefixPanel, 0));
        prefixPanel.add(prefixLabel);
        prefixPanel.add(Box.createHorizontalStrut(10));
        prefixPanel.add((Component)prefixField);
        prefixPanel.setAlignmentX(0.0f);
        prefixField.addFocusListener((FocusListener)new FocusAdapter(){

            @Override
            public void focusLost(FocusEvent e) {
                String prefix = prefixField.getText();
                if (prefix == null || prefix.length() <= 0) {
                    return;
                }
                if (OSUtils.IS_MAC) {
                    AddrBookActivator.getConfigService().setProperty("net.java.sip.communicator.plugin.addrbook.MACOSX_ADDR_BOOK_PREFIX", (Object)prefix);
                }
                if (OSUtils.IS_WINDOWS) {
                    AddrBookActivator.getConfigService().setProperty("net.java.sip.communicator.plugin.addrbook.OUTLOOK_ADDR_BOOK_PREFIX", (Object)prefix);
                }
            }
        });
        return prefixPanel;
    }
}

