/*
 * Decompiled with CFR 0.152.
 */
package net.java.sip.communicator.impl.gui.main.presence;

import java.awt.Graphics;
import java.awt.Image;
import java.awt.image.ImageObserver;
import javax.swing.Icon;
import javax.swing.JMenuItem;
import net.java.sip.communicator.impl.gui.GuiActivator;
import net.java.sip.communicator.impl.gui.main.presence.StatusEntry;
import net.java.sip.communicator.plugin.desktoputil.AntialiasingManager;
import net.java.sip.communicator.plugin.desktoputil.SIPCommMenu;
import net.java.sip.communicator.service.protocol.OperationSetPresence;
import net.java.sip.communicator.service.protocol.PresenceStatus;
import net.java.sip.communicator.service.protocol.ProtocolProviderService;
import net.java.sip.communicator.util.account.AccountStatusUtils;
import net.java.sip.communicator.util.skin.Skinnable;

public abstract class StatusSelectorMenu
extends SIPCommMenu
implements ImageObserver,
StatusEntry,
Skinnable {
    private Image connectingIcon;
    private boolean isConnecting;
    protected ProtocolProviderService protocolProvider;
    private PresenceStatus offlineStatus;
    private PresenceStatus onlineStatus;
    protected OperationSetPresence presence;

    public StatusSelectorMenu() {
    }

    public StatusSelectorMenu(String text, Icon defaultIcon, ProtocolProviderService protocolProvider) {
        super(text, defaultIcon);
        this.protocolProvider = protocolProvider;
        this.presence = (OperationSetPresence)protocolProvider.getOperationSet(OperationSetPresence.class);
        this.onlineStatus = AccountStatusUtils.getOnlineStatus((ProtocolProviderService)protocolProvider);
        this.offlineStatus = AccountStatusUtils.getOfflineStatus((ProtocolProviderService)protocolProvider);
        this.loadSkin();
    }

    public int getAccountIndex() {
        return -1;
    }

    public void setAccountIndex(int index) {
    }

    public void paintComponent(Graphics g) {
        AntialiasingManager.activateAntialiasing((Graphics)g);
        super.paintComponent(g);
        if (this.isConnecting) {
            g.drawImage(this.getConnectingIcon(), 0, 3, this);
        }
    }

    private Image getConnectingIcon() {
        if (this.connectingIcon == null) {
            this.connectingIcon = GuiActivator.getResources().getImage("service.gui.icons.CONNECTING").getImage();
        }
        return this.connectingIcon;
    }

    private void clearConnectingIcon() {
        if (this.connectingIcon != null) {
            this.connectingIcon.flush();
            this.connectingIcon = null;
        }
    }

    @Override
    public void startConnecting() {
        this.setConnecting(true);
    }

    @Override
    public void stopConnecting() {
        this.clearConnectingIcon();
        this.setConnecting(false);
    }

    private void setConnecting(boolean isConnecting) {
        this.isConnecting = isConnecting;
        this.repaint();
    }

    @Override
    public boolean imageUpdate(Image img, int infoflags, int x, int y, int w, int h) {
        this.repaint();
        return true;
    }

    @Override
    public ProtocolProviderService getProtocolProvider() {
        return this.protocolProvider;
    }

    @Override
    public PresenceStatus getOfflineStatus() {
        return this.offlineStatus;
    }

    @Override
    public PresenceStatus getOnlineStatus() {
        return this.onlineStatus;
    }

    public void loadSkin() {
        this.clearConnectingIcon();
    }

    @Override
    public void dispose() {
        this.protocolProvider = null;
        this.clearConnectingIcon();
        this.offlineStatus = null;
        this.onlineStatus = null;
    }

    @Override
    public JMenuItem getEntryComponent() {
        return this;
    }
}

