/*
 * Decompiled with CFR 0.152.
 */
package net.java.sip.communicator.impl.gui.main.menus;

import java.awt.Frame;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.lang.reflect.InvocationTargetException;
import java.lang.reflect.Method;
import javax.swing.ImageIcon;
import javax.swing.JMenuItem;
import net.java.sip.communicator.impl.gui.GuiActivator;
import net.java.sip.communicator.impl.gui.UIServiceImpl;
import net.java.sip.communicator.impl.gui.main.account.NewAccountDialog;
import net.java.sip.communicator.impl.gui.main.chatroomslist.ChatRoomTableDialog;
import net.java.sip.communicator.impl.gui.main.contactlist.AddContactDialog;
import net.java.sip.communicator.impl.gui.main.contactlist.addgroup.CreateGroupDialog;
import net.java.sip.communicator.impl.gui.utils.ImageLoader;
import net.java.sip.communicator.plugin.desktoputil.SIPCommMenu;
import net.java.sip.communicator.util.ConfigurationUtils;
import net.java.sip.communicator.util.Logger;
import net.java.sip.communicator.util.skin.Skinnable;
import org.jitsi.service.resources.ResourceManagementService;

public class FileMenu
extends SIPCommMenu
implements ActionListener,
Skinnable {
    private static final Logger logger = Logger.getLogger(FileMenu.class);
    private final Frame parentWindow;
    private JMenuItem newAccountMenuItem;
    private JMenuItem addContactItem;
    private JMenuItem createGroupItem;
    private JMenuItem myChatRoomsItem;
    private JMenuItem closeMenuItem;
    private boolean isChatMenu;

    public FileMenu(Frame parentWindow) {
        this(parentWindow, false);
    }

    public FileMenu(Frame parentWindow, boolean isChatMenu) {
        super(GuiActivator.getResources().getI18NString("service.gui.FILE"));
        this.isChatMenu = isChatMenu;
        ResourceManagementService resources = GuiActivator.getResources();
        this.createGroupItem = new JMenuItem(resources.getI18NString("service.gui.CREATE_GROUP"));
        this.myChatRoomsItem = new JMenuItem(resources.getI18NString("service.gui.MY_CHAT_ROOMS"));
        this.parentWindow = parentWindow;
        boolean endsWithSeparator = false;
        if (ConfigurationUtils.isShowAccountConfig()) {
            this.newAccountMenuItem = new JMenuItem(resources.getI18NString("service.gui.NEW_ACCOUNT"));
            this.add(this.newAccountMenuItem);
            this.newAccountMenuItem.setName("newAccount");
            this.newAccountMenuItem.addActionListener(this);
            this.newAccountMenuItem.setMnemonic(resources.getI18nMnemonic("service.gui.NEW_ACCOUNT"));
            if (!(ConfigurationUtils.isAddContactDisabled() && ConfigurationUtils.isCreateGroupDisabled() && ConfigurationUtils.isGoToChatroomDisabled())) {
                this.addSeparator();
                endsWithSeparator = true;
            }
        }
        if (!isChatMenu && !ConfigurationUtils.isAddContactDisabled()) {
            this.addContactItem = new JMenuItem(resources.getI18NString("service.gui.ADD_CONTACT") + "...");
            this.add(this.addContactItem);
            this.addContactItem.setName("addContact");
            this.addContactItem.addActionListener(this);
            this.addContactItem.setMnemonic(resources.getI18nMnemonic("service.gui.ADD_CONTACT"));
            if (ConfigurationUtils.isCreateGroupDisabled() && !ConfigurationUtils.isGoToChatroomDisabled()) {
                this.addSeparator();
                endsWithSeparator = true;
            } else {
                endsWithSeparator = false;
            }
        }
        if (!isChatMenu && !ConfigurationUtils.isCreateGroupDisabled()) {
            this.add(this.createGroupItem);
            if (!ConfigurationUtils.isGoToChatroomDisabled()) {
                this.addSeparator();
                endsWithSeparator = true;
            }
        }
        if (!ConfigurationUtils.isGoToChatroomDisabled() && !GuiActivator.getConfigurationService().getBoolean("net.java.sip.communicator.impl.muc.MUC_SERVICE_DISABLED", false)) {
            this.add(this.myChatRoomsItem);
            endsWithSeparator = false;
        }
        this.registerCloseMenuItem(!endsWithSeparator);
        this.loadSkin();
        this.createGroupItem.setName("createGroup");
        this.myChatRoomsItem.setName("myChatRooms");
        this.createGroupItem.addActionListener(this);
        this.myChatRoomsItem.addActionListener(this);
        this.setMnemonic(resources.getI18nMnemonic("service.gui.FILE"));
        this.createGroupItem.setMnemonic(resources.getI18nMnemonic("service.gui.CREATE_GROUP"));
        this.myChatRoomsItem.setMnemonic(resources.getI18nMnemonic("service.gui.MY_CHAT_ROOMS"));
    }

    public void loadSkin() {
        if (this.newAccountMenuItem != null) {
            this.newAccountMenuItem.setIcon(new ImageIcon(ImageLoader.getImage(ImageLoader.ADD_ACCOUNT_MENU_ICON)));
        }
        if (this.addContactItem != null) {
            this.addContactItem.setIcon(new ImageIcon(ImageLoader.getImage(ImageLoader.ADD_CONTACT_16x16_ICON)));
        }
        this.createGroupItem.setIcon(new ImageIcon(ImageLoader.getImage(ImageLoader.GROUPS_16x16_ICON)));
        this.myChatRoomsItem.setIcon(new ImageIcon(ImageLoader.getImage(ImageLoader.CHAT_ROOM_MENU_ICON)));
        if (this.closeMenuItem != null) {
            this.closeMenuItem.setIcon(new ImageIcon(ImageLoader.getImage(ImageLoader.QUIT_16x16_ICON)));
        }
    }

    @Override
    public void actionPerformed(ActionEvent e) {
        JMenuItem menuItem = (JMenuItem)e.getSource();
        String itemName = menuItem.getName();
        if (itemName.equals("newAccount")) {
            NewAccountDialog.showNewAccountDialog();
        } else if (itemName.equals("addContact")) {
            AddContactDialog dialog = new AddContactDialog(this.parentWindow);
            dialog.setVisible(true);
        } else if (itemName.equals("createGroup")) {
            CreateGroupDialog dialog = new CreateGroupDialog(this.parentWindow);
            dialog.setVisible(true);
        } else if (itemName.equals("close")) {
            this.closeActionPerformed();
        } else if (itemName.equals("myChatRooms")) {
            ChatRoomTableDialog.showChatRoomTableDialog();
        }
    }

    void closeActionPerformed() {
        GuiActivator.getUIService().beginShutdown();
    }

    private void registerCloseMenuItem(boolean addSeparator) {
        UIServiceImpl uiService = GuiActivator.getUIService();
        if (uiService == null || !uiService.useMacOSXScreenMenuBar() || !this.registerCloseMenuItemMacOSX()) {
            this.registerCloseMenuItemNonMacOSX(addSeparator);
        }
    }

    private boolean registerCloseMenuItemMacOSX() {
        return FileMenu.registerMenuItemMacOSX("Quit", this);
    }

    static boolean registerMenuItemMacOSX(String menuItemText, Object userData) {
        ReflectiveOperationException exception = null;
        try {
            Class<?> clazz = Class.forName("net.java.sip.communicator.impl.gui.main.menus.MacOSX" + menuItemText + "Registration");
            Method method = clazz.getMethod("run", Object.class);
            Object result = method.invoke(null, userData);
            if (result instanceof Boolean) {
                return (Boolean)result;
            }
        }
        catch (ClassNotFoundException ex) {
            exception = ex;
        }
        catch (IllegalAccessException ex) {
            exception = ex;
        }
        catch (InvocationTargetException ex) {
            exception = ex;
        }
        catch (NoSuchMethodException ex) {
            exception = ex;
        }
        if (exception != null) {
            logger.error((Object)("Failed to register Mac OS X-specific " + menuItemText + " handling."), (Throwable)exception);
        }
        return false;
    }

    private void registerCloseMenuItemNonMacOSX(boolean addSeparator) {
        this.closeMenuItem = new JMenuItem(GuiActivator.getResources().getI18NString("service.gui.QUIT"));
        if (addSeparator) {
            this.addSeparator();
        }
        if (!this.isChatMenu) {
            this.add(this.closeMenuItem);
            this.closeMenuItem.setName("close");
            this.closeMenuItem.addActionListener(this);
            this.closeMenuItem.setMnemonic(GuiActivator.getResources().getI18nMnemonic("service.gui.QUIT"));
        }
    }
}

