/*
 * Decompiled with CFR 0.152.
 */
package net.java.sip.communicator.impl.gui.main.contactlist;

import java.awt.Component;
import java.awt.Dimension;
import java.awt.Frame;
import java.awt.Point;
import java.awt.Rectangle;
import java.awt.Toolkit;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.MouseEvent;
import java.awt.event.MouseListener;
import java.awt.event.MouseMotionListener;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Iterator;
import java.util.LinkedList;
import java.util.List;
import java.util.Vector;
import javax.swing.AbstractAction;
import javax.swing.ActionMap;
import javax.swing.ImageIcon;
import javax.swing.InputMap;
import javax.swing.JMenu;
import javax.swing.JMenuItem;
import javax.swing.JPopupMenu;
import javax.swing.KeyStroke;
import javax.swing.SwingUtilities;
import javax.swing.event.TreeExpansionEvent;
import javax.swing.event.TreeExpansionListener;
import javax.swing.event.TreeSelectionEvent;
import javax.swing.event.TreeSelectionListener;
import javax.swing.event.TreeWillExpandListener;
import javax.swing.tree.ExpandVetoException;
import javax.swing.tree.TreeModel;
import javax.swing.tree.TreeNode;
import javax.swing.tree.TreePath;
import net.java.sip.communicator.impl.gui.GuiActivator;
import net.java.sip.communicator.impl.gui.main.contactlist.AddContactDialog;
import net.java.sip.communicator.impl.gui.main.contactlist.CallHistoryFilter;
import net.java.sip.communicator.impl.gui.main.contactlist.ContactListTreeCellRenderer;
import net.java.sip.communicator.impl.gui.main.contactlist.ContactListTreeModel;
import net.java.sip.communicator.impl.gui.main.contactlist.ContactNode;
import net.java.sip.communicator.impl.gui.main.contactlist.DefaultTreeContactList;
import net.java.sip.communicator.impl.gui.main.contactlist.GroupNode;
import net.java.sip.communicator.impl.gui.main.contactlist.PresenceFilter;
import net.java.sip.communicator.impl.gui.main.contactlist.RenameContactDialog;
import net.java.sip.communicator.impl.gui.main.contactlist.RenameGroupDialog;
import net.java.sip.communicator.impl.gui.main.contactlist.SearchFilter;
import net.java.sip.communicator.impl.gui.main.contactlist.UIContactImpl;
import net.java.sip.communicator.impl.gui.main.contactlist.UIFilterQuery;
import net.java.sip.communicator.impl.gui.main.contactlist.UIGroupImpl;
import net.java.sip.communicator.impl.gui.main.contactlist.contactsource.ExternalContactSource;
import net.java.sip.communicator.impl.gui.main.contactlist.contactsource.MetaContactListSource;
import net.java.sip.communicator.impl.gui.main.contactlist.contactsource.MetaUIContact;
import net.java.sip.communicator.impl.gui.main.contactlist.contactsource.MetaUIGroup;
import net.java.sip.communicator.impl.gui.main.contactlist.notifsource.NotificationContactSource;
import net.java.sip.communicator.impl.gui.utils.ImageLoader;
import net.java.sip.communicator.plugin.desktoputil.LowPriorityEventQueue;
import net.java.sip.communicator.plugin.desktoputil.SIPCommButton;
import net.java.sip.communicator.service.contactlist.MetaContact;
import net.java.sip.communicator.service.contactlist.MetaContactGroup;
import net.java.sip.communicator.service.contactlist.event.MetaContactListListener;
import net.java.sip.communicator.service.contactsource.AsyncContactSourceService;
import net.java.sip.communicator.service.contactsource.ContactChangedEvent;
import net.java.sip.communicator.service.contactsource.ContactDetail;
import net.java.sip.communicator.service.contactsource.ContactQuery;
import net.java.sip.communicator.service.contactsource.ContactQueryListener;
import net.java.sip.communicator.service.contactsource.ContactQueryStatusEvent;
import net.java.sip.communicator.service.contactsource.ContactReceivedEvent;
import net.java.sip.communicator.service.contactsource.ContactRemovedEvent;
import net.java.sip.communicator.service.contactsource.ContactSourceService;
import net.java.sip.communicator.service.contactsource.ExtendedContactSourceService;
import net.java.sip.communicator.service.contactsource.SourceContact;
import net.java.sip.communicator.service.gui.ContactList;
import net.java.sip.communicator.service.gui.ContactListContainer;
import net.java.sip.communicator.service.gui.ContactListFilter;
import net.java.sip.communicator.service.gui.FilterQuery;
import net.java.sip.communicator.service.gui.UIContact;
import net.java.sip.communicator.service.gui.UIContactSource;
import net.java.sip.communicator.service.gui.UIGroup;
import net.java.sip.communicator.service.gui.event.ContactListEvent;
import net.java.sip.communicator.service.gui.event.ContactListListener;
import net.java.sip.communicator.service.gui.event.MetaContactQuery;
import net.java.sip.communicator.service.gui.event.MetaContactQueryEvent;
import net.java.sip.communicator.service.gui.event.MetaContactQueryListener;
import net.java.sip.communicator.service.gui.event.MetaContactQueryStatusEvent;
import net.java.sip.communicator.service.gui.event.MetaGroupQueryEvent;
import net.java.sip.communicator.service.muc.ChatRoomWrapper;
import net.java.sip.communicator.service.protocol.OperationSetBasicInstantMessaging;
import net.java.sip.communicator.service.protocol.OperationSetMultiUserChat;
import net.java.sip.communicator.service.protocol.OperationSetPersistentPresence;
import net.java.sip.communicator.service.protocol.OperationSetSmsMessaging;
import net.java.sip.communicator.service.protocol.ProtocolProviderService;
import net.java.sip.communicator.util.ConfigurationUtils;
import net.java.sip.communicator.util.Logger;
import org.osgi.framework.ServiceEvent;
import org.osgi.framework.ServiceListener;
import org.osgi.framework.ServiceReference;

public class TreeContactList
extends DefaultTreeContactList
implements ContactList,
ContactQueryListener,
MetaContactQueryListener,
MouseListener,
MouseMotionListener,
TreeWillExpandListener,
TreeExpansionListener,
TreeSelectionListener {
    private static final long serialVersionUID = 0L;
    private static final Logger logger = Logger.getLogger(TreeContactList.class);
    private ContactListTreeModel treeModel;
    private Component rightButtonMenu;
    private boolean isRightButtonMenuEnabled = true;
    private final List<ContactNode> activeContacts = new ArrayList<ContactNode>();
    private final List<ContactListListener> contactListListeners = new ArrayList<ContactListListener>();
    public static final PresenceFilter presenceFilter = new PresenceFilter();
    public static final MetaContactListSource mclSource = new MetaContactListSource();
    public static final SearchFilter searchFilter = new SearchFilter(mclSource);
    public static final CallHistoryFilter historyFilter = new CallHistoryFilter();
    private ContactListFilter defaultFilter;
    private ContactListFilter currentFilter = this.defaultFilter = presenceFilter;
    private boolean isGroupClickConsumed = false;
    private MouseListener[] originalMouseListeners;
    private final LinkedList<UIContactSource> contactSources = new LinkedList();
    private static NotificationContactSource notificationSource;
    private UIFilterQuery currentFilterQuery;
    private FilterThread filterThread;
    private static boolean imageSearchCanceled;
    private boolean isContactButtonsVisible = true;
    private ContactListContainer parentCLContainer;
    private UIGroupImpl rootUIGroup = null;
    private Boolean setAutoSelectionAllowed = false;
    private Object previouslySelectedNode = null;

    public TreeContactList(ContactListContainer clContainer) {
        this.parentCLContainer = clContainer;
        for (MouseListener listener : this.originalMouseListeners = this.getMouseListeners()) {
            this.removeMouseListener(listener);
        }
        this.addMouseListener(this);
        this.addMouseMotionListener(this);
        this.addTreeExpansionListener(this);
        this.addTreeWillExpandListener(this);
        this.addTreeSelectionListener(this);
        GuiActivator.getContactListService().addMetaContactListListener((MetaContactListListener)mclSource);
        this.treeModel = new ContactListTreeModel(this);
        this.setTreeModel(this.treeModel);
        if (this.isRootVisible()) {
            this.setRootVisible(false);
        }
        this.initKeyActions();
        this.initContactSources();
    }

    public void contactReceived(ContactReceivedEvent event) {
        SourceContact sourceContact = event.getContact();
        ContactSourceService contactSource = sourceContact.getContactSource();
        UIContactSource sourceUI = this.getContactSource(contactSource);
        if (sourceUI == null) {
            return;
        }
        UIContact uiContact = sourceUI.getUIContact(sourceContact);
        if (uiContact != null) {
            this.contactChanged(sourceContact, uiContact, sourceUI);
            return;
        }
        uiContact = sourceUI.createUIContact(sourceContact);
        if (contactSource instanceof ExtendedContactSourceService || this.currentFilter.isMatching(uiContact)) {
            boolean isSorted = sourceContact.getIndex() > -1;
            this.addContact(event.getQuerySource(), uiContact, sourceUI.getUIGroup(), isSorted);
        } else {
            sourceUI.removeUIContact(sourceContact);
            uiContact = null;
        }
    }

    public void contactRemoved(ContactRemovedEvent event) {
        SourceContact sourceContact = event.getContact();
        ContactSourceService contactSource = sourceContact.getContactSource();
        UIContactSource sourceUI = this.getContactSource(contactSource);
        if (sourceUI == null) {
            return;
        }
        UIContact uiContact = sourceUI.getUIContact(sourceContact);
        if (uiContact == null) {
            return;
        }
        if (contactSource instanceof ExtendedContactSourceService || this.currentFilter.isMatching(uiContact)) {
            this.removeContact(uiContact, false);
        }
    }

    public void contactChanged(ContactChangedEvent event) {
        SourceContact sourceContact = event.getContact();
        ContactSourceService contactSource = sourceContact.getContactSource();
        UIContactSource sourceUI = this.getContactSource(contactSource);
        if (sourceUI == null) {
            return;
        }
        UIContact uiContact = sourceUI.getUIContact(sourceContact);
        if (uiContact == null) {
            uiContact = sourceUI.createUIContact(sourceContact);
            if (contactSource instanceof ExtendedContactSourceService || this.currentFilter.isMatching(uiContact)) {
                this.addContact(event.getQuerySource(), uiContact, sourceUI.getUIGroup(), sourceContact.getIndex() > -1);
            } else {
                sourceUI.removeUIContact(sourceContact);
            }
            return;
        }
        this.contactChanged(sourceContact, uiContact, sourceUI);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void contactChanged(final SourceContact sourceContact, final UIContact uiContact, final UIContactSource sourceUI) {
        ContactNode contactNode;
        if (!SwingUtilities.isEventDispatchThread()) {
            LowPriorityEventQueue.invokeLater((Runnable)new Runnable(){

                @Override
                public void run() {
                    TreeContactList.this.contactChanged(sourceContact, uiContact, sourceUI);
                }
            });
            return;
        }
        if (!(uiContact instanceof UIContactImpl)) {
            return;
        }
        UIContact uIContact = uiContact;
        synchronized (uIContact) {
            contactNode = ((UIContactImpl)uiContact).getContactNode();
            if (contactNode == null) {
                return;
            }
            this.nodeChanged(contactNode);
        }
        TreeNode parentNode = contactNode.getParent();
        if (parentNode == null) {
            return;
        }
        int currentIndex = parentNode.getIndex(contactNode);
        if (currentIndex != sourceContact.getIndex()) {
            GroupNode groupNode;
            UIGroupImpl uiGroup;
            UIGroupImpl uIGroupImpl = uiGroup = (UIGroupImpl)sourceUI.getUIGroup();
            synchronized (uIGroupImpl) {
                groupNode = uiGroup.getGroupNode();
                if (groupNode == null) {
                    return;
                }
            }
            groupNode.sort(this.treeModel);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void metaContactReceived(MetaContactQueryEvent event) {
        UIContactImpl newUIContact;
        MetaContact metaContact = event.getMetaContact();
        MetaContactGroup parentGroup = metaContact.getParentMetaContactGroup();
        UIGroupImpl uiGroup = null;
        if (!MetaContactListSource.isRootGroup(parentGroup)) {
            MetaContactGroup metaContactGroup = parentGroup;
            synchronized (metaContactGroup) {
                uiGroup = MetaContactListSource.getUIGroup(parentGroup);
                if (uiGroup == null) {
                    uiGroup = MetaContactListSource.createUIGroup(parentGroup);
                }
            }
        }
        MetaContact metaContact2 = metaContact;
        synchronized (metaContact2) {
            newUIContact = MetaContactListSource.getUIContact(metaContact);
            if (newUIContact == null) {
                newUIContact = MetaContactListSource.createUIContact(metaContact);
            }
        }
        this.addContact(event.getQuerySource(), (UIContact)newUIContact, (UIGroup)uiGroup, true);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void metaGroupReceived(MetaGroupQueryEvent event) {
        UIGroup uiGroup;
        MetaContactGroup metaGroup;
        MetaContactGroup metaContactGroup = metaGroup = event.getMetaGroup();
        synchronized (metaContactGroup) {
            uiGroup = MetaContactListSource.createUIGroup(metaGroup);
        }
        if (uiGroup != null) {
            this.addGroup(uiGroup, true);
        }
    }

    public void queryStatusChanged(ContactQueryStatusEvent event) {
        int eventType = event.getEventType();
        if (eventType == 2 && logger.isInfoEnabled()) {
            logger.info((Object)("Contact query error occured: " + event.getQuerySource()));
        }
    }

    public void metaContactQueryStatusChanged(MetaContactQueryStatusEvent event) {
        int eventType = event.getEventType();
        if (eventType == 2 && logger.isInfoEnabled()) {
            logger.info((Object)("Contact query error occured: " + event.getQuerySource()));
        }
        event.getQuerySource().removeContactQueryListener((MetaContactQueryListener)this);
    }

    public Component getRightButtonMenu() {
        return this.rightButtonMenu;
    }

    public void deactivateAll() {
        for (ContactNode contactNode : this.activeContacts) {
            if (contactNode == null) continue;
            contactNode.setActive(false);
        }
        this.activeContacts.clear();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void setActiveContact(MetaContact metaContact, boolean isActive) {
        ContactNode contactNode;
        UIContactImpl uiContact;
        MetaContact metaContact2 = metaContact;
        synchronized (metaContact2) {
            uiContact = MetaContactListSource.getUIContact(metaContact);
            if (uiContact == null) {
                return;
            }
        }
        UIContactImpl uIContactImpl = uiContact;
        synchronized (uIContactImpl) {
            contactNode = uiContact.getContactNode();
            if (contactNode == null) {
                return;
            }
        }
        contactNode.setActive(isActive);
        if (isActive) {
            this.activeContacts.add(contactNode);
        } else {
            this.activeContacts.remove(contactNode);
        }
        this.treeModel.nodeChanged(contactNode);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public boolean isContactActive(UIContactImpl contact) {
        UIContactImpl uIContactImpl = contact;
        synchronized (uIContactImpl) {
            ContactNode contactNode = contact.getContactNode();
            return contactNode == null ? false : contactNode.isActive();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void addContact(final UIContact contact, final UIGroup group, final boolean isContactSorted, final boolean isGroupSorted) {
        UIContactImpl contactImpl;
        if (!SwingUtilities.isEventDispatchThread()) {
            SwingUtilities.invokeLater(new Runnable(){

                @Override
                public void run() {
                    TreeContactList.this.addContact(contact, group, isContactSorted, isGroupSorted);
                }
            });
            return;
        }
        GroupNode groupNode = null;
        if (group == null || ConfigurationUtils.isFlattenGroupEnabled() && group instanceof MetaUIGroup) {
            groupNode = this.treeModel.getRoot();
        } else if (group instanceof UIGroupImpl) {
            UIGroupImpl contactImpl2;
            UIGroupImpl uIGroupImpl = contactImpl2 = (UIGroupImpl)group;
            synchronized (uIGroupImpl) {
                groupNode = contactImpl2.getGroupNode();
                if (groupNode == null) {
                    GroupNode parentNode = this.treeModel.getRoot();
                    groupNode = isGroupSorted ? parentNode.sortedAddContactGroup(contactImpl2) : parentNode.addContactGroup(contactImpl2);
                    TreeNode node = this.treeModel.getRoot().getChildAfter(groupNode);
                    if (group.getSourceIndex() < mclSource.getIndex() * UIGroup.MAX_GROUPS && this.rootUIGroup == null && !(node instanceof GroupNode) && node != null && !this.currentFilter.equals(historyFilter)) {
                        this.createMetaUIRootGroup();
                    }
                }
            }
        }
        if (groupNode == null) {
            return;
        }
        contact.setParentGroup((UIGroup)groupNode.getGroupDescriptor());
        if (!(contact instanceof UIContactImpl)) {
            return;
        }
        ContactNode contactNode = null;
        Object object = contactImpl = (UIContactImpl)contact;
        synchronized (object) {
            if (contactImpl.getContactNode() != null) {
                return;
            }
        }
        contactNode = isContactSorted ? groupNode.sortedAddContact(contactImpl) : groupNode.addContact(contactImpl);
        object = this.setAutoSelectionAllowed;
        synchronized (object) {
            if (this.setAutoSelectionAllowed.booleanValue()) {
                this.selectFirstContact();
            }
        }
        if (this.rootUIGroup == null && groupNode == this.treeModel.getRoot() && this.treeModel.getRoot().getChildBefore(contactNode) instanceof GroupNode) {
            this.createMetaUIRootGroup();
        }
        if (!this.currentFilter.equals(presenceFilter) || !groupNode.isCollapsed()) {
            this.expandGroup(groupNode);
        } else {
            this.expandGroup(this.treeModel.getRoot());
        }
    }

    public UIGroupImpl getRootUIGroup() {
        return this.rootUIGroup;
    }

    private void createMetaUIRootGroup() {
        if (this.rootUIGroup != null) {
            return;
        }
        this.rootUIGroup = new UIGroupImpl(){
            private GroupNode groupNode = null;

            public boolean isGroupCollapsed() {
                return true;
            }

            public int getSourceIndex() {
                return mclSource.getIndex() * UIGroup.MAX_GROUPS;
            }

            public Component getRightButtonMenu() {
                return null;
            }

            public UIGroup getParentGroup() {
                return null;
            }

            public String getId() {
                return null;
            }

            public String getDisplayName() {
                return GuiActivator.getResources().getI18NString("service.gui.CONTACTS");
            }

            public Object getDescriptor() {
                return null;
            }

            public int countOnlineChildContacts() {
                return -1;
            }

            public int countChildContacts() {
                return -1;
            }

            @Override
            public void setGroupNode(GroupNode groupNode) {
                this.groupNode = groupNode;
            }

            @Override
            public GroupNode getGroupNode() {
                return this.groupNode;
            }
        };
        this.treeModel.getRoot().sortedAddContactGroup(this.rootUIGroup);
    }

    private void removeMetaUIRootGroup() {
        if (this.rootUIGroup == null) {
            return;
        }
        GroupNode parentNode = this.treeModel.getRoot();
        parentNode.removeContactGroup(this.rootUIGroup);
        this.rootUIGroup = null;
    }

    private void addContact(final MetaContactQuery query, final UIContact contact, final UIGroup group, final boolean isSorted) {
        if (!SwingUtilities.isEventDispatchThread()) {
            LowPriorityEventQueue.invokeLater((Runnable)new Runnable(){

                @Override
                public void run() {
                    TreeContactList.this.addContact(query, contact, group, isSorted);
                }
            });
            return;
        }
        if (query != null && !query.isCanceled()) {
            this.addContact(contact, group, isSorted, true);
        }
    }

    public void addContact(final ContactQuery query, final UIContact contact, final UIGroup group, final boolean isSorted) {
        if (!SwingUtilities.isEventDispatchThread()) {
            LowPriorityEventQueue.invokeLater((Runnable)new Runnable(){

                @Override
                public void run() {
                    TreeContactList.this.addContact(query, contact, group, isSorted);
                }
            });
            return;
        }
        if (query != null && this.currentFilterQuery.containsQuery(query)) {
            this.addContact(contact, group, isSorted, true);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void removeContact(final UIContact contact, final boolean removeEmptyGroup) {
        if (!SwingUtilities.isEventDispatchThread()) {
            LowPriorityEventQueue.invokeLater((Runnable)new Runnable(){

                @Override
                public void run() {
                    TreeContactList.this.removeContact(contact, removeEmptyGroup);
                }
            });
            return;
        }
        if (!(contact instanceof UIContactImpl)) {
            return;
        }
        UIGroupImpl parentGroup = (UIGroupImpl)contact.getParentGroup();
        if (parentGroup == null) {
            return;
        }
        UIGroupImpl uIGroupImpl = parentGroup;
        synchronized (uIGroupImpl) {
            GroupNode parent;
            GroupNode parentGroupNode = parentGroup.getGroupNode();
            if (parentGroupNode == null) {
                return;
            }
            parentGroupNode.removeContact((UIContactImpl)contact);
            if (removeEmptyGroup && parentGroupNode.getChildCount() == 0 && (parent = (GroupNode)parentGroupNode.getParent()) != null) {
                parent.removeContactGroup(parentGroup);
            }
        }
        if (this.rootUIGroup != null && (this.treeModel.getRoot().getChildAfter(this.rootUIGroup.getGroupNode()) instanceof GroupNode || this.treeModel.getRoot().getChildBefore(this.rootUIGroup.getGroupNode()) == null)) {
            this.removeMetaUIRootGroup();
        }
    }

    public void removeContact(UIContact contact) {
        this.removeContact(contact, true);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void refreshContact(final UIContact contact) {
        if (!SwingUtilities.isEventDispatchThread()) {
            SwingUtilities.invokeLater(new Runnable(){

                @Override
                public void run() {
                    TreeContactList.this.refreshContact(contact);
                }
            });
            return;
        }
        UIContact uIContact = contact;
        synchronized (uIContact) {
            if (!(contact instanceof UIContactImpl)) {
                return;
            }
            this.treeModel.nodeChanged(((UIContactImpl)contact).getContactNode());
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void addGroup(final UIGroup group, final boolean isSorted) {
        UIGroupImpl groupImpl;
        if (!SwingUtilities.isEventDispatchThread()) {
            SwingUtilities.invokeLater(new Runnable(){

                @Override
                public void run() {
                    TreeContactList.this.addGroup(group, isSorted);
                }
            });
            return;
        }
        if (!(group instanceof UIGroupImpl) || ConfigurationUtils.isCreateGroupDisabled() && group instanceof MetaUIGroup) {
            return;
        }
        UIGroupImpl uIGroupImpl = groupImpl = (UIGroupImpl)group;
        synchronized (uIGroupImpl) {
            GroupNode groupNode = groupImpl.getGroupNode();
            if (groupNode != null) {
                return;
            }
        }
        GroupNode parentNode = this.treeModel.getRoot();
        if (isSorted) {
            parentNode.sortedAddContactGroup(groupImpl);
        } else {
            parentNode.addContactGroup(groupImpl);
        }
        this.expandGroup(this.treeModel.getRoot());
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public void removeGroup(final UIGroup group) {
        GroupNode parent;
        GroupNode parentGroupNode;
        if (!SwingUtilities.isEventDispatchThread()) {
            SwingUtilities.invokeLater(new Runnable(){

                @Override
                public void run() {
                    TreeContactList.this.removeGroup(group);
                }
            });
            return;
        }
        if (!(group instanceof UIGroupImpl)) {
            return;
        }
        UIGroupImpl parentGroup = (UIGroupImpl)group.getParentGroup();
        if (parentGroup == null) {
            if (group.countChildContacts() != 0) return;
            parentGroupNode = this.treeModel.getRoot();
        } else {
            UIGroupImpl uIGroupImpl = parentGroup;
            synchronized (uIGroupImpl) {
                parentGroupNode = parentGroup.getGroupNode();
            }
        }
        if (parentGroupNode == null) {
            return;
        }
        parentGroupNode.removeContactGroup((UIGroupImpl)group);
        if (parentGroupNode.getChildCount() != 0 || (parent = (GroupNode)parentGroupNode.getParent()) == null) return;
        parent.removeContactGroup(parentGroup);
    }

    @Override
    public void removeAll() {
        this.treeModel.clear();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Collection<UIContact> getContacts(UIGroup group) {
        GroupNode groupNode;
        if (group != null && !(group instanceof UIGroupImpl)) {
            return null;
        }
        if (group == null) {
            groupNode = this.treeModel.getRoot();
        } else {
            UIGroup uIGroup = group;
            synchronized (uIGroup) {
                groupNode = ((UIGroupImpl)group).getGroupNode();
            }
        }
        if (groupNode == null) {
            return null;
        }
        Collection<ContactNode> contactNodes = groupNode.getContacts();
        if (contactNodes == null) {
            return null;
        }
        ArrayList<UIContact> childContacts = new ArrayList<UIContact>();
        Iterator<ContactNode> contactNodesIter = contactNodes.iterator();
        while (contactNodesIter.hasNext()) {
            childContacts.add(contactNodesIter.next().getContactDescriptor());
        }
        return childContacts;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void addContactListListener(ContactListListener listener) {
        List<ContactListListener> list = this.contactListListeners;
        synchronized (list) {
            if (!this.contactListListeners.contains(listener)) {
                this.contactListListeners.add(listener);
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void removeContactListListener(ContactListListener listener) {
        List<ContactListListener> list = this.contactListListeners;
        synchronized (list) {
            this.contactListListeners.remove(listener);
        }
    }

    public void setGroupClickConsumed(boolean isGroupClickConsumed) {
        this.isGroupClickConsumed = isGroupClickConsumed;
    }

    public FilterQuery applyDefaultFilter() {
        FilterQuery filterQuery = null;
        String currentSearchText = this.parentCLContainer.getCurrentSearchText();
        if (currentSearchText != null && currentSearchText.length() > 0) {
            if (!SwingUtilities.isEventDispatchThread()) {
                SwingUtilities.invokeLater(new Runnable(){

                    @Override
                    public void run() {
                        TreeContactList.this.parentCLContainer.clearCurrentSearchText();
                    }
                });
            } else {
                this.parentCLContainer.clearCurrentSearchText();
            }
        } else {
            filterQuery = this.applyFilter(this.defaultFilter);
        }
        return filterQuery;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void setAutoSectionAllowed(boolean value) {
        Boolean bl = this.setAutoSelectionAllowed;
        synchronized (bl) {
            this.setAutoSelectionAllowed = value;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public FilterQuery applyFilter(ContactListFilter filter) {
        if (logger.isDebugEnabled()) {
            logger.debug((Object)("Contact list filter applied: " + filter));
        }
        if (this.currentFilterQuery != null && !this.currentFilterQuery.isCanceled()) {
            this.currentFilterQuery.cancel();
        }
        this.rootUIGroup = null;
        this.currentFilterQuery = new UIFilterQuery(this);
        if (this.filterThread == null) {
            this.filterThread = new FilterThread();
            this.filterThread.setFilter(filter);
            this.filterThread.start();
        } else {
            this.filterThread.setFilter(filter);
            FilterThread filterThread = this.filterThread;
            synchronized (filterThread) {
                this.filterThread.notify();
            }
        }
        return this.currentFilterQuery;
    }

    public void setDefaultFilter(ContactListFilter filter) {
        this.currentFilter = this.defaultFilter = filter;
    }

    public ContactListFilter getDefaultFilter() {
        return this.defaultFilter;
    }

    public ContactListFilter getCurrentFilter() {
        return this.currentFilter;
    }

    public FilterQuery getCurrentFilterQuery() {
        return this.currentFilterQuery;
    }

    public boolean isEmpty() {
        return this.treeModel.getRoot().getChildCount() <= 0;
    }

    public void selectFirstContact() {
        SwingUtilities.invokeLater(new Runnable(){

            @Override
            public void run() {
                ContactNode contactNode = TreeContactList.this.treeModel.findFirstContactNode();
                if (contactNode != null && !contactNode.equals(TreeContactList.this.getSelectedValue())) {
                    TreeContactList.this.setSelectionPath(new TreePath(contactNode.getPath()));
                }
            }
        });
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void fireContactListEvent(Object source, int eventID, int clickCount) {
        ContactListEvent evt = new ContactListEvent(source, eventID, clickCount);
        List<ContactListListener> list = this.contactListListeners;
        synchronized (list) {
            if (this.contactListListeners.size() > 0) {
                this.fireContactListEvent(new Vector<ContactListListener>(this.contactListListeners), evt);
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void fireContactListEvent(List<ContactListListener> contactListListeners, ContactListEvent event) {
        List<ContactListListener> list = contactListListeners;
        synchronized (list) {
            block9: for (ContactListListener listener : contactListListeners) {
                switch (event.getEventID()) {
                    case 1: {
                        listener.contactClicked(event);
                        continue block9;
                    }
                    case 2: {
                        listener.groupClicked(event);
                        continue block9;
                    }
                    case 3: {
                        listener.contactSelected(event);
                        continue block9;
                    }
                    case 4: {
                        listener.groupSelected(event);
                        continue block9;
                    }
                }
                logger.error((Object)("Unknown event type " + event.getEventID()));
            }
        }
    }

    private void expandGroup(GroupNode groupNode) {
        final TreePath path = new TreePath(this.treeModel.getPathToRoot(groupNode));
        if (!this.isExpanded(path)) {
            if (!SwingUtilities.isEventDispatchThread()) {
                SwingUtilities.invokeLater(new Runnable(){

                    @Override
                    public void run() {
                        TreeContactList.this.expandPath(path);
                    }
                });
            } else {
                this.expandPath(path);
            }
        }
    }

    @Override
    public void mouseClicked(MouseEvent e) {
        TreePath path = this.getPathForLocation(e.getX(), e.getY());
        if (path == null) {
            return;
        }
        Object lastComponent = path.getLastPathComponent();
        if (!(lastComponent instanceof TreeNode)) {
            return;
        }
        if ((e.getModifiers() & 0x10) == 0) {
            return;
        }
        if (lastComponent instanceof ContactNode) {
            this.fireContactListEvent((Object)((ContactNode)lastComponent).getContactDescriptor(), 1, e.getClickCount());
            this.setAutoSectionAllowed(false);
        } else if (lastComponent instanceof GroupNode) {
            this.fireContactListEvent((Object)((GroupNode)lastComponent).getGroupDescriptor(), 2, e.getClickCount());
            this.setAutoSectionAllowed(false);
        }
    }

    @Override
    public void mousePressed(MouseEvent e) {
        TreePath path;
        if (!this.isGroupClickConsumed) {
            for (MouseListener listener : this.originalMouseListeners) {
                listener.mousePressed(e);
            }
        }
        if ((path = this.getPathForLocation(e.getX(), e.getY())) == null) {
            return;
        }
        Object lastComponent = path.getLastPathComponent();
        if (!(lastComponent instanceof TreeNode)) {
            return;
        }
        boolean isSelected = path.equals(this.getSelectionPath());
        if (!isSelected && (e.getModifiers() & 8) != 0 || (e.getModifiers() & 4) != 0 || e.isControlDown() && !e.isMetaDown()) {
            this.setSelectionPath(path);
        }
        if (this.isRightButtonMenuEnabled) {
            if (lastComponent instanceof ContactNode) {
                UIContactImpl uiContact = ((ContactNode)lastComponent).getContactDescriptor();
                if ((e.getModifiers() & 4) != 0 || e.isControlDown() && !e.isMetaDown()) {
                    this.rightButtonMenu = uiContact.getRightButtonMenu();
                    this.openRightButtonMenu(e.getPoint());
                }
            } else if (lastComponent instanceof GroupNode) {
                UIGroupImpl uiGroup = ((GroupNode)lastComponent).getGroupDescriptor();
                if ((e.getModifiers() & 4) != 0 || e.isControlDown() && !e.isMetaDown()) {
                    this.rightButtonMenu = uiGroup.getRightButtonMenu();
                    this.openRightButtonMenu(e.getPoint());
                }
            }
        }
        if (isSelected && e.getClickCount() < 2) {
            this.dispatchEventToButtons(e);
        }
    }

    @Override
    public void mouseEntered(MouseEvent e) {
        for (MouseListener listener : this.originalMouseListeners) {
            listener.mouseEntered(e);
        }
    }

    @Override
    public void mouseExited(MouseEvent e) {
        for (MouseListener listener : this.originalMouseListeners) {
            listener.mouseExited(e);
        }
    }

    @Override
    public void mouseReleased(MouseEvent event) {
        this.dispatchEventToButtons(event);
        for (MouseListener listener : this.originalMouseListeners) {
            listener.mouseReleased(event);
        }
    }

    private void openRightButtonMenu(Point contactListPoint) {
        if (this.rightButtonMenu == null) {
            return;
        }
        SwingUtilities.convertPointToScreen(contactListPoint, this);
        if (this.rightButtonMenu instanceof JPopupMenu) {
            ((JPopupMenu)this.rightButtonMenu).setInvoker(this);
        }
        this.rightButtonMenu.setLocation(contactListPoint.x, contactListPoint.y);
        this.rightButtonMenu.setVisible(true);
    }

    @Override
    public void mouseMoved(MouseEvent e) {
        this.dispatchEventToButtons(e);
        for (MouseListener listener : this.originalMouseListeners) {
            listener.mouseReleased(e);
        }
    }

    @Override
    public void mouseDragged(MouseEvent e) {
    }

    @Override
    public void treeWillExpand(TreeExpansionEvent event) throws ExpandVetoException {
        TreePath path = event.getPath();
        if (path == null) {
            return;
        }
        if (this.previouslySelectedNode != null) {
            this.previouslySelectedNode = path.getLastPathComponent();
        }
    }

    @Override
    public void treeWillCollapse(TreeExpansionEvent event) throws ExpandVetoException {
        TreePath path = event.getPath();
        if (path == null) {
            return;
        }
        Object lastComponent = path.getLastPathComponent();
        if (lastComponent instanceof GroupNode) {
            GroupNode gn = (GroupNode)lastComponent;
            UIGroupImpl uiGroup = gn.getGroupDescriptor();
            if ((this.previouslySelectedNode != null && !this.previouslySelectedNode.equals(lastComponent) || this.previouslySelectedNode == null) && uiGroup.getCustomActionButtons() != null && uiGroup.getCustomActionButtons().size() > 0) {
                this.previouslySelectedNode = lastComponent;
                throw new ExpandVetoException(event);
            }
        }
    }

    @Override
    public void treeCollapsed(TreeExpansionEvent event) {
        GroupNode groupNode;
        String id;
        Object collapsedNode = event.getPath().getLastPathComponent();
        if (collapsedNode instanceof GroupNode && this.currentFilter.equals(presenceFilter) && (id = (groupNode = (GroupNode)collapsedNode).getGroupDescriptor().getId()) != null) {
            ConfigurationUtils.setContactListGroupCollapsed((String)id, (boolean)true);
        }
    }

    @Override
    public void treeExpanded(TreeExpansionEvent event) {
        GroupNode groupNode;
        String id;
        Object collapsedNode = event.getPath().getLastPathComponent();
        if (collapsedNode instanceof GroupNode && this.currentFilter.equals(presenceFilter) && (id = (groupNode = (GroupNode)collapsedNode).getGroupDescriptor().getId()) != null) {
            ConfigurationUtils.setContactListGroupCollapsed((String)id, (boolean)false);
        }
    }

    private void dispatchEventToButtons(MouseEvent event) {
        TreePath mousePath = this.getPathForLocation(event.getX(), event.getY());
        if (mousePath == null) {
            return;
        }
        ContactListTreeCellRenderer renderer = (ContactListTreeCellRenderer)this.getCellRenderer().getTreeCellRendererComponent(this, mousePath.getLastPathComponent(), true, true, true, this.getRowForPath(mousePath), true);
        if (!mousePath.equals(this.getSelectionPath())) {
            renderer.resetRolloverState();
            this.repaint();
            return;
        }
        Rectangle r = this.getPathBounds(mousePath);
        int translatedX = event.getX() - r.x;
        int translatedY = event.getY() - r.y;
        Component mouseComponent = renderer.findComponentAt(translatedX, translatedY);
        if (logger.isDebugEnabled() && mouseComponent != null) {
            logger.debug((Object)("DISPATCH MOUSE EVENT TO COMPONENT: " + mouseComponent.getClass().getName() + " with bounds: " + mouseComponent.getBounds() + " for x: " + translatedX + " and y: " + translatedY));
        }
        if (mouseComponent instanceof SIPCommButton) {
            MouseEvent evt = new MouseEvent(mouseComponent, event.getID(), event.getWhen(), event.getModifiers(), 5, 5, event.getClickCount(), event.isPopupTrigger());
            ((SIPCommButton)mouseComponent).getModel().setRollover(event.getID() == 503);
            if (event.getID() == 502 && event.getClickCount() < 2 && this.previouslySelectedNode instanceof GroupNode) {
                this.previouslySelectedNode = null;
            }
            renderer.resetRolloverState(mouseComponent);
            mouseComponent.dispatchEvent(evt);
        } else {
            renderer.resetRolloverState();
        }
        this.repaint();
    }

    private void initKeyActions() {
        InputMap imap = this.getInputMap();
        ActionMap amap = this.getActionMap();
        imap.put(KeyStroke.getKeyStroke(113, 0), "main-rename");
        imap.put(KeyStroke.getKeyStroke(10, 0), "enter");
        imap.put(KeyStroke.getKeyStroke('+'), "openGroup");
        imap.put(KeyStroke.getKeyStroke('-'), "closeGroup");
        imap.put(KeyStroke.getKeyStroke(39, 0), "openGroup");
        imap.put(KeyStroke.getKeyStroke(37, 0), "closeGroup");
        amap.put("main-rename", new RenameAction());
        amap.put("enter", new AbstractAction(){
            private static final long serialVersionUID = 0L;

            @Override
            public void actionPerformed(ActionEvent e) {
                TreeContactList.this.startSelectedContactChat();
            }
        });
        amap.put("openGroup", new AbstractAction(){
            private static final long serialVersionUID = 0L;

            @Override
            public void actionPerformed(ActionEvent e) {
                TreePath selectionPath = TreeContactList.this.getSelectionPath();
                if (selectionPath != null && selectionPath.getLastPathComponent() instanceof GroupNode) {
                    GroupNode groupNode = (GroupNode)selectionPath.getLastPathComponent();
                    TreeContactList.this.expandGroup(groupNode);
                }
            }
        });
        amap.put("closeGroup", new AbstractAction(){
            private static final long serialVersionUID = 0L;

            @Override
            public void actionPerformed(ActionEvent e) {
                TreePath selectionPath = TreeContactList.this.getSelectionPath();
                if (selectionPath != null && selectionPath.getLastPathComponent() instanceof GroupNode) {
                    TreeContactList.this.collapsePath(selectionPath);
                }
            }
        });
    }

    public void startSelectedContactChat() {
        TreePath selectionPath = this.getSelectionPath();
        if (selectionPath != null && selectionPath.getLastPathComponent() instanceof ContactNode) {
            UIContactImpl uiContact = ((ContactNode)selectionPath.getLastPathComponent()).getContactDescriptor();
            if (uiContact instanceof MetaUIContact) {
                GuiActivator.getUIService().getChatWindowManager().startChat((MetaContact)uiContact.getDescriptor());
            } else if (uiContact.getDescriptor() instanceof SourceContact) {
                SourceContact contact = (SourceContact)uiContact.getDescriptor();
                List imDetails = contact.getContactDetails(OperationSetBasicInstantMessaging.class);
                List mucDetails = contact.getContactDetails(OperationSetMultiUserChat.class);
                if (imDetails != null && imDetails.size() > 0) {
                    ProtocolProviderService pps = ((ContactDetail)imDetails.get(0)).getPreferredProtocolProvider(OperationSetBasicInstantMessaging.class);
                    if (pps != null) {
                        GuiActivator.getUIService().getChatWindowManager().startChat(contact.getContactAddress(), pps);
                    } else {
                        GuiActivator.getUIService().getChatWindowManager().startChat(contact.getContactAddress());
                    }
                } else if (mucDetails != null && mucDetails.size() > 0) {
                    ChatRoomWrapper room = GuiActivator.getMUCService().findChatRoomWrapperFromSourceContact(contact);
                    if (room == null) {
                        ProtocolProviderService pps = ((ContactDetail)mucDetails.get(0)).getPreferredProtocolProvider(OperationSetMultiUserChat.class);
                        room = GuiActivator.getMUCService().findChatRoomWrapperFromChatRoomID(contact.getContactAddress(), pps);
                        if (room == null) {
                            GuiActivator.getMUCService().createChatRoom(contact.getContactAddress(), pps, new ArrayList(), "", false, false, false);
                        }
                    }
                    if (room != null) {
                        GuiActivator.getMUCService().openChatRoom(room);
                    }
                } else {
                    List smsDetails = contact.getContactDetails(OperationSetSmsMessaging.class);
                    if (smsDetails != null && smsDetails.size() > 0) {
                        GuiActivator.getUIService().getChatWindowManager().startChat(contact.getContactAddress(), true);
                    }
                }
            }
        }
    }

    public void startSelectedContactCall() {
        TreePath selectionPath = this.getSelectionPath();
        if (selectionPath == null) {
            return;
        }
        ContactListTreeCellRenderer renderer = (ContactListTreeCellRenderer)this.getCellRenderer().getTreeCellRendererComponent(this, selectionPath.getLastPathComponent(), true, true, true, this.getRowForPath(selectionPath), true);
        renderer.getCallButton().doClick();
    }

    public void startSelectedContactVideoCall() {
        TreePath selectionPath = this.getSelectionPath();
        if (selectionPath == null) {
            return;
        }
        ContactListTreeCellRenderer renderer = (ContactListTreeCellRenderer)this.getCellRenderer().getTreeCellRendererComponent(this, selectionPath.getLastPathComponent(), true, true, true, this.getRowForPath(selectionPath), true);
        renderer.getCallVideoButton().doClick();
    }

    public void startSelectedContactDesktopSharing() {
        TreePath selectionPath = this.getSelectionPath();
        if (selectionPath == null) {
            return;
        }
        ContactListTreeCellRenderer renderer = (ContactListTreeCellRenderer)this.getCellRenderer().getTreeCellRendererComponent(this, selectionPath.getLastPathComponent(), true, true, true, this.getRowForPath(selectionPath), true);
        renderer.getDesktopSharingButton().doClick();
    }

    private void setTreeModel(TreeModel treeModel) {
        this.setModel(treeModel);
        this.setRowHeight(0);
        this.setToggleClickCount(1);
    }

    public void nodeChanged(TreeNode node) {
        this.treeModel.nodeChanged(node);
    }

    private void initContactSources() {
        for (ContactSourceService contactSource : GuiActivator.getContactSources()) {
            if (contactSource instanceof AsyncContactSourceService && !((AsyncContactSourceService)contactSource).canBeUsedToSearchContacts()) continue;
            ExternalContactSource extContactSource = new ExternalContactSource(contactSource, this);
            int sourceIndex = contactSource.getIndex();
            if (sourceIndex >= 0 && this.contactSources.size() >= sourceIndex) {
                this.contactSources.add(sourceIndex, extContactSource);
                continue;
            }
            this.contactSources.add(extContactSource);
        }
        GuiActivator.bundleContext.addServiceListener((ServiceListener)new ContactSourceServiceListener());
    }

    public Collection<UIContactSource> getContactSources() {
        return this.contactSources;
    }

    public void addContactSource(ContactSourceService contactSource) {
        if (!(contactSource instanceof AsyncContactSourceService) || ((AsyncContactSourceService)contactSource).canBeUsedToSearchContacts()) {
            this.contactSources.add(new ExternalContactSource(contactSource, this));
        }
    }

    public void removeContactSource(ContactSourceService contactSource) {
        for (UIContactSource extSource : this.contactSources) {
            if (!extSource.getContactSourceService().equals(contactSource)) continue;
            this.contactSources.remove(extSource);
            break;
        }
    }

    public void removeAllContactSources() {
        this.contactSources.clear();
    }

    public static NotificationContactSource getNotificationContactSource() {
        if (notificationSource == null) {
            notificationSource = new NotificationContactSource();
        }
        return notificationSource;
    }

    public UIContactSource getContactSource(ContactSourceService contactSource) {
        for (UIContactSource extSource : this.contactSources) {
            if (!extSource.getContactSourceService().equals(contactSource)) continue;
            return extSource;
        }
        return null;
    }

    public List<UIContactSource> getContactSources(int type) {
        ArrayList<UIContactSource> sources = new ArrayList<UIContactSource>();
        for (UIContactSource extSource : this.contactSources) {
            if (extSource.getContactSourceService().getType() != type) continue;
            sources.add(extSource);
        }
        return sources;
    }

    public static JMenuItem createAddContactMenu(SourceContact sourceContact) {
        JMenuItem addContactComponentTmp = null;
        List details = sourceContact.getContactDetails(OperationSetPersistentPresence.class);
        final String displayName = sourceContact.getDisplayName();
        if (details.size() == 1) {
            addContactComponentTmp = new JMenuItem(GuiActivator.getResources().getI18NString("service.gui.ADD_CONTACT"), new ImageIcon(ImageLoader.getImage(ImageLoader.ADD_CONTACT_16x16_ICON)));
            final ContactDetail detail = (ContactDetail)details.get(0);
            addContactComponentTmp.addActionListener(new ActionListener(){

                @Override
                public void actionPerformed(ActionEvent e) {
                    TreeContactList.showAddContactDialog(detail, displayName);
                }
            });
        } else if (details.size() > 1) {
            addContactComponentTmp = new JMenu(GuiActivator.getResources().getI18NString("service.gui.ADD_CONTACT"));
            for (final ContactDetail detail : details) {
                JMenuItem addMenuItem = new JMenuItem(detail.getDetail());
                ((JMenu)addContactComponentTmp).add(addMenuItem);
                addMenuItem.addActionListener(new ActionListener(){

                    @Override
                    public void actionPerformed(ActionEvent e) {
                        TreeContactList.showAddContactDialog(detail, displayName);
                    }
                });
            }
        }
        return addContactComponentTmp;
    }

    public static void showAddContactDialog(ContactDetail contactDetail, String displayName) {
        AddContactDialog dialog = new AddContactDialog((Frame)((Object)GuiActivator.getUIService().getMainFrame()));
        ProtocolProviderService preferredProvider = null;
        List opSetClasses = contactDetail.getSupportedOperationSets();
        if (opSetClasses != null && opSetClasses.size() > 0) {
            preferredProvider = contactDetail.getPreferredProtocolProvider((Class)opSetClasses.get(0));
        }
        if (preferredProvider != null) {
            dialog.setSelectedAccount(preferredProvider);
        }
        String contactAddress = contactDetail.getDetail();
        dialog.setContactAddress(contactAddress);
        if (displayName != null && !displayName.equalsIgnoreCase(contactAddress)) {
            dialog.setDisplayName(displayName);
        }
        dialog.setVisible(true);
    }

    public ContactListTreeModel getTreeModel() {
        return this.treeModel;
    }

    public MetaContactListSource getMetaContactListSource() {
        return mclSource;
    }

    public Component getComponent() {
        return this;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void setSelectedContact(final UIContact uiContact) {
        if (!SwingUtilities.isEventDispatchThread()) {
            SwingUtilities.invokeLater(new Runnable(){

                @Override
                public void run() {
                    TreeContactList.this.setSelectedContact(uiContact);
                }
            });
            return;
        }
        UIContact uIContact = uiContact;
        synchronized (uIContact) {
            if (!(uiContact instanceof UIContactImpl)) {
                return;
            }
            this.setSelectionPath(new TreePath(((UIContactImpl)uiContact).getContactNode().getPath()));
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void setSelectedGroup(final UIGroup uiGroup) {
        if (!SwingUtilities.isEventDispatchThread()) {
            SwingUtilities.invokeLater(new Runnable(){

                @Override
                public void run() {
                    TreeContactList.this.setSelectedGroup(uiGroup);
                }
            });
            return;
        }
        if (!(uiGroup instanceof UIGroupImpl)) {
            return;
        }
        UIGroup uIGroup = uiGroup;
        synchronized (uIGroup) {
            this.setSelectionPath(new TreePath(((UIGroupImpl)uiGroup).getGroupNode().getPath()));
        }
    }

    public UIContact getSelectedContact() {
        TreePath selectionPath = this.getSelectionPath();
        if (selectionPath != null && selectionPath.getLastPathComponent() instanceof ContactNode) {
            return ((ContactNode)selectionPath.getLastPathComponent()).getContactDescriptor();
        }
        return null;
    }

    public List<UIContact> getSelectedContacts() {
        TreePath[] selectionPaths = this.getSelectionPaths();
        if (selectionPaths == null) {
            return null;
        }
        ArrayList<UIContact> selectedContacts = new ArrayList<UIContact>();
        for (TreePath selectionPath : selectionPaths) {
            if (!(selectionPath.getLastPathComponent() instanceof ContactNode)) continue;
            selectedContacts.add(((ContactNode)selectionPath.getLastPathComponent()).getContactDescriptor());
        }
        return selectedContacts;
    }

    public UIGroup getSelectedGroup() {
        TreePath selectionPath = this.getSelectionPath();
        if (selectionPath != null && selectionPath.getLastPathComponent() instanceof GroupNode) {
            return ((GroupNode)selectionPath.getLastPathComponent()).getGroupDescriptor();
        }
        return null;
    }

    public void setMultipleSelectionEnabled(boolean isEnabled) {
        if (isEnabled) {
            this.getSelectionModel().setSelectionMode(4);
        } else {
            this.getSelectionModel().setSelectionMode(1);
        }
    }

    public void removeSelection() {
        TreePath[] selectionPaths = this.getSelectionPaths();
        if (selectionPaths != null) {
            this.removeSelectionPaths(selectionPaths);
        }
    }

    @Override
    public void valueChanged(TreeSelectionEvent e) {
        UIGroup selectedGroup;
        TreePath oldSelectionPath = e.getOldLeadSelectionPath();
        if (oldSelectionPath != null) {
            this.previouslySelectedNode = oldSelectionPath.getLastPathComponent();
        }
        if ((selectedGroup = this.getSelectedGroup()) != null) {
            this.fireContactListEvent(selectedGroup, 4, 0);
        } else {
            UIContact selectedContact = this.getSelectedContact();
            if (selectedContact != null) {
                this.fireContactListEvent(selectedContact, 3, 0);
            }
        }
    }

    public void setContactButtonsVisible(boolean isVisible) {
        this.isContactButtonsVisible = isVisible;
    }

    public boolean isContactButtonsVisible() {
        return this.isContactButtonsVisible;
    }

    public void setRightButtonMenuEnabled(boolean isEnabled) {
        this.isRightButtonMenuEnabled = isEnabled;
    }

    static {
        imageSearchCanceled = false;
    }

    private class RenameAction
    extends AbstractAction {
        private static final long serialVersionUID = 0L;

        private RenameAction() {
        }

        @Override
        public void actionPerformed(ActionEvent e) {
            Object selectedObject = TreeContactList.this.getSelectedValue();
            if (selectedObject instanceof ContactNode) {
                UIContactImpl uiContact = ((ContactNode)selectedObject).getContactDescriptor();
                if (!(uiContact instanceof MetaUIContact)) {
                    return;
                }
                MetaUIContact metaUIContact = (MetaUIContact)uiContact;
                RenameContactDialog dialog = new RenameContactDialog(GuiActivator.getUIService().getMainFrame(), (MetaContact)metaUIContact.getDescriptor());
                Dimension screenSize = Toolkit.getDefaultToolkit().getScreenSize();
                dialog.setLocation(screenSize.width / 2 - 200, screenSize.height / 2 - 50);
                dialog.setVisible(true);
                dialog.requestFocusInFiled();
            } else if (selectedObject instanceof GroupNode) {
                UIGroupImpl uiGroup = ((GroupNode)selectedObject).getGroupDescriptor();
                if (!(uiGroup instanceof MetaUIGroup)) {
                    return;
                }
                MetaUIGroup metaUIGroup = (MetaUIGroup)uiGroup;
                RenameGroupDialog dialog = new RenameGroupDialog(GuiActivator.getUIService().getMainFrame(), (MetaContactGroup)metaUIGroup.getDescriptor());
                Dimension screenSize = Toolkit.getDefaultToolkit().getScreenSize();
                dialog.setLocation(screenSize.width / 2 - 200, screenSize.height / 2 - 50);
                dialog.setVisible(true);
                dialog.requestFocusInFiled();
            }
        }
    }

    private class ContactSourceServiceListener
    implements ServiceListener {
        private ContactSourceServiceListener() {
        }

        public void serviceChanged(ServiceEvent event) {
            ServiceReference serviceRef = event.getServiceReference();
            if (serviceRef.getBundle().getState() == 16) {
                return;
            }
            Object service = GuiActivator.bundleContext.getService(serviceRef);
            if (!(service instanceof ContactSourceService)) {
                return;
            }
            boolean changed = false;
            switch (event.getType()) {
                case 1: {
                    if (service instanceof AsyncContactSourceService && !((AsyncContactSourceService)service).canBeUsedToSearchContacts()) break;
                    ExternalContactSource contactSource = new ExternalContactSource((ContactSourceService)service, TreeContactList.this);
                    TreeContactList.this.contactSources.add(contactSource);
                    changed = true;
                    break;
                }
                case 4: {
                    UIContactSource cSource = TreeContactList.this.getContactSource((ContactSourceService)service);
                    if (cSource != null) {
                        TreeContactList.this.contactSources.remove(cSource);
                    }
                    changed = true;
                }
            }
            if (changed) {
                if (TreeContactList.this.currentFilter.equals(TreeContactList.this.defaultFilter)) {
                    TreeContactList.this.applyDefaultFilter();
                } else {
                    TreeContactList.this.applyFilter(TreeContactList.this.currentFilter);
                }
            }
        }
    }

    private class FilterThread
    extends Thread {
        private ContactListFilter filter;

        private FilterThread() {
        }

        public void setFilter(ContactListFilter filter) {
            this.filter = filter;
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public void run() {
            while (true) {
                UIFilterQuery filterQuery;
                block11: {
                    filterQuery = TreeContactList.this.currentFilterQuery;
                    ContactListFilter filter = this.filter;
                    TreeContactList.this.treeModel.clear();
                    if (!filterQuery.isCanceled()) {
                        if (TreeContactList.this.currentFilter == null || !TreeContactList.this.currentFilter.equals(filter)) {
                            TreeContactList.this.currentFilter = filter;
                        }
                        TreeContactList.this.setAutoSectionAllowed(false);
                        try {
                            TreeContactList.this.currentFilter.applyFilter((FilterQuery)filterQuery);
                        }
                        catch (Throwable t) {
                            if (!logger.isInfoEnabled()) break block11;
                            logger.info((Object)"One of our contact list filters has crashed.", t);
                        }
                    }
                }
                FilterThread filterThread = this;
                synchronized (filterThread) {
                    block12: {
                        try {
                            if (filterQuery == TreeContactList.this.currentFilterQuery) {
                                this.wait();
                            }
                        }
                        catch (InterruptedException e) {
                            if (!logger.isInfoEnabled()) break block12;
                            logger.info((Object)"Filter thread was interrupted.", (Throwable)e);
                        }
                    }
                }
            }
        }
    }
}

