/*
 * Decompiled with CFR 0.152.
 */
package net.java.sip.communicator.impl.gui.main.contactlist;

import java.util.Iterator;
import java.util.List;
import java.util.Vector;
import javax.swing.AbstractListModel;
import net.java.sip.communicator.service.contactlist.MetaContact;
import net.java.sip.communicator.service.contactlist.MetaContactGroup;
import net.java.sip.communicator.service.contactlist.MetaContactListService;
import net.java.sip.communicator.service.protocol.Contact;
import net.java.sip.communicator.util.ConfigurationUtils;

public class ContactListModel
extends AbstractListModel {
    private final MetaContactListService contactList;
    private final MetaContactGroup rootGroup;
    private final List<MetaContactGroup> closedGroups = new Vector<MetaContactGroup>();
    private boolean showOffline = true;

    public ContactListModel(MetaContactListService contactList) {
        this.contactList = contactList;
        this.rootGroup = this.contactList.getRoot();
        this.initGroupsStatus(this.rootGroup);
    }

    public void contentChanged(int startIndex, int endIndex) {
        this.fireContentsChanged(this, startIndex, endIndex);
    }

    public void contentAdded(int startIndex, int endIndex) {
        this.fireIntervalAdded(this, startIndex, endIndex);
    }

    public void contentRemoved(int startIndex, int endIndex) {
        this.fireIntervalRemoved(this, startIndex, endIndex);
    }

    @Override
    public int getSize() {
        return this.getContactListSize(this.rootGroup);
    }

    @Override
    public Object getElementAt(int index) {
        return this.getElementAt(this.rootGroup, -1, index);
    }

    private int getContactListSize(MetaContactGroup group) {
        int size = 0;
        if (!this.isGroupClosed(group)) {
            if (this.showOffline) {
                size = group.countChildContacts();
                if (!group.equals(this.rootGroup)) {
                    ++size;
                }
            } else {
                Iterator i = group.getChildContacts();
                while (i.hasNext()) {
                    MetaContact contact = (MetaContact)i.next();
                    if (!this.isContactOnline(contact)) continue;
                    ++size;
                }
                if (!group.equals(this.rootGroup) && size > 0) {
                    ++size;
                }
            }
            Iterator subgroups = group.getSubgroups();
            while (subgroups.hasNext()) {
                MetaContactGroup subGroup = (MetaContactGroup)subgroups.next();
                size += this.getContactListSize(subGroup);
            }
        } else if (this.showOffline) {
            ++size;
        } else if (this.containsOnlineContacts(group)) {
            ++size;
        }
        return size;
    }

    public int indexOf(Object o) {
        if (o instanceof MetaContact) {
            return this.indexOf((MetaContact)o);
        }
        if (o instanceof MetaContactGroup) {
            return this.indexOf((MetaContactGroup)o);
        }
        return -1;
    }

    private int indexOf(MetaContact contact) {
        MetaContactGroup parentGroup;
        int index = -1;
        if ((this.showOffline || this.isContactOnline(contact)) && (parentGroup = this.contactList.findParentMetaContactGroup(contact)) != null && !this.isGroupClosed(parentGroup)) {
            index = this.indexOf(parentGroup) + (parentGroup.indexOf(contact) + 1);
        }
        return index;
    }

    private int indexOf(MetaContactGroup group) {
        MetaContactGroup parentGroup;
        int index = -1;
        if ((this.showOffline || this.containsOnlineContacts(group)) && (parentGroup = this.contactList.findParentMetaContactGroup(group)) != null && !this.isGroupClosed(parentGroup)) {
            int indexOfGroupInParentGroup = parentGroup.indexOf(group);
            index = this.indexOf(parentGroup) + this.countChildContacts(parentGroup) + (indexOfGroupInParentGroup + 1);
            for (int i = 0; i < indexOfGroupInParentGroup; ++i) {
                MetaContactGroup siblingGroup = parentGroup.getMetaContactSubgroup(i);
                index += this.countContactsAndSubgroups(siblingGroup);
            }
        }
        return index;
    }

    public int countContactsAndSubgroups(MetaContactGroup parentGroup) {
        int count = 0;
        if (parentGroup != null && !this.isGroupClosed(parentGroup)) {
            if (this.showOffline) {
                count = parentGroup.countChildContacts();
            } else {
                Iterator i = parentGroup.getChildContacts();
                while (i.hasNext()) {
                    MetaContact contact = (MetaContact)i.next();
                    if (!this.isContactOnline(contact)) continue;
                    ++count;
                }
            }
            Iterator subgroups = parentGroup.getSubgroups();
            while (subgroups.hasNext()) {
                MetaContactGroup subgroup = (MetaContactGroup)subgroups.next();
                count += this.countContactsAndSubgroups(subgroup);
            }
        }
        return count;
    }

    private Object getElementAt(MetaContactGroup group, int currentIndex, int searchedIndex) {
        Object element = null;
        if (currentIndex == searchedIndex) {
            element = group;
        } else if (!this.isGroupClosed(group)) {
            int childCount = this.countChildContacts(group);
            if (searchedIndex <= currentIndex + childCount) {
                MetaContact contact = group.getMetaContact(searchedIndex - currentIndex - 1);
                if (this.showOffline || this.isContactOnline(contact)) {
                    element = contact;
                }
            } else {
                currentIndex += childCount;
                Iterator subgroups = group.getSubgroups();
                while (subgroups.hasNext()) {
                    MetaContactGroup subgroup = (MetaContactGroup)subgroups.next();
                    if (this.showOffline || this.containsOnlineContacts(subgroup)) {
                        element = this.getElementAt(subgroup, currentIndex + 1, searchedIndex);
                    }
                    if (element != null) break;
                    if (!this.showOffline && !this.containsOnlineContacts(subgroup)) continue;
                    if (!this.isGroupClosed(subgroup)) {
                        currentIndex += this.countChildContacts(subgroup) + 1;
                        continue;
                    }
                    ++currentIndex;
                }
            }
        }
        return element;
    }

    public void closeGroup(MetaContactGroup group) {
        if (!this.isGroupClosed(group) && !this.isGroupEmpty(group)) {
            if (this.showOffline || this.containsOnlineContacts(group)) {
                this.contentRemoved(this.indexOf(group.getMetaContact(0)), this.indexOf(group.getMetaContact(this.countContactsAndSubgroups(group) - 1)));
            }
            this.closedGroups.add(group);
            ConfigurationUtils.setContactListGroupCollapsed((String)group.getMetaUID(), (boolean)true);
        }
    }

    public void openGroup(MetaContactGroup group) {
        if (this.isGroupClosed(group)) {
            this.closedGroups.remove(group);
            this.contentAdded(this.indexOf(group.getMetaContact(0)), this.indexOf(group.getMetaContact(this.countContactsAndSubgroups(group) - 1)));
            ConfigurationUtils.setContactListGroupCollapsed((String)group.getMetaUID(), (boolean)false);
        }
    }

    public boolean isGroupClosed(MetaContactGroup group) {
        return this.closedGroups.contains(group);
    }

    public boolean isGroupEmpty(MetaContactGroup group) {
        return group.countChildContacts() <= 0 && group.countSubgroups() <= 0;
    }

    public boolean isShowOffline() {
        return this.showOffline;
    }

    public void setShowOffline(boolean showOffline) {
        this.showOffline = showOffline;
    }

    public boolean isContactOnline(MetaContact contact) {
        Contact defaultContact = contact.getDefaultContact();
        if (defaultContact == null) {
            return false;
        }
        return defaultContact.getPresenceStatus().getStatus() >= 20;
    }

    public int countChildContacts(MetaContactGroup group) {
        if (this.showOffline) {
            return group.countChildContacts();
        }
        int count = 0;
        Iterator i = group.getChildContacts();
        while (i.hasNext() && this.isContactOnline((MetaContact)i.next())) {
            ++count;
        }
        return count;
    }

    private boolean containsOnlineContacts(MetaContactGroup group) {
        Iterator childContacts = group.getChildContacts();
        while (childContacts.hasNext()) {
            MetaContact contact = (MetaContact)childContacts.next();
            if (!this.isContactOnline(contact)) continue;
            return true;
        }
        return false;
    }

    private void initGroupsStatus(MetaContactGroup group) {
        boolean isClosed = ConfigurationUtils.isContactListGroupCollapsed((String)group.getMetaUID());
        if (isClosed) {
            this.closedGroups.add(group);
        }
        Iterator subgroups = group.getSubgroups();
        while (subgroups.hasNext()) {
            MetaContactGroup subgroup = (MetaContactGroup)subgroups.next();
            this.initGroupsStatus(subgroup);
        }
    }
}

