/*
 * Decompiled with CFR 0.152.
 */
package net.java.sip.communicator.impl.gui.main.configforms;

import java.awt.BorderLayout;
import java.awt.Color;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.Font;
import java.awt.Graphics;
import java.awt.Graphics2D;
import javax.swing.BorderFactory;
import javax.swing.ImageIcon;
import javax.swing.JLabel;
import javax.swing.JList;
import javax.swing.ListCellRenderer;
import net.java.sip.communicator.impl.gui.main.configforms.ConfigFormDescriptor;
import net.java.sip.communicator.plugin.desktoputil.AntialiasingManager;
import net.java.sip.communicator.plugin.desktoputil.EmphasizedLabel;
import net.java.sip.communicator.plugin.desktoputil.TransparentPanel;

public class ConfigFormListCellRenderer
extends TransparentPanel
implements ListCellRenderer {
    public static final int SELECTED_GRADIENT_SIZE = 5;
    private final JLabel textLabel = new EmphasizedLabel("");
    private final JLabel iconLabel = new JLabel();
    private boolean isSelected = false;

    public ConfigFormListCellRenderer() {
        this.setBorder(BorderFactory.createEmptyBorder(3, 3, 5, 3));
        this.setLayout(new BorderLayout(0, 0));
        this.setPreferredSize(new Dimension(60, 50));
        Font font = this.getFont();
        this.textLabel.setFont(font.deriveFont(11.0f));
        this.iconLabel.setHorizontalAlignment(0);
        this.textLabel.setHorizontalAlignment(0);
        this.add(this.iconLabel, "Center");
        this.add(this.textLabel, "South");
    }

    public Component getListCellRendererComponent(JList list, Object value, int index, boolean isSelected, boolean cellHasFocus) {
        String title;
        ConfigFormDescriptor cfDescriptor = (ConfigFormDescriptor)value;
        ImageIcon icon = cfDescriptor.getConfigFormIcon();
        if (icon != null) {
            this.iconLabel.setIcon(icon);
        }
        if ((title = cfDescriptor.getConfigFormTitle()) != null) {
            this.textLabel.setText(title);
        }
        this.isSelected = isSelected;
        return this;
    }

    public void paintComponent(Graphics g) {
        super.paintComponent(g);
        AntialiasingManager.activateAntialiasing((Graphics)g);
        Graphics2D g2 = (Graphics2D)g;
        if (this.isSelected) {
            g2.setPaint(new Color(100, 100, 100, 100));
            g2.fillRoundRect(0, 0, this.getWidth(), this.getHeight(), 10, 10);
            g2.setColor(Color.GRAY);
            g2.drawRoundRect(0, 0, this.getWidth() - 1, this.getHeight() - 1, 10, 10);
        }
    }
}

