/*
 * Decompiled with CFR 0.152.
 */
package net.java.sip.communicator.impl.gui.main.chat.replacers;

import java.util.regex.Matcher;
import java.util.regex.Pattern;
import net.java.sip.communicator.impl.gui.main.chat.Replacer;
import org.apache.commons.lang3.StringEscapeUtils;

public class KeywordReplacer
implements Replacer {
    private static final int INDEX_OPTIONAL_PREFIX_GROUP = 1;
    private static final int INDEX_KEYWORD_MATCH_GROUP = 2;
    private static final int INDEX_OPTIONAL_SUFFIX_GROUP = 3;
    private final String keyword;

    public KeywordReplacer(String keyword) {
        this.keyword = keyword;
    }

    @Override
    public boolean expectsPlainText() {
        return true;
    }

    @Override
    public void replace(StringBuilder target, String piece) {
        if (this.keyword == null || this.keyword.isEmpty()) {
            target.append(StringEscapeUtils.escapeHtml4((String)piece));
            return;
        }
        Matcher m = Pattern.compile("(^|\\W)(" + Pattern.quote(this.keyword) + ")(\\W|$)", 2).matcher(piece);
        int prevEnd = 0;
        while (m.find()) {
            target.append(StringEscapeUtils.escapeHtml4((String)piece.substring(prevEnd, m.start() + m.group(1).length())));
            prevEnd = m.end() - m.group(3).length();
            String keywordMatch = m.group(2).trim();
            target.append("<b>");
            target.append(StringEscapeUtils.escapeHtml4((String)keywordMatch));
            target.append("</b>");
        }
        target.append(StringEscapeUtils.escapeHtml4((String)piece.substring(prevEnd)));
    }
}

