/*
 * Decompiled with CFR 0.152.
 */
package net.java.sip.communicator.impl.gui.main.chat.history;

import java.awt.BasicStroke;
import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.Graphics;
import java.awt.Graphics2D;
import java.util.Date;
import javax.swing.JLabel;
import javax.swing.JList;
import javax.swing.JPanel;
import javax.swing.ListCellRenderer;
import net.java.sip.communicator.impl.gui.utils.Constants;
import net.java.sip.communicator.plugin.desktoputil.AntialiasingManager;
import net.java.sip.communicator.util.GuiUtils;

public class DatesListRenderer
extends JPanel
implements ListCellRenderer {
    private JLabel label = new JLabel();
    private boolean isSelected;

    public DatesListRenderer() {
        super(new BorderLayout());
        this.add(this.label);
    }

    public Component getListCellRendererComponent(JList list, Object value, int index, boolean isSelected, boolean cellHasFocus) {
        Date dateValue = (Date)value;
        StringBuffer dateStrBuf = new StringBuffer();
        GuiUtils.formatDate((long)dateValue.getTime(), (StringBuffer)dateStrBuf);
        this.label.setText(dateStrBuf.toString());
        this.isSelected = isSelected;
        return this;
    }

    @Override
    public void paintComponent(Graphics g) {
        super.paintComponent(g);
        g = g.create();
        try {
            AntialiasingManager.activateAntialiasing((Graphics)g);
            Graphics2D g2 = (Graphics2D)g;
            if (this.isSelected) {
                g2.setColor(Constants.SELECTED_COLOR);
                g2.fillRoundRect(0, 0, this.getWidth(), this.getHeight(), 7, 7);
                g2.setColor(Constants.LIST_SELECTION_BORDER_COLOR);
                g2.setStroke(new BasicStroke(1.5f));
                g2.drawRoundRect(0, 0, this.getWidth() - 1, this.getHeight() - 1, 7, 7);
            }
        }
        finally {
            g.dispose();
        }
    }
}

