/*
 * Decompiled with CFR 0.152.
 */
package net.java.sip.communicator.impl.gui.main.call;

import java.awt.Color;
import java.awt.Component;
import java.awt.Container;
import java.awt.FlowLayout;
import java.awt.Graphics;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.Image;
import java.awt.Insets;
import java.awt.LayoutManager;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.beans.PropertyChangeEvent;
import java.beans.PropertyChangeListener;
import java.util.List;
import javax.swing.BoxLayout;
import javax.swing.Icon;
import javax.swing.ImageIcon;
import javax.swing.JButton;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.SwingUtilities;
import net.java.sip.communicator.impl.gui.GuiActivator;
import net.java.sip.communicator.impl.gui.main.call.SecurityPanel;
import net.java.sip.communicator.impl.gui.main.call.SecurityStatusLabel;
import net.java.sip.communicator.impl.gui.main.call.SwingCallPeerRenderer;
import net.java.sip.communicator.impl.gui.utils.ImageLoader;
import net.java.sip.communicator.plugin.desktoputil.AntialiasingManager;
import net.java.sip.communicator.plugin.desktoputil.SIPCommButton;
import net.java.sip.communicator.plugin.desktoputil.TransparentPanel;
import net.java.sip.communicator.service.gui.PopupDialog;
import net.java.sip.communicator.service.protocol.Call;
import net.java.sip.communicator.service.protocol.CallPeer;
import net.java.sip.communicator.service.protocol.OperationSetVideoTelephony;
import net.java.sip.communicator.service.protocol.event.CallPeerSecurityOffEvent;
import net.java.sip.communicator.service.protocol.event.CallPeerSecurityOnEvent;
import net.java.sip.communicator.service.protocol.event.CallPeerSecurityTimeoutEvent;
import net.java.sip.communicator.service.protocol.media.MediaAwareCallPeer;
import net.java.sip.communicator.service.resources.ImageID;
import org.jitsi.service.configuration.ConfigurationService;
import org.jitsi.service.neomedia.ZrtpControl;
import org.jitsi.service.resources.ResourceManagementService;
import org.jitsi.util.event.VideoEvent;
import org.jitsi.util.event.VideoListener;

public class ZrtpSecurityPanel
extends SecurityPanel<ZrtpControl>
implements VideoListener,
PropertyChangeListener {
    private static Icon encryptionVerifiedIcon;
    private static Icon audioSecuredIcon;
    private static Icon audioNotSecuredIcon;
    private static Icon videoSecuredIcon;
    private static Icon videoNotSecuredIcon;
    private final JLabel securityStringLabel = this.createSecurityLabel("", null);
    private final JLabel audioSecurityLabel;
    private final JLabel videoSecurityLabel;
    private final JButton closeButton = new SIPCommButton((Image)ImageLoader.getImage(ImageLoader.CLOSE_VIDEO));
    private final JLabel compareLabel = this.createSecurityLabel("", null);
    private final JButton confirmButton = new JButton("");
    private boolean sasVerified = false;
    private boolean isAudioSecurityOn = false;
    private boolean isVideoSecurityOn = false;
    private final CallPeer callPeer;
    private final SwingCallPeerRenderer peerRenderer;
    private SecurityStatusLabel securityStatusLabel;
    private SIPCommButton zidNameButton;
    private ZidToNameThread zidNameDialogThread;
    private String zidString;
    private String zidNameKey;
    private ConfigurationService configService;
    private String zidNameValue;
    private String zidAorKey;
    private String zidAorValue;
    private boolean zidAorMismatch = false;

    public ZrtpSecurityPanel(SwingCallPeerRenderer peerRenderer, CallPeer callPeer, ZrtpControl zrtpControl) {
        super(zrtpControl);
        this.peerRenderer = peerRenderer;
        this.callPeer = callPeer;
        OperationSetVideoTelephony videoTelephony = (OperationSetVideoTelephony)callPeer.getProtocolProvider().getOperationSet(OperationSetVideoTelephony.class);
        if (videoTelephony != null) {
            videoTelephony.addVideoListener(callPeer, (VideoListener)this);
            Call call = callPeer.getCall();
            if (call != null) {
                videoTelephony.addPropertyChangeListener(call, (PropertyChangeListener)this);
            }
        }
        this.audioSecurityLabel = this.createSecurityLabel("", null);
        this.videoSecurityLabel = this.createSecurityLabel("", null);
        this.zidString = zrtpControl.getPeerZidString();
        this.zidNameKey = "net.java.sip.communicator.zrtp.ZIDNAME" + this.zidString;
        this.zidAorKey = "net.java.sip.communicator.zrtp.ZIDAOR" + this.zidString;
        this.configService = GuiActivator.getConfigurationService();
        this.zidNameValue = this.configService.getString(this.zidNameKey);
        this.zidAorValue = this.configService.getString(this.zidAorKey);
        if (this.zidAorValue != null && !this.zidAorValue.equalsIgnoreCase(callPeer.getAddress())) {
            this.zidAorMismatch = true;
            if (this.zidNameDialogThread == null) {
                this.zidNameDialogThread = new ZidToNameThread();
                this.zidNameDialogThread.start();
            }
        }
        this.loadSkin();
    }

    private void addComponents() {
        this.setAudioSecurityOn(this.isAudioSecurityOn);
        this.setVideoSecurityOn(this.isVideoSecurityOn);
        this.closeButton.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent ev) {
                ZrtpSecurityPanel.this.peerRenderer.setSecurityPanelVisible(false);
            }
        });
        this.setLayout(new GridBagLayout());
        GridBagConstraints constraints = new GridBagConstraints();
        constraints.anchor = 12;
        constraints.fill = 0;
        constraints.gridx = 0;
        constraints.gridy = 0;
        constraints.gridheight = 1;
        constraints.weightx = 0.5;
        constraints.weighty = 0.0;
        this.add(this.audioSecurityLabel, constraints);
        constraints.anchor = 12;
        constraints.fill = 0;
        constraints.gridx = 0;
        constraints.gridy = 1;
        constraints.gridheight = 1;
        constraints.weightx = 0.5;
        constraints.weighty = 0.0;
        constraints.insets = new Insets(5, 0, 0, 0);
        this.add(this.videoSecurityLabel, constraints);
        constraints.anchor = 18;
        constraints.fill = 0;
        constraints.gridx = 1;
        constraints.gridy = 0;
        constraints.gridheight = 3;
        constraints.weightx = 0.5;
        constraints.weighty = 0.0;
        constraints.insets = new Insets(0, 5, 0, 5);
        this.add(this.createSasPanel(), constraints);
        constraints.anchor = 12;
        constraints.fill = 0;
        constraints.gridx = 2;
        constraints.gridy = 0;
        constraints.gridheight = 1;
        constraints.weightx = 0.0;
        constraints.weighty = 0.0;
        constraints.insets = new Insets(0, 0, 0, 5);
        this.add(this.closeButton, constraints);
    }

    private JLabel createSecurityLabel(String text, Icon icon) {
        JLabel label = new JLabel(text, icon, 2);
        label.setForeground(Color.WHITE);
        return label;
    }

    private JPanel createSasPanel() {
        this.sasVerified = ((ZrtpControl)this.getSecurityControl()).isSecurityVerified();
        TransparentPanel sasPanel = new TransparentPanel(){

            public void paintComponent(Graphics g) {
                g = g.create();
                try {
                    AntialiasingManager.activateAntialiasing((Graphics)g);
                    g.setColor(new Color(1.0f, 1.0f, 1.0f, 0.1f));
                    g.fillRoundRect(0, 0, this.getWidth(), this.getHeight(), 10, 10);
                    g.setColor(Color.WHITE);
                    g.drawRoundRect(0, 0, this.getWidth() - 1, this.getHeight() - 1, 10, 10);
                }
                finally {
                    g.dispose();
                }
            }
        };
        sasPanel.setLayout((LayoutManager)new BoxLayout((Container)sasPanel, 1));
        this.initSasLabels();
        SIPCommButton infoButton = new SIPCommButton((Image)ImageLoader.getImage(ImageLoader.CALL_INFO));
        infoButton.setToolTipText(GuiActivator.getResources().getI18NString("service.gui.security.SAS_INFO_TOOLTIP"));
        this.compareLabel.setAlignmentX(0.5f);
        TransparentPanel stringPanel = new TransparentPanel((LayoutManager)new FlowLayout(1, 5, 0));
        stringPanel.add(this.compareLabel);
        stringPanel.add((Component)infoButton);
        this.initZidNameButton();
        stringPanel.add((Component)this.zidNameButton);
        sasPanel.add((Component)stringPanel);
        this.securityStringLabel.setAlignmentX(0.5f);
        sasPanel.add((Component)this.securityStringLabel);
        this.confirmButton.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent ev) {
                if (ZrtpSecurityPanel.this.getSecurityControl() != null) {
                    ((ZrtpControl)ZrtpSecurityPanel.this.getSecurityControl()).setSASVerification(!ZrtpSecurityPanel.this.sasVerified);
                    ZrtpSecurityPanel.this.sasVerified = !ZrtpSecurityPanel.this.sasVerified;
                    ZrtpSecurityPanel.this.securityStringLabel.setIcon(ZrtpSecurityPanel.this.sasVerified ? encryptionVerifiedIcon : null);
                    if (ZrtpSecurityPanel.this.sasVerified) {
                        ZrtpSecurityPanel.this.peerRenderer.securityOn(null);
                    } else {
                        ZrtpSecurityPanel.this.peerRenderer.securityPending();
                    }
                    ZrtpSecurityPanel.this.initSasLabels();
                }
            }
        });
        this.confirmButton.setAlignmentX(0.5f);
        sasPanel.add((Component)this.confirmButton);
        return sasPanel;
    }

    private void initSasLabels() {
        String statusLabel = "zrtp";
        String longNamelabel = GuiActivator.getResources().getI18NString("service.gui.ZID_NAME_NOT_SET");
        if (!this.sasVerified) {
            this.compareLabel.setText(GuiActivator.getResources().getI18NString("service.gui.security.COMPARE_WITH_PARTNER_SHORT"));
            this.confirmButton.setText(GuiActivator.getResources().getI18NString("service.gui.CONFIRM"));
            this.zidNameValue = null;
            this.zidAorValue = null;
            this.configService.setProperty(this.zidNameKey, (Object)this.zidNameValue);
            this.configService.setProperty(this.zidAorKey, (Object)this.zidAorValue);
        } else {
            this.compareLabel.setText(GuiActivator.getResources().getI18NString("service.gui.security.STRING_COMPARED"));
            this.confirmButton.setText(GuiActivator.getResources().getI18NString("service.gui.CLEAR"));
            if (this.zidNameValue != null) {
                String label = this.zidNameValue;
                if (this.zidNameValue.length() > 6) {
                    label = this.zidNameValue.substring(0, 6) + "...";
                }
                statusLabel = "zrtp - " + label;
                longNamelabel = GuiActivator.getResources().getI18NString("service.gui.ZID_NAME_SET") + " '" + this.zidNameValue + "'";
            }
        }
        if (this.securityStatusLabel != null) {
            this.securityStatusLabel.setText(statusLabel);
            this.securityStatusLabel.setToolTipText(longNamelabel);
        }
        if (this.compareLabel.isVisible()) {
            this.compareLabel.revalidate();
            this.compareLabel.repaint();
            this.confirmButton.revalidate();
            this.confirmButton.repaint();
        }
    }

    private void initZidNameButton() {
        this.zidNameButton = new SIPCommButton((Image)ImageLoader.getImage(new ImageID("service.gui.buttons.ZRTP_ID_BUTTON")));
        this.zidNameButton.setToolTipText(GuiActivator.getResources().getI18NString("service.gui.ZID_NAME_BUTTON"));
        this.zidNameButton.setEnabled(true);
        this.zidNameButton.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent ev) {
                if (!ZrtpSecurityPanel.this.sasVerified) {
                    return;
                }
                if (ZrtpSecurityPanel.this.zidNameDialogThread == null) {
                    ZrtpSecurityPanel.this.zidNameDialogThread = new ZidToNameThread();
                    ZrtpSecurityPanel.this.zidNameDialogThread.start();
                }
            }
        });
    }

    @Override
    public void securityOn(CallPeerSecurityOnEvent ev) {
        switch (ev.getSessionType()) {
            case 1: {
                this.setAudioSecurityOn(true);
                break;
            }
            case 2: {
                this.setVideoSecurityOn(true);
            }
        }
        String securityString = ((ZrtpControl)this.getSecurityControl()).getSecurityString();
        if (securityString != null) {
            StringBuffer sb = new StringBuffer(10);
            sb.append(securityString.charAt(0));
            sb.append(' ');
            sb.append(securityString.charAt(1));
            sb.append(' ');
            sb.append(securityString.charAt(2));
            sb.append(' ');
            sb.append(securityString.charAt(3));
            securityString = sb.toString();
            this.securityStringLabel.setText(securityString);
        } else {
            this.securityStringLabel.setText(null);
        }
        this.sasVerified = ((ZrtpControl)this.getSecurityControl()).isSecurityVerified();
        this.securityStringLabel.setIcon(this.sasVerified ? encryptionVerifiedIcon : null);
        this.revalidate();
        this.repaint();
    }

    @Override
    public void securityOff(CallPeerSecurityOffEvent ev) {
        switch (ev.getSessionType()) {
            case 1: {
                this.setAudioSecurityOn(false);
                break;
            }
            case 2: {
                this.setVideoSecurityOn(false);
            }
        }
        this.revalidate();
        this.repaint();
    }

    @Override
    public void securityTimeout(CallPeerSecurityTimeoutEvent ev) {
    }

    public void loadSkin() {
        this.removeAll();
        encryptionVerifiedIcon = new ImageIcon(ImageLoader.getImage(ImageLoader.ENCR_VERIFIED));
        audioSecuredIcon = new ImageIcon(ImageLoader.getImage(ImageLoader.SECURE_AUDIO_ON));
        audioNotSecuredIcon = new ImageIcon(ImageLoader.getImage(ImageLoader.SECURE_AUDIO_OFF));
        videoSecuredIcon = new ImageIcon(ImageLoader.getImage(ImageLoader.SECURE_VIDEO_ON));
        videoNotSecuredIcon = new ImageIcon(ImageLoader.getImage(ImageLoader.SECURE_VIDEO_OFF));
        this.addComponents();
        if (this.isVisible()) {
            this.revalidate();
            this.repaint();
        }
    }

    private void setAudioSecurityOn(final boolean isAudioSecurityOn) {
        String statusText;
        Icon statusIcon;
        if (!SwingUtilities.isEventDispatchThread()) {
            SwingUtilities.invokeLater(new Runnable(){

                @Override
                public void run() {
                    ZrtpSecurityPanel.this.setAudioSecurityOn(isAudioSecurityOn);
                }
            });
            return;
        }
        this.isAudioSecurityOn = isAudioSecurityOn;
        if (isAudioSecurityOn) {
            statusIcon = audioSecuredIcon;
            statusText = GuiActivator.getResources().getI18NString("service.gui.security.SECURE_AUDIO");
        } else {
            statusIcon = audioNotSecuredIcon;
            statusText = GuiActivator.getResources().getI18NString("service.gui.security.AUDIO_NOT_SECURED");
        }
        this.audioSecurityLabel.setIcon(statusIcon);
        this.audioSecurityLabel.setText(statusText);
    }

    private void setVideoSecurityOn(final boolean isVideoSecurityOn) {
        if (!SwingUtilities.isEventDispatchThread()) {
            SwingUtilities.invokeLater(new Runnable(){

                @Override
                public void run() {
                    ZrtpSecurityPanel.this.setVideoSecurityOn(isVideoSecurityOn);
                }
            });
            return;
        }
        this.isVideoSecurityOn = isVideoSecurityOn;
        Icon icon = null;
        String text = null;
        boolean visible = false;
        OperationSetVideoTelephony videoTelephony = (OperationSetVideoTelephony)this.callPeer.getProtocolProvider().getOperationSet(OperationSetVideoTelephony.class);
        if (videoTelephony != null) {
            visible = ((MediaAwareCallPeer)this.callPeer).isLocalVideoStreaming();
            if (!visible) {
                List videos = videoTelephony.getVisualComponents(this.callPeer);
                boolean bl = visible = videos != null && videos.size() != 0;
            }
            if (visible) {
                ResourceManagementService r = GuiActivator.getResources();
                if (isVideoSecurityOn) {
                    icon = videoSecuredIcon;
                    text = r.getI18NString("service.gui.security.SECURE_VIDEO");
                } else {
                    icon = videoNotSecuredIcon;
                    text = r.getI18NString("service.gui.security.VIDEO_NOT_SECURED");
                }
            }
        }
        if (icon != null && text != null) {
            this.videoSecurityLabel.setIcon(icon);
            this.videoSecurityLabel.setText(text);
            if (!this.videoSecurityLabel.isVisible()) {
                this.videoSecurityLabel.setVisible(true);
            }
        } else {
            this.videoSecurityLabel.setVisible(visible);
        }
        this.revalidate();
        this.repaint();
    }

    @Override
    public void propertyChange(PropertyChangeEvent ev) {
        if ("LOCAL_VIDEO_STREAMING".equals(ev.getPropertyName())) {
            this.setVideoSecurityOn(this.isVideoSecurityOn);
        }
    }

    public void videoAdded(VideoEvent ev) {
        this.setVideoSecurityOn(this.isVideoSecurityOn);
    }

    public void videoRemoved(VideoEvent ev) {
        this.setVideoSecurityOn(this.isVideoSecurityOn);
    }

    public void videoUpdate(VideoEvent ev) {
        this.setVideoSecurityOn(this.isVideoSecurityOn);
    }

    public void setSecurityStatusLabel(SecurityStatusLabel ssl) {
        this.securityStatusLabel = ssl;
    }

    public boolean isZidAorMismatch() {
        return this.zidAorMismatch;
    }

    private class ZidToNameThread
    extends Thread {
        @Override
        public void run() {
            PopupDialog dialog;
            String name;
            String message;
            String string = message = ZrtpSecurityPanel.this.zidAorMismatch ? GuiActivator.getResources().getI18NString("service.gui.ZID_NAME_UNEXPECTED") : GuiActivator.getResources().getI18NString("service.gui.ZID_NAME_SET");
            if (ZrtpSecurityPanel.this.zidNameValue == null) {
                message = GuiActivator.getResources().getI18NString("service.gui.ZID_NAME_NOT_SET");
                ZrtpSecurityPanel.this.zidNameValue = ZrtpSecurityPanel.this.callPeer.getDisplayName();
            }
            if ((name = (String)(dialog = GuiActivator.getUIService().getPopupDialog()).showInputPopupDialog((Object)message, GuiActivator.getResources().getI18NString("service.gui.ZID_NAME_DIALOG"), 1, null, (Object)ZrtpSecurityPanel.this.zidNameValue)) != null) {
                ZrtpSecurityPanel.this.zidNameValue = name;
                ZrtpSecurityPanel.this.configService.setProperty(ZrtpSecurityPanel.this.zidNameKey, (Object)ZrtpSecurityPanel.this.zidNameValue);
                ZrtpSecurityPanel.this.configService.setProperty(ZrtpSecurityPanel.this.zidAorKey, (Object)ZrtpSecurityPanel.this.callPeer.getAddress());
                String label = ZrtpSecurityPanel.this.zidNameValue;
                if (ZrtpSecurityPanel.this.zidNameValue.length() > 6) {
                    label = ZrtpSecurityPanel.this.zidNameValue.substring(0, 6) + "...";
                }
                ZrtpSecurityPanel.this.securityStatusLabel.setText("zrtp - " + label);
                ZrtpSecurityPanel.this.securityStatusLabel.setToolTipText(GuiActivator.getResources().getI18NString("service.gui.ZID_NAME_SET") + " '" + ZrtpSecurityPanel.this.zidNameValue + "'");
            } else {
                ZrtpSecurityPanel.this.securityStatusLabel.setText("zrtp");
            }
            ZrtpSecurityPanel.this.zidNameDialogThread = null;
        }
    }
}

