/*
 * Decompiled with CFR 0.152.
 */
package net.java.sip.communicator.impl.gui.lookandfeel;

import java.awt.Component;
import java.awt.Graphics;
import java.awt.Graphics2D;
import java.awt.Insets;
import java.awt.geom.GeneralPath;
import javax.swing.border.AbstractBorder;
import javax.swing.plaf.metal.MetalComboBoxEditor;
import net.java.sip.communicator.impl.gui.lookandfeel.SIPCommLookAndFeel;
import net.java.sip.communicator.plugin.desktoputil.AntialiasingManager;
import net.java.sip.communicator.plugin.desktoputil.plaf.SIPCommTextFieldUI;
import net.java.sip.communicator.util.skin.Skinnable;

public class SIPCommComboBoxEditor
extends MetalComboBoxEditor
implements Skinnable {
    protected static final Insets editorBorderInsets = new Insets(2, 2, 2, 0);
    private static final Insets SAFE_EDITOR_BORDER_INSETS = new Insets(2, 2, 2, 0);

    public SIPCommComboBoxEditor() {
        this.editor.setBorder(new EditorBorder());
        if (this.editor.getUI() instanceof SIPCommTextFieldUI) {
            ((SIPCommTextFieldUI)this.editor.getUI()).setDeleteButtonEnabled(true);
        }
    }

    public void loadSkin() {
        if (this.editor.getUI() instanceof SIPCommTextFieldUI) {
            ((SIPCommTextFieldUI)this.editor.getUI()).loadSkin();
        }
    }

    public static class UIResource
    extends SIPCommComboBoxEditor
    implements javax.swing.plaf.UIResource {
    }

    private static class EditorBorder
    extends AbstractBorder {
        private EditorBorder() {
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public void paintBorder(Component c, Graphics g, int x, int y, int w, int h) {
            g = g.create();
            try {
                this.internalPaintBorder(g, x, y, w, h);
            }
            finally {
                g.dispose();
            }
        }

        private void internalPaintBorder(Graphics g, int x, int y, int w, int h) {
            Graphics2D g2d = (Graphics2D)g;
            AntialiasingManager.activateAntialiasing((Graphics)g2d);
            g2d.translate(x, y);
            g2d.setColor(SIPCommLookAndFeel.getControlDarkShadow());
            GeneralPath path = new GeneralPath();
            int round = 2;
            path.moveTo(w, h - 1);
            path.lineTo(round, h - 1);
            path.curveTo(round, h - 1, 0.0f, h - 1, 0.0f, h - round - 1);
            path.lineTo(0.0f, round);
            path.curveTo(0.0f, round, 0.0f, 0.0f, round, 0.0f);
            path.lineTo(w, 0.0f);
            g2d.draw(path);
            g2d.translate(-x, -y);
        }

        @Override
        public Insets getBorderInsets(Component c) {
            if (System.getSecurityManager() != null) {
                return SAFE_EDITOR_BORDER_INSETS;
            }
            return editorBorderInsets;
        }
    }
}

