/*
 * Decompiled with CFR 0.152.
 */
package net.java.sip.communicator.impl.protocol.irc;

import com.ircclouds.irc.api.IRCApi;
import com.ircclouds.irc.api.IRCApiImpl;
import com.ircclouds.irc.api.IServerParameters;
import com.ircclouds.irc.api.domain.IRCServer;
import com.ircclouds.irc.api.domain.SecureIRCServer;
import com.ircclouds.irc.api.domain.messages.interfaces.IMessage;
import com.ircclouds.irc.api.listeners.IMessageListener;
import java.io.IOException;
import java.nio.channels.NotYetConnectedException;
import java.security.GeneralSecurityException;
import java.security.cert.CertificateException;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import java.util.SortedSet;
import java.util.TreeSet;
import java.util.concurrent.atomic.AtomicReference;
import javax.net.ssl.SSLContext;
import javax.net.ssl.X509TrustManager;
import net.java.sip.communicator.impl.protocol.irc.ClientConfig;
import net.java.sip.communicator.impl.protocol.irc.IdentityManager;
import net.java.sip.communicator.impl.protocol.irc.IrcActivator;
import net.java.sip.communicator.impl.protocol.irc.IrcConnection;
import net.java.sip.communicator.impl.protocol.irc.IrcConnectionListener;
import net.java.sip.communicator.impl.protocol.irc.ProtocolProviderServiceIrcImpl;
import net.java.sip.communicator.service.certificate.CertificateService;
import net.java.sip.communicator.service.protocol.OperationFailedException;
import net.java.sip.communicator.service.protocol.RegistrationState;
import net.java.sip.communicator.util.Logger;

public class IrcStack
implements IrcConnectionListener {
    private static final Logger LOGGER = Logger.getLogger(IrcStack.class);
    private final ProtocolProviderServiceIrcImpl provider;
    private final ServerParameters params;
    private final PersistentContext context;
    private final AtomicReference<IrcConnection> session = new AtomicReference<Object>(null);

    public IrcStack(ProtocolProviderServiceIrcImpl parentProvider, String nick, String login, String version, String finger) {
        if (parentProvider == null) {
            throw new NullPointerException("parentProvider cannot be null");
        }
        this.provider = parentProvider;
        this.params = new ServerParameters(nick, login, finger, null);
        this.context = new PersistentContext(this.provider);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void connect(String host, int port, String password, boolean secureConnection, boolean autoNickChange, ClientConfig config) throws OperationFailedException, Exception {
        String plainPass = this.determinePlainPassword(password, config);
        IRCServer server = this.createServer(config, host, port, secureConnection, plainPass);
        try {
            AtomicReference<IrcConnection> atomicReference = this.session;
            synchronized (atomicReference) {
                IrcConnection current = this.session.get();
                if (current != null && current.isConnected()) {
                    return;
                }
                this.params.setServer(server);
                IRCApiImpl irc = new IRCApiImpl(Boolean.valueOf(true));
                if (LOGGER.isTraceEnabled()) {
                    irc.addListener((IMessageListener)new DebugListener());
                }
                this.session.set(new IrcConnection(this.context, config, (IRCApi)irc, this.params, password, this));
                this.provider.setCurrentRegistrationState(RegistrationState.REGISTERED, 0);
            }
        }
        catch (IOException e) {
            if (this.isCausedByCertificateException(e)) {
                LOGGER.info((Object)"Connection aborted due to server certificate.");
                this.provider.setCurrentRegistrationState(RegistrationState.UNREGISTERED, 0);
                throw new OperationFailedException("Failed certificate verification.", 16);
            }
            this.provider.setCurrentRegistrationState(RegistrationState.CONNECTION_FAILED, -1);
            throw e;
        }
        catch (InterruptedException e) {
            this.provider.setCurrentRegistrationState(RegistrationState.UNREGISTERED, 0);
            throw e;
        }
        catch (NotYetConnectedException e) {
            this.provider.setCurrentRegistrationState(RegistrationState.CONNECTION_FAILED, -1);
            throw e;
        }
        catch (Exception e) {
            LOGGER.error((Object)"Unanticipated exception occurred!", (Throwable)e);
            this.provider.setCurrentRegistrationState(RegistrationState.CONNECTION_FAILED, 6);
            throw e;
        }
    }

    private IRCServer createServer(ClientConfig config, String host, int port, boolean secureConnection, String password) {
        Object server = secureConnection ? new SecureIRCServer(host, port, password, this.getCustomSSLContext(host), config.getProxy(), config.isResolveByProxy()) : new IRCServer(host, port, password, Boolean.valueOf(false), config.getProxy(), config.isResolveByProxy());
        return server;
    }

    private String determinePlainPassword(String password, ClientConfig config) {
        String plainPass = config.isVersion3Allowed() && config.getSASL() != null ? null : password;
        return plainPass;
    }

    private boolean isCausedByCertificateException(Exception e) {
        for (Throwable cause = e; cause != null; cause = cause.getCause()) {
            if (!(cause instanceof CertificateException)) continue;
            return true;
        }
        return false;
    }

    public IrcConnection getConnection() {
        return this.session.get();
    }

    PersistentContext getContext() {
        return this.context;
    }

    private SSLContext getCustomSSLContext(String hostname) {
        SSLContext context = null;
        try {
            CertificateService cs = IrcActivator.getCertificateService();
            X509TrustManager tm = cs.getTrustManager(hostname);
            context = cs.getSSLContext(tm);
        }
        catch (GeneralSecurityException e) {
            LOGGER.error((Object)"failed to create custom SSL context", (Throwable)e);
        }
        return context;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void disconnect() {
        AtomicReference<IrcConnection> atomicReference = this.session;
        synchronized (atomicReference) {
            IrcConnection connection = this.session.getAndSet(null);
            if (connection != null) {
                connection.disconnect();
            }
        }
        this.provider.setCurrentRegistrationState(RegistrationState.UNREGISTERED, 0);
    }

    public void dispose() {
        this.disconnect();
    }

    @Override
    public void connectionInterrupted(IrcConnection connection) {
        if (this.session.get() != connection) {
            LOGGER.debug((Object)"Interrupted connection is not the current connection, so assuming that connection interruption was intended.");
            return;
        }
        LOGGER.warn((Object)"IRC connection interrupted unexpectedly.");
        this.provider.setCurrentRegistrationState(RegistrationState.CONNECTION_FAILED, -1);
    }

    static final class PersistentContext {
        final ProtocolProviderServiceIrcImpl provider;
        final SortedSet<String> nickWatchList = Collections.synchronizedSortedSet(new TreeSet());

        private PersistentContext(ProtocolProviderServiceIrcImpl provider) {
            if (provider == null) {
                throw new IllegalArgumentException("provider cannot be null");
            }
            this.provider = provider;
        }
    }

    private static final class ServerParameters
    implements IServerParameters {
        private static final int NUM_INCREMENTS_FOR_ALTERNATIVES = 10;
        private String nick;
        private List<String> alternativeNicks = new ArrayList<String>();
        private String real;
        private String ident;
        private IRCServer server;

        private ServerParameters(String nickName, String realName, String ident, IRCServer server) {
            this.nick = IdentityManager.checkNick(nickName, null);
            this.alternativeNicks.add(nickName + "_");
            this.alternativeNicks.add(nickName + "__");
            this.alternativeNicks.add(nickName + "___");
            this.alternativeNicks.add(nickName + "____");
            for (int i = 1; i < 10; ++i) {
                this.alternativeNicks.add(nickName + i);
            }
            this.real = realName;
            this.ident = ident;
            this.server = server;
        }

        public String getNickname() {
            return this.nick;
        }

        public List<String> getAlternativeNicknames() {
            return this.alternativeNicks;
        }

        public String getIdent() {
            return this.ident;
        }

        public String getRealname() {
            return this.real;
        }

        public IRCServer getServer() {
            return this.server;
        }

        public void setServer(IRCServer server) {
            if (server == null) {
                throw new IllegalArgumentException("server cannot be null");
            }
            this.server = server;
        }
    }

    private static final class DebugListener
    implements IMessageListener {
        private DebugListener() {
        }

        public void onMessage(IMessage aMessage) {
            LOGGER.trace((Object)("(" + aMessage + ") " + aMessage.asRaw()));
        }
    }
}

