/*
 * Decompiled with CFR 0.152.
 */
package net.java.sip.communicator.slick.callhistory;

import java.util.Collection;
import java.util.Date;
import java.util.Hashtable;
import java.util.Iterator;
import java.util.Vector;
import junit.framework.Test;
import junit.framework.TestCase;
import junit.framework.TestSuite;
import net.java.sip.communicator.impl.protocol.mock.MockOperationSetBasicTelephony;
import net.java.sip.communicator.impl.protocol.mock.MockProvider;
import net.java.sip.communicator.service.callhistory.CallHistoryService;
import net.java.sip.communicator.service.callhistory.CallPeerRecord;
import net.java.sip.communicator.service.callhistory.CallRecord;
import net.java.sip.communicator.service.protocol.Call;
import net.java.sip.communicator.service.protocol.CallPeer;
import net.java.sip.communicator.service.protocol.OperationSetBasicTelephony;
import net.java.sip.communicator.service.protocol.ProtocolProviderService;
import net.java.sip.communicator.slick.callhistory.CallHistoryServiceLick;
import net.java.sip.communicator.util.Logger;
import org.osgi.framework.ServiceReference;
import org.osgi.framework.ServiceRegistration;

public class TestCallHistoryService
extends TestCase {
    private static final Logger logger = Logger.getLogger(TestCallHistoryService.class);
    public static MockProvider mockProvider = null;
    public static MockOperationSetBasicTelephony mockBTelphonyOpSet = null;
    private static ServiceReference callHistoryServiceRef = null;
    public static CallHistoryService callHistoryService = null;
    public static ServiceRegistration mockPrServiceRegistration = null;
    private static Date controlDate1 = null;
    private static Date controlDate2 = null;
    private static Vector<String> participantAddresses = new Vector();

    public TestCallHistoryService(String name) {
        super(name);
    }

    public static Test suite() {
        TestSuite suite = new TestSuite();
        suite.addTest((Test)new TestCallHistoryService("readRecords"));
        suite.addTest((Test)new TestCallHistoryService("checkRecordCompleteness"));
        return suite;
    }

    protected void setUp() throws Exception {
        this.setupContact();
        callHistoryService.eraseLocallyStoredHistory();
        this.writeRecords();
    }

    protected void tearDown() throws Exception {
    }

    private void setupContact() {
        System.setProperty("HistoryServiceDirectory", "test-callhistory");
        mockProvider = new MockProvider("CallHistoryMockUser");
        mockBTelphonyOpSet = (MockOperationSetBasicTelephony)mockProvider.getOperationSet(OperationSetBasicTelephony.class);
        System.setProperty("net.java.sip.communicator.service.contactlist.PROVIDER_MASK", "1");
        Hashtable<String, String> mockProvProperties = new Hashtable<String, String>();
        mockProvProperties.put("PROTOCOL_NAME", mockProvider.getProtocolName());
        mockProvProperties.put("net.java.sip.communicator.service.contactlist.PROVIDER_MASK", "1");
        mockPrServiceRegistration = CallHistoryServiceLick.bc.registerService(ProtocolProviderService.class.getName(), (Object)mockProvider, mockProvProperties);
        logger.debug((Object)"Registered a mock protocol provider! ");
        callHistoryServiceRef = CallHistoryServiceLick.bc.getServiceReference(CallHistoryService.class.getName());
        callHistoryService = (CallHistoryService)CallHistoryServiceLick.bc.getService(callHistoryServiceRef);
        participantAddresses.add("participant_address_1");
        participantAddresses.add("participant_address_2");
        participantAddresses.add("participant_address_3");
        participantAddresses.add("participant_address_4");
    }

    private void writeRecords() {
        logger.info((Object)"write records ");
        this.generateCall(participantAddresses.get(0));
        this.waitSeconds(1L);
        controlDate1 = new Date();
        this.generateCall(participantAddresses.get(1));
        this.generateCall(participantAddresses.get(2));
        this.waitSeconds(1L);
        controlDate2 = new Date();
        this.generateCall(participantAddresses.get(3));
    }

    private void generateCall(String participant) {
        try {
            Call newCall = mockBTelphonyOpSet.placeCall(participant);
            Vector<CallPeer> v = new Vector<CallPeer>();
            Iterator iter = newCall.getCallPeers();
            while (iter.hasNext()) {
                CallPeer item = (CallPeer)iter.next();
                v.add(item);
            }
            this.waitSeconds(2000L);
            for (CallPeer item : v) {
                mockBTelphonyOpSet.hangupCallPeer(item);
            }
        }
        catch (Exception ex1) {
            logger.error((Object)"Cannot place mock call", (Throwable)ex1);
            TestCallHistoryService.fail((String)("Cannot place mock call to " + participant));
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void waitSeconds(long secs) {
        Object lock;
        Object object = lock = new Object();
        synchronized (object) {
            try {
                lock.wait(secs);
            }
            catch (InterruptedException interruptedException) {
                // empty catch block
            }
        }
    }

    public void readRecords() {
        Collection rs = callHistoryService.findByEndDate(controlDate2);
        Iterator resultIter = rs.iterator();
        TestCallHistoryService.assertTrue((String)"Calls too few - findByEndDate", (rs.size() >= 3 ? 1 : 0) != 0);
        rs = callHistoryService.findByPeriod(controlDate1, controlDate2);
        resultIter = rs.iterator();
        TestCallHistoryService.assertEquals((String)"Calls must be 2", (int)rs.size(), (int)2);
        CallRecord rec = (CallRecord)resultIter.next();
        CallPeerRecord participant = (CallPeerRecord)rec.getPeerRecords().get(0);
        TestCallHistoryService.assertTrue((String)"Participant incorrect ", (boolean)participant.getPeerAddress().equals(participantAddresses.get(2)));
        rec = (CallRecord)resultIter.next();
        participant = (CallPeerRecord)rec.getPeerRecords().get(0);
        TestCallHistoryService.assertTrue((String)"Participant incorrect ", (boolean)participant.getPeerAddress().equals(participantAddresses.get(1)));
        rs = callHistoryService.findByStartDate(controlDate2);
        resultIter = rs.iterator();
        TestCallHistoryService.assertEquals((String)"Calls must be 1", (int)rs.size(), (int)1);
        rec = (CallRecord)resultIter.next();
        participant = (CallPeerRecord)rec.getPeerRecords().get(0);
        TestCallHistoryService.assertTrue((String)"Participant incorrect ", (boolean)participant.getPeerAddress().equals(participantAddresses.get(3)));
        rs = callHistoryService.findLast(3);
        resultIter = rs.iterator();
        TestCallHistoryService.assertEquals((String)"Calls must be 3", (int)rs.size(), (int)3);
        rec = (CallRecord)resultIter.next();
        participant = (CallPeerRecord)rec.getPeerRecords().get(0);
        TestCallHistoryService.assertTrue((String)"Participant incorrect ", (boolean)participant.getPeerAddress().equals(participantAddresses.get(3)));
        rec = (CallRecord)resultIter.next();
        participant = (CallPeerRecord)rec.getPeerRecords().get(0);
        TestCallHistoryService.assertTrue((String)"Participant incorrect ", (boolean)participant.getPeerAddress().equals(participantAddresses.get(2)));
        rec = (CallRecord)resultIter.next();
        participant = (CallPeerRecord)rec.getPeerRecords().get(0);
        TestCallHistoryService.assertTrue((String)"Participant incorrect ", (boolean)participant.getPeerAddress().equals(participantAddresses.get(1)));
    }

    public void checkRecordCompleteness() {
        logger.info((Object)"---=== checkRecordCompleteness ===---");
        String[] partAddresses = new String[]{"some_address", "some_new_address"};
        try {
            Call newCall = mockBTelphonyOpSet.placeCall(partAddresses[0]);
            Vector<CallPeer> v = new Vector<CallPeer>();
            Iterator iter = newCall.getCallPeers();
            while (iter.hasNext()) {
                CallPeer item = (CallPeer)iter.next();
                v.add(item);
            }
            this.waitSeconds(2000L);
            CallPeer newParticipant = mockBTelphonyOpSet.addNewCallPeer(newCall, partAddresses[1]);
            mockBTelphonyOpSet.hangupCallPeer(newParticipant);
            this.waitSeconds(2000L);
            for (CallPeer item : v) {
                mockBTelphonyOpSet.hangupCallPeer(item);
            }
        }
        catch (Exception ex1) {
            logger.error((Object)"Cannot place mock call", (Throwable)ex1);
            TestCallHistoryService.fail((String)"Cannot place mock call");
        }
        Collection lastCall = callHistoryService.findLast(1);
        TestCallHistoryService.assertEquals((String)"There must be 1 Call", (int)1, (int)lastCall.size());
        CallRecord callRecord = (CallRecord)lastCall.iterator().next();
        TestCallHistoryService.assertEquals((String)"There must be 2 participants in the call", (int)2, (int)callRecord.getPeerRecords().size());
        CallPeerRecord callP1 = callRecord.findPeerRecord(partAddresses[0]);
        CallPeerRecord callP2 = callRecord.findPeerRecord(partAddresses[1]);
        TestCallHistoryService.assertTrue((String)"Second participant added after first one", (boolean)callP2.getStartTime().after(callP1.getStartTime()));
        TestCallHistoryService.assertTrue((String)"Second participant hanguped before first one", (boolean)callP2.getEndTime().before(callP1.getEndTime()));
    }
}

