/*
 * Decompiled with CFR 0.152.
 */
package org.jivesoftware.smack;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.CopyOnWriteArrayList;
import java.util.logging.Logger;
import org.jivesoftware.smack.AbstractConnectionListener;
import org.jivesoftware.smack.Connection;
import org.jivesoftware.smack.ConnectionCreationListener;
import org.jivesoftware.smack.PacketListener;
import org.jivesoftware.smack.RosterEntry;
import org.jivesoftware.smack.RosterGroup;
import org.jivesoftware.smack.RosterListener;
import org.jivesoftware.smack.XMPPException;
import org.jivesoftware.smack.filter.PacketTypeFilter;
import org.jivesoftware.smack.packet.IQ;
import org.jivesoftware.smack.packet.Packet;
import org.jivesoftware.smack.packet.Presence;
import org.jivesoftware.smack.packet.RosterPacket;
import org.jivesoftware.smack.packet.XMPPError;
import org.jivesoftware.smack.util.StringUtils;

public class Roster {
    private static final Logger LOGGER = Logger.getLogger(Roster.class.getName());
    private static SubscriptionMode defaultSubscriptionMode = SubscriptionMode.accept_all;
    private Connection connection;
    private final Map<String, RosterGroup> groups;
    private final Map<String, RosterEntry> entries;
    private final List<RosterEntry> unfiledEntries;
    private final List<RosterListener> rosterListeners;
    private Map<String, Map<String, Presence>> presenceMap;
    boolean rosterInitialized = false;
    private PresencePacketListener presencePacketListener;
    private SubscriptionMode subscriptionMode = Roster.getDefaultSubscriptionMode();

    public static SubscriptionMode getDefaultSubscriptionMode() {
        return defaultSubscriptionMode;
    }

    public static void setDefaultSubscriptionMode(SubscriptionMode subscriptionMode) {
        defaultSubscriptionMode = subscriptionMode;
    }

    Roster(Connection connection) {
        this.connection = connection;
        this.groups = new ConcurrentHashMap<String, RosterGroup>();
        this.unfiledEntries = new CopyOnWriteArrayList<RosterEntry>();
        this.entries = new ConcurrentHashMap<String, RosterEntry>();
        this.rosterListeners = new CopyOnWriteArrayList<RosterListener>();
        this.presenceMap = new ConcurrentHashMap<String, Map<String, Presence>>();
        PacketTypeFilter rosterFilter = new PacketTypeFilter(RosterPacket.class);
        connection.addPacketListener(new RosterPacketListener(), rosterFilter);
        PacketTypeFilter presenceFilter = new PacketTypeFilter(Presence.class);
        this.presencePacketListener = new PresencePacketListener();
        connection.addPacketListener(this.presencePacketListener, presenceFilter);
        final AbstractConnectionListener connectionListener = new AbstractConnectionListener(){

            @Override
            public void connectionClosed() {
                Roster.this.setOfflinePresences();
            }

            @Override
            public void connectionClosedOnError(Exception e) {
                Roster.this.setOfflinePresences();
            }
        };
        if (!this.connection.isConnected()) {
            Connection.addConnectionCreationListener(new ConnectionCreationListener(){

                @Override
                public void connectionCreated(Connection connection) {
                    if (connection.equals(Roster.this.connection)) {
                        Roster.this.connection.addConnectionListener(connectionListener);
                    }
                }
            });
        } else {
            connection.addConnectionListener(connectionListener);
        }
    }

    public SubscriptionMode getSubscriptionMode() {
        return this.subscriptionMode;
    }

    public void setSubscriptionMode(SubscriptionMode subscriptionMode) {
        this.subscriptionMode = subscriptionMode;
    }

    public void reload() {
        if (!this.connection.isAuthenticated()) {
            throw new IllegalStateException("Not logged in to server.");
        }
        if (this.connection.isAnonymous()) {
            throw new IllegalStateException("Anonymous users can't have a roster.");
        }
        this.connection.sendPacket(new RosterPacket());
    }

    public void addRosterListener(RosterListener rosterListener) {
        if (!this.rosterListeners.contains(rosterListener)) {
            this.rosterListeners.add(rosterListener);
        }
    }

    public void removeRosterListener(RosterListener rosterListener) {
        this.rosterListeners.remove(rosterListener);
    }

    public RosterGroup createGroup(String name) {
        if (!this.connection.isAuthenticated()) {
            throw new IllegalStateException("Not logged in to server.");
        }
        if (this.connection.isAnonymous()) {
            throw new IllegalStateException("Anonymous users can't have a roster.");
        }
        if (this.groups.containsKey(name)) {
            throw new IllegalArgumentException("Group with name " + name + " alread exists.");
        }
        RosterGroup group = new RosterGroup(name, this.connection);
        this.groups.put(name, group);
        return group;
    }

    public void createEntry(String user, String name, String[] groups) throws XMPPException {
        if (!this.connection.isAuthenticated()) {
            throw new IllegalStateException("Not logged in to server.");
        }
        if (this.connection.isAnonymous()) {
            throw new IllegalStateException("Anonymous users can't have a roster.");
        }
        RosterPacket rosterPacket = new RosterPacket();
        rosterPacket.setType(IQ.Type.SET);
        RosterPacket.Item item = new RosterPacket.Item(user, name);
        if (groups != null) {
            for (String group : groups) {
                if (group == null || group.trim().length() <= 0) continue;
                item.addGroupName(group);
            }
        }
        rosterPacket.addRosterItem(item);
        this.connection.createPacketCollectorAndSend(rosterPacket).nextResultOrThrow();
        Presence presencePacket = new Presence(Presence.Type.subscribe);
        presencePacket.setTo(user);
        this.connection.sendPacket(presencePacket);
    }

    public void removeEntry(RosterEntry entry) throws XMPPException {
        if (!this.connection.isAuthenticated()) {
            throw new IllegalStateException("Not logged in to server.");
        }
        if (this.connection.isAnonymous()) {
            throw new IllegalStateException("Anonymous users can't have a roster.");
        }
        if (!this.entries.containsKey(entry.getUser())) {
            return;
        }
        RosterPacket packet = new RosterPacket();
        packet.setType(IQ.Type.SET);
        RosterPacket.Item item = RosterEntry.toRosterItem(entry);
        item.setItemType(RosterPacket.ItemType.remove);
        packet.addRosterItem(item);
        this.connection.createPacketCollectorAndSend(packet).nextResultOrThrow();
    }

    public int getEntryCount() {
        return this.getEntries().size();
    }

    public Collection<RosterEntry> getEntries() {
        HashSet<RosterEntry> allEntries = new HashSet<RosterEntry>();
        for (RosterGroup rosterGroup : this.getGroups()) {
            allEntries.addAll(rosterGroup.getEntries());
        }
        allEntries.addAll(this.unfiledEntries);
        return Collections.unmodifiableCollection(allEntries);
    }

    public int getUnfiledEntryCount() {
        return this.unfiledEntries.size();
    }

    public Collection<RosterEntry> getUnfiledEntries() {
        return Collections.unmodifiableList(this.unfiledEntries);
    }

    public RosterEntry getEntry(String user) {
        if (user == null) {
            return null;
        }
        return this.entries.get(user.toLowerCase());
    }

    public boolean contains(String user) {
        return this.getEntry(user) != null;
    }

    public RosterGroup getGroup(String name) {
        return this.groups.get(name);
    }

    public int getGroupCount() {
        return this.groups.size();
    }

    public Collection<RosterGroup> getGroups() {
        return Collections.unmodifiableCollection(this.groups.values());
    }

    public Presence getPresence(String user) {
        String key = this.getPresenceMapKey(StringUtils.parseBareAddress(user));
        Map<String, Presence> userPresences = this.presenceMap.get(key);
        if (userPresences == null) {
            Presence presence = new Presence(Presence.Type.unavailable);
            presence.setFrom(user);
            return presence;
        }
        Presence presence = null;
        for (String resource : userPresences.keySet()) {
            Presence.Mode presenceMode;
            Presence p = userPresences.get(resource);
            if (!p.isAvailable()) continue;
            if (presence == null || p.getPriority() > presence.getPriority()) {
                presence = p;
                continue;
            }
            if (p.getPriority() != presence.getPriority()) continue;
            Presence.Mode pMode = p.getMode();
            if (pMode == null) {
                pMode = Presence.Mode.available;
            }
            if ((presenceMode = presence.getMode()) == null) {
                presenceMode = Presence.Mode.available;
            }
            if (pMode.compareTo(presenceMode) >= 0) continue;
            presence = p;
        }
        if (presence == null) {
            presence = new Presence(Presence.Type.unavailable);
            presence.setFrom(user);
            return presence;
        }
        return presence;
    }

    public Presence getPresenceResource(String userWithResource) {
        String key = this.getPresenceMapKey(userWithResource);
        String resource = StringUtils.parseResource(userWithResource);
        Map<String, Presence> userPresences = this.presenceMap.get(key);
        if (userPresences == null) {
            Presence presence = new Presence(Presence.Type.unavailable);
            presence.setFrom(userWithResource);
            return presence;
        }
        Presence presence = userPresences.get(resource);
        if (presence == null) {
            presence = new Presence(Presence.Type.unavailable);
            presence.setFrom(userWithResource);
            return presence;
        }
        return presence;
    }

    public Iterator<Presence> getPresences(String user) {
        String key = this.getPresenceMapKey(user);
        Map<String, Presence> userPresences = this.presenceMap.get(key);
        if (userPresences == null) {
            Presence presence = new Presence(Presence.Type.unavailable);
            presence.setFrom(user);
            return Arrays.asList(presence).iterator();
        }
        ArrayList<Presence> answer = new ArrayList<Presence>();
        for (Presence presence : userPresences.values()) {
            if (!presence.isAvailable()) continue;
            answer.add(presence);
        }
        if (!answer.isEmpty()) {
            return answer.iterator();
        }
        Presence presence = new Presence(Presence.Type.unavailable);
        presence.setFrom(user);
        return Arrays.asList(presence).iterator();
    }

    void cleanup() {
        this.rosterListeners.clear();
    }

    private String getPresenceMapKey(String user) {
        if (user == null) {
            return null;
        }
        String key = user;
        if (!this.contains(user)) {
            key = StringUtils.parseBareAddress(user);
        }
        return key.toLowerCase();
    }

    private void setOfflinePresences() {
        for (String user : this.presenceMap.keySet()) {
            Map<String, Presence> resources = this.presenceMap.get(user);
            if (resources == null) continue;
            for (String resource : resources.keySet()) {
                Presence packetUnavailable = new Presence(Presence.Type.unavailable);
                packetUnavailable.setFrom(user + "/" + resource);
                this.presencePacketListener.processPacket(packetUnavailable);
            }
        }
    }

    private void fireRosterChangedEvent(Collection<String> addedEntries, Collection<String> updatedEntries, Collection<String> deletedEntries) {
        for (RosterListener listener : this.rosterListeners) {
            if (!addedEntries.isEmpty()) {
                listener.entriesAdded(addedEntries);
            }
            if (!updatedEntries.isEmpty()) {
                listener.entriesUpdated(updatedEntries);
            }
            if (deletedEntries.isEmpty()) continue;
            listener.entriesDeleted(deletedEntries);
        }
    }

    private void fireRosterChangedEvent(XMPPError error, Packet packet) {
        for (RosterListener listener : this.rosterListeners) {
            listener.rosterError(error, packet);
        }
    }

    private void fireRosterPresenceEvent(Presence presence) {
        for (RosterListener listener : this.rosterListeners) {
            listener.presenceChanged(presence);
        }
    }

    private class RosterPacketListener
    implements PacketListener {
        private RosterPacketListener() {
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public void processPacket(Packet packet) {
            if (packet.getError() != null) {
                Roster.this.fireRosterChangedEvent(packet.getError(), packet);
                return;
            }
            RosterPacket rosterPacket = (RosterPacket)packet;
            String jid = StringUtils.parseBareAddress(Roster.this.connection.getUser());
            String service = StringUtils.parseServer(Roster.this.connection.getUser());
            String from = rosterPacket.getFrom();
            if (from != null && !from.equals(jid) && !from.equals(service)) {
                LOGGER.warning("Ignoring roster push with a non matching 'from' ourJid='" + jid + "' from='" + from + "'");
                XMPPError error = new XMPPError(XMPPError.Condition.service_unavailable, "");
                IQ errorIQ = IQ.createErrorResponse(rosterPacket, error);
                Roster.this.connection.sendPacket(errorIQ);
                return;
            }
            ArrayList<String> addedEntries = new ArrayList<String>();
            ArrayList<String> updatedEntries = new ArrayList<String>();
            ArrayList<String> deletedEntries = new ArrayList<String>();
            for (RosterPacket.Item item : rosterPacket.getRosterItems()) {
                RosterEntry entry = new RosterEntry(item.getUser(), item.getName(), item.getItemType(), item.getItemStatus(), Roster.this, Roster.this.connection);
                if (RosterPacket.ItemType.remove.equals((Object)item.getItemType())) {
                    if (Roster.this.entries.containsKey(item.getUser())) {
                        Roster.this.entries.remove(item.getUser());
                    }
                    if (Roster.this.unfiledEntries.contains(entry)) {
                        Roster.this.unfiledEntries.remove(entry);
                    }
                    String key = StringUtils.parseName(item.getUser()) + "@" + StringUtils.parseServer(item.getUser());
                    Roster.this.presenceMap.remove(key);
                    deletedEntries.add(item.getUser());
                } else {
                    if (!Roster.this.entries.containsKey(item.getUser())) {
                        Roster.this.entries.put(item.getUser(), entry);
                        addedEntries.add(item.getUser());
                    } else {
                        RosterEntry oldEntry = Roster.this.entries.put(item.getUser(), entry);
                        RosterPacket.Item oldItem = RosterEntry.toRosterItem(oldEntry);
                        if (oldEntry == null || !oldEntry.equalsDeep(entry) || !item.getGroupNames().equals(oldItem.getGroupNames())) {
                            updatedEntries.add(item.getUser());
                        }
                    }
                    if (!item.getGroupNames().isEmpty()) {
                        Roster.this.unfiledEntries.remove(entry);
                    } else if (!Roster.this.unfiledEntries.contains(entry)) {
                        Roster.this.unfiledEntries.add(entry);
                    }
                }
                ArrayList<String> currentGroupNames = new ArrayList<String>();
                for (RosterGroup rosterGroup : Roster.this.getGroups()) {
                    if (!rosterGroup.contains(entry)) continue;
                    currentGroupNames.add(rosterGroup.getName());
                }
                if (!RosterPacket.ItemType.remove.equals((Object)item.getItemType())) {
                    ArrayList<String> newGroupNames = new ArrayList<String>();
                    for (String groupName : item.getGroupNames()) {
                        newGroupNames.add(groupName);
                        RosterGroup group2 = Roster.this.getGroup(groupName);
                        if (group2 == null) {
                            group2 = Roster.this.createGroup(groupName);
                            Roster.this.groups.put(groupName, group2);
                        }
                        group2.addEntryLocal(entry);
                    }
                    for (String newGroupName : newGroupNames) {
                        currentGroupNames.remove(newGroupName);
                    }
                }
                for (String string : currentGroupNames) {
                    RosterGroup group = Roster.this.getGroup(string);
                    group.removeEntryLocal(entry);
                    if (group.getEntryCount() != 0) continue;
                    Roster.this.groups.remove(string);
                }
                for (RosterGroup rosterGroup : Roster.this.getGroups()) {
                    if (rosterGroup.getEntryCount() != 0) continue;
                    Roster.this.groups.remove(rosterGroup.getName());
                }
            }
            Roster roster = Roster.this;
            synchronized (roster) {
                Roster.this.rosterInitialized = true;
                Roster.this.notifyAll();
            }
            Roster.this.fireRosterChangedEvent(addedEntries, updatedEntries, deletedEntries);
        }
    }

    private class PresencePacketListener
    implements PacketListener {
        private PresencePacketListener() {
        }

        @Override
        public void processPacket(Packet packet) {
            Presence presence = (Presence)packet;
            String from = presence.getFrom();
            String key = Roster.this.getPresenceMapKey(from);
            if (presence.getType() == Presence.Type.available) {
                Map<String, Presence> userPresences;
                if (Roster.this.presenceMap.get(key) == null) {
                    userPresences = new ConcurrentHashMap();
                    Roster.this.presenceMap.put(key, userPresences);
                } else {
                    userPresences = (Map)Roster.this.presenceMap.get(key);
                }
                userPresences.remove("");
                userPresences.put(StringUtils.parseResource(from), presence);
                RosterEntry entry = (RosterEntry)Roster.this.entries.get(key);
                if (entry != null) {
                    Roster.this.fireRosterPresenceEvent(presence);
                }
            } else if (presence.getType() == Presence.Type.unavailable) {
                Map<String, Presence> userPresences;
                if ("".equals(StringUtils.parseResource(from))) {
                    if (Roster.this.presenceMap.get(key) == null) {
                        userPresences = new ConcurrentHashMap();
                        Roster.this.presenceMap.put(key, userPresences);
                    } else {
                        userPresences = (Map)Roster.this.presenceMap.get(key);
                    }
                    userPresences.put("", presence);
                } else if (Roster.this.presenceMap.get(key) != null) {
                    userPresences = (Map)Roster.this.presenceMap.get(key);
                    userPresences.put(StringUtils.parseResource(from), presence);
                }
                RosterEntry entry = (RosterEntry)Roster.this.entries.get(key);
                if (entry != null) {
                    Roster.this.fireRosterPresenceEvent(presence);
                } else {
                    Roster.this.presenceMap.remove(key);
                }
            } else if (presence.getType() == Presence.Type.subscribe) {
                if (Roster.this.subscriptionMode == SubscriptionMode.accept_all) {
                    Presence response = new Presence(Presence.Type.subscribed);
                    response.setTo(presence.getFrom());
                    Roster.this.connection.sendPacket(response);
                } else if (Roster.this.subscriptionMode == SubscriptionMode.reject_all) {
                    Presence response = new Presence(Presence.Type.unsubscribed);
                    response.setTo(presence.getFrom());
                    Roster.this.connection.sendPacket(response);
                }
            } else if (presence.getType() == Presence.Type.unsubscribe) {
                if (Roster.this.subscriptionMode != SubscriptionMode.manual) {
                    Presence response = new Presence(Presence.Type.unsubscribed);
                    response.setTo(presence.getFrom());
                    Roster.this.connection.sendPacket(response);
                }
            } else if (presence.getType() == Presence.Type.error && "".equals(StringUtils.parseResource(from))) {
                Map<String, Presence> userPresences;
                if (!Roster.this.presenceMap.containsKey(key)) {
                    userPresences = new ConcurrentHashMap();
                    Roster.this.presenceMap.put(key, userPresences);
                } else {
                    userPresences = (Map)Roster.this.presenceMap.get(key);
                    userPresences.clear();
                }
                userPresences.put("", presence);
                RosterEntry entry = (RosterEntry)Roster.this.entries.get(key);
                if (entry != null) {
                    Roster.this.fireRosterPresenceEvent(presence);
                }
            }
        }
    }

    public static enum SubscriptionMode {
        accept_all,
        reject_all,
        manual;

    }
}

