/*
 * Decompiled with CFR 0.152.
 */
package net.java.sip.communicator.slick.protocol.jabber;

import java.util.Hashtable;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Vector;
import junit.framework.TestCase;
import net.java.sip.communicator.service.protocol.Contact;
import net.java.sip.communicator.service.protocol.ContactGroup;
import net.java.sip.communicator.service.protocol.OperationFailedException;
import net.java.sip.communicator.service.protocol.OperationSetPersistentPresence;
import net.java.sip.communicator.service.protocol.ProtocolProviderFactory;
import net.java.sip.communicator.service.protocol.ProtocolProviderService;
import org.osgi.framework.Bundle;
import org.osgi.framework.BundleContext;
import org.osgi.framework.InvalidSyntaxException;
import org.osgi.framework.ServiceReference;

public class JabberSlickFixture
extends TestCase {
    public static BundleContext bc = null;
    public ServiceReference provider1ServiceRef = null;
    public ProtocolProviderService provider1 = null;
    public String userID1 = null;
    public ServiceReference provider2ServiceRef = null;
    public ProtocolProviderService provider2 = null;
    public String userID2 = null;
    public ServiceReference provider3ServiceRef = null;
    public ProtocolProviderService provider3 = null;
    public String userID3 = null;
    public String chatRoomName = null;
    public ProtocolProviderFactory providerFactory = null;
    public static Bundle providerBundle = null;
    public static boolean onlineTestingDisabled = false;
    public static Hashtable<String, List<String>> preInstalledBuddyList = null;

    public void setUp() throws Exception {
        ServiceReference[] serRefs = null;
        String osgiFilter = "(PROTOCOL_NAME=Jabber)";
        try {
            serRefs = bc.getServiceReferences(ProtocolProviderFactory.class.getName(), osgiFilter);
        }
        catch (InvalidSyntaxException ex) {
            JabberSlickFixture.fail((String)(osgiFilter + " is not a valid osgi filter"));
        }
        JabberSlickFixture.assertTrue((String)"Failed to find a provider factory service for protocol Jabber", (serRefs != null && serRefs.length > 0 ? 1 : 0) != 0);
        this.providerFactory = (ProtocolProviderFactory)bc.getService(serRefs[0]);
        this.userID1 = System.getProperty("accounts.jabber.account1.USER_ID");
        this.userID2 = System.getProperty("accounts.jabber.account2.USER_ID");
        this.userID3 = System.getProperty("accounts.jabber.account3.USER_ID");
        this.chatRoomName = System.getProperty("accounts.jabber.CHAT_ROOM_NAME");
        ServiceReference[] jabberProvider1Refs = bc.getServiceReferences(ProtocolProviderService.class.getName(), "(&(PROTOCOL_NAME=Jabber)(USER_ID=" + this.userID1 + "))");
        JabberSlickFixture.assertNotNull((String)("No Protocol Provider was found for Jabber account1:" + this.userID1), (Object)jabberProvider1Refs);
        JabberSlickFixture.assertTrue((String)("No Protocol Provider was found for Jabber account1:" + this.userID1), (jabberProvider1Refs.length > 0 ? 1 : 0) != 0);
        ServiceReference[] jabberProvider2Refs = bc.getServiceReferences(ProtocolProviderService.class.getName(), "(&(PROTOCOL_NAME=Jabber)(USER_ID=" + this.userID2 + "))");
        JabberSlickFixture.assertNotNull((String)("No Protocol Provider was found for Jabber account2:" + this.userID2), (Object)jabberProvider2Refs);
        JabberSlickFixture.assertTrue((String)("No Protocol Provider was found for Jabber account2:" + this.userID2), (jabberProvider2Refs.length > 0 ? 1 : 0) != 0);
        ServiceReference[] jabberProvider3Refs = bc.getServiceReferences(ProtocolProviderService.class.getName(), "(&(PROTOCOL_NAME=Jabber)(USER_ID=" + this.userID3 + "))");
        JabberSlickFixture.assertNotNull((String)("No Protocol Provider was found for Jabber account3:" + this.userID3), (Object)jabberProvider3Refs);
        JabberSlickFixture.assertTrue((String)("No Protocol Provider was found for Jabber account3:" + this.userID3), (jabberProvider3Refs.length > 0 ? 1 : 0) != 0);
        this.provider1ServiceRef = jabberProvider1Refs[0];
        this.provider1 = (ProtocolProviderService)bc.getService(this.provider1ServiceRef);
        this.provider2ServiceRef = jabberProvider2Refs[0];
        this.provider2 = (ProtocolProviderService)bc.getService(this.provider2ServiceRef);
        this.provider3ServiceRef = jabberProvider3Refs[0];
        this.provider3 = (ProtocolProviderService)bc.getService(this.provider3ServiceRef);
    }

    public void tearDown() {
        bc.ungetService(this.provider1ServiceRef);
        bc.ungetService(this.provider2ServiceRef);
        bc.ungetService(this.provider3ServiceRef);
    }

    public Bundle findProtocolProviderBundle(ProtocolProviderService provider) {
        Bundle[] bundles = bc.getBundles();
        for (int i = 0; i < bundles.length; ++i) {
            ServiceReference[] registeredServices = bundles[i].getRegisteredServices();
            if (registeredServices == null) continue;
            for (int j = 0; j < registeredServices.length; ++j) {
                Object service = bc.getService(registeredServices[j]);
                if (service != provider) continue;
                return bundles[i];
            }
        }
        return null;
    }

    public void clearProvidersLists() throws Exception {
        this.clearProvider(this.provider1);
        this.clearProvider(this.provider2);
        this.clearProvider(this.provider3);
    }

    public void clearProvider(ProtocolProviderService provider) throws IllegalArgumentException, IllegalStateException, OperationFailedException {
        Map supportedOperationSets = provider.getSupportedOperationSets();
        if (supportedOperationSets == null || supportedOperationSets.size() < 1) {
            throw new NullPointerException("No OperationSet implementations are supported by this Jabber implementation. ");
        }
        OperationSetPersistentPresence opSetPersPresence = (OperationSetPersistentPresence)supportedOperationSets.get(OperationSetPersistentPresence.class.getName());
        if (opSetPersPresence == null) {
            throw new NullPointerException("An implementation of the Jabber service must provide an implementation of at least the one of the Presence Operation Sets");
        }
        this.deleteGroups(opSetPersPresence);
    }

    public void deleteGroups(OperationSetPersistentPresence opSetPersPresence) throws IllegalArgumentException, IllegalStateException, OperationFailedException {
        ContactGroup rootGroup = opSetPersPresence.getServerStoredContactListRoot();
        Vector groupsToRemove = new Vector();
        Iterator iter = rootGroup.subgroups();
        while (iter.hasNext()) {
            groupsToRemove.add(iter.next());
        }
        for (ContactGroup item : groupsToRemove) {
            opSetPersPresence.removeServerStoredContactGroup(item);
        }
        Vector contactsToRemove = new Vector();
        Iterator iter2 = rootGroup.contacts();
        while (iter2.hasNext()) {
            contactsToRemove.add(iter2.next());
        }
        iter2 = contactsToRemove.iterator();
        while (iter2.hasNext()) {
            opSetPersPresence.unsubscribe((Contact)iter2.next());
        }
    }
}

