/*
 * Decompiled with CFR 0.152.
 */
package net.java.sip.communicator.slick.protocol.generic;

import java.util.Hashtable;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Vector;
import junit.framework.TestCase;
import net.java.sip.communicator.service.protocol.Contact;
import net.java.sip.communicator.service.protocol.ContactGroup;
import net.java.sip.communicator.service.protocol.OperationFailedException;
import net.java.sip.communicator.service.protocol.OperationSetPersistentPresence;
import net.java.sip.communicator.service.protocol.ProtocolProviderFactory;
import net.java.sip.communicator.service.protocol.ProtocolProviderService;
import org.osgi.framework.Bundle;
import org.osgi.framework.BundleContext;
import org.osgi.framework.ServiceReference;

public abstract class AdHocMultiUserChatSlickFixture
extends TestCase {
    public static BundleContext bc = null;
    public ServiceReference provider1ServiceRef = null;
    public ProtocolProviderService provider1 = null;
    public String userID1 = null;
    public ServiceReference provider2ServiceRef = null;
    public ProtocolProviderService provider2 = null;
    public String userID2 = null;
    public ServiceReference provider3ServiceRef = null;
    public ProtocolProviderService provider3 = null;
    public String userID3 = null;
    public ProtocolProviderFactory providerFactory = null;
    public static boolean onlineTestingDisabled = false;
    public static Hashtable<String, List<String>> preInstalledBuddyList = null;
    public static Bundle providerBundle = null;

    public void clearProvidersLists() throws IllegalArgumentException, IllegalStateException, OperationFailedException {
        Map supportedOperationSets1 = this.provider1.getSupportedOperationSets();
        if (supportedOperationSets1 == null || supportedOperationSets1.size() < 1) {
            throw new NullPointerException("No OperationSet implementations are supported by this msn implementation. ");
        }
        OperationSetPersistentPresence opSetPersPresence1 = (OperationSetPersistentPresence)supportedOperationSets1.get(OperationSetPersistentPresence.class.getName());
        if (opSetPersPresence1 == null) {
            throw new NullPointerException("An implementation of the msn service must provide an implementation of at least the one of the Presence Operation Sets");
        }
        Map supportedOperationSets2 = this.provider2.getSupportedOperationSets();
        if (supportedOperationSets2 == null || supportedOperationSets2.size() < 1) {
            throw new NullPointerException("No OperationSet implementations are supported by this msn implementation. ");
        }
        OperationSetPersistentPresence opSetPersPresence2 = (OperationSetPersistentPresence)supportedOperationSets2.get(OperationSetPersistentPresence.class.getName());
        if (opSetPersPresence2 == null) {
            throw new NullPointerException("An implementation of the msn service must provide an implementation of at least the one of the Presence Operation Sets");
        }
        Map supportedOperationSets3 = this.provider3.getSupportedOperationSets();
        if (supportedOperationSets3 == null || supportedOperationSets3.size() < 1) {
            throw new NullPointerException("No OperationSet implementations are supported by this msn implementation. ");
        }
        OperationSetPersistentPresence opSetPersPresence3 = (OperationSetPersistentPresence)supportedOperationSets3.get(OperationSetPersistentPresence.class.getName());
        if (opSetPersPresence3 == null) {
            throw new NullPointerException("An implementation of the msn service must provide an implementation of at least the one of the Presence Operation Sets");
        }
        this.deleteGroups(opSetPersPresence1);
        this.deleteGroups(opSetPersPresence2);
        this.deleteGroups(opSetPersPresence3);
    }

    public static Bundle findProtocolProviderBundle(ProtocolProviderService provider) {
        Bundle[] bundles = bc.getBundles();
        for (int i = 0; i < bundles.length; ++i) {
            ServiceReference[] registeredServices = bundles[i].getRegisteredServices();
            if (registeredServices == null) continue;
            for (int j = 0; j < registeredServices.length; ++j) {
                Object service = bc.getService(registeredServices[j]);
                if (service != provider) continue;
                return bundles[i];
            }
        }
        return null;
    }

    public void deleteGroups(OperationSetPersistentPresence opSetPersPresence) throws IllegalArgumentException, IllegalStateException, OperationFailedException {
        ContactGroup rootGroup = opSetPersPresence.getServerStoredContactListRoot();
        Vector groupsToRemove = new Vector();
        Iterator iter = rootGroup.subgroups();
        while (iter.hasNext()) {
            groupsToRemove.add(iter.next());
        }
        for (ContactGroup item : groupsToRemove) {
            opSetPersPresence.removeServerStoredContactGroup(item);
        }
        Vector contactsToRemove = new Vector();
        Iterator iter2 = rootGroup.contacts();
        while (iter2.hasNext()) {
            contactsToRemove.add(iter2.next());
        }
        iter2 = contactsToRemove.iterator();
        while (iter2.hasNext()) {
            opSetPersPresence.unsubscribe((Contact)iter2.next());
        }
    }

    public void setUp() throws Exception {
        super.setUp();
    }

    public void tearDown() throws Exception {
        bc.ungetService(this.provider1ServiceRef);
        bc.ungetService(this.provider2ServiceRef);
        bc.ungetService(this.provider3ServiceRef);
    }
}

