/*
 * Decompiled with CFR 0.152.
 */
package net.java.sip.communicator.plugin.loggingutils;

import java.awt.BorderLayout;
import java.awt.Color;
import java.awt.Component;
import java.awt.Container;
import java.awt.FlowLayout;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.GridLayout;
import java.awt.Insets;
import java.awt.LayoutManager;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.io.File;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.OutputStream;
import java.util.ArrayList;
import javax.swing.BorderFactory;
import javax.swing.JButton;
import javax.swing.JCheckBox;
import javax.swing.JLabel;
import javax.swing.JScrollPane;
import javax.swing.JTextArea;
import javax.swing.JTextField;
import javax.swing.event.DocumentEvent;
import javax.swing.event.DocumentListener;
import net.java.sip.communicator.plugin.desktoputil.GenericFileDialog;
import net.java.sip.communicator.plugin.desktoputil.SIPCommCheckBox;
import net.java.sip.communicator.plugin.desktoputil.SIPCommDialog;
import net.java.sip.communicator.plugin.desktoputil.SIPCommTextField;
import net.java.sip.communicator.plugin.desktoputil.SipCommFileChooser;
import net.java.sip.communicator.plugin.desktoputil.TransparentPanel;
import net.java.sip.communicator.plugin.loggingutils.LoggingUtilsActivator;
import net.java.sip.communicator.plugin.loggingutils.LogsCollector;
import net.java.sip.communicator.service.httputil.HttpUtils;
import net.java.sip.communicator.service.notification.NotificationService;
import net.java.sip.communicator.util.Logger;
import org.jitsi.service.packetlogging.PacketLoggingConfiguration;
import org.jitsi.service.packetlogging.PacketLoggingService;
import org.jitsi.service.resources.ResourceManagementService;
import org.jitsi.util.StringUtils;

public class LoggingConfigForm
extends TransparentPanel
implements ActionListener,
DocumentListener {
    private static final long serialVersionUID = 0L;
    private static final Logger logger = Logger.getLogger(LoggingConfigForm.class);
    private static final String UPLOAD_LOCATION_PROPETY = "plugin.loggingutils.uploadlocation";
    private JCheckBox enableCheckBox;
    private JCheckBox sipProtocolCheckBox;
    private JCheckBox jabberProtocolCheckBox;
    private JCheckBox rtpProtocolCheckBox;
    private JCheckBox ice4jProtocolCheckBox;
    private JLabel fileCountLabel;
    private JTextField fileCountField = new JTextField();
    private JLabel fileSizeLabel;
    private JTextField fileSizeField = new JTextField();
    private static final String LOGFILES_ARCHIVED = "LogFilesArchived";
    private JButton archiveButton;
    private JButton uploadLogsButton;

    public LoggingConfigForm() {
        super((LayoutManager)new BorderLayout());
        this.init();
        this.loadValues();
        if (LoggingUtilsActivator.getNotificationService() != null) {
            LoggingUtilsActivator.getNotificationService().registerDefaultNotificationForEvent(LOGFILES_ARCHIVED, "PopupMessageAction", null, null);
        }
    }

    private void init() {
        ResourceManagementService resources = LoggingUtilsActivator.getResourceService();
        this.enableCheckBox = new SIPCommCheckBox(resources.getI18NString("plugin.loggingutils.ENABLE_DISABLE"));
        this.enableCheckBox.addActionListener(this);
        this.sipProtocolCheckBox = new SIPCommCheckBox(resources.getI18NString("plugin.sipaccregwizz.PROTOCOL_NAME"));
        this.sipProtocolCheckBox.addActionListener(this);
        this.jabberProtocolCheckBox = new SIPCommCheckBox(resources.getI18NString("plugin.jabberaccregwizz.PROTOCOL_NAME"));
        this.jabberProtocolCheckBox.addActionListener(this);
        String rtpDescription = resources.getI18NString("plugin.loggingutils.PACKET_LOGGING_RTP_DESCRIPTION");
        this.rtpProtocolCheckBox = new SIPCommCheckBox(resources.getI18NString("plugin.loggingutils.PACKET_LOGGING_RTP") + " " + rtpDescription);
        this.rtpProtocolCheckBox.addActionListener(this);
        this.rtpProtocolCheckBox.setToolTipText(rtpDescription);
        this.ice4jProtocolCheckBox = new SIPCommCheckBox(resources.getI18NString("plugin.loggingutils.PACKET_LOGGING_ICE4J"));
        this.ice4jProtocolCheckBox.addActionListener(this);
        TransparentPanel mainPanel = new TransparentPanel();
        this.add((Component)mainPanel, "North");
        mainPanel.setLayout(new GridBagLayout());
        GridBagConstraints c = new GridBagConstraints();
        this.enableCheckBox.setAlignmentX(0.0f);
        c.fill = 2;
        c.weightx = 1.0;
        c.gridx = 0;
        c.gridy = 0;
        mainPanel.add((Component)this.enableCheckBox, c);
        String label = resources.getI18NString("plugin.loggingutils.PACKET_LOGGING_DESCRIPTION");
        JLabel descriptionLabel = new JLabel(label);
        descriptionLabel.setToolTipText(label);
        this.enableCheckBox.setToolTipText(label);
        descriptionLabel.setForeground(Color.GRAY);
        descriptionLabel.setFont(descriptionLabel.getFont().deriveFont(8));
        c.gridy = 1;
        c.insets = new Insets(0, 25, 10, 0);
        mainPanel.add((Component)descriptionLabel, c);
        TransparentPanel loggersButtonPanel = new TransparentPanel((LayoutManager)new GridLayout(0, 1));
        loggersButtonPanel.setBorder(BorderFactory.createTitledBorder(resources.getI18NString("service.gui.PROTOCOL")));
        loggersButtonPanel.add(this.sipProtocolCheckBox);
        loggersButtonPanel.add(this.jabberProtocolCheckBox);
        loggersButtonPanel.add(this.rtpProtocolCheckBox);
        loggersButtonPanel.add(this.ice4jProtocolCheckBox);
        c.insets = new Insets(0, 20, 10, 0);
        c.gridy = 2;
        mainPanel.add((Component)loggersButtonPanel, c);
        TransparentPanel advancedPanel = new TransparentPanel((LayoutManager)new GridLayout(0, 2));
        advancedPanel.setBorder(BorderFactory.createTitledBorder(resources.getI18NString("service.gui.ADVANCED")));
        this.fileCountField.getDocument().addDocumentListener(this);
        this.fileSizeField.getDocument().addDocumentListener(this);
        this.fileCountLabel = new JLabel(resources.getI18NString("plugin.loggingutils.PACKET_LOGGING_FILE_COUNT"));
        advancedPanel.add(this.fileCountLabel);
        advancedPanel.add(this.fileCountField);
        this.fileSizeLabel = new JLabel(resources.getI18NString("plugin.loggingutils.PACKET_LOGGING_FILE_SIZE"));
        advancedPanel.add(this.fileSizeLabel);
        advancedPanel.add(this.fileSizeField);
        c.gridy = 3;
        mainPanel.add((Component)advancedPanel, c);
        this.archiveButton = new JButton(resources.getI18NString("plugin.loggingutils.ARCHIVE_BUTTON"));
        this.archiveButton.addActionListener(this);
        c = new GridBagConstraints();
        c.anchor = 21;
        c.weightx = 0.0;
        c.gridx = 0;
        c.gridy = 4;
        mainPanel.add((Component)this.archiveButton, c);
        if (!StringUtils.isNullOrEmpty((String)LoggingConfigForm.getUploadLocation())) {
            this.uploadLogsButton = new JButton(resources.getI18NString("plugin.loggingutils.UPLOAD_LOGS_BUTTON"));
            this.uploadLogsButton.addActionListener(this);
            c.insets = new Insets(10, 0, 0, 0);
            c.gridy = 5;
            mainPanel.add((Component)this.uploadLogsButton, c);
        }
    }

    static String getUploadLocation() {
        String uploadLocation = LoggingUtilsActivator.getConfigurationService().getString(UPLOAD_LOCATION_PROPETY);
        if (uploadLocation == null || uploadLocation.length() == 0) {
            uploadLocation = LoggingUtilsActivator.getResourceService().getSettingsString(UPLOAD_LOCATION_PROPETY);
        }
        return uploadLocation;
    }

    private void loadValues() {
        PacketLoggingService packetLogging = LoggingUtilsActivator.getPacketLoggingService();
        PacketLoggingConfiguration cfg = packetLogging.getConfiguration();
        this.enableCheckBox.setSelected(cfg.isGlobalLoggingEnabled());
        this.sipProtocolCheckBox.setSelected(cfg.isSipLoggingEnabled());
        this.jabberProtocolCheckBox.setSelected(cfg.isJabberLoggingEnabled());
        this.rtpProtocolCheckBox.setSelected(cfg.isRTPLoggingEnabled());
        this.ice4jProtocolCheckBox.setSelected(cfg.isIce4JLoggingEnabled());
        this.fileCountField.setText(String.valueOf(cfg.getLogfileCount()));
        this.fileSizeField.setText(String.valueOf(cfg.getLimit() / 1000L));
        this.updateButtonsState();
    }

    private void updateButtonsState() {
        this.sipProtocolCheckBox.setEnabled(this.enableCheckBox.isSelected());
        this.jabberProtocolCheckBox.setEnabled(this.enableCheckBox.isSelected());
        this.rtpProtocolCheckBox.setEnabled(this.enableCheckBox.isSelected());
        this.ice4jProtocolCheckBox.setEnabled(this.enableCheckBox.isSelected());
        this.fileCountField.setEnabled(this.enableCheckBox.isSelected());
        this.fileSizeField.setEnabled(this.enableCheckBox.isSelected());
        this.fileSizeLabel.setEnabled(this.enableCheckBox.isSelected());
        this.fileCountLabel.setEnabled(this.enableCheckBox.isSelected());
    }

    @Override
    public void actionPerformed(ActionEvent e) {
        Object source = e.getSource();
        PacketLoggingService packetLogging = LoggingUtilsActivator.getPacketLoggingService();
        if (source.equals(this.enableCheckBox)) {
            packetLogging.getConfiguration().setGlobalLoggingEnabled(this.enableCheckBox.isSelected());
            this.updateButtonsState();
        } else if (source.equals(this.sipProtocolCheckBox)) {
            packetLogging.getConfiguration().setSipLoggingEnabled(this.sipProtocolCheckBox.isSelected());
        } else if (source.equals(this.jabberProtocolCheckBox)) {
            packetLogging.getConfiguration().setJabberLoggingEnabled(this.jabberProtocolCheckBox.isSelected());
        } else if (source.equals(this.rtpProtocolCheckBox)) {
            packetLogging.getConfiguration().setRTPLoggingEnabled(this.rtpProtocolCheckBox.isSelected());
        } else if (source.equals(this.ice4jProtocolCheckBox)) {
            packetLogging.getConfiguration().setIce4JLoggingEnabled(this.ice4jProtocolCheckBox.isSelected());
        } else if (source.equals(this.archiveButton)) {
            new Thread(new Runnable(){

                @Override
                public void run() {
                    LoggingConfigForm.this.collectLogs();
                }
            }).start();
        } else if (source.equals(this.uploadLogsButton)) {
            new Thread(new Runnable(){

                @Override
                public void run() {
                    LoggingConfigForm.this.uploadLogs();
                }
            }).start();
        }
    }

    @Override
    public void insertUpdate(DocumentEvent e) {
        this.documentChanged(e);
    }

    @Override
    public void removeUpdate(DocumentEvent e) {
        this.documentChanged(e);
    }

    @Override
    public void changedUpdate(DocumentEvent e) {
    }

    private void documentChanged(DocumentEvent e) {
        if (e.getDocument().equals(this.fileCountField.getDocument())) {
            try {
                int newFileCount = Integer.valueOf(this.fileCountField.getText());
                this.fileCountField.setForeground(Color.black);
                LoggingUtilsActivator.getPacketLoggingService().getConfiguration().setLogfileCount(newFileCount);
            }
            catch (Throwable t) {
                this.fileCountField.setForeground(Color.red);
            }
        } else if (e.getDocument().equals(this.fileSizeField.getDocument())) {
            try {
                int newFileSize = Integer.valueOf(this.fileSizeField.getText());
                this.fileSizeField.setForeground(Color.black);
                LoggingUtilsActivator.getPacketLoggingService().getConfiguration().setLimit((long)(newFileSize * 1000));
            }
            catch (Throwable t) {
                this.fileSizeField.setForeground(Color.red);
            }
        }
    }

    private void collectLogs() {
        ResourceManagementService resources = LoggingUtilsActivator.getResourceService();
        SipCommFileChooser fileChooser = GenericFileDialog.create(null, (String)resources.getI18NString("plugin.loggingutils.ARCHIVE_FILECHOOSE_TITLE"), (int)1);
        fileChooser.setSelectionMode(1);
        String defaultDir = "";
        try {
            defaultDir = LoggingUtilsActivator.getFileAccessService().getDefaultDownloadDirectory().getAbsolutePath() + File.separator;
        }
        catch (IOException iOException) {
            // empty catch block
        }
        fileChooser.setStartPath(defaultDir + LogsCollector.getDefaultFileName());
        File dest = fileChooser.getFileFromDialog();
        if (dest == null) {
            return;
        }
        dest = LogsCollector.collectLogs(dest, null);
        NotificationService notificationService = LoggingUtilsActivator.getNotificationService();
        if (notificationService != null) {
            String bodyMsgKey = dest == null ? "plugin.loggingutils.ARCHIVE_MESSAGE_NOTOK" : "plugin.loggingutils.ARCHIVE_MESSAGE_OK";
            notificationService.fireNotification(LOGFILES_ARCHIVED, resources.getI18NString("plugin.loggingutils.ARCHIVE_BUTTON"), resources.getI18NString(bodyMsgKey, new String[]{dest.getAbsolutePath()}), null);
        }
    }

    private void uploadLogs() {
        ResourceManagementService resources = LoggingUtilsActivator.getResourceService();
        final SIPCommDialog dialog = new SIPCommDialog(false){
            private static final long serialVersionUID = 0L;

            protected void close(boolean escaped) {
            }
        };
        dialog.setModal(true);
        dialog.setTitle(resources.getI18NString("plugin.loggingutils.UPLOAD_LOGS_BUTTON"));
        Container container = dialog.getContentPane();
        container.setLayout(new GridBagLayout());
        JLabel descriptionLabel = new JLabel("Add a comment:");
        JTextArea commentTextArea = new JTextArea();
        commentTextArea.setRows(4);
        JButton uploadButton = new JButton(resources.getI18NString("plugin.loggingutils.UPLOAD_BUTTON"));
        SIPCommTextField emailField = new SIPCommTextField(resources.getI18NString("plugin.loggingutils.ARCHIVE_UPREPORT_EMAIL"));
        SIPCommCheckBox emailCheckBox = new SIPCommCheckBox("Email me when more information is available");
        emailCheckBox.setSelected(true);
        emailCheckBox.addActionListener(new ActionListener((JCheckBox)emailCheckBox, uploadButton, emailField){
            final /* synthetic */ JCheckBox val$emailCheckBox;
            final /* synthetic */ JButton val$uploadButton;
            final /* synthetic */ SIPCommTextField val$emailField;
            {
                this.val$emailCheckBox = jCheckBox;
                this.val$uploadButton = jButton;
                this.val$emailField = sIPCommTextField;
            }

            @Override
            public void actionPerformed(ActionEvent e) {
                if (!this.val$emailCheckBox.isSelected()) {
                    this.val$uploadButton.setEnabled(true);
                    this.val$emailField.setEnabled(false);
                } else {
                    this.val$emailField.setEnabled(true);
                    if (this.val$emailField.getText() != null && this.val$emailField.getText().trim().length() > 0) {
                        this.val$uploadButton.setEnabled(true);
                    } else {
                        this.val$uploadButton.setEnabled(false);
                    }
                }
            }
        });
        emailField.getDocument().addDocumentListener(new DocumentListener((JCheckBox)emailCheckBox, emailField, uploadButton){
            final /* synthetic */ JCheckBox val$emailCheckBox;
            final /* synthetic */ SIPCommTextField val$emailField;
            final /* synthetic */ JButton val$uploadButton;
            {
                this.val$emailCheckBox = jCheckBox;
                this.val$emailField = sIPCommTextField;
                this.val$uploadButton = jButton;
            }

            @Override
            public void insertUpdate(DocumentEvent e) {
                this.updateButtonsState();
            }

            @Override
            public void removeUpdate(DocumentEvent e) {
                this.updateButtonsState();
            }

            @Override
            public void changedUpdate(DocumentEvent e) {
            }

            private void updateButtonsState() {
                if (this.val$emailCheckBox.isSelected() && this.val$emailField.getText() != null && this.val$emailField.getText().trim().length() > 0) {
                    this.val$uploadButton.setEnabled(true);
                } else {
                    this.val$uploadButton.setEnabled(false);
                }
            }
        });
        GridBagConstraints c = new GridBagConstraints();
        c.fill = 2;
        c.insets = new Insets(10, 10, 3, 10);
        c.weightx = 1.0;
        c.gridx = 0;
        c.gridy = 0;
        container.add((Component)descriptionLabel, c);
        c.insets = new Insets(0, 10, 10, 10);
        c.gridy = 1;
        container.add((Component)new JScrollPane(commentTextArea), c);
        c.insets = new Insets(0, 10, 0, 10);
        c.gridy = 2;
        container.add((Component)emailCheckBox, c);
        c.insets = new Insets(0, 10, 10, 10);
        c.gridy = 3;
        container.add((Component)emailField, c);
        JButton cancelButton = new JButton(resources.getI18NString("service.gui.CANCEL"));
        cancelButton.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                dialog.dispose();
            }
        });
        uploadButton.setEnabled(false);
        uploadButton.addActionListener(new ActionListener((JCheckBox)emailCheckBox, emailField, commentTextArea, dialog){
            final /* synthetic */ JCheckBox val$emailCheckBox;
            final /* synthetic */ SIPCommTextField val$emailField;
            final /* synthetic */ JTextArea val$commentTextArea;
            final /* synthetic */ SIPCommDialog val$dialog;
            {
                this.val$emailCheckBox = jCheckBox;
                this.val$emailField = sIPCommTextField;
                this.val$commentTextArea = jTextArea;
                this.val$dialog = sIPCommDialog;
            }

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            @Override
            public void actionPerformed(ActionEvent e) {
                try {
                    final ArrayList<String> paramNames = new ArrayList<String>();
                    final ArrayList<String> paramValues = new ArrayList<String>();
                    if (this.val$emailCheckBox.isSelected()) {
                        paramNames.add("Email");
                        paramValues.add(this.val$emailField.getText());
                    }
                    paramNames.add("Description");
                    paramValues.add(this.val$commentTextArea.getText());
                    new Thread(new Runnable(){

                        @Override
                        public void run() {
                            LoggingConfigForm.uploadLogs(LoggingConfigForm.getUploadLocation(), LogsCollector.getDefaultFileName(), paramNames.toArray(new String[0]), paramValues.toArray(new String[0]));
                        }
                    }).start();
                }
                finally {
                    this.val$dialog.dispose();
                }
            }
        });
        TransparentPanel buttonsPanel = new TransparentPanel((LayoutManager)new FlowLayout(2));
        buttonsPanel.add(uploadButton);
        buttonsPanel.add(cancelButton);
        c.anchor = 22;
        c.weightx = 0.0;
        c.gridy = 4;
        container.add((Component)buttonsPanel, c);
        dialog.setVisible(true);
    }

    static void uploadLogs(String uploadLocation, String fileName, String[] params, String[] values) {
        try {
            NotificationService notificationService;
            File tempDir = LoggingUtilsActivator.getFileAccessService().getTemporaryDirectory();
            File newDest = new File(tempDir, fileName);
            File optionalFile = null;
            if (params != null) {
                optionalFile = new File(LoggingUtilsActivator.getFileAccessService().getTemporaryDirectory(), "description.txt");
                FileOutputStream out = new FileOutputStream(optionalFile);
                for (int i = 0; i < params.length; ++i) {
                    ((OutputStream)out).write((params[i] + " : " + values[i] + "\r\n").getBytes("UTF-8"));
                }
                out.flush();
                ((OutputStream)out).close();
            }
            newDest = LogsCollector.collectLogs(newDest, optionalFile);
            if (optionalFile != null) {
                optionalFile.delete();
            }
            if (uploadLocation == null) {
                return;
            }
            if (HttpUtils.postFile((String)uploadLocation, (String)"logs", (File)newDest) != null && (notificationService = LoggingUtilsActivator.getNotificationService()) != null) {
                ResourceManagementService resources = LoggingUtilsActivator.getResourceService();
                String bodyMsgKey = "plugin.loggingutils.ARCHIVE_MESSAGE_OK";
                notificationService.fireNotification(LOGFILES_ARCHIVED, resources.getI18NString("plugin.loggingutils.ARCHIVE_BUTTON"), resources.getI18NString(bodyMsgKey, new String[]{uploadLocation}), null);
            }
        }
        catch (Throwable e) {
            logger.error((Object)"Cannot upload file", e);
        }
    }
}

