/*
 * Decompiled with CFR 0.152.
 */
package javax.jmdns.impl;

import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.LinkedList;
import java.util.List;
import javax.jmdns.impl.DNSQuestion;
import javax.jmdns.impl.DNSRecord;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public abstract class DNSMessage {
    public static final boolean MULTICAST = true;
    public static final boolean UNICAST = false;
    private int _id;
    boolean _multicast;
    private int _flags;
    protected final List<DNSQuestion> _questions;
    protected final List<DNSRecord> _answers;
    protected final List<DNSRecord> _authoritativeAnswers;
    protected final List<DNSRecord> _additionals;

    protected DNSMessage(int flags, int id, boolean multicast) {
        this._flags = flags;
        this._id = id;
        this._multicast = multicast;
        this._questions = Collections.synchronizedList(new LinkedList());
        this._answers = Collections.synchronizedList(new LinkedList());
        this._authoritativeAnswers = Collections.synchronizedList(new LinkedList());
        this._additionals = Collections.synchronizedList(new LinkedList());
    }

    public int getId() {
        return this._multicast ? 0 : this._id;
    }

    public void setId(int id) {
        this._id = id;
    }

    public int getFlags() {
        return this._flags;
    }

    public void setFlags(int flags) {
        this._flags = flags;
    }

    public boolean isMulticast() {
        return this._multicast;
    }

    public Collection<? extends DNSQuestion> getQuestions() {
        return this._questions;
    }

    public int getNumberOfQuestions() {
        return this.getQuestions().size();
    }

    public Collection<? extends DNSRecord> getAllAnswers() {
        ArrayList<DNSRecord> aList = new ArrayList<DNSRecord>(this._answers.size() + this._authoritativeAnswers.size() + this._additionals.size());
        aList.addAll(this._answers);
        aList.addAll(this._authoritativeAnswers);
        aList.addAll(this._additionals);
        return aList;
    }

    public Collection<? extends DNSRecord> getAnswers() {
        return this._answers;
    }

    public int getNumberOfAnswers() {
        return this.getAnswers().size();
    }

    public Collection<? extends DNSRecord> getAuthorities() {
        return this._authoritativeAnswers;
    }

    public int getNumberOfAuthorities() {
        return this.getAuthorities().size();
    }

    public Collection<? extends DNSRecord> getAdditionals() {
        return this._additionals;
    }

    public int getNumberOfAdditionals() {
        return this.getAdditionals().size();
    }

    public boolean isTruncated() {
        return (this._flags & 0x200) != 0;
    }

    public boolean isQuery() {
        return (this._flags & 0x8000) == 0;
    }

    public boolean isResponse() {
        return (this._flags & 0x8000) == 32768;
    }

    public boolean isEmpty() {
        return this.getNumberOfQuestions() + this.getNumberOfAnswers() + this.getNumberOfAuthorities() + this.getNumberOfAdditionals() == 0;
    }

    String print() {
        StringBuffer buf = new StringBuffer();
        buf.append(this.toString() + "\n");
        for (DNSQuestion question : this._questions) {
            buf.append("\tquestion:      " + question + "\n");
        }
        for (DNSRecord answer : this._answers) {
            buf.append("\tanswer:        " + answer + "\n");
        }
        for (DNSRecord answer : this._authoritativeAnswers) {
            buf.append("\tauthoritative: " + answer + "\n");
        }
        for (DNSRecord answer : this._additionals) {
            buf.append("\tadditional:    " + answer + "\n");
        }
        return buf.toString();
    }
}

