/*
 * Decompiled with CFR 0.152.
 */
package net.java.sip.communicator.impl.callhistory;

import java.io.IOException;
import java.io.StreamTokenizer;
import java.io.StringReader;
import java.text.ParseException;
import java.text.SimpleDateFormat;
import java.util.Collection;
import java.util.Comparator;
import java.util.Date;
import java.util.HashMap;
import java.util.Hashtable;
import java.util.Iterator;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import java.util.TreeSet;
import java.util.Vector;
import net.java.sip.communicator.impl.callhistory.CallHistoryActivator;
import net.java.sip.communicator.impl.callhistory.CallHistoryQueryImpl;
import net.java.sip.communicator.impl.callhistory.CallPeerRecordImpl;
import net.java.sip.communicator.impl.callhistory.CallRecordImpl;
import net.java.sip.communicator.service.callhistory.CallHistoryQuery;
import net.java.sip.communicator.service.callhistory.CallHistoryService;
import net.java.sip.communicator.service.callhistory.CallPeerRecord;
import net.java.sip.communicator.service.callhistory.CallRecord;
import net.java.sip.communicator.service.callhistory.event.CallHistoryPeerRecordEvent;
import net.java.sip.communicator.service.callhistory.event.CallHistoryPeerRecordListener;
import net.java.sip.communicator.service.callhistory.event.CallHistorySearchProgressListener;
import net.java.sip.communicator.service.callhistory.event.ProgressEvent;
import net.java.sip.communicator.service.contactlist.MetaContact;
import net.java.sip.communicator.service.history.History;
import net.java.sip.communicator.service.history.HistoryID;
import net.java.sip.communicator.service.history.HistoryQuery;
import net.java.sip.communicator.service.history.HistoryReader;
import net.java.sip.communicator.service.history.HistoryService;
import net.java.sip.communicator.service.history.HistoryWriter;
import net.java.sip.communicator.service.history.InteractiveHistoryReader;
import net.java.sip.communicator.service.history.QueryResultSet;
import net.java.sip.communicator.service.history.event.HistorySearchProgressListener;
import net.java.sip.communicator.service.history.records.HistoryRecord;
import net.java.sip.communicator.service.history.records.HistoryRecordStructure;
import net.java.sip.communicator.service.protocol.AccountID;
import net.java.sip.communicator.service.protocol.Call;
import net.java.sip.communicator.service.protocol.CallPeer;
import net.java.sip.communicator.service.protocol.CallPeerState;
import net.java.sip.communicator.service.protocol.CallState;
import net.java.sip.communicator.service.protocol.Contact;
import net.java.sip.communicator.service.protocol.OperationSetBasicTelephony;
import net.java.sip.communicator.service.protocol.ProtocolProviderFactory;
import net.java.sip.communicator.service.protocol.ProtocolProviderService;
import net.java.sip.communicator.service.protocol.event.CallChangeEvent;
import net.java.sip.communicator.service.protocol.event.CallChangeListener;
import net.java.sip.communicator.service.protocol.event.CallEvent;
import net.java.sip.communicator.service.protocol.event.CallListener;
import net.java.sip.communicator.service.protocol.event.CallPeerAdapter;
import net.java.sip.communicator.service.protocol.event.CallPeerChangeEvent;
import net.java.sip.communicator.service.protocol.event.CallPeerEvent;
import net.java.sip.communicator.service.protocol.event.CallPeerListener;
import net.java.sip.communicator.util.Logger;
import net.java.sip.communicator.util.ServiceUtils;
import org.osgi.framework.BundleContext;
import org.osgi.framework.ServiceEvent;
import org.osgi.framework.ServiceListener;
import org.osgi.framework.ServiceReference;

public class CallHistoryServiceImpl
implements CallHistoryService,
CallListener,
ServiceListener {
    private static final Logger logger = Logger.getLogger(CallHistoryServiceImpl.class);
    private static String[] STRUCTURE_NAMES = new String[]{"accountUID", "callStart", "callEnd", "dir", "callParticipantIDs", "callParticipantStart", "callParticipantEnd", "callParticipantStates", "callEndReason", "callParticipantNames", "secondaryCallParticipantIDs"};
    private static HistoryRecordStructure recordStructure = new HistoryRecordStructure(STRUCTURE_NAMES);
    private static final char DELIM = ',';
    private BundleContext bundleContext = null;
    private HistoryService historyService = null;
    private Object syncRoot_HistoryService = new Object();
    private final Map<CallHistorySearchProgressListener, SearchProgressWrapper> progressListeners = new Hashtable<CallHistorySearchProgressListener, SearchProgressWrapper>();
    private final List<CallRecordImpl> currentCallRecords = new Vector<CallRecordImpl>();
    private final CallChangeListener historyCallChangeListener = new HistoryCallChangeListener();
    private HistoryReader historyReader;
    private List<CallHistoryPeerRecordListener> callHistoryRecordlisteners = new LinkedList<CallHistoryPeerRecordListener>();

    public HistoryService getHistoryService() {
        return this.historyService;
    }

    @Override
    public Collection<CallRecord> findByStartDate(MetaContact contact, Date startDate) throws RuntimeException {
        throw new UnsupportedOperationException("Not implemented yet!");
    }

    @Override
    public Collection<CallRecord> findByStartDate(Date startDate) {
        TreeSet<CallRecord> result = new TreeSet<CallRecord>(new CallRecordComparator());
        try {
            History history = this.getHistory(null, null);
            this.historyReader = history.getReader();
            this.addHistorySearchProgressListeners(this.historyReader, 1);
            QueryResultSet rs = this.historyReader.findByStartDate(startDate);
            while (rs.hasNext()) {
                HistoryRecord hr = (HistoryRecord)rs.next();
                result.add(CallHistoryServiceImpl.convertHistoryRecordToCallRecord(hr));
            }
            this.removeHistorySearchProgressListeners(this.historyReader);
        }
        catch (IOException ex) {
            logger.error((Object)"Could not read history", (Throwable)ex);
        }
        return result;
    }

    @Override
    public Collection<CallRecord> findByEndDate(MetaContact contact, Date endDate) throws RuntimeException {
        throw new UnsupportedOperationException("Not implemented yet!");
    }

    @Override
    public Collection<CallRecord> findByEndDate(Date endDate) throws RuntimeException {
        TreeSet<CallRecord> result = new TreeSet<CallRecord>(new CallRecordComparator());
        try {
            History history = this.getHistory(null, null);
            this.historyReader = history.getReader();
            this.addHistorySearchProgressListeners(this.historyReader, 1);
            QueryResultSet rs = this.historyReader.findByEndDate(endDate);
            while (rs.hasNext()) {
                HistoryRecord hr = (HistoryRecord)rs.next();
                result.add(CallHistoryServiceImpl.convertHistoryRecordToCallRecord(hr));
            }
            this.removeHistorySearchProgressListeners(this.historyReader);
        }
        catch (IOException ex) {
            logger.error((Object)"Could not read history", (Throwable)ex);
        }
        return result;
    }

    @Override
    public Collection<CallRecord> findByPeriod(MetaContact contact, Date startDate, Date endDate) throws RuntimeException {
        throw new UnsupportedOperationException("Not implemented yet!");
    }

    @Override
    public Collection<CallRecord> findByPeriod(Date startDate, Date endDate) throws RuntimeException {
        TreeSet<CallRecord> result = new TreeSet<CallRecord>(new CallRecordComparator());
        try {
            History history = this.getHistory(null, null);
            this.historyReader = history.getReader();
            this.addHistorySearchProgressListeners(this.historyReader, 1);
            QueryResultSet rs = this.historyReader.findByPeriod(startDate, endDate);
            while (rs.hasNext()) {
                HistoryRecord hr = (HistoryRecord)rs.next();
                result.add(CallHistoryServiceImpl.convertHistoryRecordToCallRecord(hr));
            }
            this.removeHistorySearchProgressListeners(this.historyReader);
        }
        catch (IOException ex) {
            logger.error((Object)"Could not read history", (Throwable)ex);
        }
        return result;
    }

    @Override
    public Collection<CallRecord> findLast(MetaContact contact, int count) throws RuntimeException {
        throw new UnsupportedOperationException("Not implemented yet!");
    }

    @Override
    public Collection<CallRecord> findLast(int count) throws RuntimeException {
        TreeSet<CallRecord> result = new TreeSet<CallRecord>(new CallRecordComparator());
        try {
            History history = this.getHistory(null, null);
            this.historyReader = history.getReader();
            QueryResultSet rs = this.historyReader.findLast(count);
            while (rs.hasNext()) {
                HistoryRecord hr = (HistoryRecord)rs.next();
                result.add(CallHistoryServiceImpl.convertHistoryRecordToCallRecord(hr));
            }
        }
        catch (IOException ex) {
            logger.error((Object)"Could not read history", (Throwable)ex);
        }
        return result;
    }

    @Override
    public CallHistoryQuery findByPeer(String address, int recordCount) throws RuntimeException {
        CallHistoryQueryImpl callQuery = null;
        try {
            History history = this.getHistory(null, null);
            InteractiveHistoryReader historyReader = history.getInteractiveReader();
            HistoryQuery historyQuery = historyReader.findByKeyword(address, "callParticipantIDs", recordCount);
            callQuery = new CallHistoryQueryImpl(historyQuery);
        }
        catch (IOException ex) {
            logger.error((Object)"Could not read history", (Throwable)ex);
        }
        return callQuery;
    }

    private History getHistory(Contact localContact, Contact remoteContact) throws IOException {
        String localId = localContact == null ? "default" : localContact.getAddress();
        String remoteId = remoteContact == null ? "default" : remoteContact.getAddress();
        HistoryID historyId = HistoryID.createFromRawID((String[])new String[]{"callhistory", localId, remoteId});
        return this.historyService.createHistory(historyId, recordStructure);
    }

    static CallRecord convertHistoryRecordToCallRecord(HistoryRecord hr) {
        CallRecordImpl result = new CallRecordImpl();
        List<String> callPeerIDs = null;
        List<String> callPeerNames = null;
        List<String> callPeerStart = null;
        List<String> callPeerEnd = null;
        List<CallPeerState> callPeerStates = null;
        List<String> callPeerSecondaryIDs = null;
        SimpleDateFormat sdf = new SimpleDateFormat("yyyy-MM-dd'T'HH:mm:ss.SSSZ");
        for (int i = 0; i < hr.getPropertyNames().length; ++i) {
            String propName = hr.getPropertyNames()[i];
            String value = hr.getPropertyValues()[i];
            if (propName.equals(STRUCTURE_NAMES[0])) {
                result.setProtocolProvider(CallHistoryServiceImpl.getProtocolProvider(value));
                continue;
            }
            if (propName.equals(STRUCTURE_NAMES[1])) {
                try {
                    result.setStartTime(sdf.parse(value));
                }
                catch (ParseException e) {
                    result.setStartTime(new Date(Long.parseLong(value)));
                }
                continue;
            }
            if (propName.equals(STRUCTURE_NAMES[2])) {
                try {
                    result.setEndTime(sdf.parse(value));
                }
                catch (ParseException e) {
                    result.setEndTime(new Date(Long.parseLong(value)));
                }
                continue;
            }
            if (propName.equals(STRUCTURE_NAMES[3])) {
                result.setDirection(value);
                continue;
            }
            if (propName.equals(STRUCTURE_NAMES[4])) {
                callPeerIDs = CallHistoryServiceImpl.getCSVs(value);
                continue;
            }
            if (propName.equals(STRUCTURE_NAMES[5])) {
                callPeerStart = CallHistoryServiceImpl.getCSVs(value);
                continue;
            }
            if (propName.equals(STRUCTURE_NAMES[6])) {
                callPeerEnd = CallHistoryServiceImpl.getCSVs(value);
                continue;
            }
            if (propName.equals(STRUCTURE_NAMES[7])) {
                callPeerStates = CallHistoryServiceImpl.getStates(value);
                continue;
            }
            if (propName.equals(STRUCTURE_NAMES[8])) {
                result.setEndReason(Integer.parseInt(value));
                continue;
            }
            if (propName.equals(STRUCTURE_NAMES[9])) {
                callPeerNames = CallHistoryServiceImpl.getCSVs(value);
                continue;
            }
            if (!propName.equals(STRUCTURE_NAMES[10])) continue;
            callPeerSecondaryIDs = CallHistoryServiceImpl.getCSVs(value);
        }
        int callPeerCount = callPeerIDs == null ? 0 : callPeerIDs.size();
        for (int i = 0; i < callPeerCount; ++i) {
            Date callPeerStartValue = null;
            Date callPeerEndValue = null;
            if (i < callPeerStart.size()) {
                try {
                    callPeerStartValue = sdf.parse((String)callPeerStart.get(i));
                }
                catch (ParseException e) {
                    callPeerStartValue = new Date(Long.parseLong((String)callPeerStart.get(i)));
                }
            } else {
                callPeerStartValue = result.getStartTime();
                if (logger.isInfoEnabled()) {
                    logger.info((Object)("Call history start time list different from ids list: " + hr.toString()));
                }
            }
            if (i < callPeerEnd.size()) {
                try {
                    callPeerEndValue = sdf.parse((String)callPeerEnd.get(i));
                }
                catch (ParseException e) {
                    callPeerEndValue = new Date(Long.parseLong((String)callPeerEnd.get(i)));
                }
            } else {
                callPeerEndValue = result.getEndTime();
                if (logger.isInfoEnabled()) {
                    logger.info((Object)("Call history end time list different from ids list: " + hr.toString()));
                }
            }
            CallPeerRecordImpl cpr = new CallPeerRecordImpl((String)callPeerIDs.get(i), callPeerStartValue, callPeerEndValue);
            String callPeerSecondaryID = null;
            if (callPeerSecondaryIDs != null && !callPeerSecondaryIDs.isEmpty()) {
                callPeerSecondaryID = (String)callPeerSecondaryIDs.get(i);
            }
            if (callPeerSecondaryID != null && !callPeerSecondaryID.equals("")) {
                cpr.setPeerSecondaryAddress(callPeerSecondaryID);
            }
            if (callPeerStates != null && i < callPeerStates.size()) {
                cpr.setState((CallPeerState)callPeerStates.get(i));
            } else if (logger.isInfoEnabled()) {
                logger.info((Object)("Call history state list different from ids list: " + hr.toString()));
            }
            result.getPeerRecords().add(cpr);
            if (callPeerNames == null || i >= callPeerNames.size()) continue;
            cpr.setDisplayName((String)callPeerNames.get(i));
        }
        return result;
    }

    private static List<String> getCSVs(String str) {
        LinkedList<String> result = new LinkedList<String>();
        if (str == null) {
            return result;
        }
        StreamTokenizer stt = new StreamTokenizer(new StringReader(str));
        stt.resetSyntax();
        stt.wordChars(0, 65535);
        stt.eolIsSignificant(false);
        stt.quoteChar(34);
        stt.whitespaceChars(44, 44);
        try {
            while (stt.nextToken() != -1) {
                if (stt.sval == null) continue;
                result.add(stt.sval.trim());
            }
        }
        catch (IOException e) {
            logger.error((Object)("failed to parse " + str), (Throwable)e);
        }
        return result;
    }

    private static List<CallPeerState> getStates(String str) {
        LinkedList<CallPeerState> result = new LinkedList<CallPeerState>();
        List<String> stateStrs = CallHistoryServiceImpl.getCSVs(str);
        for (String item : stateStrs) {
            result.add(CallHistoryServiceImpl.convertStateStringToState(item));
        }
        return result;
    }

    private static CallPeerState convertStateStringToState(String state) {
        if (state.equals("Connected")) {
            return CallPeerState.CONNECTED;
        }
        if (state.equals("Busy")) {
            return CallPeerState.BUSY;
        }
        if (state.equals("Failed")) {
            return CallPeerState.FAILED;
        }
        if (state.equals("Disconnected")) {
            return CallPeerState.DISCONNECTED;
        }
        if (state.equals("Alerting Remote User (Ringing)")) {
            return CallPeerState.ALERTING_REMOTE_SIDE;
        }
        if (state.equals("Connecting")) {
            return CallPeerState.CONNECTING;
        }
        if (state.equals("Locally On Hold")) {
            return CallPeerState.ON_HOLD_LOCALLY;
        }
        if (state.equals("Mutually On Hold")) {
            return CallPeerState.ON_HOLD_MUTUALLY;
        }
        if (state.equals("Remotely On Hold")) {
            return CallPeerState.ON_HOLD_REMOTELY;
        }
        if (state.equals("Initiating Call")) {
            return CallPeerState.INITIATING_CALL;
        }
        if (state.equals("Incoming Call")) {
            return CallPeerState.INCOMING_CALL;
        }
        return CallPeerState.UNKNOWN;
    }

    public void start(BundleContext bc) {
        if (logger.isDebugEnabled()) {
            logger.debug((Object)"Starting the call history implementation.");
        }
        this.bundleContext = bc;
        bc.addServiceListener((ServiceListener)this);
        Collection ppsRefs = ServiceUtils.getServiceReferences((BundleContext)bc, ProtocolProviderService.class);
        if (!ppsRefs.isEmpty()) {
            if (logger.isDebugEnabled()) {
                logger.debug((Object)("Found " + ppsRefs.size() + " already installed providers."));
            }
            for (ServiceReference ppsRef : ppsRefs) {
                ProtocolProviderService pps = (ProtocolProviderService)bc.getService(ppsRef);
                this.handleProviderAdded(pps);
            }
        }
    }

    public void stop(BundleContext bc) {
        bc.removeServiceListener((ServiceListener)this);
        Collection ppsRefs = ServiceUtils.getServiceReferences((BundleContext)bc, ProtocolProviderService.class);
        if (!ppsRefs.isEmpty()) {
            for (ServiceReference ppsRef : ppsRefs) {
                ProtocolProviderService pps = (ProtocolProviderService)bc.getService(ppsRef);
                this.handleProviderRemoved(pps);
            }
        }
    }

    private void writeCall(CallRecordImpl callRecord, Contact source, Contact destination) {
        try {
            SimpleDateFormat sdf = new SimpleDateFormat("yyyy-MM-dd'T'HH:mm:ss.SSSZ");
            History history = this.getHistory(source, destination);
            HistoryWriter historyWriter = history.getWriter();
            StringBuffer callPeerIDs = new StringBuffer();
            StringBuffer callPeerNames = new StringBuffer();
            StringBuffer callPeerStartTime = new StringBuffer();
            StringBuffer callPeerEndTime = new StringBuffer();
            StringBuffer callPeerStates = new StringBuffer();
            StringBuffer callPeerSecondaryIDs = new StringBuffer();
            for (CallPeerRecord item : callRecord.getPeerRecords()) {
                if (callPeerIDs.length() > 0) {
                    callPeerIDs.append(',');
                    callPeerNames.append(',');
                    callPeerStartTime.append(',');
                    callPeerEndTime.append(',');
                    callPeerStates.append(',');
                    callPeerSecondaryIDs.append(',');
                }
                callPeerIDs.append(item.getPeerAddress());
                String dn = item.getDisplayName();
                if (dn != null) {
                    dn = dn.replace("\"", "\\\"");
                    callPeerNames.append('\"');
                    callPeerNames.append(dn);
                    callPeerNames.append('\"');
                }
                callPeerStartTime.append(sdf.format(item.getStartTime()));
                callPeerEndTime.append(sdf.format(item.getEndTime()));
                callPeerStates.append(item.getState().getStateString());
                callPeerSecondaryIDs.append(item.getPeerSecondaryAddress() == null ? "" : item.getPeerSecondaryAddress());
            }
            historyWriter.addRecord(new String[]{callRecord.getSourceCall().getProtocolProvider().getAccountID().getAccountUniqueID(), sdf.format(callRecord.getStartTime()), sdf.format(callRecord.getEndTime()), callRecord.getDirection(), callPeerIDs.toString(), callPeerStartTime.toString(), callPeerEndTime.toString(), callPeerStates.toString(), String.valueOf(callRecord.getEndReason()), callPeerNames.toString(), callPeerSecondaryIDs.toString()}, new Date());
        }
        catch (IOException e) {
            logger.error((Object)"Could not add call to history", (Throwable)e);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void setHistoryService(HistoryService historyService) throws IllegalArgumentException, IOException {
        Object object = this.syncRoot_HistoryService;
        synchronized (object) {
            this.historyService = historyService;
            if (logger.isDebugEnabled()) {
                logger.debug((Object)"New history service registered.");
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void unsetHistoryService(HistoryService hService) {
        Object object = this.syncRoot_HistoryService;
        synchronized (object) {
            if (this.historyService == hService) {
                this.historyService = null;
                if (logger.isDebugEnabled()) {
                    logger.debug((Object)"History service unregistered.");
                }
            }
        }
    }

    @Override
    public void eraseLocallyStoredHistory() throws IOException {
        HistoryID historyId = HistoryID.createFromRawID((String[])new String[]{"callhistory"});
        this.historyService.purgeLocallyStoredHistory(historyId);
    }

    public void serviceChanged(ServiceEvent serviceEvent) {
        Object sService = this.bundleContext.getService(serviceEvent.getServiceReference());
        if (logger.isTraceEnabled()) {
            logger.trace((Object)("Received a service event for: " + sService.getClass().getName()));
        }
        if (!(sService instanceof ProtocolProviderService)) {
            return;
        }
        if (logger.isDebugEnabled()) {
            logger.debug((Object)"Service is a protocol provider.");
        }
        if (serviceEvent.getType() == 1) {
            if (logger.isDebugEnabled()) {
                logger.debug((Object)"Handling registration of a new Protocol Provider.");
            }
            this.handleProviderAdded((ProtocolProviderService)sService);
        } else if (serviceEvent.getType() == 4) {
            this.handleProviderRemoved((ProtocolProviderService)sService);
        }
    }

    private void handleProviderAdded(ProtocolProviderService provider) {
        OperationSetBasicTelephony opSetTelephony;
        if (logger.isDebugEnabled()) {
            logger.debug((Object)("Adding protocol provider " + provider.getProtocolName()));
        }
        if ((opSetTelephony = (OperationSetBasicTelephony)provider.getOperationSet(OperationSetBasicTelephony.class)) != null) {
            opSetTelephony.addCallListener((CallListener)this);
        } else if (logger.isTraceEnabled()) {
            logger.trace((Object)"Service did not have a basic telephony op. set.");
        }
    }

    private void handleProviderRemoved(ProtocolProviderService provider) {
        OperationSetBasicTelephony opSetTelephony = (OperationSetBasicTelephony)provider.getOperationSet(OperationSetBasicTelephony.class);
        if (opSetTelephony != null) {
            opSetTelephony.removeCallListener((CallListener)this);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void addSearchProgressListener(CallHistorySearchProgressListener listener) {
        Map<CallHistorySearchProgressListener, SearchProgressWrapper> map = this.progressListeners;
        synchronized (map) {
            this.progressListeners.put(listener, new SearchProgressWrapper(listener));
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void removeSearchProgressListener(CallHistorySearchProgressListener listener) {
        Map<CallHistorySearchProgressListener, SearchProgressWrapper> map = this.progressListeners;
        synchronized (map) {
            this.progressListeners.remove(listener);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void addCallHistoryRecordListener(CallHistoryPeerRecordListener listener) {
        List<CallHistoryPeerRecordListener> list = this.callHistoryRecordlisteners;
        synchronized (list) {
            this.callHistoryRecordlisteners.add(listener);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void removeCallHistoryRecordListener(CallHistoryPeerRecordListener listener) {
        List<CallHistoryPeerRecordListener> list = this.callHistoryRecordlisteners;
        synchronized (list) {
            this.callHistoryRecordlisteners.remove(listener);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void fireCallHistoryRecordReceivedEvent(CallHistoryPeerRecordEvent event) {
        LinkedList<CallHistoryPeerRecordListener> tmpListeners;
        List<CallHistoryPeerRecordListener> list = this.callHistoryRecordlisteners;
        synchronized (list) {
            tmpListeners = new LinkedList<CallHistoryPeerRecordListener>(this.callHistoryRecordlisteners);
        }
        for (CallHistoryPeerRecordListener listener : tmpListeners) {
            listener.callPeerRecordReceived(event);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void addHistorySearchProgressListeners(HistoryReader reader, int countContacts) {
        Map<CallHistorySearchProgressListener, SearchProgressWrapper> map = this.progressListeners;
        synchronized (map) {
            for (SearchProgressWrapper l : this.progressListeners.values()) {
                l.contactCount = countContacts;
                reader.addSearchProgressListener((HistorySearchProgressListener)l);
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void removeHistorySearchProgressListeners(HistoryReader reader) {
        Map<CallHistorySearchProgressListener, SearchProgressWrapper> map = this.progressListeners;
        synchronized (map) {
            for (SearchProgressWrapper l : this.progressListeners.values()) {
                l.clear();
                reader.removeSearchProgressListener((HistorySearchProgressListener)l);
            }
        }
    }

    public void incomingCallReceived(CallEvent event) {
        this.handleNewCall(event.getSourceCall(), "in");
    }

    public void outgoingCallCreated(CallEvent event) {
        this.handleNewCall(event.getSourceCall(), "out");
    }

    public void callEnded(CallEvent event) {
    }

    private void handlePeerAdded(CallPeer callPeer) {
        CallRecordImpl callRecord = this.findCallRecord(callPeer.getCall());
        if (callRecord == null) {
            return;
        }
        callPeer.addCallPeerListener((CallPeerListener)new CallPeerAdapter(){

            public void peerStateChanged(CallPeerChangeEvent evt) {
                if (evt.getNewValue().equals(CallPeerState.DISCONNECTED)) {
                    return;
                }
                CallPeerRecordImpl peerRecord = CallHistoryServiceImpl.this.findPeerRecord(evt.getSourceCallPeer());
                if (peerRecord == null) {
                    return;
                }
                CallPeerState newState = (CallPeerState)evt.getNewValue();
                if (newState.equals(CallPeerState.CONNECTED) && !CallPeerState.isOnHold((CallPeerState)((CallPeerState)evt.getOldValue()))) {
                    peerRecord.setStartTime(new Date());
                }
                peerRecord.setState(newState);
            }
        });
        Date startDate = new Date();
        CallPeerRecordImpl newRec = new CallPeerRecordImpl(callPeer.getAddress(), startDate, startDate);
        newRec.setDisplayName(callPeer.getDisplayName());
        callRecord.getPeerRecords().add(newRec);
        this.fireCallHistoryRecordReceivedEvent(new CallHistoryPeerRecordEvent(callPeer.getAddress(), startDate, callPeer.getProtocolProvider()));
    }

    private void handlePeerRemoved(CallPeer callPeer, Call srcCall) {
        CallPeerState cpRecordState;
        CallRecordImpl callRecord = this.findCallRecord(srcCall);
        String pAddress = callPeer.getAddress();
        if (callRecord == null) {
            return;
        }
        CallPeerRecordImpl cpRecord = (CallPeerRecordImpl)callRecord.findPeerRecord(pAddress);
        if (cpRecord == null) {
            return;
        }
        if (!callPeer.getState().equals(CallPeerState.DISCONNECTED)) {
            cpRecord.setState(callPeer.getState());
        }
        if ((cpRecordState = cpRecord.getState()).equals(CallPeerState.CONNECTED) || CallPeerState.isOnHold((CallPeerState)cpRecordState)) {
            cpRecord.setEndTime(new Date());
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void updateCallRecordPeerSecondaryAddress(final Date date, final String peerAddress, String address) {
        History history;
        boolean callRecordFound = false;
        List<CallRecordImpl> list = this.currentCallRecords;
        synchronized (list) {
            for (CallRecord callRecord : this.currentCallRecords) {
                for (CallPeerRecord peerRecord : callRecord.getPeerRecords()) {
                    if (!peerRecord.getPeerAddress().equals(peerAddress) || !peerRecord.getStartTime().equals(date)) continue;
                    callRecordFound = true;
                    peerRecord.setPeerSecondaryAddress(address);
                }
            }
        }
        if (callRecordFound) {
            return;
        }
        try {
            history = this.getHistory(null, null);
        }
        catch (IOException e) {
            logger.warn((Object)"Failed to get the history object.");
            return;
        }
        HistoryWriter historyWriter = history.getWriter();
        HistoryWriter.HistoryRecordUpdater historyRecordUpdater = new HistoryWriter.HistoryRecordUpdater(){
            private HistoryRecord record;
            private int dateIndex;
            private int peerIDIndex;
            private int peerSecondaryIDIndex;

            public void setHistoryRecord(HistoryRecord historyRecord) {
                this.record = historyRecord;
                String[] propertyNames = this.record.getPropertyNames();
                for (int i = 0; i < propertyNames.length; ++i) {
                    if (propertyNames[i].equals(STRUCTURE_NAMES[5])) {
                        this.dateIndex = i;
                    }
                    if (propertyNames[i].equals(STRUCTURE_NAMES[4])) {
                        this.peerIDIndex = i;
                    }
                    if (!propertyNames[i].equals(STRUCTURE_NAMES[10])) continue;
                    this.peerSecondaryIDIndex = i;
                }
            }

            public boolean isMatching() {
                String[] propertyVlaues = this.record.getPropertyValues();
                List peerIDs = CallHistoryServiceImpl.getCSVs(propertyVlaues[this.peerIDIndex]);
                int i = peerIDs.indexOf(peerAddress);
                if (i == -1) {
                    return false;
                }
                String dateString = (String)CallHistoryServiceImpl.getCSVs(propertyVlaues[this.dateIndex]).get(i);
                SimpleDateFormat sdf = new SimpleDateFormat("yyyy-MM-dd'T'HH:mm:ss.SSSZ");
                try {
                    if (!sdf.parse(dateString).equals(date)) {
                        return false;
                    }
                }
                catch (ParseException e) {
                    logger.warn((Object)"Failed to parse the date.");
                    return false;
                }
                String secondaryID = (String)CallHistoryServiceImpl.getCSVs(propertyVlaues[this.peerSecondaryIDIndex]).get(i);
                return secondaryID == null;
            }

            public Map<String, String> getUpdateChanges() {
                String[] propertyVlaues = this.record.getPropertyValues();
                List peerIDs = CallHistoryServiceImpl.getCSVs(propertyVlaues[this.peerIDIndex]);
                int i = peerIDs.indexOf(peerAddress);
                if (i == -1) {
                    return null;
                }
                List secondaryID = CallHistoryServiceImpl.getCSVs(this.record.getPropertyValues()[this.peerSecondaryIDIndex]);
                secondaryID.set(i, peerAddress);
                String res = "";
                int j = 0;
                for (String id : secondaryID) {
                    if (j++ != 0) {
                        res = res + ',';
                    }
                    res = res + id;
                }
                HashMap<String, String> changesMap = new HashMap<String, String>();
                changesMap.put(STRUCTURE_NAMES[10], res);
                return changesMap;
            }
        };
        try {
            historyWriter.updateRecord(historyRecordUpdater);
        }
        catch (IOException e) {
            logger.warn((Object)"Failed to update the record.");
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private CallRecordImpl findCallRecord(Call call) {
        List<CallRecordImpl> list = this.currentCallRecords;
        synchronized (list) {
            for (CallRecordImpl item : this.currentCallRecords) {
                if (!item.getSourceCall().equals((Object)call)) continue;
                return item;
            }
        }
        return null;
    }

    private CallPeerRecordImpl findPeerRecord(CallPeer callPeer) {
        CallRecordImpl record = this.findCallRecord(callPeer.getCall());
        if (record == null) {
            return null;
        }
        return (CallPeerRecordImpl)record.findPeerRecord(callPeer.getAddress());
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void handleNewCall(Call sourceCall, String direction) {
        List<CallRecordImpl> list = this.currentCallRecords;
        synchronized (list) {
            for (CallRecordImpl currentCallRecord : this.currentCallRecords) {
                if (!currentCallRecord.getSourceCall().equals((Object)sourceCall)) continue;
                return;
            }
        }
        CallRecordImpl newRecord = new CallRecordImpl(direction, new Date(), null);
        newRecord.setSourceCall(sourceCall);
        sourceCall.addCallChangeListener(this.historyCallChangeListener);
        List<CallRecordImpl> list2 = this.currentCallRecords;
        synchronized (list2) {
            this.currentCallRecords.add(newRecord);
        }
        Iterator iter = sourceCall.getCallPeers();
        while (iter.hasNext()) {
            this.handlePeerAdded((CallPeer)iter.next());
        }
    }

    private static ProtocolProviderService getProtocolProvider(String accountUID) {
        for (ProtocolProviderFactory providerFactory : CallHistoryActivator.getProtocolProviderFactories().values()) {
            for (AccountID accountID : providerFactory.getRegisteredAccounts()) {
                if (!accountID.getAccountUniqueID().equals(accountUID)) continue;
                ServiceReference serRef = providerFactory.getProviderForAccount(accountID);
                return (ProtocolProviderService)CallHistoryActivator.bundleContext.getService(serRef);
            }
        }
        return null;
    }

    private class HistoryCallChangeListener
    implements CallChangeListener {
        private HistoryCallChangeListener() {
        }

        public void callPeerAdded(CallPeerEvent evt) {
            CallHistoryServiceImpl.this.handlePeerAdded(evt.getSourceCallPeer());
        }

        public void callPeerRemoved(CallPeerEvent evt) {
            CallHistoryServiceImpl.this.handlePeerRemoved(evt.getSourceCallPeer(), evt.getSourceCall());
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public void callStateChanged(CallChangeEvent evt) {
            CallRecordImpl callRecord = CallHistoryServiceImpl.this.findCallRecord(evt.getSourceCall());
            if (callRecord == null) {
                return;
            }
            if (!"CallState".equals(evt.getPropertyName())) {
                return;
            }
            if (evt.getNewValue().equals(CallState.CALL_ENDED)) {
                boolean writeRecord = true;
                if (evt.getOldValue().equals(CallState.CALL_INITIALIZATION)) {
                    callRecord.setEndTime(callRecord.getStartTime());
                    if (evt.getCause() != null && evt.getCause().getReasonCode() == 200) {
                        callRecord.setEndReason(evt.getCause().getReasonCode());
                        if ("Call completed elsewhere".equals(evt.getCause().getReasonString())) {
                            writeRecord = false;
                        }
                    }
                } else {
                    callRecord.setEndTime(new Date());
                }
                if (writeRecord) {
                    CallHistoryServiceImpl.this.writeCall(callRecord, null, null);
                }
                List list = CallHistoryServiceImpl.this.currentCallRecords;
                synchronized (list) {
                    CallHistoryServiceImpl.this.currentCallRecords.remove(callRecord);
                }
            }
        }
    }

    private static class CallRecordComparator
    implements Comparator<CallRecord> {
        private CallRecordComparator() {
        }

        @Override
        public int compare(CallRecord o1, CallRecord o2) {
            return o2.getStartTime().compareTo(o1.getStartTime());
        }
    }

    private class SearchProgressWrapper
    implements HistorySearchProgressListener {
        private CallHistorySearchProgressListener listener = null;
        int contactCount = 0;
        int currentContactCount = 0;
        int currentProgress = 0;
        int lastHistoryProgress = 0;

        SearchProgressWrapper(CallHistorySearchProgressListener listener) {
            this.listener = listener;
        }

        public void progressChanged(net.java.sip.communicator.service.history.event.ProgressEvent evt) {
            int progress = this.getProgressMapping(evt.getProgress());
            this.listener.progressChanged(new ProgressEvent(CallHistoryServiceImpl.this, evt, progress));
        }

        private int getProgressMapping(int historyProgress) {
            this.currentProgress += (historyProgress - this.lastHistoryProgress) / this.contactCount;
            if (historyProgress == 1000) {
                ++this.currentContactCount;
                this.lastHistoryProgress = 0;
                if (this.currentContactCount == this.contactCount) {
                    this.currentProgress = 1000;
                }
            } else {
                this.lastHistoryProgress = historyProgress;
            }
            return this.currentProgress;
        }

        void clear() {
            this.contactCount = 0;
            this.currentProgress = 0;
            this.lastHistoryProgress = 0;
            this.currentContactCount = 0;
        }
    }
}

