/*
 * Decompiled with CFR 0.152.
 */
package net.java.sip.communicator.plugin.desktoputil.presence.avatar.imagepicker;

import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.Rectangle;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.image.BufferedImage;
import javax.swing.JButton;
import javax.swing.JSlider;
import javax.swing.SwingUtilities;
import javax.swing.event.ChangeEvent;
import javax.swing.event.ChangeListener;
import net.java.sip.communicator.plugin.desktoputil.DesktopUtilActivator;
import net.java.sip.communicator.plugin.desktoputil.ImageUtils;
import net.java.sip.communicator.plugin.desktoputil.TransparentPanel;
import net.java.sip.communicator.plugin.desktoputil.presence.avatar.imagepicker.ImageClipper;

public class EditPanel
extends TransparentPanel
implements ChangeListener,
ActionListener {
    private ImageClipper imageClipper;
    private BufferedImage image;
    private JSlider imageSizeSlider;
    private JButton zoomIn;
    private JButton zoomOut;
    private JButton reset;
    private boolean resizeOnWidth = true;
    private boolean smallImage = false;
    private int clippingZoneWidth = 96;
    private int clippingZoneHeight = 96;

    public EditPanel(int clippingZoneWidth, int clippingZoneHeight) {
        this.setLayout(new BorderLayout());
        this.clippingZoneWidth = clippingZoneWidth;
        this.clippingZoneHeight = clippingZoneHeight;
        this.zoomOut = new JButton(DesktopUtilActivator.getResources().getImage("service.gui.buttons.ZOOM_OUT"));
        this.zoomOut.addActionListener(this);
        this.zoomIn = new JButton(DesktopUtilActivator.getResources().getImage("service.gui.buttons.ZOOM_IN"));
        this.zoomIn.addActionListener(this);
        this.reset = new JButton(DesktopUtilActivator.getResources().getImage("service.gui.buttons.RESET"));
        this.reset.setToolTipText(DesktopUtilActivator.getResources().getI18NString("service.gui.avatar.imagepicker.RESET"));
        this.reset.addActionListener(this);
        this.imageSizeSlider = new JSlider(clippingZoneWidth, clippingZoneWidth, clippingZoneWidth);
        this.imageSizeSlider.addChangeListener(this);
        this.imageSizeSlider.setOpaque(false);
        this.imageSizeSlider.setToolTipText(DesktopUtilActivator.getResources().getI18NString("service.gui.avatar.imagepicker.IMAGE_SIZE"));
        TransparentPanel sliderPanel = new TransparentPanel();
        sliderPanel.add(this.zoomOut);
        sliderPanel.add(this.imageSizeSlider);
        sliderPanel.add(this.zoomIn);
        sliderPanel.add(this.reset);
        this.imageClipper = new ImageClipper(this.clippingZoneWidth, this.clippingZoneHeight);
        this.add(this.imageClipper, "Center");
        this.add((Component)((Object)sliderPanel), "South");
    }

    public void setImage(BufferedImage image) {
        int width = image.getWidth(null);
        int height = image.getHeight(null);
        if (width < this.clippingZoneWidth || height < this.clippingZoneHeight) {
            this.enableSlider(false);
            this.smallImage = true;
            this.image = width > height && width > this.clippingZoneWidth || height > width && height <= this.clippingZoneHeight ? ImageUtils.getBufferedImage(image.getScaledInstance(-1, this.clippingZoneHeight, 4)) : ImageUtils.getBufferedImage(image.getScaledInstance(this.clippingZoneWidth, -1, 4));
        } else {
            this.image = image;
            this.enableSlider(true);
            this.resizeOnWidth = height >= width;
            this.imageSizeSlider.setMaximum(Math.min(width, height));
        }
        SwingUtilities.invokeLater(new Runnable(){

            @Override
            public void run() {
                EditPanel.this.reset();
            }
        });
    }

    public void reset() {
        this.imageSizeSlider.setValue(this.imageSizeSlider.getMinimum());
        this.drawImage();
    }

    public byte[] getClippedImage() {
        BufferedImage fullImage = this.getResizedImage(true);
        if (fullImage == null) {
            return null;
        }
        Rectangle clipping = this.imageClipper.getCroppedArea();
        BufferedImage subImage = fullImage.getSubimage(clipping.x, clipping.y, clipping.width, clipping.height);
        byte[] result = ImageUtils.toByteArray(subImage);
        return result;
    }

    private BufferedImage getResizedImage(boolean hq) {
        if (this.image == null) {
            return null;
        }
        BufferedImage i = null;
        int size = this.imageSizeSlider.getValue();
        i = this.resizeOnWidth ? ImageUtils.getBufferedImage(this.image.getScaledInstance(size, -1, hq ? 4 : 2)) : ImageUtils.getBufferedImage(this.image.getScaledInstance(-1, size, hq ? 4 : 2));
        return i;
    }

    private void drawImage() {
        this.imageClipper.setImage(this.getResizedImage(this.smallImage));
    }

    private void enableSlider(boolean enabled) {
        this.imageSizeSlider.setEnabled(enabled);
        this.zoomIn.setEnabled(enabled);
        this.zoomOut.setEnabled(enabled);
        this.reset.setEnabled(enabled);
    }

    @Override
    public void stateChanged(ChangeEvent e) {
        this.drawImage();
    }

    @Override
    public void actionPerformed(ActionEvent e) {
        if (e.getSource().equals(this.zoomIn)) {
            if (this.imageSizeSlider.getValue() < this.imageSizeSlider.getMaximum()) {
                this.imageSizeSlider.setValue(this.imageSizeSlider.getValue() + 1);
                this.drawImage();
            }
        } else if (e.getSource().equals(this.zoomOut)) {
            if (this.imageSizeSlider.getValue() > this.imageSizeSlider.getMinimum()) {
                this.imageSizeSlider.setValue(this.imageSizeSlider.getValue() - 1);
                this.drawImage();
            }
        } else if (e.getSource().equals(this.reset)) {
            this.reset();
        }
    }
}

