/*
 * Decompiled with CFR 0.152.
 */
package net.java.sip.communicator.impl.osdependent.systemtray;

import java.awt.GraphicsEnvironment;
import javax.swing.ImageIcon;
import net.java.sip.communicator.impl.osdependent.OsDependentActivator;
import net.java.sip.communicator.impl.osdependent.systemtray.TrayIcon;
import net.java.sip.communicator.impl.osdependent.systemtray.appindicator.AppIndicatorTray;
import net.java.sip.communicator.impl.osdependent.systemtray.awt.AWTSystemTray;
import net.java.sip.communicator.util.Logger;
import org.jitsi.util.OSUtils;

public abstract class SystemTray {
    private static final Logger logger = Logger.getLogger(SystemTray.class);
    private static SystemTray systemTray;
    private static final String DISABLED_TRAY_MODE = "disabled";

    public static final SystemTray getSystemTray() {
        if (systemTray == null) {
            String mode = SystemTray.getSystemTrayMode();
            logger.info((Object)("Tray for " + mode + " requested"));
            switch (mode) {
                case "disabled": {
                    return null;
                }
                case "native": {
                    if (!java.awt.SystemTray.isSupported()) break;
                    systemTray = new AWTSystemTray();
                    break;
                }
                case "appindicator": {
                    try {
                        systemTray = new AppIndicatorTray(true);
                    }
                    catch (Exception ex) {
                        logger.error((Object)"AppIndicator tray not available", (Throwable)ex);
                    }
                    break;
                }
                case "appindicator_static": {
                    try {
                        systemTray = new AppIndicatorTray(false);
                        break;
                    }
                    catch (Exception ex) {
                        logger.error((Object)"AppIndicator tray not available", (Throwable)ex);
                    }
                }
            }
            if (systemTray == null) {
                OsDependentActivator.getConfigurationService().setProperty("net.java.sip.communicator.osdependent.systemtray.MODE", (Object)DISABLED_TRAY_MODE);
            }
        }
        return systemTray;
    }

    public static String getSystemTrayMode() {
        String defaultTrayMode = DISABLED_TRAY_MODE;
        if (GraphicsEnvironment.isHeadless()) {
            return DISABLED_TRAY_MODE;
        }
        if (Boolean.getBoolean("disable-tray")) {
            OsDependentActivator.getConfigurationService().setProperty("net.java.sip.communicator.osdependent.systemtray.MODE", (Object)DISABLED_TRAY_MODE);
        }
        if (OSUtils.IS_WINDOWS || OSUtils.IS_MAC) {
            defaultTrayMode = "native";
        }
        return OsDependentActivator.getConfigurationService().getString("net.java.sip.communicator.osdependent.systemtray.MODE", defaultTrayMode);
    }

    public abstract void addTrayIcon(TrayIcon var1);

    public abstract TrayIcon createTrayIcon(ImageIcon var1, String var2, Object var3);

    public abstract boolean useSwingPopupMenu();

    public abstract boolean supportsDynamicMenu();
}

