/*
 * Decompiled with CFR 0.152.
 */
package net.java.sip.communicator.plugin.globalproxyconfig;

import java.awt.BorderLayout;
import java.awt.Color;
import java.awt.Component;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.GridLayout;
import java.awt.Insets;
import java.awt.LayoutManager;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.KeyEvent;
import java.awt.event.KeyListener;
import javax.swing.JCheckBox;
import javax.swing.JComboBox;
import javax.swing.JEditorPane;
import javax.swing.JLabel;
import javax.swing.JPasswordField;
import javax.swing.JTextField;
import javax.swing.JTextPane;
import net.java.sip.communicator.plugin.desktoputil.SIPCommCheckBox;
import net.java.sip.communicator.plugin.desktoputil.TransparentPanel;
import net.java.sip.communicator.plugin.globalproxyconfig.GlobalProxyPluginActivator;
import net.java.sip.communicator.plugin.globalproxyconfig.Resources;
import net.java.sip.communicator.service.protocol.ProxyInfo;
import org.jitsi.service.configuration.ConfigurationService;

public class GlobalProxyConfigForm
extends TransparentPanel
implements ActionListener,
KeyListener {
    private static final long serialVersionUID = 0L;
    private JComboBox typeCombo;
    private JTextField serverAddressField = new JTextField();
    private JTextField portField = new JTextField();
    private JTextField usernameField = new JTextField();
    private JPasswordField passwordField = new JPasswordField();
    private JCheckBox dnsForwardCheck = new SIPCommCheckBox();
    private JTextField dnsForwardServerAddressField = new JTextField();
    private JTextField dnsForwardPortField = new JTextField();
    private TransparentPanel dnsAddressPane;

    public GlobalProxyConfigForm() {
        super((LayoutManager)new BorderLayout());
        this.init();
    }

    private void init() {
        TransparentPanel centerPanel = new TransparentPanel((LayoutManager)new GridBagLayout());
        GridBagConstraints constraints = new GridBagConstraints();
        constraints.fill = 2;
        constraints.anchor = 18;
        constraints.insets = new Insets(5, 10, 0, 0);
        constraints.gridx = 0;
        constraints.weightx = 0.0;
        constraints.weighty = 0.0;
        constraints.gridy = 0;
        centerPanel.add((Component)new JLabel(Resources.getString("plugin.globalproxy.PROXY_TYPE")), (Object)constraints);
        constraints.gridy = 1;
        centerPanel.add((Component)new JLabel(Resources.getString("plugin.globalproxy.PROXY_ADDRESS")), (Object)constraints);
        constraints.gridy = 2;
        centerPanel.add((Component)new JLabel(Resources.getString("plugin.globalproxy.PROXY_USERNAME")), (Object)constraints);
        constraints.gridy = 3;
        centerPanel.add((Component)new JLabel(Resources.getString("plugin.globalproxy.PROXY_PASSWORD")), (Object)constraints);
        constraints.weightx = 1.0;
        constraints.gridx = 1;
        constraints.gridy = 0;
        constraints.gridwidth = 3;
        this.typeCombo = new JComboBox<ProxyInfo.ProxyType>(ProxyInfo.ProxyType.values());
        this.typeCombo.setEditable(false);
        centerPanel.add((Component)this.typeCombo, (Object)constraints);
        constraints.gridy = 1;
        constraints.gridwidth = 1;
        centerPanel.add((Component)this.serverAddressField, (Object)constraints);
        constraints.gridx = 2;
        constraints.weightx = 0.0;
        centerPanel.add((Component)new JLabel(Resources.getString("plugin.globalproxy.PROXY_PORT")), (Object)constraints);
        constraints.gridx = 3;
        constraints.weightx = 1.0;
        centerPanel.add((Component)this.portField, (Object)constraints);
        constraints.gridx = 1;
        constraints.gridwidth = 3;
        constraints.gridy = 2;
        centerPanel.add((Component)this.usernameField, (Object)constraints);
        constraints.gridy = 3;
        centerPanel.add((Component)this.passwordField, (Object)constraints);
        constraints.gridx = 0;
        constraints.gridy = 4;
        constraints.gridwidth = 4;
        constraints.gridheight = 2;
        constraints.insets = new Insets(15, 15, 0, 15);
        JTextPane pane = new JTextPane();
        pane.setEditable(false);
        pane.setOpaque(false);
        pane.setText(Resources.getResources().getI18NString("plugin.globalproxy.DESCRIPTION", new String[]{Resources.getResources().getSettingsString("service.gui.APPLICATION_NAME")}));
        centerPanel.add((Component)pane, (Object)constraints);
        constraints.gridx = 0;
        constraints.gridy = 6;
        constraints.gridwidth = 4;
        constraints.gridheight = 2;
        constraints.insets = new Insets(0, 20, 0, 20);
        JEditorPane table = new JEditorPane();
        table.setContentType("text/html");
        table.setEditable(false);
        table.setOpaque(false);
        table.putClientProperty("JEditorPane.honorDisplayProperties", Boolean.TRUE);
        table.setText(Resources.getString("plugin.globalproxy.PROTOCOL_SUPPORT"));
        centerPanel.add((Component)table, (Object)constraints);
        constraints.weightx = 0.0;
        constraints.gridx = 0;
        constraints.gridy = 9;
        constraints.gridwidth = 4;
        constraints.gridheight = 1;
        constraints.insets = new Insets(5, 10, 0, 0);
        this.dnsForwardCheck.setText(Resources.getResources().getI18NString("plugin.globalproxy.FWD_DNS"));
        centerPanel.add((Component)this.dnsForwardCheck, (Object)constraints);
        constraints.gridy = 10;
        constraints.insets = new Insets(0, 38, 0, 0);
        String dnsForwardLabelText = Resources.getResources().getI18NString("plugin.globalproxy.FWD_DNS_NOTE");
        JTextPane dnspane = new JTextPane();
        dnspane.setEditable(false);
        dnspane.setOpaque(false);
        dnspane.setText(dnsForwardLabelText);
        dnspane.setForeground(Color.GRAY);
        dnspane.setFont(dnspane.getFont().deriveFont(8));
        centerPanel.add((Component)dnspane, (Object)constraints);
        constraints.gridy = 11;
        constraints.gridwidth = 4;
        constraints.gridheight = 2;
        this.dnsAddressPane = new TransparentPanel((LayoutManager)new GridLayout(2, 2));
        this.dnsAddressPane.add((Component)new JLabel(Resources.getResources().getI18NString("plugin.globalproxy.FWD_DNS_ADDR")));
        this.dnsAddressPane.add((Component)this.dnsForwardServerAddressField);
        this.dnsAddressPane.add((Component)new JLabel(Resources.getResources().getI18NString("plugin.globalproxy.FWD_DNS_PORT")));
        this.dnsAddressPane.add((Component)this.dnsForwardPortField);
        this.dnsAddressPane.setVisible(false);
        centerPanel.add((Component)this.dnsAddressPane, (Object)constraints);
        this.add((Component)centerPanel, "North");
        this.loadValues();
        this.serverAddressField.addKeyListener(this);
        this.portField.addKeyListener(this);
        this.usernameField.addKeyListener(this);
        this.passwordField.addKeyListener(this);
        this.typeCombo.addActionListener(this);
        this.dnsForwardServerAddressField.addKeyListener(this);
        this.dnsForwardPortField.addKeyListener(this);
        this.dnsForwardCheck.addActionListener(this);
    }

    private void loadValues() {
        String password;
        String username;
        String port;
        ConfigurationService configService = GlobalProxyPluginActivator.getConfigurationService();
        String serverAddress = configService.getString("net.java.sip.communicator.service.connectionProxyAddress");
        if (serverAddress != null) {
            this.serverAddressField.setText(serverAddress);
        }
        if ((port = configService.getString("net.java.sip.communicator.service.connectionProxyPort")) != null) {
            this.portField.setText(port);
        }
        if ((username = configService.getString("net.java.sip.communicator.service.connectionProxyUsername")) != null) {
            this.usernameField.setText(username);
        }
        if ((password = configService.getString("net.java.sip.communicator.service.connectionProxyPassword")) != null) {
            this.passwordField.setText(password);
        }
        try {
            String type = configService.getString("net.java.sip.communicator.service.connectionProxyType");
            if (type != null) {
                this.typeCombo.setSelectedItem(ProxyInfo.ProxyType.valueOf((String)type));
            }
        }
        catch (IllegalArgumentException illegalArgumentException) {
            // empty catch block
        }
        if (this.typeCombo.getSelectedItem().equals(ProxyInfo.ProxyType.NONE)) {
            this.serverAddressField.setEnabled(false);
            this.portField.setEnabled(false);
            this.usernameField.setEnabled(false);
            this.passwordField.setEnabled(false);
        }
        if (configService.getBoolean("net.java.sip.communicator.service.connectionProxyForwardDNS", false)) {
            this.dnsForwardCheck.setSelected(true);
            this.dnsForwardServerAddressField.setText((String)configService.getProperty("net.java.sip.communicator.service.connectionProxyForwardDNSAddress"));
            this.dnsForwardPortField.setText((String)configService.getProperty("net.java.sip.communicator.service.connectionProxyForwardDNSPort"));
            this.dnsAddressPane.setVisible(true);
        }
    }

    private void saveValues() {
        ConfigurationService configService = GlobalProxyPluginActivator.getConfigurationService();
        if (this.typeCombo.getSelectedItem().equals(ProxyInfo.ProxyType.NONE)) {
            configService.setProperty("net.java.sip.communicator.service.connectionProxyType", (Object)ProxyInfo.ProxyType.NONE.name());
            configService.removeProperty("net.java.sip.communicator.service.connectionProxyAddress");
            configService.removeProperty("net.java.sip.communicator.service.connectionProxyPort");
            configService.removeProperty("net.java.sip.communicator.service.connectionProxyUsername");
            configService.removeProperty("net.java.sip.communicator.service.connectionProxyPassword");
        } else {
            String username;
            String serverAddress = this.serverAddressField.getText();
            String port = this.portField.getText();
            if (serverAddress == null || serverAddress.length() == 0 || port == null || port.length() == 0) {
                return;
            }
            configService.setProperty("net.java.sip.communicator.service.connectionProxyType", (Object)((ProxyInfo.ProxyType)this.typeCombo.getSelectedItem()).name());
            if (serverAddress != null && serverAddress.length() > 0) {
                configService.setProperty("net.java.sip.communicator.service.connectionProxyAddress", (Object)serverAddress);
            }
            if (port != null && port.length() > 0) {
                configService.setProperty("net.java.sip.communicator.service.connectionProxyPort", (Object)port);
            }
            if ((username = this.usernameField.getText()) != null && username.length() > 0) {
                configService.setProperty("net.java.sip.communicator.service.connectionProxyUsername", (Object)username);
            } else {
                configService.removeProperty("net.java.sip.communicator.service.connectionProxyUsername");
            }
            char[] password = this.passwordField.getPassword();
            if (password.length > 0) {
                configService.setProperty("net.java.sip.communicator.service.connectionProxyPassword", (Object)new String(password));
            } else {
                configService.removeProperty("net.java.sip.communicator.service.connectionProxyPassword");
            }
        }
        if (this.dnsForwardCheck.isSelected()) {
            configService.setProperty("net.java.sip.communicator.service.connectionProxyForwardDNS", (Object)Boolean.TRUE);
            configService.setProperty("net.java.sip.communicator.service.connectionProxyForwardDNSAddress", (Object)this.dnsForwardServerAddressField.getText().trim());
            configService.setProperty("net.java.sip.communicator.service.connectionProxyForwardDNSPort", (Object)this.dnsForwardPortField.getText().trim());
        } else {
            configService.removeProperty("net.java.sip.communicator.service.connectionProxyForwardDNS");
            configService.removeProperty("net.java.sip.communicator.service.connectionProxyForwardDNSAddress");
            configService.removeProperty("net.java.sip.communicator.service.connectionProxyForwardDNSPort");
        }
        GlobalProxyPluginActivator.initProperties();
    }

    @Override
    public void actionPerformed(ActionEvent e) {
        if (e.getSource().equals(this.dnsForwardCheck)) {
            this.dnsAddressPane.setVisible(this.dnsForwardCheck.isSelected());
            if (this.dnsForwardCheck.isSelected()) {
                if (this.dnsForwardServerAddressField.getText().length() == 0) {
                    this.dnsForwardServerAddressField.setText(this.serverAddressField.getText());
                }
                if (this.dnsForwardPortField.getText().length() == 0) {
                    this.dnsForwardPortField.setText("53");
                }
            }
            this.revalidate();
            this.repaint();
            this.saveValues();
            return;
        }
        if (this.typeCombo.getSelectedItem().equals(ProxyInfo.ProxyType.NONE)) {
            this.serverAddressField.setEnabled(false);
            this.portField.setEnabled(false);
            this.usernameField.setEnabled(false);
            this.passwordField.setEnabled(false);
        } else {
            this.serverAddressField.setEnabled(true);
            this.portField.setEnabled(true);
            this.usernameField.setEnabled(true);
            this.passwordField.setEnabled(true);
        }
        this.saveValues();
    }

    @Override
    public void keyTyped(KeyEvent e) {
    }

    @Override
    public void keyPressed(KeyEvent e) {
    }

    @Override
    public void keyReleased(KeyEvent e) {
        this.saveValues();
    }
}

