/*
 * Decompiled with CFR 0.152.
 */
package net.kano.joustsim.oscar.proxy;

import java.io.IOException;
import java.net.InetAddress;
import java.net.ServerSocket;
import java.net.UnknownHostException;
import javax.net.ServerSocketFactory;
import javax.net.SocketFactory;
import net.kano.joscar.DefensiveTools;
import net.kano.joustsim.oscar.proxy.HttpProxiedSocketFactory;
import net.kano.joustsim.oscar.proxy.SocksServerSocketFactory;
import net.kano.joustsim.oscar.proxy.SocksSocketFactory;
import org.jetbrains.annotations.Nullable;
import socks.Proxy;
import socks.Socks4Proxy;
import socks.Socks5Proxy;
import socks.UserPasswordAuthentication;

public class AimProxyInfo {
    private SocketFactory socketFactory;
    private ServerSocketFactory serverSocketFactory;
    private String host;
    private int port;
    private String username;
    private String password;
    private Type type;

    public static AimProxyInfo forHttp(String host, int port, @Nullable String username, @Nullable String password) {
        DefensiveTools.checkNull(host, "host");
        DefensiveTools.checkRange(port, "port", 1, 65535);
        return new AimProxyInfo(Type.HTTP, host, port, username, password);
    }

    public static AimProxyInfo forSocks4(String host, int port, @Nullable String username) {
        DefensiveTools.checkNull(host, "host");
        DefensiveTools.checkRange(port, "port", 1, 65535);
        return new AimProxyInfo(Type.SOCKS4, host, port, username, null);
    }

    public static AimProxyInfo forSocks5(String host, int port, @Nullable String username, @Nullable String password) {
        DefensiveTools.checkNull(host, "host");
        DefensiveTools.checkRange(port, "port", 1, 65535);
        if (username == null != (password == null)) {
            throw new IllegalArgumentException("Username and password must either be both null or neither null; username was " + username + ", password was " + password);
        }
        return new AimProxyInfo(Type.SOCKS5, host, port, username, password);
    }

    public static AimProxyInfo forNoProxy() {
        return new AimProxyInfo(Type.NONE, null, -1, null, null);
    }

    public AimProxyInfo(Type type, String host, int port, String username, String password) {
        this.type = type;
        this.host = host;
        this.port = port;
        this.username = username;
        this.password = password;
        if (type == Type.SOCKS4 || type == Type.SOCKS5) {
            this.socketFactory = new SocksSocketFactory(this);
            this.serverSocketFactory = new SocksServerSocketFactory(this);
        } else if (type == Type.HTTP) {
            if (username == null && password != null || username != null && password == null) {
                throw new IllegalArgumentException("Username and password must be specified together; username was " + username + ", password was <" + (password == null ? "null" : "non-null") + ">");
            }
            this.socketFactory = new HttpProxiedSocketFactory(this);
        }
    }

    public Type getType() {
        return this.type;
    }

    public String getHost() {
        return this.host;
    }

    public int getPort() {
        return this.port;
    }

    public String getUsername() {
        return this.username;
    }

    public String getPassword() {
        return this.password;
    }

    @Nullable
    public SocketFactory getSocketFactory() {
        return this.socketFactory;
    }

    @Nullable
    public ServerSocketFactory getServerSocketFactory() {
        return this.serverSocketFactory;
    }

    public Proxy createSocksProxy() throws UnknownHostException {
        if (this.type == Type.SOCKS4) {
            return new Socks4Proxy(this.getHost(), this.getPort(), this.getUsername());
        }
        if (this.type == Type.SOCKS5) {
            Socks5Proxy proxy = new Socks5Proxy(this.getHost(), this.getPort());
            String username = this.getUsername();
            String password = this.getPassword();
            if (username != null) {
                assert (password != null);
                proxy.setAuthenticationMethod(2, new UserPasswordAuthentication(username, password));
            }
            return proxy;
        }
        throw new IllegalStateException(this.type.name());
    }

    private static class UselessServerSocketFactory
    extends ServerSocketFactory {
        private UselessServerSocketFactory() {
        }

        public ServerSocket createServerSocket(int i) throws IOException {
            throw new IOException("Cannot open server socket over HTTP proxy");
        }

        public ServerSocket createServerSocket(int i, int i1) throws IOException {
            throw new IOException("Cannot open server socket over HTTP proxy");
        }

        public ServerSocket createServerSocket(int i, int i1, InetAddress inetAddress) throws IOException {
            throw new IOException("Cannot open server socket over HTTP proxy");
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    public static enum Type {
        NONE,
        SOCKS4,
        SOCKS5,
        HTTP;

    }
}

