/*
 * Decompiled with CFR 0.152.
 */
package net.java.sip.communicator.plugin.keybindingchooser;

import java.awt.AWTError;
import java.awt.Color;
import java.awt.Component;
import java.awt.Container;
import java.awt.Dialog;
import java.awt.Dimension;
import java.awt.Frame;
import java.awt.GradientPaint;
import java.awt.Graphics;
import java.awt.Graphics2D;
import java.awt.Point;
import java.awt.RenderingHints;
import java.awt.Toolkit;
import java.awt.Window;
import java.awt.event.ActionEvent;
import javax.swing.AbstractAction;
import javax.swing.BorderFactory;
import javax.swing.JButton;
import javax.swing.JComponent;
import javax.swing.JDialog;
import javax.swing.KeyStroke;
import javax.swing.border.Border;

public class ComponentTools {
    public static GradientPaint applyThemedScheme(JComponent component, Color reference, boolean isPressed) {
        boolean isVeryDark;
        int r = reference.getRed();
        int g = reference.getGreen();
        int b = reference.getBlue();
        Color lightened = new Color(ComponentTools.getValidRgb(r + 75), ComponentTools.getValidRgb(g + 75), ComponentTools.getValidRgb(b + 75));
        Color darkened = new Color(ComponentTools.getValidRgb(r - 75), ComponentTools.getValidRgb(g - 75), ComponentTools.getValidRgb(b - 75));
        boolean bl = isVeryDark = (r + g + b) / 3 < 25;
        if (isPressed) {
            if (isVeryDark) {
                reference = reference.brighter();
                lightened = lightened.brighter();
                darkened = darkened.brighter();
            } else {
                reference = reference.darker();
                lightened = lightened.darker();
                darkened = darkened.darker();
            }
        }
        if (component != null) {
            int borderType = !isPressed ? 0 : 1;
            Border border = BorderFactory.createBevelBorder(borderType, lightened, darkened);
            component.setBorder(border);
            Color foreground = isVeryDark ? new Color(224, 224, 224) : Color.BLACK;
            component.setForeground(foreground);
        }
        Point p1 = new Point(0, 20);
        Point p2 = new Point(0, 5);
        return new GradientPaint(p1, reference, p2, lightened, false);
    }

    public static JButton makeThemedButton(String text, final Color reference) {
        JButton button = new JButton(text){
            private static final long serialVersionUID = 0L;

            @Override
            public void paintComponent(Graphics g) {
                Graphics2D g2 = (Graphics2D)g;
                g2.setRenderingHint(RenderingHints.KEY_ANTIALIASING, RenderingHints.VALUE_ANTIALIAS_ON);
                g2.setPaint(ComponentTools.applyThemedScheme(this, reference, this.getModel().isArmed()));
                g2.fillRect(0, 0, this.getWidth(), this.getHeight());
                super.paintComponent(g);
            }
        };
        button.setContentAreaFilled(false);
        return button;
    }

    public static void center(Window mover) {
        Dimension moverSize = mover.getPreferredSize();
        Dimension screenSize = Toolkit.getDefaultToolkit().getScreenSize();
        int x = (screenSize.width - moverSize.width) / 2;
        int y = (screenSize.height - moverSize.height) / 2;
        mover.setLocation(x, y);
    }

    public static void center(Window mover, Component target) {
        Dimension moverSize = mover.getSize();
        Dimension targetSize = target.getSize();
        int x = (targetSize.width - moverSize.width) / 2;
        int y = (targetSize.height - moverSize.height) / 2;
        mover.setLocation(x += target.getLocation().x, y += target.getLocation().y);
    }

    public static void setKeyBinding(JButton button, KeyStroke event) {
        String eventName = "do" + button.getText();
        button.getInputMap(2).put(event, eventName);
        button.getActionMap().put(eventName, new AbstractAction(){
            private static final long serialVersionUID = 0L;

            @Override
            public void actionPerformed(ActionEvent event) {
                ((JButton)event.getSource()).doClick();
            }
        });
    }

    public static JDialog makeDialog(Component parent, String title) {
        if ((parent = ComponentTools.findParent(parent)) == null) {
            throw new AWTError("No suitable parent found for Component.");
        }
        if (parent instanceof Frame) {
            return new JDialog((Frame)parent, title, true);
        }
        return new JDialog((Dialog)parent, title, true);
    }

    private static Component findParent(Component comp) {
        if (comp instanceof Frame || comp instanceof Dialog) {
            return comp;
        }
        Container parent = comp.getParent();
        if (parent != null) {
            return ComponentTools.findParent(parent);
        }
        return null;
    }

    private static int getValidRgb(int value) {
        value = Math.max(value, 0);
        value = Math.min(value, 255);
        return value;
    }
}

