/*
 * Decompiled with CFR 0.152.
 */
package net.java.sip.communicator.plugin.otr;

import java.util.Collection;
import java.util.Dictionary;
import java.util.Hashtable;
import java.util.List;
import java.util.Map;
import java.util.Vector;
import net.java.sip.communicator.plugin.otr.OtrActionHandler;
import net.java.sip.communicator.plugin.otr.OtrContactManager;
import net.java.sip.communicator.plugin.otr.OtrMetaContactButton;
import net.java.sip.communicator.plugin.otr.OtrMetaContactMenu;
import net.java.sip.communicator.plugin.otr.OtrTransformLayer;
import net.java.sip.communicator.plugin.otr.ScOtrEngineImpl;
import net.java.sip.communicator.plugin.otr.ScOtrKeyManager;
import net.java.sip.communicator.plugin.otr.ScOtrKeyManagerImpl;
import net.java.sip.communicator.plugin.otr.SwingOtrActionHandler;
import net.java.sip.communicator.plugin.otr.authdialog.OTRv3OutgoingSessionSwitcher;
import net.java.sip.communicator.service.contactlist.MetaContactListService;
import net.java.sip.communicator.service.gui.ConfigurationForm;
import net.java.sip.communicator.service.gui.Container;
import net.java.sip.communicator.service.gui.LazyConfigurationForm;
import net.java.sip.communicator.service.gui.PluginComponent;
import net.java.sip.communicator.service.gui.PluginComponentFactory;
import net.java.sip.communicator.service.gui.UIService;
import net.java.sip.communicator.service.msghistory.MessageHistoryService;
import net.java.sip.communicator.service.protocol.AccountID;
import net.java.sip.communicator.service.protocol.OperationSetInstantMessageTransform;
import net.java.sip.communicator.service.protocol.ProtocolProviderFactory;
import net.java.sip.communicator.service.protocol.ProtocolProviderService;
import net.java.sip.communicator.service.protocol.TransformLayer;
import net.java.sip.communicator.service.resources.ResourceManagementServiceUtils;
import net.java.sip.communicator.util.AbstractServiceDependentActivator;
import net.java.sip.communicator.util.Logger;
import net.java.sip.communicator.util.ServiceUtils;
import org.jitsi.service.configuration.ConfigurationService;
import org.jitsi.service.resources.ResourceManagementService;
import org.jitsi.util.OSUtils;
import org.osgi.framework.BundleContext;
import org.osgi.framework.ServiceEvent;
import org.osgi.framework.ServiceListener;
import org.osgi.framework.ServiceReference;

public class OtrActivator
extends AbstractServiceDependentActivator
implements ServiceListener {
    public static BundleContext bundleContext;
    public static ConfigurationService configService;
    private static final Logger logger;
    private static final String OTR_CHAT_CONFIG_DISABLED_PROP = "net.java.sip.communicator.plugin.otr.otrchatconfig.DISABLED";
    public static final String OTR_DISABLED_PROP = "net.java.sip.communicator.plugin.otr.DISABLED";
    public static final String OTR_MANDATORY_PROP = "net.java.sip.communicator.plugin.otr.PRIVATE_MESSAGING_MANDATORY";
    public static ResourceManagementService resourceService;
    public static ScOtrEngineImpl scOtrEngine;
    public static ScOtrKeyManager scOtrKeyManager;
    public static UIService uiService;
    private static MetaContactListService metaCListService;
    private static MessageHistoryService messageHistoryService;
    private static OtrContactManager otrContactManager;
    private OtrTransformLayer otrTransformLayer;

    public static AccountID getAccountIDByUID(String uid) {
        if (uid == null || uid.length() < 1) {
            return null;
        }
        Map<Object, ProtocolProviderFactory> providerFactoriesMap = OtrActivator.getProtocolProviderFactories();
        if (providerFactoriesMap == null) {
            return null;
        }
        for (ProtocolProviderFactory providerFactory : providerFactoriesMap.values()) {
            for (AccountID accountID : providerFactory.getRegisteredAccounts()) {
                if (!accountID.getAccountUniqueID().equals(uid)) continue;
                return accountID;
            }
        }
        return null;
    }

    public static List<AccountID> getAllAccountIDs() {
        Map<Object, ProtocolProviderFactory> providerFactoriesMap = OtrActivator.getProtocolProviderFactories();
        if (providerFactoriesMap == null) {
            return null;
        }
        Vector<AccountID> accountIDs = new Vector<AccountID>();
        for (ProtocolProviderFactory providerFactory : providerFactoriesMap.values()) {
            for (AccountID accountID : providerFactory.getRegisteredAccounts()) {
                accountIDs.add(accountID);
            }
        }
        return accountIDs;
    }

    private static Map<Object, ProtocolProviderFactory> getProtocolProviderFactories() {
        Collection serRefs = ServiceUtils.getServiceReferences((BundleContext)bundleContext, ProtocolProviderFactory.class);
        Hashtable<Object, ProtocolProviderFactory> providerFactoriesMap = new Hashtable<Object, ProtocolProviderFactory>();
        if (!serRefs.isEmpty()) {
            for (ServiceReference serRef : serRefs) {
                ProtocolProviderFactory providerFactory = (ProtocolProviderFactory)bundleContext.getService(serRef);
                providerFactoriesMap.put(serRef.getProperty("PROTOCOL_NAME"), providerFactory);
            }
        }
        return providerFactoriesMap;
    }

    public Class<?> getDependentServiceClass() {
        return UIService.class;
    }

    private void handleProviderAdded(ProtocolProviderService provider) {
        OperationSetInstantMessageTransform opSetMessageTransform = (OperationSetInstantMessageTransform)provider.getOperationSet(OperationSetInstantMessageTransform.class);
        if (opSetMessageTransform != null) {
            opSetMessageTransform.addTransformLayer((TransformLayer)this.otrTransformLayer);
        } else if (logger.isTraceEnabled()) {
            logger.trace((Object)"Service did not have a transform op. set.");
        }
    }

    private void handleProviderRemoved(ProtocolProviderService provider) {
        OperationSetInstantMessageTransform opSetMessageTransform = (OperationSetInstantMessageTransform)provider.getOperationSet(OperationSetInstantMessageTransform.class);
        if (opSetMessageTransform != null) {
            opSetMessageTransform.removeTransformLayer((TransformLayer)this.otrTransformLayer);
        }
    }

    public void serviceChanged(ServiceEvent serviceEvent) {
        Object sService = bundleContext.getService(serviceEvent.getServiceReference());
        if (logger.isTraceEnabled()) {
            logger.trace((Object)("Received a service event for: " + sService.getClass().getName()));
        }
        if (!(sService instanceof ProtocolProviderService)) {
            return;
        }
        if (logger.isDebugEnabled()) {
            logger.debug((Object)"Service is a protocol provider.");
        }
        if (serviceEvent.getType() == 1) {
            if (logger.isDebugEnabled()) {
                logger.debug((Object)"Handling registration of a new Protocol Provider.");
            }
            this.handleProviderAdded((ProtocolProviderService)sService);
        } else if (serviceEvent.getType() == 4) {
            this.handleProviderRemoved((ProtocolProviderService)sService);
        }
    }

    public void setBundleContext(BundleContext context) {
        bundleContext = context;
    }

    public void start(Object dependentService) {
        configService = (ConfigurationService)ServiceUtils.getService((BundleContext)bundleContext, ConfigurationService.class);
        if (configService.getBoolean(OTR_DISABLED_PROP, false)) {
            configService = null;
            return;
        }
        resourceService = ResourceManagementServiceUtils.getService((BundleContext)bundleContext);
        if (resourceService == null) {
            configService = null;
            return;
        }
        uiService = (UIService)dependentService;
        scOtrEngine = new ScOtrEngineImpl();
        otrContactManager = new OtrContactManager();
        this.otrTransformLayer = new OtrTransformLayer();
        bundleContext.addServiceListener((ServiceListener)this);
        bundleContext.addServiceListener((ServiceListener)scOtrEngine);
        bundleContext.addServiceListener((ServiceListener)otrContactManager);
        Collection protocolProviderRefs = ServiceUtils.getServiceReferences((BundleContext)bundleContext, ProtocolProviderService.class);
        if (!protocolProviderRefs.isEmpty()) {
            if (logger.isDebugEnabled()) {
                logger.debug((Object)("Found " + protocolProviderRefs.size() + " already installed providers."));
            }
            for (ServiceReference protocolProviderRef : protocolProviderRefs) {
                ProtocolProviderService provider = (ProtocolProviderService)bundleContext.getService(protocolProviderRef);
                this.handleProviderAdded(provider);
            }
        }
        if (!OSUtils.IS_ANDROID) {
            Hashtable<String, String> containerFilter = new Hashtable<String, String>();
            containerFilter.put("CONTAINER_ID", Container.CONTAINER_CONTACT_RIGHT_BUTTON_MENU.getID());
            bundleContext.registerService(PluginComponentFactory.class.getName(), (Object)new OtrPluginComponentFactory(Container.CONTAINER_CONTACT_RIGHT_BUTTON_MENU), containerFilter);
            containerFilter.put("CONTAINER_ID", Container.CONTAINER_CHAT_MENU_BAR.getID());
            bundleContext.registerService(PluginComponentFactory.class.getName(), (Object)new OtrPluginComponentFactory(Container.CONTAINER_CHAT_MENU_BAR), containerFilter);
            containerFilter.put("CONTAINER_ID", Container.CONTAINER_CHAT_TOOL_BAR.getID());
            bundleContext.registerService(PluginComponentFactory.class.getName(), (Object)new OtrPluginComponentFactory(Container.CONTAINER_CHAT_TOOL_BAR), containerFilter);
            bundleContext.registerService(OtrActionHandler.class.getName(), (Object)new SwingOtrActionHandler(), null);
            containerFilter.put("CONTAINER_ID", Container.CONTAINER_CHAT_WRITE_PANEL.getID());
            bundleContext.registerService(PluginComponentFactory.class.getName(), (Object)new PluginComponentFactory(Container.CONTAINER_CHAT_WRITE_PANEL){

                protected PluginComponent getPluginInstance() {
                    return new OTRv3OutgoingSessionSwitcher(this.getContainer(), this);
                }
            }, containerFilter);
        }
        if (!configService.getBoolean(OTR_CHAT_CONFIG_DISABLED_PROP, false) && !OSUtils.IS_ANDROID) {
            Hashtable<String, String> properties = new Hashtable<String, String>();
            ((Dictionary)properties).put("FORM_TYPE", "SECURITY_TYPE");
            bundleContext.registerService(ConfigurationForm.class.getName(), (Object)new LazyConfigurationForm("net.java.sip.communicator.plugin.otr.authdialog.OtrConfigurationPanel", ((Object)((Object)this)).getClass().getClassLoader(), "plugin.otr.configform.ICON", "service.gui.CHAT", 1), properties);
        }
    }

    public void stop(BundleContext bc) throws Exception {
        Collection protocolProviderRefs;
        bundleContext.removeServiceListener((ServiceListener)this);
        if (scOtrEngine != null) {
            bundleContext.removeServiceListener((ServiceListener)scOtrEngine);
        }
        if (otrContactManager != null) {
            bundleContext.removeServiceListener((ServiceListener)otrContactManager);
        }
        if (!(protocolProviderRefs = ServiceUtils.getServiceReferences((BundleContext)bundleContext, ProtocolProviderService.class)).isEmpty()) {
            for (ServiceReference protocolProviderRef : protocolProviderRefs) {
                ProtocolProviderService provider = (ProtocolProviderService)bundleContext.getService(protocolProviderRef);
                this.handleProviderRemoved(provider);
            }
        }
    }

    public static MetaContactListService getContactListService() {
        if (metaCListService == null) {
            metaCListService = (MetaContactListService)ServiceUtils.getService((BundleContext)bundleContext, MetaContactListService.class);
        }
        return metaCListService;
    }

    public static MessageHistoryService getMessageHistoryService() {
        if (messageHistoryService == null) {
            messageHistoryService = (MessageHistoryService)ServiceUtils.getService((BundleContext)bundleContext, MessageHistoryService.class);
        }
        return messageHistoryService;
    }

    static {
        logger = Logger.getLogger(OtrActivator.class);
        scOtrKeyManager = new ScOtrKeyManagerImpl();
    }

    private static class OtrPluginComponentFactory
    extends PluginComponentFactory {
        OtrPluginComponentFactory(Container c) {
            super(c);
        }

        protected PluginComponent getPluginInstance() {
            Container container = this.getContainer();
            if (container.equals((Object)Container.CONTAINER_CHAT_TOOL_BAR)) {
                return new OtrMetaContactButton(container, this);
            }
            return new OtrMetaContactMenu(container, this);
        }
    }
}

