/*
 * Decompiled with CFR 0.152.
 */
package net.java.sip.communicator.plugin.chatalerter;

import com.apple.eawt.Application;
import java.beans.PropertyChangeEvent;
import java.beans.PropertyChangeListener;
import java.util.Iterator;
import javax.swing.JFrame;
import net.java.sip.communicator.service.gui.ExportedWindow;
import net.java.sip.communicator.service.gui.UIService;
import net.java.sip.communicator.service.gui.WindowID;
import net.java.sip.communicator.service.protocol.AdHocChatRoom;
import net.java.sip.communicator.service.protocol.Call;
import net.java.sip.communicator.service.protocol.CallPeer;
import net.java.sip.communicator.service.protocol.CallPeerState;
import net.java.sip.communicator.service.protocol.ChatRoom;
import net.java.sip.communicator.service.protocol.OperationSetBasicInstantMessaging;
import net.java.sip.communicator.service.protocol.OperationSetBasicTelephony;
import net.java.sip.communicator.service.protocol.OperationSetMultiUserChat;
import net.java.sip.communicator.service.protocol.OperationSetSmsMessaging;
import net.java.sip.communicator.service.protocol.ProtocolProviderService;
import net.java.sip.communicator.service.protocol.event.AdHocChatRoomMessageDeliveredEvent;
import net.java.sip.communicator.service.protocol.event.AdHocChatRoomMessageDeliveryFailedEvent;
import net.java.sip.communicator.service.protocol.event.AdHocChatRoomMessageListener;
import net.java.sip.communicator.service.protocol.event.AdHocChatRoomMessageReceivedEvent;
import net.java.sip.communicator.service.protocol.event.CallEvent;
import net.java.sip.communicator.service.protocol.event.CallListener;
import net.java.sip.communicator.service.protocol.event.ChatRoomMessageDeliveredEvent;
import net.java.sip.communicator.service.protocol.event.ChatRoomMessageDeliveryFailedEvent;
import net.java.sip.communicator.service.protocol.event.ChatRoomMessageListener;
import net.java.sip.communicator.service.protocol.event.ChatRoomMessageReceivedEvent;
import net.java.sip.communicator.service.protocol.event.LocalUserAdHocChatRoomPresenceChangeEvent;
import net.java.sip.communicator.service.protocol.event.LocalUserAdHocChatRoomPresenceListener;
import net.java.sip.communicator.service.protocol.event.LocalUserChatRoomPresenceChangeEvent;
import net.java.sip.communicator.service.protocol.event.LocalUserChatRoomPresenceListener;
import net.java.sip.communicator.service.protocol.event.MessageDeliveredEvent;
import net.java.sip.communicator.service.protocol.event.MessageDeliveryFailedEvent;
import net.java.sip.communicator.service.protocol.event.MessageListener;
import net.java.sip.communicator.service.protocol.event.MessageReceivedEvent;
import net.java.sip.communicator.util.ConfigurationUtils;
import net.java.sip.communicator.util.Logger;
import net.java.sip.communicator.util.ServiceUtils;
import org.jdesktop.jdic.misc.Alerter;
import org.jitsi.service.configuration.ConfigurationService;
import org.jitsi.util.OSUtils;
import org.osgi.framework.BundleActivator;
import org.osgi.framework.BundleContext;
import org.osgi.framework.InvalidSyntaxException;
import org.osgi.framework.ServiceEvent;
import org.osgi.framework.ServiceListener;
import org.osgi.framework.ServiceReference;

public class ChatAlerterActivator
implements BundleActivator,
ServiceListener,
MessageListener,
ChatRoomMessageListener,
AdHocChatRoomMessageListener,
LocalUserChatRoomPresenceListener,
LocalUserAdHocChatRoomPresenceListener,
PropertyChangeListener,
CallListener {
    private static Logger logger = Logger.getLogger(ChatAlerterActivator.class);
    private BundleContext bundleContext = null;
    private UIService uiService;
    private boolean started = false;

    public void start(BundleContext bc) throws Exception {
        this.bundleContext = bc;
        ((ConfigurationService)ServiceUtils.getService((BundleContext)this.bundleContext, ConfigurationService.class)).addPropertyChangeListener("plugin.chatalerter.ENABLED", (PropertyChangeListener)this);
        try {
            if (!ConfigurationUtils.isAlerterEnabled()) {
                return;
            }
            if (!OSUtils.IS_MAC) {
                Alerter.newInstance();
            }
        }
        catch (Exception exception) {
            if (logger.isInfoEnabled()) {
                logger.info((Object)"The Alerter not supported or problem loading it!", (Throwable)exception);
            }
            return;
        }
        this.startInternal(bc);
    }

    private void startInternal(BundleContext bc) {
        ServiceReference[] protocolProviderRefs;
        bc.addServiceListener((ServiceListener)this);
        try {
            protocolProviderRefs = bc.getServiceReferences(ProtocolProviderService.class.getName(), null);
        }
        catch (InvalidSyntaxException ex) {
            logger.error((Object)"Error while retrieving service refs", (Throwable)ex);
            return;
        }
        if (protocolProviderRefs != null) {
            if (logger.isDebugEnabled()) {
                logger.debug((Object)("Found " + protocolProviderRefs.length + " already installed providers."));
            }
            for (ServiceReference protocolProviderRef : protocolProviderRefs) {
                ProtocolProviderService provider = (ProtocolProviderService)bc.getService(protocolProviderRef);
                this.handleProviderAdded(provider);
            }
        }
        this.started = true;
    }

    public void stop(BundleContext bc) throws Exception {
        this.stopInternal(bc);
        ((ConfigurationService)ServiceUtils.getService((BundleContext)this.bundleContext, ConfigurationService.class)).removePropertyChangeListener("plugin.chatalerter.ENABLED", (PropertyChangeListener)this);
    }

    private void stopInternal(BundleContext bc) {
        ServiceReference[] protocolProviderRefs;
        bc.removeServiceListener((ServiceListener)this);
        try {
            protocolProviderRefs = bc.getServiceReferences(ProtocolProviderService.class.getName(), null);
        }
        catch (InvalidSyntaxException ex) {
            logger.error((Object)"Error while retrieving service refs", (Throwable)ex);
            return;
        }
        if (protocolProviderRefs != null) {
            for (ServiceReference protocolProviderRef : protocolProviderRefs) {
                ProtocolProviderService provider = (ProtocolProviderService)bc.getService(protocolProviderRef);
                this.handleProviderRemoved(provider);
            }
        }
        this.started = false;
    }

    private void handleProviderAdded(ProtocolProviderService provider) {
        OperationSetBasicInstantMessaging opSetIm;
        if (logger.isDebugEnabled()) {
            logger.debug((Object)("Adding protocol provider " + provider.getProtocolName()));
        }
        if ((opSetIm = (OperationSetBasicInstantMessaging)provider.getOperationSet(OperationSetBasicInstantMessaging.class)) != null) {
            opSetIm.addMessageListener((MessageListener)this);
        } else if (logger.isTraceEnabled()) {
            logger.trace((Object)"Service did not have a im op. set.");
        }
        OperationSetSmsMessaging opSetSms = (OperationSetSmsMessaging)provider.getOperationSet(OperationSetSmsMessaging.class);
        if (opSetSms != null) {
            opSetSms.addMessageListener((MessageListener)this);
        } else if (logger.isTraceEnabled()) {
            logger.trace((Object)"Service did not have a sms op. set.");
        }
        OperationSetMultiUserChat opSetMultiUChat = (OperationSetMultiUserChat)provider.getOperationSet(OperationSetMultiUserChat.class);
        if (opSetMultiUChat != null) {
            for (ChatRoom room : opSetMultiUChat.getCurrentlyJoinedChatRooms()) {
                room.addMessageListener((ChatRoomMessageListener)this);
            }
            opSetMultiUChat.addPresenceListener((LocalUserChatRoomPresenceListener)this);
        } else if (logger.isTraceEnabled()) {
            logger.trace((Object)"Service did not have a multi im op. set.");
        }
        OperationSetBasicTelephony basicTelephonyOpSet = (OperationSetBasicTelephony)provider.getOperationSet(OperationSetBasicTelephony.class);
        if (basicTelephonyOpSet != null) {
            basicTelephonyOpSet.addCallListener((CallListener)this);
        }
    }

    private void handleProviderRemoved(ProtocolProviderService provider) {
        OperationSetBasicTelephony basicTelephonyOpSet;
        OperationSetMultiUserChat opSetMultiUChat;
        OperationSetSmsMessaging opSetSms;
        OperationSetBasicInstantMessaging opSetIm = (OperationSetBasicInstantMessaging)provider.getOperationSet(OperationSetBasicInstantMessaging.class);
        if (opSetIm != null) {
            opSetIm.removeMessageListener((MessageListener)this);
        }
        if ((opSetSms = (OperationSetSmsMessaging)provider.getOperationSet(OperationSetSmsMessaging.class)) != null) {
            opSetSms.removeMessageListener((MessageListener)this);
        }
        if ((opSetMultiUChat = (OperationSetMultiUserChat)provider.getOperationSet(OperationSetMultiUserChat.class)) != null) {
            for (ChatRoom room : opSetMultiUChat.getCurrentlyJoinedChatRooms()) {
                room.removeMessageListener((ChatRoomMessageListener)this);
            }
        }
        if ((basicTelephonyOpSet = (OperationSetBasicTelephony)provider.getOperationSet(OperationSetBasicTelephony.class)) != null) {
            basicTelephonyOpSet.removeCallListener((CallListener)this);
        }
    }

    public void localUserPresenceChanged(LocalUserChatRoomPresenceChangeEvent ev) {
        ChatRoom chatRoom = ev.getChatRoom();
        if ("LocalUserJoined".equals(ev.getEventType())) {
            if (!chatRoom.isSystem()) {
                chatRoom.addMessageListener((ChatRoomMessageListener)this);
            }
        } else {
            chatRoom.removeMessageListener((ChatRoomMessageListener)this);
        }
    }

    public void messageReceived(MessageReceivedEvent evt) {
        this.alertChatWindow();
    }

    public void messageDelivered(MessageDeliveredEvent evt) {
    }

    public void messageDeliveryFailed(MessageDeliveryFailedEvent evt) {
    }

    public void messageReceived(ChatRoomMessageReceivedEvent evt) {
        this.alertChatWindow();
    }

    public void messageDelivered(ChatRoomMessageDeliveredEvent evt) {
    }

    public void messageDeliveryFailed(ChatRoomMessageDeliveryFailedEvent evt) {
    }

    private void alertChatWindow() {
        this.alertWindow(ExportedWindow.CHAT_WINDOW);
    }

    private void alertWindow(WindowID windowID) {
        try {
            ExportedWindow win = this.getUIService().getExportedWindow(windowID);
            if (win == null) {
                return;
            }
            Object winSource = win.getSource();
            if (!(winSource instanceof JFrame)) {
                return;
            }
            JFrame fr = (JFrame)winSource;
            if (OSUtils.IS_MAC) {
                Application.getApplication().requestUserAttention(true);
            } else {
                Alerter.newInstance().alert(fr);
            }
        }
        catch (Throwable ex) {
            logger.error((Object)"Cannot alert chat window!", ex);
        }
    }

    public void serviceChanged(ServiceEvent serviceEvent) {
        Object sService = this.bundleContext.getService(serviceEvent.getServiceReference());
        if (logger.isTraceEnabled()) {
            logger.trace((Object)("Received a service event for: " + sService.getClass().getName()));
        }
        if (!(sService instanceof ProtocolProviderService)) {
            return;
        }
        if (logger.isDebugEnabled()) {
            logger.debug((Object)"Service is a protocol provider.");
        }
        switch (serviceEvent.getType()) {
            case 1: {
                this.handleProviderAdded((ProtocolProviderService)sService);
                break;
            }
            case 4: {
                this.handleProviderRemoved((ProtocolProviderService)sService);
            }
        }
    }

    public void messageDelivered(AdHocChatRoomMessageDeliveredEvent evt) {
    }

    public void messageDeliveryFailed(AdHocChatRoomMessageDeliveryFailedEvent evt) {
    }

    public void messageReceived(AdHocChatRoomMessageReceivedEvent evt) {
        this.alertChatWindow();
    }

    public void localUserAdHocPresenceChanged(LocalUserAdHocChatRoomPresenceChangeEvent ev) {
        AdHocChatRoom adHocChatRoom = ev.getAdHocChatRoom();
        if ("LocalUserJoined".equals(ev.getEventType())) {
            adHocChatRoom.addMessageListener((AdHocChatRoomMessageListener)this);
        } else {
            ev.getAdHocChatRoom().removeMessageListener((AdHocChatRoomMessageListener)this);
        }
    }

    public UIService getUIService() {
        ServiceReference serviceRef;
        if (this.uiService == null && (serviceRef = this.bundleContext.getServiceReference(UIService.class.getName())) != null) {
            this.uiService = (UIService)this.bundleContext.getService(serviceRef);
        }
        return this.uiService;
    }

    @Override
    public void propertyChange(PropertyChangeEvent evt) {
        if (!evt.getPropertyName().equals("plugin.chatalerter.ENABLED")) {
            return;
        }
        try {
            if (ConfigurationUtils.isAlerterEnabled() && !this.started) {
                this.startInternal(this.bundleContext);
            } else if (!ConfigurationUtils.isAlerterEnabled() && this.started) {
                this.stopInternal(this.bundleContext);
            }
        }
        catch (Throwable t) {
            logger.error((Object)"Error starting/stopping on configuration change");
        }
    }

    public void incomingCallReceived(CallEvent event) {
        Call call = event.getSourceCall();
        Iterator peerIter = call.getCallPeers();
        boolean alert = false;
        while (peerIter.hasNext()) {
            CallPeer peer = (CallPeer)peerIter.next();
            if (!CallPeerState.INCOMING_CALL.equals(peer.getState())) continue;
            alert = true;
            break;
        }
        if (alert) {
            this.alertWindow(ExportedWindow.MAIN_WINDOW);
        }
    }

    public void outgoingCallCreated(CallEvent event) {
    }

    public void callEnded(CallEvent event) {
    }
}

