/*
 * Decompiled with CFR 0.152.
 */
package net.java.sip.communicator.impl.gui.utils;

import java.awt.AlphaComposite;
import java.awt.Color;
import java.awt.Component;
import java.awt.FontMetrics;
import java.awt.Graphics;
import java.awt.Graphics2D;
import java.awt.Image;
import java.awt.image.BufferedImage;
import java.io.IOException;
import java.io.InputStream;
import java.net.URISyntaxException;
import java.net.URL;
import javax.swing.ImageIcon;
import net.java.sip.communicator.impl.gui.GuiActivator;
import net.java.sip.communicator.impl.gui.utils.Constants;
import net.java.sip.communicator.impl.gui.utils.ImageLoaderServiceImpl;
import net.java.sip.communicator.plugin.desktoputil.AntialiasingManager;
import net.java.sip.communicator.plugin.desktoputil.ImageUtils;
import net.java.sip.communicator.plugin.desktoputil.LightGrayFilter;
import net.java.sip.communicator.service.gui.ImageLoaderService;
import net.java.sip.communicator.service.protocol.OperationSetPresence;
import net.java.sip.communicator.service.protocol.ProtocolProviderService;
import net.java.sip.communicator.service.resources.ImageID;
import net.java.sip.communicator.util.Logger;
import net.java.sip.communicator.util.ServiceUtils;
import org.osgi.framework.BundleContext;

public class ImageLoader {
    private static final Logger logger = Logger.getLogger(ImageLoader.class);
    private static ImageLoaderServiceImpl imageLoaderService = null;
    public static final ImageID SIP_COMMUNICATOR_LOGO = new ImageID("service.gui.SIP_COMMUNICATOR_LOGO");
    public static final ImageID BUTTON = new ImageID("service.gui.lookandfeel.BUTTON");
    public static final ImageID BUTTON_ROLLOVER = new ImageID("service.gui.lookandfeel.BUTTON_ROLLOVER");
    public static final ImageID TOGGLE_BUTTON_PRESSED = new ImageID("service.gui.lookandfeel.TOGGLE_BUTTON_PRESSED");
    public static final ImageID SPLITPANE_HORIZONTAL = new ImageID("service.gui.lookandfeel.SPLITPANE_HORIZONTAL");
    public static final ImageID SPLITPANE_VERTICAL = new ImageID("service.gui.lookandfeel.SPLITPANE_VERTICAL");
    public static final ImageID SCROLLBAR_THUMB_VERTICAL = new ImageID("service.gui.lookandfeel.SCROLLBAR_VERTICAL");
    public static final ImageID SCROLLBAR_THUMB_HORIZONTAL = new ImageID("service.gui.lookandfeel.SCROLLBAR_HORIZONTAL");
    public static final ImageID SCROLLBAR_THUMB_HANDLE_HORIZONTAL = new ImageID("service.gui.lookandfeel.SCROLLBAR_THUMB_HORIZONTAL");
    public static final ImageID SCROLLBAR_THUMB_HANDLE_VERTICAL = new ImageID("service.gui.lookandfeel.SCROLLBAR_THUMB_VERTICAL");
    public static final ImageID WARNING_ICON = new ImageID("service.gui.icons.WARNING_ICON");
    public static final ImageID ERROR_ICON = new ImageID("service.gui.icons.ERROR_ICON");
    public static final ImageID INFO_ICON = new ImageID("service.gui.icons.INFO_ICON");
    public static final ImageID MAIN_WINDOW_BACKGROUND = new ImageID("service.gui.MAIN_WINDOW_BACKGROUND");
    public static final ImageID ADD_ACCOUNT_MENU_ICON = new ImageID("service.gui.icons.ADD_ACCOUNT_MENU_ICON");
    public static final ImageID DOWN_ARROW_ICON = new ImageID("service.gui.icons.DOWN_ARROW_ICON");
    public static final ImageID RIGHT_ARROW_ICON = new ImageID("service.gui.icons.RIGHT_ARROW_ICON");
    public static final ImageID ACCOUNT_EDIT_ICON = new ImageID("service.gui.buttons.ACCOUNT_EDIT_ICON");
    public static final ImageID INCOMING_CALL_BUTTON_BG = new ImageID("service.gui.buttons.INCOMING_CALL_BUTTON_BG");
    public static final ImageID INCOMING_CALL_BUTTON_ROLLOVER = new ImageID("service.gui.buttons.INCOMING_CALL_BUTTON_ROLLOVER");
    public static final ImageID INCOMING_CALL_BUTTON_PRESSED = new ImageID("service.gui.buttons.INCOMING_CALL_BUTTON_PRESSED");
    public static final ImageID MERGE_CALL_BUTTON_BG = new ImageID("service.gui.buttons.MERGE_CALL_BUTTON_BG");
    public static final ImageID MERGE_CALL_BUTTON_ROLLOVER = new ImageID("service.gui.buttons.MERGE_CALL_BUTTON_ROLLOVER");
    public static final ImageID MERGE_CALL_BUTTON_PRESSED = new ImageID("service.gui.buttons.MERGE_CALL_BUTTON_PRESSED");
    public static final ImageID CALL_VIDEO_BUTTON_BG = new ImageID("service.gui.buttons.CALL_VIDEO_BUTTON_BG");
    public static final ImageID CALL_VIDEO_BUTTON_ROLLOVER = new ImageID("service.gui.buttons.CALL_VIDEO_BUTTON_ROLLOVER");
    public static final ImageID CALL_VIDEO_BUTTON_PRESSED = new ImageID("service.gui.buttons.CALL_VIDEO_BUTTON_PRESSED");
    public static final ImageID CONTACT_LIST_BUTTON_BG_LEFT = new ImageID("service.gui.buttons.CONTACT_LIST_BUTTON_BG_LEFT");
    public static final ImageID CONTACT_LIST_BUTTON_BG_RIGHT = new ImageID("service.gui.buttons.CONTACT_LIST_BUTTON_BG_RIGHT");
    public static final ImageID CONTACT_LIST_BUTTON_BG_MIDDLE = new ImageID("service.gui.buttons.CONTACT_LIST_BUTTON_BG_MIDDLE");
    public static final ImageID CONTACT_LIST_ONE_BUTTON_BG = new ImageID("service.gui.buttons.CONTACT_LIST_ONE_BUTTON_BG");
    public static final ImageID CONTACT_LIST_BUTTON_SEPARATOR = new ImageID("service.gui.buttons.CONTACT_LIST_BUTTON_SEPARATOR");
    public static final ImageID CONTACT_LIST_MOBILE_INDICATOR = new ImageID("service.gui.buttons.CONTACT_LIST_MOBILE_INDICATOR");
    public static final ImageID CALL_BUTTON_SMALL = new ImageID("service.gui.buttons.CALL_BUTTON_SMALL");
    public static final ImageID CALL_BUTTON_SMALL_ROLLOVER = new ImageID("service.gui.buttons.CALL_BUTTON_SMALL_ROLLOVER");
    public static final ImageID CALL_BUTTON_SMALL_PRESSED = new ImageID("service.gui.buttons.CALL_BUTTON_SMALL_PRESSED");
    public static final ImageID DESKTOP_BUTTON_SMALL = new ImageID("service.gui.buttons.DESKTOP_BUTTON_SMALL");
    public static final ImageID DESKTOP_BUTTON_SMALL_ROLLOVER = new ImageID("service.gui.buttons.DESKTOP_BUTTON_SMALL_ROLLOVER");
    public static final ImageID DESKTOP_BUTTON_SMALL_PRESSED = new ImageID("service.gui.buttons.DESKTOP_BUTTON_SMALL_PRESSED");
    public static final ImageID CALL_DESKTOP_BUTTON = new ImageID("service.gui.buttons.CALL_DESKTOP_BUTTON");
    public static final ImageID CALL_VIDEO_BUTTON_SMALL = new ImageID("service.gui.buttons.CALL_VIDEO_BUTTON_SMALL");
    public static final ImageID CALL_VIDEO_BUTTON_SMALL_ROLLOVER = new ImageID("service.gui.buttons.CALL_VIDEO_BUTTON_SMALL_ROLLOVER");
    public static final ImageID CALL_VIDEO_BUTTON_SMALL_PRESSED = new ImageID("service.gui.buttons.CALL_VIDEO_BUTTON_SMALL_PRESSED");
    public static final ImageID ADD_CONTACT_BUTTON_SMALL = new ImageID("service.gui.buttons.ADD_CONTACT_BUTTON_SMALL");
    public static final ImageID ADD_CONTACT_BUTTON_SMALL_ROLLOVER = new ImageID("service.gui.buttons.ADD_CONTACT_BUTTON_SMALL_ROLLOVER");
    public static final ImageID ADD_CONTACT_BUTTON_SMALL_PRESSED = new ImageID("service.gui.buttons.ADD_CONTACT_BUTTON_SMALL_PRESSED");
    public static final ImageID WEB_BUTTON = new ImageID("service.gui.buttons.WEB_BUTTON");
    public static final ImageID WEB_BUTTON_ROLLOVER = new ImageID("service.gui.buttons.WEB_BUTTON_ROLLOVER");
    public static final ImageID WEB_BUTTON_PRESSED = new ImageID("service.gui.buttons.WEB_BUTTON_PRESSED");
    public static final ImageID CHAT_BUTTON_SMALL = new ImageID("service.gui.buttons.CHAT_BUTTON_SMALL");
    public static final ImageID CHAT_BUTTON_SMALL_WHITE = new ImageID("service.gui.buttons.CHAT_BUTTON_SMALL_WHITE");
    public static final ImageID CALL_TOOLBAR_SEPARATOR = new ImageID("service.gui.icons.CALL_TOOLBAR_SEPARATOR");
    public static final ImageID CALL_TOOLBAR_DARK_SEPARATOR = new ImageID("service.gui.icons.CALL_TOOLBAR_DARK_SEPARATOR");
    public static final ImageID CHAT_CALL = new ImageID("service.gui.buttons.CHAT_CALL");
    public static final ImageID CHAT_ROOM_CALL = new ImageID("service.gui.buttons.CHAT_ROOM_CALL");
    public static final ImageID CHAT_VIDEO_CALL = new ImageID("service.gui.buttons.CHAT_VIDEO_CALL");
    public static final ImageID CHAT_ROOM_VIDEO_CALL = new ImageID("service.gui.buttons.CHAT_ROOM_VIDEO_CALL");
    public static final ImageID CHAT_DESKTOP_SHARING = new ImageID("service.gui.buttons.CHAT_DESKTOP_SHARING");
    public static final ImageID CALL_HISTORY_BUTTON = new ImageID("service.gui.buttons.CALL_HISTORY_BUTTON");
    public static final ImageID CALL_HISTORY_BUTTON_PRESSED = new ImageID("service.gui.buttons.CALL_HISTORY_BUTTON_PRESSED");
    public static final ImageID CALL_HISTORY_BUTTON_NOTIFICATION = new ImageID("service.gui.icons.CALL_HISTORY_BUTTON_NOTIFICATION");
    public static final ImageID CHAT_BUTTON_SMALL_PRESSED = new ImageID("service.gui.buttons.CHAT_BUTTON_SMALL_PRESSED");
    public static final ImageID CHAT_BUTTON_SMALL_ROLLOVER = new ImageID("service.gui.buttons.CHAT_BUTTON_SMALL_ROLLOVER");
    public static final ImageID HANGUP_BUTTON_BG = new ImageID("service.gui.buttons.HANGUP_BUTTON_BG");
    public static final ImageID HANGUP_BUTTON_ROLLOVER = new ImageID("service.gui.buttons.HANGUP_BUTTON_ROLLOVER");
    public static final ImageID HANGUP_BUTTON_PRESSED = new ImageID("service.gui.buttons.HANGUP_BUTTON_PRESSED");
    public static final ImageID CALL_SETTING_BUTTON_BG = new ImageID("service.gui.buttons.CALL_SETTING_BUTTON_BG");
    public static final ImageID CALL_SETTING_BUTTON_PRESSED_BG = new ImageID("service.gui.buttons.CALL_SETTING_BUTTON_PRESSED_BG");
    public static final ImageID ONE_DIAL_BUTTON_MAC = new ImageID("service.gui.buttons.ONE_DIAL_BUTTON_MAC");
    public static final ImageID TWO_DIAL_BUTTON_MAC = new ImageID("service.gui.buttons.TWO_DIAL_BUTTON_MAC");
    public static final ImageID THREE_DIAL_BUTTON_MAC = new ImageID("service.gui.buttons.THREE_DIAL_BUTTON_MAC");
    public static final ImageID FOUR_DIAL_BUTTON_MAC = new ImageID("service.gui.buttons.FOUR_DIAL_BUTTON_MAC");
    public static final ImageID FIVE_DIAL_BUTTON_MAC = new ImageID("service.gui.buttons.FIVE_DIAL_BUTTON_MAC");
    public static final ImageID SIX_DIAL_BUTTON_MAC = new ImageID("service.gui.buttons.SIX_DIAL_BUTTON_MAC");
    public static final ImageID SEVEN_DIAL_BUTTON_MAC = new ImageID("service.gui.buttons.SEVEN_DIAL_BUTTON_MAC");
    public static final ImageID EIGHT_DIAL_BUTTON_MAC = new ImageID("service.gui.buttons.EIGHT_DIAL_BUTTON_MAC");
    public static final ImageID NINE_DIAL_BUTTON_MAC = new ImageID("service.gui.buttons.NINE_DIAL_BUTTON_MAC");
    public static final ImageID STAR_DIAL_BUTTON_MAC = new ImageID("service.gui.buttons.STAR_DIAL_BUTTON_MAC");
    public static final ImageID ZERO_DIAL_BUTTON_MAC = new ImageID("service.gui.buttons.ZERO_DIAL_BUTTON_MAC");
    public static final ImageID DIEZ_DIAL_BUTTON_MAC = new ImageID("service.gui.buttons.DIEZ_DIAL_BUTTON_MAC");
    public static final ImageID ONE_DIAL_BUTTON_MAC_ROLLOVER = new ImageID("service.gui.buttons.ONE_DIAL_BUTTON_MAC_ROLLOVER");
    public static final ImageID TWO_DIAL_BUTTON_MAC_ROLLOVER = new ImageID("service.gui.buttons.TWO_DIAL_BUTTON_MAC_ROLLOVER");
    public static final ImageID THREE_DIAL_BUTTON_MAC_ROLLOVER = new ImageID("service.gui.buttons.THREE_DIAL_BUTTON_MAC_ROLLOVER");
    public static final ImageID FOUR_DIAL_BUTTON_MAC_ROLLOVER = new ImageID("service.gui.buttons.FOUR_DIAL_BUTTON_MAC_ROLLOVER");
    public static final ImageID FIVE_DIAL_BUTTON_MAC_ROLLOVER = new ImageID("service.gui.buttons.FIVE_DIAL_BUTTON_MAC_ROLLOVER");
    public static final ImageID SIX_DIAL_BUTTON_MAC_ROLLOVER = new ImageID("service.gui.buttons.SIX_DIAL_BUTTON_MAC_ROLLOVER");
    public static final ImageID SEVEN_DIAL_BUTTON_MAC_ROLLOVER = new ImageID("service.gui.buttons.SEVEN_DIAL_BUTTON_MAC_ROLLOVER");
    public static final ImageID EIGHT_DIAL_BUTTON_MAC_ROLLOVER = new ImageID("service.gui.buttons.EIGHT_DIAL_BUTTON_MAC_ROLLOVER");
    public static final ImageID NINE_DIAL_BUTTON_MAC_ROLLOVER = new ImageID("service.gui.buttons.NINE_DIAL_BUTTON_MAC_ROLLOVER");
    public static final ImageID STAR_DIAL_BUTTON_MAC_ROLLOVER = new ImageID("service.gui.buttons.STAR_DIAL_BUTTON_MAC_ROLLOVER");
    public static final ImageID ZERO_DIAL_BUTTON_MAC_ROLLOVER = new ImageID("service.gui.buttons.ZERO_DIAL_BUTTON_MAC_ROLLOVER");
    public static final ImageID DIEZ_DIAL_BUTTON_MAC_ROLLOVER = new ImageID("service.gui.buttons.DIEZ_DIAL_BUTTON_MAC_ROLLOVER");
    public static final ImageID ONE_DIAL_BUTTON = new ImageID("service.gui.buttons.ONE_DIAL_BUTTON");
    public static final ImageID ONE_DIAL_BUTTON_PRESSED = new ImageID("service.gui.buttons.ONE_DIAL_BUTTON_PRESSED");
    public static final ImageID ONE_DIAL_BUTTON_ROLLOVER = new ImageID("service.gui.buttons.ONE_DIAL_BUTTON_ROLLOVER");
    public static final ImageID TWO_DIAL_BUTTON = new ImageID("service.gui.buttons.TWO_DIAL_BUTTON");
    public static final ImageID TWO_DIAL_BUTTON_PRESSED = new ImageID("service.gui.buttons.TWO_DIAL_BUTTON_PRESSED");
    public static final ImageID TWO_DIAL_BUTTON_ROLLOVER = new ImageID("service.gui.buttons.TWO_DIAL_BUTTON_ROLLOVER");
    public static final ImageID THREE_DIAL_BUTTON = new ImageID("service.gui.buttons.THREE_DIAL_BUTTON");
    public static final ImageID THREE_DIAL_BUTTON_PRESSED = new ImageID("service.gui.buttons.THREE_DIAL_BUTTON_PRESSED");
    public static final ImageID THREE_DIAL_BUTTON_ROLLOVER = new ImageID("service.gui.buttons.THREE_DIAL_BUTTON_ROLLOVER");
    public static final ImageID FOUR_DIAL_BUTTON = new ImageID("service.gui.buttons.FOUR_DIAL_BUTTON");
    public static final ImageID FOUR_DIAL_BUTTON_PRESSED = new ImageID("service.gui.buttons.FOUR_DIAL_BUTTON_PRESSED");
    public static final ImageID FOUR_DIAL_BUTTON_ROLLOVER = new ImageID("service.gui.buttons.FOUR_DIAL_BUTTON_ROLLOVER");
    public static final ImageID FIVE_DIAL_BUTTON = new ImageID("service.gui.buttons.FIVE_DIAL_BUTTON");
    public static final ImageID FIVE_DIAL_BUTTON_PRESSED = new ImageID("service.gui.buttons.FIVE_DIAL_BUTTON_PRESSED");
    public static final ImageID FIVE_DIAL_BUTTON_ROLLOVER = new ImageID("service.gui.buttons.FIVE_DIAL_BUTTON_ROLLOVER");
    public static final ImageID SIX_DIAL_BUTTON = new ImageID("service.gui.buttons.SIX_DIAL_BUTTON");
    public static final ImageID SIX_DIAL_BUTTON_PRESSED = new ImageID("service.gui.buttons.SIX_DIAL_BUTTON_PRESSED");
    public static final ImageID SIX_DIAL_BUTTON_ROLLOVER = new ImageID("service.gui.buttons.SIX_DIAL_BUTTON_ROLLOVER");
    public static final ImageID SEVEN_DIAL_BUTTON = new ImageID("service.gui.buttons.SEVEN_DIAL_BUTTON");
    public static final ImageID SEVEN_DIAL_BUTTON_PRESSED = new ImageID("service.gui.buttons.SEVEN_DIAL_BUTTON_PRESSED");
    public static final ImageID SEVEN_DIAL_BUTTON_ROLLOVER = new ImageID("service.gui.buttons.SEVEN_DIAL_BUTTON_ROLLOVER");
    public static final ImageID EIGHT_DIAL_BUTTON = new ImageID("service.gui.buttons.EIGHT_DIAL_BUTTON");
    public static final ImageID EIGHT_DIAL_BUTTON_PRESSED = new ImageID("service.gui.buttons.EIGHT_DIAL_BUTTON_PRESSED");
    public static final ImageID EIGHT_DIAL_BUTTON_ROLLOVER = new ImageID("service.gui.buttons.EIGHT_DIAL_BUTTON_ROLLOVER");
    public static final ImageID NINE_DIAL_BUTTON = new ImageID("service.gui.buttons.NINE_DIAL_BUTTON");
    public static final ImageID NINE_DIAL_BUTTON_PRESSED = new ImageID("service.gui.buttons.NINE_DIAL_BUTTON_PRESSED");
    public static final ImageID NINE_DIAL_BUTTON_ROLLOVER = new ImageID("service.gui.buttons.NINE_DIAL_BUTTON_ROLLOVER");
    public static final ImageID STAR_DIAL_BUTTON = new ImageID("service.gui.buttons.STAR_DIAL_BUTTON");
    public static final ImageID STAR_DIAL_BUTTON_PRESSED = new ImageID("service.gui.buttons.STAR_DIAL_BUTTON_PRESSED");
    public static final ImageID STAR_DIAL_BUTTON_ROLLOVER = new ImageID("service.gui.buttons.STAR_DIAL_BUTTON_ROLLOVER");
    public static final ImageID ZERO_DIAL_BUTTON = new ImageID("service.gui.buttons.ZERO_DIAL_BUTTON");
    public static final ImageID ZERO_DIAL_BUTTON_PRESSED = new ImageID("service.gui.buttons.ZERO_DIAL_BUTTON_PRESSED");
    public static final ImageID ZERO_DIAL_BUTTON_ROLLOVER = new ImageID("service.gui.buttons.ZERO_DIAL_BUTTON_ROLLOVER");
    public static final ImageID DIEZ_DIAL_BUTTON = new ImageID("service.gui.buttons.DIEZ_DIAL_BUTTON");
    public static final ImageID DIEZ_DIAL_BUTTON_PRESSED = new ImageID("service.gui.buttons.DIEZ_DIAL_BUTTON_PRESSED");
    public static final ImageID DIEZ_DIAL_BUTTON_ROLLOVER = new ImageID("service.gui.buttons.DIEZ_DIAL_BUTTON_ROLLOVER");
    public static final ImageID DIAL_BUTTON = new ImageID("service.gui.buttons.DIAL_BUTTON");
    public static final ImageID ADD_TO_CALL_BUTTON = new ImageID("service.gui.buttons.ADD_TO_CALL_BUTTON");
    public static final ImageID HOLD_BUTTON = new ImageID("service.gui.buttons.HOLD_BUTTON");
    public static final ImageID MERGE_CALL_BUTTON = new ImageID("service.gui.buttons.MERGE_CALL_BUTTON");
    public static final ImageID HOLD_BUTTON_PRESSED = new ImageID("service.gui.buttons.HOLD_BUTTON_PRESSED");
    public static final ImageID HOLD_STATUS_ICON = new ImageID("service.gui.icons.HOLD_STATUS_ICON");
    public static final ImageID MUTE_STATUS_ICON = new ImageID("service.gui.icons.MUTE_STATUS_ICON");
    public static final ImageID MUTE_BUTTON = new ImageID("service.gui.buttons.MUTE_BUTTON");
    public static final ImageID RECORD_BUTTON = new ImageID("service.gui.buttons.RECORD_BUTTON");
    public static final ImageID RECORD_BUTTON_PRESSED = new ImageID("service.gui.buttons.RECORD_BUTTON_PRESSED");
    public static final ImageID LOCAL_VIDEO_BUTTON = new ImageID("service.gui.buttons.LOCAL_VIDEO_BUTTON");
    public static final ImageID LOCAL_VIDEO_BUTTON_PRESSED = new ImageID("service.gui.buttons.LOCAL_VIDEO_BUTTON_PRESSED");
    public static final ImageID SHOW_LOCAL_VIDEO_BUTTON = new ImageID("service.gui.buttons.SHOW_LOCAL_VIDEO_BUTTON");
    public static final ImageID SHOW_LOCAL_VIDEO_BUTTON_PRESSED = new ImageID("service.gui.buttons.SHOW_LOCAL_VIDEO_BUTTON_PRESSED");
    public static final ImageID SHOW_HIDE_PEERS_BUTTON = new ImageID("service.gui.buttons.SHOW_HIDE_PEERS_BUTTON");
    public static final ImageID SHOW_HIDE_PEERS_BUTTON_PRESSED = new ImageID("service.gui.buttons.SHOW_HIDE_PEERS_BUTTON_PRESSED");
    public static final ImageID HD_VIDEO_BUTTON = new ImageID("service.gui.buttons.HD_VIDEO_BUTTON");
    public static final ImageID SD_VIDEO_BUTTON = new ImageID("service.gui.buttons.SD_VIDEO_BUTTON");
    public static final ImageID LO_VIDEO_BUTTON = new ImageID("service.gui.buttons.LO_VIDEO_BUTTON");
    public static final ImageID TRANSFER_CALL_BUTTON = new ImageID("service.gui.buttons.TRANSFER_CALL_BUTTON");
    public static final ImageID PARK_CALL_BUTTON = new ImageID("service.gui.buttons.PARK_CALL_BUTTON");
    public static final ImageID SECURE_BUTTON_ON = new ImageID("service.gui.buttons.SECURE_BUTTON_ON");
    public static final ImageID SECURE_BUTTON_OFF = new ImageID("service.gui.buttons.SECURE_BUTTON_OFF");
    public static final ImageID SECURE_BUTTON_PENDING = new ImageID("service.gui.buttons.SECURE_BUTTON_PENDING");
    public static final ImageID SECURE_OFF_CONF_CALL = new ImageID("service.gui.buttons.SECURE_OFF_CONF_CALL");
    public static final ImageID SECURE_AUDIO_ON = new ImageID("service.gui.buttons.SECURE_AUDIO_ON");
    public static final ImageID SECURE_AUDIO_OFF = new ImageID("service.gui.buttons.SECURE_AUDIO_OFF");
    public static final ImageID SECURE_VIDEO_ON = new ImageID("service.gui.buttons.SECURE_VIDEO_ON");
    public static final ImageID SECURE_VIDEO_OFF = new ImageID("service.gui.buttons.SECURE_VIDEO_OFF");
    public static final ImageID ENCR_VERIFIED = new ImageID("service.gui.buttons.ENCR_VERIFIED");
    public static final ImageID ENTER_FULL_SCREEN_BUTTON = new ImageID("service.gui.buttons.ENTER_FULL_SCREEN_BUTTON");
    public static final ImageID EXIT_FULL_SCREEN_BUTTON = new ImageID("service.gui.buttons.EXIT_FULL_SCREEN_BUTTON");
    public static final ImageID CALL_INFO = new ImageID("service.gui.buttons.CALL_INFO");
    public static final ImageID CRM = new ImageID("service.gui.buttons.CRM");
    public static final ImageID DEFAULT_USER_PHOTO = new ImageID("service.gui.DEFAULT_USER_PHOTO");
    public static final ImageID UNAUTHORIZED_CONTACT_PHOTO = new ImageID("service.gui.icons.UNAUTHORIZED_CONTACT_PHOTO");
    public static final ImageID UNAUTHORIZED_CONTACT_16x16 = new ImageID("service.gui.icons.UNAUTHORIZED_CONTACT_16x16");
    public static final ImageID ADD_TO_CHAT_ICON = new ImageID("service.gui.icons.ADD_TO_CHAT_ICON");
    public static final ImageID ADD_GROUP_ICON = new ImageID("service.gui.icons.ADD_GROUP_ICON");
    public static final ImageID RENAME_DIALOG_ICON = new ImageID("service.gui.icons.RENAME_DIALOG_ICON");
    public static final ImageID BROWSER_ICON = new ImageID("service.gui.icons.BROWSER_ICON");
    public static final ImageID AUTHORIZATION_ICON = new ImageID("service.gui.icons.AUTHORIZATION_ICON");
    public static final ImageID MOVE_CONTACT_ICON = new ImageID("service.gui.icons.MOVE_CONTACT");
    public static final ImageID MOVE_TO_GROUP_16x16_ICON = new ImageID("service.gui.icons.MOVE_TO_GROUP_16x16_ICON");
    public static final ImageID EXCLAMATION_MARK = new ImageID("service.gui.icons.EXCLAMATION_MARK");
    public static final ImageID OPENED_GROUP_ICON = new ImageID("service.gui.icons.OPENED_GROUP");
    public static final ImageID CLOSED_GROUP_ICON = new ImageID("service.gui.icons.CLOSED_GROUP");
    public static final ImageID CHAT_ROOM_OFFLINE_ICON = new ImageID("service.gui.icons.CHAT_ROOM_ICON");
    public static final ImageID CHAT_ROOM_MENU_ICON = new ImageID("service.gui.icons.CHAT_ROOM_16x16_ICON");
    public static final ImageID CHAT_ROOM_ONLINE_ICON = new ImageID("service.gui.icons.CHAT_ROOM_JOINED_ICON");
    public static final ImageID CHAT_SERVER_16x16_ICON = new ImageID("service.gui.icons.CHAT_SERVER_16x16_ICON");
    public static final ImageID MESSAGE_RECEIVED_ICON = new ImageID("service.gui.icons.MESSAGE_RECEIVED_ICON");
    public static final ImageID JOIN_ICON = new ImageID("service.gui.icons.JOIN_ICON");
    public static final ImageID JOIN_AS_ICON = new ImageID("service.gui.icons.JOIN_AS_ICON");
    public static final ImageID MSG_SRC_CONTACT_ONLINE_ICON = new ImageID("service.gui.icons.SMS_STATUS_ICON");
    public static final ImageID LEAVE_ICON = new ImageID("service.gui.icons.LEAVE_ICON");
    public static final ImageID REMOVE_CHAT_ICON = new ImageID("service.gui.icons.REMOVE_CHAT_ICON");
    public static final ImageID DIAL_BUTTON_BG = new ImageID("service.gui.buttons.DIAL_BUTTON_BG");
    public static final ImageID MENU_BACKGROUND = new ImageID("service.gui.MENU_BACKGROUND");
    public static final ImageID WINDOW_TITLE_BAR = new ImageID("service.gui.WINDOW_TITLE_BAR");
    public static final ImageID WINDOW_TITLE_BAR_BG = new ImageID("service.gui.WINDOW_TITLE_BAR_BG");
    public static final ImageID DEFAULT_FILE_ICON = new ImageID("service.gui.icons.DEFAULT_FILE_ICON");
    public static final ImageID CALL_PEER_TOOLS = new ImageID("service.gui.buttons.CALL_PEER_TOOLS");
    public static final ImageID CHAT_ROOM_CONFIG = new ImageID("service.gui.buttons.CHAT_ROOM_CONFIG");
    public static final ImageID CHAT_ROOM_MEMBERS_LIST_CONFIG = new ImageID("service.gui.buttons.CHAT_ROOM_MEMBERS_LIST_CONFIG");
    public static final ImageID VIDEO_CALL = new ImageID("service.gui.icons.VIDEO_CALL_16x16_ICON");
    public static final ImageID DESKTOP_SHARING = new ImageID("service.gui.icons.DESKTOP_SHARING_16x16_ICON");
    public static final ImageID REGION_DESKTOP_SHARING = new ImageID("service.gui.icons.REGION_SHARING_16x16_ICON");
    public static final ImageID VOLUME_CONTROL_BUTTON = new ImageID("service.gui.buttons.VOLUME_CONTROL");
    public static final ImageID CONTACT_LIST_DIAL_BUTTON = new ImageID("service.gui.buttons.CONTACT_LIST_DIAL_BUTTON");
    public static final ImageID DIAL_PAD_CALL_BUTTON_BG = new ImageID("service.gui.buttons.DIAL_PAD_CALL_BUTTON_BG");
    public static final ImageID CONFERENCE_VIDEO_INDICATOR = new ImageID("service.gui.icons.CONFERENCE_VIDEO_INDICATOR");
    public static final ImageID ADD_CONTACT_CHAT_ICON = new ImageID("service.gui.icons.ADD_CONTACT_CHAT_ICON");
    public static final ImageID INVITE_DIALOG_ICON = new ImageID("service.gui.icons.INVITE_DIALOG_ICON");
    public static final ImageID CLOSE_VIDEO = new ImageID("service.gui.buttons.CLOSE_VIDEO");
    public static final ImageID CHAT_TOOLBAR_BUTTON_BG = new ImageID("MSG_TOOLBAR_BUTTON_BG");
    public static final ImageID COPY_ICON = new ImageID("service.gui.icons.COPY_ICON");
    public static final ImageID CUT_ICON = new ImageID("service.gui.icons.CUT_ICON");
    public static final ImageID PASTE_ICON = new ImageID("service.gui.icons.PASTE_ICON");
    public static final ImageID SMILIES_ICON = new ImageID("service.gui.icons.SMILIES_ICON");
    public static final ImageID CLOSE_ICON = new ImageID("service.gui.icons.CLOSE_ICON");
    public static final ImageID PREVIOUS_ICON = new ImageID("service.gui.icons.PREVIOUS_ICON");
    public static final ImageID NEXT_ICON = new ImageID("service.gui.icons.NEXT_ICON");
    public static final ImageID HISTORY_ICON = new ImageID("service.gui.icons.HISTORY_ICON");
    public static final ImageID HISTORY_ICON_ON = new ImageID("service.gui.icons.HISTORY_ICON_ON");
    public static final ImageID HISTORY_ICON_OFF = new ImageID("service.gui.icons.HISTORY_ICON_OFF");
    public static final ImageID SEND_FILE_ICON = new ImageID("service.gui.icons.SEND_FILE_ICON");
    public static final ImageID FONT_ICON = new ImageID("service.gui.icons.FONT_ICON");
    public static final ImageID CONFERENCE_ICON = new ImageID("service.gui.icons.CONFERENCE_CALL");
    public static final ImageID CHAT_CONFIGURE_ICON = new ImageID("service.gui.icons.CHAT_CONFIGURE_ICON");
    public static final ImageID SEND_MESSAGE_16x16_ICON = new ImageID("service.gui.icons.SEND_MESSAGE_16x16_ICON");
    public static final ImageID CALL_16x16_ICON = new ImageID("service.gui.icons.CALL_16x16_ICON");
    public static final ImageID DELETE_16x16_ICON = new ImageID("service.gui.icons.DELETE_16x16_ICON");
    public static final ImageID HISTORY_16x16_ICON = new ImageID("service.gui.icons.HISTORY_16x16_ICON");
    public static final ImageID SEND_FILE_16x16_ICON = new ImageID("service.gui.icons.SEND_FILE_16x16_ICON");
    public static final ImageID GROUPS_16x16_ICON = new ImageID("service.gui.icons.GROUPS_16x16_ICON");
    public static final ImageID ADD_CONTACT_16x16_ICON = new ImageID("service.gui.icons.ADD_CONTACT_16x16_ICON");
    public static final ImageID QUIT_16x16_ICON = new ImageID("service.gui.icons.QUIT_16x16_ICON");
    public static final ImageID RENAME_16x16_ICON = new ImageID("service.gui.icons.RENAME_16x16_ICON");
    public static final ImageID CHAT_ROOM_REVOKE_VOICE = new ImageID("service.gui.icons.CHAT_ROOM_REVOKE_VOICE");
    public static final ImageID TOOLBAR_DRAG_ICON = new ImageID("service.gui.icons.TOOLBAR_DRAG_ICON");
    public static final ImageID SEARCH_ICON = new ImageID("service.gui.icons.SEARCH_ICON");
    public static final ImageID SEARCH_ICON_16x16 = new ImageID("service.gui.icons.SEARCH_ICON_16x16");
    public static final ImageID USER_ONLINE_ICON = new ImageID("service.gui.statusicons.USER_ONLINE_ICON");
    public static final ImageID USER_OFFLINE_ICON = new ImageID("service.gui.statusicons.USER_OFFLINE_ICON");
    public static final ImageID USER_AWAY_ICON = new ImageID("service.gui.statusicons.USER_AWAY_ICON");
    public static final ImageID USER_EXTENDED_AWAY_ICON = new ImageID("service.gui.statusicons.USER_EXTENDED_AWAY_ICON");
    public static final ImageID USER_FFC_ICON = new ImageID("service.gui.statusicons.USER_FFC_ICON");
    public static final ImageID USER_DND_ICON = new ImageID("service.gui.statusicons.USER_DND_ICON");
    public static final ImageID USER_USER_ON_THE_PHONE_ICON = new ImageID("service.gui.statusicons.USER_ON_THE_PHONE_ICON");
    public static final ImageID USER_USER_IN_A_MEETING_ICON = new ImageID("service.gui.statusicons.USER_IN_MEETING_ICON");
    public static final ImageID CHAT_BUTTON_ONLINE_ICON = new ImageID("service.gui.buttons.CHAT_BUTTON_ONLINE_ICON");
    public static final ImageID CHAT_BUTTON_OFFLINE_ICON = new ImageID("service.gui.buttons.CHAT_BUTTON_OFFLINE_ICON");
    public static final ImageID CHAT_BUTTON_AWAY_ICON = new ImageID("service.gui.buttons.CHAT_BUTTON_AWAY_ICON");
    public static final ImageID CHAT_BUTTON_EXTENDED_AWAY_ICON = new ImageID("service.gui.buttons.CHAT_BUTTON_EXTENDED_AWAY_ICON");
    public static final ImageID CHAT_BUTTON_FFC_ICON = new ImageID("service.gui.buttons.CHAT_BUTTON_FFC_ICON");
    public static final ImageID CHAT_BUTTON_DND_ICON = new ImageID("service.gui.buttons.CHAT_BUTTON_DND_ICON");
    public static final ImageID CHAT_BUTTON_ON_THE_PHONE_ICON = new ImageID("service.gui.buttons.CHAT_BUTTON_ON_THE_PHONE_ICON");
    public static final ImageID CHATROOM_MEMBER_OWNER = new ImageID("service.gui.icons.CHATROOM_MEMBER_OWNER");
    public static final ImageID CHATROOM_MEMBER_ADMIN = new ImageID("service.gui.icons.CHATROOM_MEMBER_ADMIN");
    public static final ImageID CHATROOM_MEMBER_MODERATOR = new ImageID("service.gui.icons.CHATROOM_MEMBER_MODERATOR");
    public static final ImageID CHATROOM_MEMBER_STANDARD = new ImageID("service.gui.icons.CHATROOM_MEMBER_STANDARD");
    public static final ImageID CHATROOM_MEMBER_GUEST = new ImageID("service.gui.icons.CHATROOM_MEMBER_GUEST");
    public static final ImageID CHATROOM_MEMBER_SILENT = new ImageID("service.gui.icons.CHATROOM_MEMBER_SILENT");
    public static final ImageID CHANGE_ROOM_SUBJECT_ICON_16x16 = new ImageID("service.gui.icons.CHANGE_ROOM_SUBJECT_16x16");
    public static final ImageID CHANGE_NICKNAME_ICON_16x16 = new ImageID("service.gui.icons.CHANGE_NICKNAME_16x16");
    public static final ImageID CHANGE_NICKNAME_ICON = new ImageID("service.gui.icons.CHANGE_NICKNAME");
    public static final ImageID BAN_ICON_16x16 = new ImageID("service.gui.icons.BAN_16x16");
    public static final ImageID KICK_ICON_16x16 = new ImageID("service.gui.icons.KICK_16x16");
    public static final ImageID MICROPHONE = new ImageID("service.gui.soundlevel.MICROPHONE");
    public static final ImageID HEADPHONE = new ImageID("service.gui.soundlevel.HEADPHONE");
    public static final ImageID SOUND_SETTING_BUTTON_BG = new ImageID("service.gui.soundlevel.SOUND_SETTING_BUTTON_BG");
    public static final ImageID SOUND_SETTING_BUTTON_PRESSED = new ImageID("service.gui.soundlevel.SOUND_SETTING_BUTTON_PRESSED");
    public static final ImageID AUTO_ANSWER_CHECK = new ImageID("service.gui.icons.AUTO_ANSWER_CHECK");

    private static ImageLoaderServiceImpl getImageLoaderService() {
        if (imageLoaderService == null) {
            imageLoaderService = (ImageLoaderServiceImpl)ServiceUtils.getService((BundleContext)GuiActivator.bundleContext, ImageLoaderService.class);
        }
        return imageLoaderService;
    }

    public static BufferedImage getImage(ImageID imageID) {
        return ImageLoader.getImageLoaderService().getImage(imageID);
    }

    public static String getImageUri(ImageID imageID) {
        block3: {
            URL imageURL = GuiActivator.getResources().getImageURL(imageID.getId());
            try {
                if (imageURL != null) {
                    return imageURL.toURI().toString();
                }
            }
            catch (URISyntaxException e) {
                if (!logger.isDebugEnabled()) break block3;
                logger.debug((Object)"Unable to parse image URL to URI.", (Throwable)e);
            }
        }
        return null;
    }

    public static ImageIcon getAccountStatusImage(ProtocolProviderService pps) {
        Image statusImage;
        byte[] protocolStatusIcon;
        OperationSetPresence presence = (OperationSetPresence)pps.getOperationSet(OperationSetPresence.class);
        byte[] byArray = protocolStatusIcon = presence == null ? null : presence.getPresenceStatus().getStatusIcon();
        if (presence != null && protocolStatusIcon != null) {
            statusImage = ImageUtils.getBytesInImage((byte[])protocolStatusIcon);
        } else {
            byte[] bytes = pps.getProtocolIcon().getIcon("IconSize16x16");
            Image image = statusImage = bytes == null ? null : ImageUtils.getBytesInImage((byte[])bytes);
            if (!pps.isRegistered() && statusImage != null) {
                statusImage = LightGrayFilter.createDisabledImage((Image)statusImage);
            }
        }
        return statusImage == null ? null : new ImageIcon(ImageLoader.getIndexedProtocolImage(statusImage, pps));
    }

    public static ImageIcon getIndexedProtocolIcon(Image image, ProtocolProviderService pps) {
        return new ImageIcon(ImageLoader.getIndexedProtocolImage(image, pps));
    }

    public static Image getIndexedProtocolImage(Image image, ProtocolProviderService pps) {
        Image badged;
        int index = GuiActivator.getUIService().getMainFrame().getProviderIndex(pps);
        if (index > 0) {
            BufferedImage buffImage = new BufferedImage(22, 16, 2);
            Graphics2D g = (Graphics2D)buffImage.getGraphics();
            AntialiasingManager.activateAntialiasing((Graphics)g);
            g.setColor(Color.DARK_GRAY);
            g.setFont(Constants.FONT.deriveFont(1, 9.0f));
            g.drawImage(image, 0, 0, null);
            g.setComposite(AlphaComposite.getInstance(3));
            g.drawString(Integer.toString(index + 1), 14, 8);
            badged = buffImage;
        } else {
            badged = image;
        }
        return badged;
    }

    public static Image getImage(Image bgImage, Image topImage, int x, int y) {
        int width = x + topImage.getWidth(null) > bgImage.getWidth(null) ? x + topImage.getWidth(null) : bgImage.getWidth(null);
        int height = y + topImage.getHeight(null) > bgImage.getHeight(null) ? y + topImage.getHeight(null) : bgImage.getHeight(null);
        BufferedImage buffImage = new BufferedImage(width, height, 2);
        Graphics2D g = (Graphics2D)buffImage.getGraphics();
        AntialiasingManager.activateAntialiasing((Graphics)g);
        g.drawImage(bgImage, 0, 0, null);
        g.drawImage(topImage, x, y, null);
        return buffImage;
    }

    public static Image getImage(Image bgImage, String text, Component c) {
        BufferedImage buffImage = new BufferedImage(bgImage.getWidth(c), bgImage.getHeight(c), 2);
        Graphics2D g = (Graphics2D)buffImage.getGraphics();
        AntialiasingManager.activateAntialiasing((Graphics)g);
        g.setColor(Color.WHITE);
        g.setFont(c.getFont().deriveFont(1, 9.0f));
        g.drawImage(bgImage, 0, 0, null);
        FontMetrics fontMetrics = g.getFontMetrics();
        int fontHeight = fontMetrics.getHeight();
        int textWidth = fontMetrics.stringWidth(text);
        g.drawString(text, (bgImage.getWidth(null) - textWidth) / 2 + 1, (bgImage.getHeight(null) - fontHeight) / 2 + fontHeight - 3);
        return buffImage;
    }

    public static ImageIcon getImageForPath(String imagePath) {
        InputStream is = null;
        try {
            is = new URL(imagePath).openStream();
        }
        catch (Exception exception) {
            // empty catch block
        }
        if (is == null) {
            is = GuiActivator.getResources().getImageInputStreamForPath(imagePath);
        }
        if (is == null) {
            return null;
        }
        byte[] icon = null;
        try {
            icon = new byte[is.available()];
            is.read(icon);
        }
        catch (IOException e) {
            logger.error((Object)("Failed to load icon: " + imagePath), (Throwable)e);
        }
        return new ImageIcon(icon);
    }

    public static void clearCache() {
        ImageLoader.getImageLoaderService().clearCache();
    }
}

