/*
 * Decompiled with CFR 0.152.
 */
package net.java.sip.communicator.impl.gui.main.chat.conference;

import java.util.Collection;
import java.util.Date;
import java.util.Iterator;
import java.util.List;
import javax.swing.ImageIcon;
import javax.swing.SwingUtilities;
import net.java.sip.communicator.impl.gui.GuiActivator;
import net.java.sip.communicator.impl.gui.main.chat.ChatContact;
import net.java.sip.communicator.impl.gui.main.chat.ChatSession;
import net.java.sip.communicator.impl.gui.main.chat.ChatSessionRenderer;
import net.java.sip.communicator.impl.gui.main.chat.ChatTransport;
import net.java.sip.communicator.impl.gui.main.chat.conference.ConferenceChatContact;
import net.java.sip.communicator.impl.gui.main.chat.conference.ConferenceChatTransport;
import net.java.sip.communicator.service.metahistory.MetaHistoryService;
import net.java.sip.communicator.service.muc.ChatRoomWrapper;
import net.java.sip.communicator.service.muc.MUCService;
import net.java.sip.communicator.service.protocol.ChatRoom;
import net.java.sip.communicator.service.protocol.ChatRoomConfigurationForm;
import net.java.sip.communicator.service.protocol.ChatRoomMember;
import net.java.sip.communicator.service.protocol.ConferenceDescription;
import net.java.sip.communicator.service.protocol.OperationFailedException;
import net.java.sip.communicator.service.protocol.event.ChatRoomConferencePublishedEvent;
import net.java.sip.communicator.service.protocol.event.ChatRoomConferencePublishedListener;
import net.java.sip.communicator.service.protocol.event.ChatRoomLocalUserRoleListener;
import net.java.sip.communicator.service.protocol.event.ChatRoomMemberPresenceChangeEvent;
import net.java.sip.communicator.service.protocol.event.ChatRoomMemberPresenceListener;
import net.java.sip.communicator.service.protocol.event.ChatRoomMemberRoleListener;
import net.java.sip.communicator.service.protocol.event.ChatRoomPropertyChangeEvent;
import net.java.sip.communicator.service.protocol.event.ChatRoomPropertyChangeFailedEvent;
import net.java.sip.communicator.service.protocol.event.ChatRoomPropertyChangeListener;
import net.java.sip.communicator.service.protocol.event.MessageDeliveredEvent;
import net.java.sip.communicator.service.protocol.event.MessageReceivedEvent;
import net.java.sip.communicator.service.protocol.globalstatus.GlobalStatusEnum;
import net.java.sip.communicator.util.ConfigurationUtils;

public class ConferenceChatSession
extends ChatSession
implements ChatRoomMemberPresenceListener,
ChatRoomPropertyChangeListener,
ChatRoomConferencePublishedListener {
    private ChatTransport currentChatTransport;
    private final ChatRoomWrapper chatRoomWrapper;
    private final ChatSessionRenderer sessionRenderer;

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public ConferenceChatSession(ChatSessionRenderer sessionRenderer, ChatRoomWrapper chatRoomWrapper) {
        this.sessionRenderer = sessionRenderer;
        this.chatRoomWrapper = chatRoomWrapper;
        this.currentChatTransport = new ConferenceChatTransport(this, chatRoomWrapper.getChatRoom());
        this.chatTransports.add(this.currentChatTransport);
        List list = this.chatParticipants;
        synchronized (list) {
            this.initChatParticipants();
        }
        ChatRoom chatRoom = chatRoomWrapper.getChatRoom();
        chatRoom.addMemberPresenceListener((ChatRoomMemberPresenceListener)this);
        chatRoom.addPropertyChangeListener((ChatRoomPropertyChangeListener)this);
        chatRoom.addConferencePublishedListener((ChatRoomConferencePublishedListener)this);
    }

    @Override
    public Object getDescriptor() {
        return this.chatRoomWrapper;
    }

    @Override
    public void dispose() {
        ChatRoom chatRoom = this.chatRoomWrapper.getChatRoom();
        chatRoom.removeMemberPresenceListener((ChatRoomMemberPresenceListener)this);
        chatRoom.removePropertyChangeListener((ChatRoomPropertyChangeListener)this);
        chatRoom.removeConferencePublishedListener((ChatRoomConferencePublishedListener)this);
        if (ConfigurationUtils.isLeaveChatRoomOnWindowCloseEnabled()) {
            chatRoom.leave();
        }
    }

    @Override
    public String getChatName() {
        return this.chatRoomWrapper.getChatRoomName();
    }

    public String getChatSubject() {
        return this.chatRoomWrapper.getChatRoom().getSubject();
    }

    public ChatRoomConfigurationForm getChatConfigurationForm() throws OperationFailedException {
        return this.chatRoomWrapper.getChatRoom().getConfigurationForm();
    }

    @Override
    public ChatTransport getCurrentChatTransport() {
        return this.currentChatTransport;
    }

    @Override
    public String getDefaultSmsNumber() {
        return null;
    }

    @Override
    public Collection<Object> getHistory(int count) {
        MetaHistoryService metaHistory = GuiActivator.getMetaHistoryService();
        if (metaHistory == null) {
            return null;
        }
        return metaHistory.findLast(this.chatHistoryFilter, (Object)this.chatRoomWrapper.getChatRoom(), ConfigurationUtils.getChatHistorySize());
    }

    @Override
    public Collection<Object> getHistoryBeforeDate(Date date, int count) {
        MetaHistoryService metaHistory = GuiActivator.getMetaHistoryService();
        if (metaHistory == null) {
            return null;
        }
        return metaHistory.findLastMessagesBefore(this.chatHistoryFilter, (Object)this.chatRoomWrapper.getChatRoom(), date, count);
    }

    @Override
    public Collection<Object> getHistoryAfterDate(Date date, int count) {
        MetaHistoryService metaHistory = GuiActivator.getMetaHistoryService();
        if (metaHistory == null) {
            return null;
        }
        return metaHistory.findFirstMessagesAfter(this.chatHistoryFilter, (Object)this.chatRoomWrapper.getChatRoom(), date, ConfigurationUtils.getChatHistorySize());
    }

    @Override
    public Date getHistoryStartDate() {
        MetaHistoryService metaHistory = GuiActivator.getMetaHistoryService();
        if (metaHistory == null) {
            return new Date(0L);
        }
        Date startHistoryDate = new Date(0L);
        Collection firstMessage = metaHistory.findFirstMessagesAfter(this.chatHistoryFilter, (Object)this.chatRoomWrapper.getChatRoom(), new Date(0L), 1);
        if (firstMessage.size() > 0) {
            Iterator i = firstMessage.iterator();
            Object o = i.next();
            if (o instanceof MessageDeliveredEvent) {
                MessageDeliveredEvent evt = (MessageDeliveredEvent)o;
                startHistoryDate = evt.getTimestamp();
            } else if (o instanceof MessageReceivedEvent) {
                MessageReceivedEvent evt = (MessageReceivedEvent)o;
                startHistoryDate = evt.getTimestamp();
            }
        }
        return startHistoryDate;
    }

    @Override
    public Date getHistoryEndDate() {
        MetaHistoryService metaHistory = GuiActivator.getMetaHistoryService();
        if (metaHistory == null) {
            return new Date(0L);
        }
        Date endHistoryDate = new Date(0L);
        Collection lastMessage = metaHistory.findLastMessagesBefore(this.chatHistoryFilter, (Object)this.chatRoomWrapper.getChatRoom(), new Date(Long.MAX_VALUE), 1);
        if (lastMessage.size() > 0) {
            Iterator i1 = lastMessage.iterator();
            Object o1 = i1.next();
            if (o1 instanceof MessageDeliveredEvent) {
                MessageDeliveredEvent evt = (MessageDeliveredEvent)o1;
                endHistoryDate = evt.getTimestamp();
            } else if (o1 instanceof MessageReceivedEvent) {
                MessageReceivedEvent evt = (MessageReceivedEvent)o1;
                endHistoryDate = evt.getTimestamp();
            }
        }
        return endHistoryDate;
    }

    @Override
    public void setCurrentChatTransport(ChatTransport chatTransport) {
        this.currentChatTransport = chatTransport;
        this.fireCurrentChatTransportChange();
    }

    @Override
    public void setDefaultSmsNumber(String smsPhoneNumber) {
    }

    @Override
    public ChatSessionRenderer getChatSessionRenderer() {
        return this.sessionRenderer;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void memberPresenceChanged(final ChatRoomMemberPresenceChangeEvent evt) {
        if (!SwingUtilities.isEventDispatchThread()) {
            SwingUtilities.invokeLater(new Runnable(){

                @Override
                public void run() {
                    ConferenceChatSession.this.memberPresenceChanged(evt);
                }
            });
            return;
        }
        ChatRoom sourceChatRoom = (ChatRoom)evt.getSource();
        if (!sourceChatRoom.equals(this.chatRoomWrapper.getChatRoom())) {
            return;
        }
        String eventType = evt.getEventType();
        ChatRoomMember chatRoomMember = evt.getChatRoomMember();
        String statusMessage = null;
        if (eventType.equals("MemberJoined")) {
            ConferenceChatContact chatContact = new ConferenceChatContact(chatRoomMember);
            List list = this.chatParticipants;
            synchronized (list) {
                if (!this.chatParticipants.contains(chatContact)) {
                    this.chatParticipants.add(chatContact);
                }
                this.sessionRenderer.addChatContact(chatContact);
            }
            ChatRoom room = this.chatRoomWrapper.getChatRoom();
            if (room != null) {
                room.updatePrivateContactPresenceStatus(chatRoomMember.getName());
            }
            if (!evt.isReasonUserList()) {
                statusMessage = GuiActivator.getResources().getI18NString("service.gui.CHAT_ROOM_USER_JOINED", new String[]{sourceChatRoom.getName()});
                this.sessionRenderer.updateChatContactStatus(chatContact, statusMessage);
            }
        } else if (eventType.equals("MemberLeft") || eventType.equals("MemberKicked") || eventType.equals("MemberQuit")) {
            if (eventType.equals("MemberLeft")) {
                statusMessage = GuiActivator.getResources().getI18NString("service.gui.CHAT_ROOM_USER_LEFT", new String[]{sourceChatRoom.getName()});
            } else if (eventType.equals("MemberKicked")) {
                statusMessage = GuiActivator.getResources().getI18NString("service.gui.CHAT_ROOM_USER_KICKED", new String[]{sourceChatRoom.getName()});
            } else if (eventType.equals("MemberQuit")) {
                statusMessage = GuiActivator.getResources().getI18NString("service.gui.CHAT_ROOM_USER_QUIT", new String[]{sourceChatRoom.getName()});
            }
            ChatContact contact = null;
            for (ChatContact chatContact : this.chatParticipants) {
                if (!chatContact.getDescriptor().equals(chatRoomMember)) continue;
                contact = chatContact;
                this.sessionRenderer.updateChatContactStatus(chatContact, statusMessage);
                this.sessionRenderer.removeChatContact(chatContact);
                ChatRoom room = this.chatRoomWrapper.getChatRoom();
                if (room == null) break;
                room.updatePrivateContactPresenceStatus(chatRoomMember.getName());
                break;
            }
            if (contact != null) {
                List list = this.chatParticipants;
                synchronized (list) {
                    this.chatParticipants.remove(contact);
                }
            }
        }
    }

    public void chatRoomPropertyChangeFailed(ChatRoomPropertyChangeFailedEvent event) {
    }

    public void chatRoomPropertyChanged(ChatRoomPropertyChangeEvent evt) {
        if (evt.getPropertyName().equals("ChatRoomSubject")) {
            this.sessionRenderer.setChatSubject((String)evt.getNewValue());
        }
    }

    @Override
    public boolean isDescriptorPersistent() {
        return true;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void loadChatRoom(ChatRoom chatRoom) {
        this.currentChatTransport = new ConferenceChatTransport(this, this.chatRoomWrapper.getChatRoom());
        this.chatTransports.clear();
        this.chatTransports.add(this.currentChatTransport);
        List list = this.chatParticipants;
        synchronized (list) {
            this.sessionRenderer.removeAllChatContacts();
            this.chatParticipants.clear();
            for (ChatRoomMember member : chatRoom.getMembers()) {
                ConferenceChatContact contact = new ConferenceChatContact(member);
                this.chatParticipants.add(contact);
                this.sessionRenderer.addChatContact(contact);
            }
        }
        chatRoom.addPropertyChangeListener((ChatRoomPropertyChangeListener)this);
        chatRoom.addMemberPresenceListener((ChatRoomMemberPresenceListener)this);
        this.sessionRenderer.setChatSubject(chatRoom.getSubject());
    }

    @Override
    public ImageIcon getChatStatusIcon() {
        GlobalStatusEnum status = GlobalStatusEnum.OFFLINE;
        if (this.chatRoomWrapper.getChatRoom() != null && this.chatRoomWrapper.getChatRoom().isJoined()) {
            status = GlobalStatusEnum.ONLINE;
        }
        return new ImageIcon(status.getStatusIcon());
    }

    @Override
    public byte[] getChatAvatar() {
        return null;
    }

    private void initChatParticipants() {
        ChatRoom chatRoom = this.chatRoomWrapper.getChatRoom();
        if (chatRoom != null && chatRoom.isJoined()) {
            for (ChatRoomMember member : chatRoom.getMembers()) {
                this.chatParticipants.add(new ConferenceChatContact(member));
            }
        }
    }

    @Override
    public boolean isContactListSupported() {
        ChatRoom chatRoom = this.chatRoomWrapper.getChatRoom();
        return !chatRoom.isSystem() && !MUCService.isPrivate((ChatRoom)chatRoom);
    }

    public void addMemberRoleListener(ChatRoomMemberRoleListener l) {
        this.chatRoomWrapper.getChatRoom().addMemberRoleListener(l);
    }

    public void addLocalUserRoleListener(ChatRoomLocalUserRoleListener l) {
        this.chatRoomWrapper.getChatRoom().addLocalUserRoleListener(l);
    }

    public void removeMemberRoleListener(ChatRoomMemberRoleListener l) {
        this.chatRoomWrapper.getChatRoom().removeMemberRoleListener(l);
    }

    public void removeLocalUserRoleListener(ChatRoomLocalUserRoleListener l) {
        this.chatRoomWrapper.getChatRoom().removelocalUserRoleListener(l);
    }

    public void conferencePublished(final ChatRoomConferencePublishedEvent evt) {
        if (!SwingUtilities.isEventDispatchThread()) {
            SwingUtilities.invokeLater(new Runnable(){

                @Override
                public void run() {
                    ConferenceChatSession.this.conferencePublished(evt);
                }
            });
            return;
        }
        ChatRoom room = evt.getChatRoom();
        if (!room.equals(this.chatRoomWrapper.getChatRoom())) {
            return;
        }
        ConferenceDescription cd = evt.getConferenceDescription();
        if (evt.getType() == 0) {
            this.sessionRenderer.chatConferenceDescriptionSent(cd);
        } else if (evt.getType() == 1) {
            this.updateChatConferences(room, evt.getMember(), cd, room.getCachedConferenceDescriptionSize());
        }
    }

    private void updateChatConferences(ChatRoom chatRoom, ChatRoomMember chatRoomMember, ConferenceDescription cd, int activeConferencesCount) {
        boolean isAvailable = cd.isAvailable();
        for (ChatContact chatContact : this.chatParticipants) {
            if (!chatContact.getDescriptor().equals(chatRoomMember)) continue;
            this.sessionRenderer.updateChatContactStatus(chatContact, (isAvailable ? "published" : "removed") + " a conference " + cd);
            break;
        }
        if (isAvailable) {
            this.sessionRenderer.addChatConferenceCall(cd);
            if (activeConferencesCount == 1) {
                this.sessionRenderer.setConferencesPanelVisible(true);
            }
        } else {
            this.sessionRenderer.removeChatConferenceCall(cd);
            if (activeConferencesCount == 0) {
                this.sessionRenderer.setConferencesPanelVisible(false);
            }
        }
    }
}

