/*
 * Decompiled with CFR 0.152.
 */
package cx.ath.matthew.utils;

import java.io.PrintStream;

public class Hexdump {
    public static final char[] hexchars = new char[]{'0', '1', '2', '3', '4', '5', '6', '7', '8', '9', 'a', 'b', 'c', 'd', 'e', 'f'};

    public static String toHex(byte[] byArray) {
        return Hexdump.toHex(byArray, 0, byArray.length);
    }

    public static String toHex(byte[] byArray, int n, int n2) {
        StringBuffer stringBuffer = new StringBuffer();
        int n3 = n + n2;
        for (int i = n; i < n3; ++i) {
            if (i < byArray.length) {
                stringBuffer.append(hexchars[(byArray[i] & 0xF0) >> 4]);
                stringBuffer.append(hexchars[byArray[i] & 0xF]);
                stringBuffer.append(' ');
                continue;
            }
            stringBuffer.append(' ');
            stringBuffer.append(' ');
            stringBuffer.append(' ');
        }
        return stringBuffer.toString();
    }

    public static String toAscii(byte[] byArray) {
        return Hexdump.toAscii(byArray, 0, byArray.length);
    }

    public static String toAscii(byte[] byArray, int n, int n2) {
        StringBuffer stringBuffer = new StringBuffer();
        int n3 = n + n2;
        for (int i = n; i < n3; ++i) {
            if (i < byArray.length) {
                if (20 <= byArray[i] && 126 >= byArray[i]) {
                    stringBuffer.append((char)byArray[i]);
                    continue;
                }
                stringBuffer.append('.');
                continue;
            }
            stringBuffer.append(' ');
        }
        return stringBuffer.toString();
    }

    public static String format(byte[] byArray) {
        return Hexdump.format(byArray, 80);
    }

    public static String format(byte[] byArray, int n) {
        int n2 = (n - 8) / 4;
        int n3 = 0;
        StringBuffer stringBuffer = new StringBuffer();
        do {
            for (int i = 0; i < 6; ++i) {
                stringBuffer.append(hexchars[(n3 << i * 4 & 0xF00000) >> 20]);
            }
            stringBuffer.append('\t');
            stringBuffer.append(Hexdump.toHex(byArray, n3, n2));
            stringBuffer.append(' ');
            stringBuffer.append(Hexdump.toAscii(byArray, n3, n2));
            stringBuffer.append('\n');
        } while ((n3 += n2) < byArray.length);
        return stringBuffer.toString();
    }

    public static void print(byte[] byArray) {
        Hexdump.print(byArray, System.err);
    }

    public static void print(byte[] byArray, int n) {
        Hexdump.print(byArray, n, System.err);
    }

    public static void print(byte[] byArray, int n, PrintStream printStream) {
        printStream.print(Hexdump.format(byArray, n));
    }

    public static void print(byte[] byArray, PrintStream printStream) {
        printStream.print(Hexdump.format(byArray));
    }

    public static String toByteArray(byte[] byArray) {
        return Hexdump.toByteArray(byArray, 0, byArray.length);
    }

    public static String toByteArray(byte[] byArray, int n, int n2) {
        StringBuffer stringBuffer = new StringBuffer();
        for (int i = n; i < n2 && i < byArray.length; ++i) {
            stringBuffer.append('0');
            stringBuffer.append('x');
            stringBuffer.append(hexchars[(byArray[i] & 0xF0) >> 4]);
            stringBuffer.append(hexchars[byArray[i] & 0xF]);
            if (i + 1 >= n2 || i + 1 >= byArray.length) continue;
            stringBuffer.append(',');
        }
        return stringBuffer.toString();
    }
}

