/*
 * Decompiled with CFR 0.152.
 */
package net.java.sip.communicator.plugin.generalconfig;

import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.GridLayout;
import java.awt.LayoutManager;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.FocusEvent;
import java.awt.event.FocusListener;
import javax.swing.Box;
import javax.swing.JButton;
import javax.swing.JCheckBox;
import javax.swing.JComboBox;
import javax.swing.JLabel;
import javax.swing.JTextField;
import net.java.sip.communicator.plugin.desktoputil.SIPCommCheckBox;
import net.java.sip.communicator.plugin.desktoputil.TransparentPanel;
import net.java.sip.communicator.plugin.generalconfig.GeneralConfigPluginActivator;
import net.java.sip.communicator.plugin.generalconfig.Resources;
import org.jitsi.service.configuration.ConfigurationService;

public class OpusConfigForm
extends TransparentPanel
implements ActionListener {
    private static final String[] BANDWIDTHS = new String[]{"auto", "fb", "swb", "wb", "mb", "nb"};
    private static final String[] BANDWIDTHS_LONG = new String[]{"Auto", "Fullband (48kHz)", "Super-wideband (24kHz)", "Wideband (16kHz)", "Medium-band (12kHz)", "Narrowband (8kHz)"};
    private static final String BANDWIDTH_DEFAULT = "auto";
    private static final int BITRATE_DEFAULT = 32;
    private static final boolean DTX_DEFAULT = true;
    private static final boolean FEC_DEFAULT = true;
    private static final int MIN_EXPECTED_PL_DEFAULT = 1;
    private static final int COMPLEXITY_DEFAULT_INDEX = 0;
    private final JComboBox bandwidthCombobox = new JComboBox();
    private final JTextField bitrateField = new JTextField(6);
    private final JCheckBox dtxCheckbox = new SIPCommCheckBox();
    private final JCheckBox fecCheckbox = new SIPCommCheckBox();
    private final JTextField minExpectedPLField = new JTextField(3);
    private final JComboBox complexityCombobox = new JComboBox();
    private final ConfigurationService configurationService = GeneralConfigPluginActivator.getConfigurationService();
    private final JButton restoreButton = new JButton(Resources.getString("plugin.generalconfig.RESTORE"));

    public OpusConfigForm() {
        super((LayoutManager)new BorderLayout());
        Box box = Box.createVerticalBox();
        this.add(box, "North");
        TransparentPanel contentPanel = new TransparentPanel();
        contentPanel.setLayout((LayoutManager)new BorderLayout(10, 10));
        box.add((Component)contentPanel);
        TransparentPanel labelPanel = new TransparentPanel((LayoutManager)new GridLayout(0, 1, 2, 2));
        TransparentPanel valuePanel = new TransparentPanel((LayoutManager)new GridLayout(0, 1, 2, 2));
        TransparentPanel southPanel = new TransparentPanel((LayoutManager)new GridLayout(0, 1, 2, 2));
        contentPanel.add((Component)labelPanel, (Object)"West");
        contentPanel.add((Component)valuePanel, (Object)"Center");
        contentPanel.add((Component)southPanel, (Object)"South");
        labelPanel.add((Component)new JLabel(Resources.getString("plugin.generalconfig.OPUS_AUDIO_BANDWIDTH")));
        for (String str : BANDWIDTHS_LONG) {
            this.bandwidthCombobox.addItem(str);
        }
        this.bandwidthCombobox.setSelectedIndex(this.getBandwidthIndex(this.configurationService.getString("net.java.sip.communicator.impl.neomedia.codec.audio.opus.encoder.AUDIO_BANDWIDTH", BANDWIDTH_DEFAULT)));
        this.bandwidthCombobox.addActionListener(this);
        valuePanel.add((Component)this.bandwidthCombobox);
        labelPanel.add((Component)new JLabel(Resources.getString("plugin.generalconfig.OPUS_BITRATE")));
        this.bitrateField.setText(Integer.valueOf(this.configurationService.getInt("net.java.sip.communicator.impl.neomedia.codec.audio.opus.encoder.BITRATE", 32)).toString());
        this.bitrateField.addFocusListener(new FocusListener(){

            @Override
            public void focusGained(FocusEvent focusEvent) {
            }

            @Override
            public void focusLost(FocusEvent focusEvent) {
                OpusConfigForm.this.configurationService.setProperty("net.java.sip.communicator.impl.neomedia.codec.audio.opus.encoder.BITRATE", (Object)OpusConfigForm.this.bitrateField.getText());
            }
        });
        valuePanel.add((Component)this.bitrateField);
        labelPanel.add((Component)new JLabel(Resources.getString("plugin.generalconfig.OPUS_USE_DTX")));
        this.dtxCheckbox.setSelected(this.configurationService.getBoolean("net.java.sip.communicator.impl.neomedia.codec.audio.opus.encoder.DTX", true));
        this.dtxCheckbox.addActionListener(this);
        valuePanel.add((Component)this.dtxCheckbox);
        labelPanel.add((Component)new JLabel(Resources.getString("plugin.generalconfig.OPUS_USE_FEC")));
        this.fecCheckbox.setSelected(this.configurationService.getBoolean("net.java.sip.communicator.impl.neomedia.codec.audio.opus.encoder.FEC", true));
        this.fecCheckbox.addActionListener(this);
        valuePanel.add((Component)this.fecCheckbox);
        labelPanel.add((Component)new JLabel(Resources.getString("plugin.generalconfig.OPUS_MIN_EXPECTED_PACKET_LOSS")));
        this.minExpectedPLField.setText(this.configurationService.getString("net.java.sip.communicator.impl.neomedia.codec.audio.opus.encoder.MIN_EXPECTED_PACKET_LOSS", Integer.valueOf(1).toString()));
        this.minExpectedPLField.addFocusListener(new FocusListener(){

            @Override
            public void focusGained(FocusEvent focusEvent) {
            }

            @Override
            public void focusLost(FocusEvent focusEvent) {
                OpusConfigForm.this.configurationService.setProperty("net.java.sip.communicator.impl.neomedia.codec.audio.opus.encoder.MIN_EXPECTED_PACKET_LOSS", (Object)OpusConfigForm.this.minExpectedPLField.getText());
            }
        });
        valuePanel.add((Component)this.minExpectedPLField);
        labelPanel.add((Component)new JLabel(Resources.getString("plugin.generalconfig.OPUS_COMPLEXITY")));
        this.complexityCombobox.addItem("");
        for (int i = 10; i > 0; --i) {
            this.complexityCombobox.addItem(Integer.toString(i));
        }
        this.complexityCombobox.addActionListener(this);
        valuePanel.add((Component)this.complexityCombobox);
        this.restoreButton.addActionListener(this);
        southPanel.add((Component)this.restoreButton);
    }

    private void restoreDefaults() {
        this.bandwidthCombobox.setSelectedIndex(this.getBandwidthIndex(BANDWIDTH_DEFAULT));
        this.bitrateField.setText(Integer.valueOf(32).toString());
        this.configurationService.setProperty("net.java.sip.communicator.impl.neomedia.codec.audio.opus.encoder.BITRATE", (Object)32);
        this.dtxCheckbox.setSelected(true);
        this.configurationService.setProperty("net.java.sip.communicator.impl.neomedia.codec.audio.opus.encoder.DTX", (Object)true);
        this.fecCheckbox.setSelected(true);
        this.configurationService.setProperty("net.java.sip.communicator.impl.neomedia.codec.audio.opus.encoder.FEC", (Object)true);
        this.minExpectedPLField.setText(Integer.valueOf(1).toString());
        this.configurationService.setProperty("net.java.sip.communicator.impl.neomedia.codec.audio.opus.encoder.MIN_EXPECTED_PACKET_LOSS", (Object)1);
        this.complexityCombobox.setSelectedIndex(0);
        this.configurationService.removeProperty("net.java.sip.communicator.impl.neomedia.codec.audio.opus.encoder.COMPLEXITY");
    }

    @Override
    public void actionPerformed(ActionEvent actionEvent) {
        Object source = actionEvent.getSource();
        if (source == this.restoreButton) {
            this.restoreDefaults();
        } else if (source == this.bandwidthCombobox) {
            this.configurationService.setProperty("net.java.sip.communicator.impl.neomedia.codec.audio.opus.encoder.AUDIO_BANDWIDTH", (Object)BANDWIDTHS[this.bandwidthCombobox.getSelectedIndex()]);
        } else if (source == this.dtxCheckbox) {
            this.configurationService.setProperty("net.java.sip.communicator.impl.neomedia.codec.audio.opus.encoder.DTX", (Object)this.dtxCheckbox.isSelected());
        } else if (source == this.fecCheckbox) {
            this.configurationService.setProperty("net.java.sip.communicator.impl.neomedia.codec.audio.opus.encoder.FEC", (Object)this.fecCheckbox.isSelected());
        } else if (source == this.complexityCombobox) {
            String complexity;
            Object selectedItem = this.complexityCombobox.getSelectedItem();
            String string = complexity = selectedItem == null ? null : selectedItem.toString();
            if (complexity == null || complexity.length() == 0) {
                this.configurationService.removeProperty("net.java.sip.communicator.impl.neomedia.codec.audio.opus.encoder.COMPLEXITY");
            } else {
                this.configurationService.setProperty("net.java.sip.communicator.impl.neomedia.codec.audio.opus.encoder.COMPLEXITY", (Object)complexity);
            }
        }
    }

    private int getBandwidthIndex(String bandwidthShortName) {
        for (int i = 0; i < BANDWIDTHS.length; ++i) {
            if (!BANDWIDTHS[i].equals(bandwidthShortName)) continue;
            return i;
        }
        return -1;
    }
}

