/*
 * Decompiled with CFR 0.152.
 */
package net.java.sip.communicator.impl.protocol.irc;

import java.util.Collections;
import java.util.Hashtable;
import java.util.Iterator;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import net.java.sip.communicator.impl.protocol.irc.ChatRoomInvitationIrcImpl;
import net.java.sip.communicator.impl.protocol.irc.ChatRoomIrcImpl;
import net.java.sip.communicator.impl.protocol.irc.ChatRoomMemberIrcImpl;
import net.java.sip.communicator.impl.protocol.irc.IrcActivator;
import net.java.sip.communicator.impl.protocol.irc.IrcConnection;
import net.java.sip.communicator.impl.protocol.irc.IrcStatusEnum;
import net.java.sip.communicator.impl.protocol.irc.ProtocolProviderServiceIrcImpl;
import net.java.sip.communicator.service.gui.UIService;
import net.java.sip.communicator.service.muc.ChatRoomWrapper;
import net.java.sip.communicator.service.muc.MUCService;
import net.java.sip.communicator.service.protocol.AbstractOperationSetMultiUserChat;
import net.java.sip.communicator.service.protocol.ChatRoom;
import net.java.sip.communicator.service.protocol.ChatRoomInvitation;
import net.java.sip.communicator.service.protocol.ChatRoomMember;
import net.java.sip.communicator.service.protocol.ChatRoomMemberRole;
import net.java.sip.communicator.service.protocol.Contact;
import net.java.sip.communicator.service.protocol.OperationFailedException;
import net.java.sip.communicator.service.protocol.OperationNotSupportedException;

public class OperationSetMultiUserChatIrcImpl
extends AbstractOperationSetMultiUserChat {
    private ProtocolProviderServiceIrcImpl ircProvider = null;
    private final Map<String, ChatRoomIrcImpl> chatRoomCache = new Hashtable<String, ChatRoomIrcImpl>();
    private ChatRoomIrcImpl serverChatRoom;

    public OperationSetMultiUserChatIrcImpl(ProtocolProviderServiceIrcImpl provider) {
        this.ircProvider = provider;
    }

    public List<String> getExistingChatRooms() throws OperationFailedException {
        IrcConnection connection = this.ircProvider.getIrcStack().getConnection();
        if (connection == null) {
            throw new IllegalStateException("Connection is not available.");
        }
        return connection.getServerChannelLister().getList();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public List<ChatRoom> getCurrentlyJoinedChatRooms() {
        Map<String, ChatRoomIrcImpl> map = this.chatRoomCache;
        synchronized (map) {
            LinkedList<ChatRoomIrcImpl> joinedRooms = new LinkedList<ChatRoomIrcImpl>(this.chatRoomCache.values());
            Iterator joinedRoomsIter = joinedRooms.iterator();
            while (joinedRoomsIter.hasNext()) {
                if (((ChatRoom)joinedRoomsIter.next()).isJoined()) continue;
                joinedRoomsIter.remove();
            }
            return joinedRooms;
        }
    }

    public List<String> getCurrentlyJoinedChatRooms(ChatRoomMember chatRoomMember) {
        return Collections.emptyList();
    }

    public ChatRoom createChatRoom(String roomName, Map<String, Object> roomProperties) throws OperationFailedException, OperationNotSupportedException {
        try {
            return this.findOrCreateRoom(roomName);
        }
        catch (IllegalArgumentException e) {
            String message = IrcActivator.getResources().getI18NString("service.gui.CREATE_CHAT_ROOM_ERROR", new String[]{roomName});
            throw new OperationFailedException(message, 11, (Throwable)e);
        }
    }

    public ChatRoomIrcImpl findRoom(String roomName) {
        return this.chatRoomCache.get(roomName);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public ChatRoomIrcImpl findOrCreateRoom(String roomName) {
        Map<String, ChatRoomIrcImpl> map = this.chatRoomCache;
        synchronized (map) {
            ChatRoomIrcImpl room = this.chatRoomCache.get(roomName);
            if (room == null) {
                room = this.createLocalChatRoomInstance(roomName);
            }
            return room;
        }
    }

    public void rejectInvitation(ChatRoomInvitation invitation, String reason) {
    }

    public boolean isMultiChatSupportedByContact(Contact contact) {
        return true;
    }

    protected ChatRoomIrcImpl getChatRoom(String chatRoomName) {
        return this.chatRoomCache.get(chatRoomName);
    }

    private ChatRoomIrcImpl createLocalChatRoomInstance(String chatRoomName) {
        ChatRoomIrcImpl chatRoom = new ChatRoomIrcImpl(chatRoomName, this.ircProvider);
        this.chatRoomCache.put(chatRoom.getName(), chatRoom);
        return chatRoom;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void registerChatRoomInstance(ChatRoomIrcImpl chatroom) {
        Map<String, ChatRoomIrcImpl> map = this.chatRoomCache;
        synchronized (map) {
            this.chatRoomCache.put(chatroom.getIdentifier(), chatroom);
        }
    }

    protected void fireInvitationEvent(ChatRoom targetChatRoom, String inviter, String reason, byte[] password) {
        ChatRoomInvitationIrcImpl invitation = new ChatRoomInvitationIrcImpl(targetChatRoom, inviter, reason, password);
        this.fireInvitationReceived(invitation);
    }

    protected ChatRoomIrcImpl findSystemRoom() {
        if (this.serverChatRoom == null) {
            this.serverChatRoom = new ChatRoomIrcImpl(this.ircProvider.getAccountID().getService(), this.ircProvider, true);
            this.fireLocalUserPresenceEvent((ChatRoom)this.serverChatRoom, "LocalUserJoined", "Connected to the server.");
        }
        return this.serverChatRoom;
    }

    protected ChatRoomMemberIrcImpl findSystemMember() {
        if (this.serverChatRoom.getMembers().size() > 0) {
            return (ChatRoomMemberIrcImpl)this.serverChatRoom.getMembers().get(0);
        }
        return new ChatRoomMemberIrcImpl(this.ircProvider, (ChatRoom)this.serverChatRoom, this.ircProvider.getAccountID().getService(), "", this.ircProvider.getAccountID().getServerAddress(), ChatRoomMemberRole.GUEST, IrcStatusEnum.ONLINE);
    }

    public boolean isPrivateMessagingContact(String contactAddress) {
        return true;
    }

    void openChatRoomWindow(ChatRoomIrcImpl chatRoom) {
        MUCService mucService = IrcActivator.getMUCService();
        UIService uiService = IrcActivator.getUIService();
        ChatRoomWrapper wrapper = mucService.getChatRoomWrapperByChatRoom((ChatRoom)chatRoom, true);
        uiService.openChatRoomWindow(wrapper);
    }
}

