/*
 * Decompiled with CFR 0.152.
 */
package net.java.sip.communicator.plugin.certconfig;

import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.Container;
import java.awt.FlowLayout;
import java.awt.GridLayout;
import java.awt.LayoutManager;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.security.Security;
import javax.swing.BorderFactory;
import javax.swing.BoxLayout;
import javax.swing.ButtonGroup;
import javax.swing.JButton;
import javax.swing.JLabel;
import javax.swing.JRadioButton;
import javax.swing.JScrollPane;
import javax.swing.JTable;
import javax.swing.border.EmptyBorder;
import javax.swing.event.ListSelectionEvent;
import javax.swing.event.ListSelectionListener;
import net.java.sip.communicator.plugin.certconfig.CertConfigActivator;
import net.java.sip.communicator.plugin.certconfig.CertConfigEntryDialog;
import net.java.sip.communicator.plugin.certconfig.CertConfigTableModel;
import net.java.sip.communicator.plugin.desktoputil.SIPCommCheckBox;
import net.java.sip.communicator.plugin.desktoputil.SIPCommRadioButton;
import net.java.sip.communicator.plugin.desktoputil.TransparentPanel;
import net.java.sip.communicator.service.certificate.CertificateConfigEntry;
import net.java.sip.communicator.service.gui.ConfigurationForm;
import org.jitsi.service.resources.ResourceManagementService;
import org.jitsi.util.OSUtils;

public class CertConfigPanel
extends TransparentPanel
implements ConfigurationForm,
ActionListener,
ListSelectionListener {
    private static final long serialVersionUID = 2324122652952574574L;
    private ResourceManagementService R = CertConfigActivator.R;
    private CertConfigTableModel model = new CertConfigTableModel();
    private JButton cmdAdd;
    private JButton cmdRemove;
    private JButton cmdEdit;
    private JTable tblCertList;
    private JRadioButton rdoUseWindows;
    private JRadioButton rdoUseJava;
    private SIPCommCheckBox chkEnableRevocationCheck;
    private SIPCommCheckBox chkEnableOcsp;

    public CertConfigPanel() {
        this.initComponents();
        this.valueChanged(null);
    }

    private void initComponents() {
        this.setLayout(new BoxLayout((Container)((Object)this), 1));
        if (OSUtils.IS_WINDOWS) {
            TransparentPanel pnlCertConfig = new TransparentPanel((LayoutManager)new GridLayout(2, 1));
            pnlCertConfig.setBorder(BorderFactory.createTitledBorder(this.R.getI18NString("plugin.certconfig.TRUSTSTORE_CONFIG")));
            this.add((Component)pnlCertConfig);
            ButtonGroup grpTrustStore = new ButtonGroup();
            this.rdoUseJava = new SIPCommRadioButton();
            this.rdoUseJava.setText(this.R.getI18NString("plugin.certconfig.JAVA_TRUSTSTORE"));
            this.rdoUseJava.addActionListener(this);
            grpTrustStore.add(this.rdoUseJava);
            pnlCertConfig.add(this.rdoUseJava);
            this.rdoUseWindows = new SIPCommRadioButton();
            this.rdoUseWindows.setText(this.R.getI18NString("plugin.certconfig.WINDOWS_TRUSTSTORE"));
            this.rdoUseWindows.addActionListener(this);
            grpTrustStore.add(this.rdoUseWindows);
            pnlCertConfig.add(this.rdoUseWindows);
            if ("Windows-ROOT".equals(CertConfigActivator.getConfigService().getProperty("net.java.sip.communicator.service.cert.truststore.type"))) {
                this.rdoUseWindows.setSelected(true);
            } else {
                this.rdoUseJava.setSelected(true);
            }
        }
        TransparentPanel pnlRevocation = new TransparentPanel((LayoutManager)new GridLayout(2, 1));
        pnlRevocation.setBorder(BorderFactory.createTitledBorder(this.R.getI18NString("plugin.certconfig.REVOCATION_TITLE")));
        this.add((Component)pnlRevocation);
        this.chkEnableRevocationCheck = new SIPCommCheckBox(this.R.getI18NString("plugin.certconfig.REVOCATION_CHECK_ENABLED"));
        this.chkEnableRevocationCheck.addActionListener((ActionListener)this);
        this.chkEnableRevocationCheck.setSelected("true".equals(System.getProperty("com.sun.net.ssl.checkRevocation")));
        pnlRevocation.add((Component)this.chkEnableRevocationCheck);
        this.chkEnableOcsp = new SIPCommCheckBox(this.R.getI18NString("plugin.certconfig.REVOCATION_OCSP_ENABLED"));
        this.chkEnableOcsp.addActionListener((ActionListener)this);
        this.chkEnableOcsp.setSelected("true".equals(Security.getProperty("ocsp.enable")));
        this.chkEnableOcsp.setEnabled(this.chkEnableRevocationCheck.isSelected());
        pnlRevocation.add((Component)this.chkEnableOcsp);
        TransparentPanel pnlCertList = new TransparentPanel((LayoutManager)new BorderLayout());
        pnlCertList.setBorder(BorderFactory.createTitledBorder(this.R.getI18NString("plugin.certconfig.CERT_LIST_TITLE")));
        this.add((Component)pnlCertList);
        JLabel lblNote = new JLabel();
        lblNote.setText(this.R.getI18NString("plugin.certconfig.CERT_LIST_DESCRIPTION"));
        lblNote.setBorder(new EmptyBorder(7, 7, 7, 7));
        pnlCertList.add((Component)lblNote, "North");
        this.tblCertList = new JTable();
        this.tblCertList.setSelectionMode(0);
        this.tblCertList.getSelectionModel().addListSelectionListener(this);
        this.tblCertList.setModel(this.model);
        pnlCertList.add((Component)new JScrollPane(this.tblCertList), "Center");
        TransparentPanel buttons = new TransparentPanel();
        buttons.setLayout((LayoutManager)new FlowLayout(2));
        pnlCertList.add((Component)buttons, "South");
        this.cmdAdd = new JButton();
        this.cmdAdd.setText(this.R.getI18NString("service.gui.ADD"));
        this.cmdAdd.addActionListener(this);
        buttons.add((Component)this.cmdAdd);
        this.cmdRemove = new JButton();
        this.cmdRemove.setText(this.R.getI18NString("service.gui.REMOVE"));
        this.cmdRemove.addActionListener(this);
        buttons.add((Component)this.cmdRemove);
        this.cmdEdit = new JButton();
        this.cmdEdit.setText(this.R.getI18NString("service.gui.EDIT"));
        this.cmdEdit.addActionListener(this);
        buttons.add((Component)this.cmdEdit);
    }

    @Override
    public void valueChanged(ListSelectionEvent e) {
        int row = this.tblCertList.getSelectedRow();
        this.cmdRemove.setEnabled(row > -1);
        this.cmdEdit.setEnabled(row > -1);
    }

    @Override
    public void actionPerformed(ActionEvent e) {
        CertificateConfigEntry entry;
        CertificateConfigEntry newEntry;
        CertConfigEntryDialog dlg;
        if (e.getSource() == this.cmdAdd && (dlg = new CertConfigEntryDialog(newEntry = new CertificateConfigEntry())).showDialog()) {
            CertConfigActivator.getCertService().setClientAuthCertificateConfig(newEntry);
        }
        if (e.getSource() == this.cmdRemove) {
            CertConfigActivator.getCertService().removeClientAuthCertificateConfig(this.model.getItem(this.tblCertList.getSelectedRow()).getId());
        }
        if (e.getSource() == this.cmdEdit && (dlg = new CertConfigEntryDialog(entry = this.model.getItem(this.tblCertList.getSelectedRow()))).showDialog()) {
            CertConfigActivator.getCertService().setClientAuthCertificateConfig(entry);
        }
        if (e.getSource() == this.rdoUseJava) {
            CertConfigActivator.getConfigService().setProperty("net.java.sip.communicator.service.cert.truststore.type", (Object)"meta:default");
            CertConfigActivator.getConfigService().removeProperty("net.java.sip.communicator.service.cert.truststore.file");
            CertConfigActivator.getCredService().removePassword("net.java.sip.communicator.service.cert.truststore.password");
        }
        if (e.getSource() == this.rdoUseWindows) {
            CertConfigActivator.getConfigService().setProperty("net.java.sip.communicator.service.cert.truststore.type", (Object)"Windows-ROOT");
            CertConfigActivator.getConfigService().removeProperty("net.java.sip.communicator.service.cert.truststore.file");
            CertConfigActivator.getCredService().removePassword("net.java.sip.communicator.service.cert.truststore.password");
        }
        if (e.getSource() == this.chkEnableRevocationCheck) {
            CertConfigActivator.getConfigService().setProperty("net.java.sip.communicator.service.cert.revocation.enabled", (Object)this.chkEnableRevocationCheck.isSelected());
            String enabled = new Boolean(this.chkEnableRevocationCheck.isSelected()).toString();
            System.setProperty("com.sun.security.enableCRLDP", enabled);
            System.setProperty("com.sun.net.ssl.checkRevocation", enabled);
            this.chkEnableOcsp.setEnabled(this.chkEnableRevocationCheck.isSelected());
        }
        if (e.getSource() == this.chkEnableOcsp) {
            CertConfigActivator.getConfigService().setProperty("net.java.sip.communicator.service.cert.ocsp.enabled", (Object)this.chkEnableOcsp.isSelected());
            Security.setProperty("ocsp.enable", new Boolean(this.chkEnableOcsp.isSelected()).toString());
        }
    }

    public String getTitle() {
        return CertConfigActivator.R.getI18NString("plugin.certconfig.TITLE");
    }

    public byte[] getIcon() {
        return null;
    }

    public Object getForm() {
        return this;
    }

    public int getIndex() {
        return -1;
    }

    public boolean isAdvanced() {
        return true;
    }
}

