/*
 * Decompiled with CFR 0.152.
 */
package net.java.sip.communicator.plugin.jabberaccregwizz;

import java.util.Hashtable;
import net.java.sip.communicator.plugin.jabberaccregwizz.JabberAccountRegistrationWizard;
import net.java.sip.communicator.plugin.jabberaccregwizz.Resources;
import net.java.sip.communicator.service.browserlauncher.BrowserLauncherService;
import net.java.sip.communicator.service.certificate.CertificateService;
import net.java.sip.communicator.service.credentialsstorage.CredentialsStorageService;
import net.java.sip.communicator.service.gui.AccountRegistrationWizard;
import net.java.sip.communicator.service.gui.UIService;
import net.java.sip.communicator.service.gui.WizardContainer;
import net.java.sip.communicator.service.protocol.ProtocolProviderFactory;
import net.java.sip.communicator.util.AbstractServiceDependentActivator;
import net.java.sip.communicator.util.Logger;
import org.jitsi.service.configuration.ConfigurationService;
import org.osgi.framework.BundleContext;
import org.osgi.framework.InvalidSyntaxException;
import org.osgi.framework.ServiceReference;

public class JabberAccRegWizzActivator
extends AbstractServiceDependentActivator {
    public static BundleContext bundleContext;
    private static final Logger logger;
    private static BrowserLauncherService browserLauncherService;
    private static ConfigurationService configService;
    private static CredentialsStorageService credentialsService;
    private static CertificateService certService;
    private static WizardContainer wizardContainer;
    private static JabberAccountRegistrationWizard jabberWizard;
    private static UIService uiService;

    public void start(Object dependentService) {
        uiService = (UIService)dependentService;
        wizardContainer = uiService.getAccountRegWizardContainer();
        jabberWizard = new JabberAccountRegistrationWizard(wizardContainer);
        Hashtable<String, String> containerFilter = new Hashtable<String, String>();
        containerFilter.put("PROTOCOL_NAME", "Jabber");
        bundleContext.registerService(AccountRegistrationWizard.class.getName(), (Object)jabberWizard, containerFilter);
    }

    public Class<?> getDependentServiceClass() {
        return UIService.class;
    }

    public void setBundleContext(BundleContext context) {
        bundleContext = context;
    }

    public void stop(BundleContext bundleContext) throws Exception {
    }

    public static ProtocolProviderFactory getJabberProtocolProviderFactory() {
        ServiceReference[] serRefs = null;
        String osgiFilter = "(PROTOCOL_NAME=Jabber)";
        try {
            serRefs = bundleContext.getServiceReferences(ProtocolProviderFactory.class.getName(), osgiFilter);
        }
        catch (InvalidSyntaxException ex) {
            logger.error((Object)("JabberAccRegWizzActivator : " + (Object)((Object)ex)));
        }
        return (ProtocolProviderFactory)bundleContext.getService(serRefs[0]);
    }

    public static UIService getUIService() {
        return uiService;
    }

    public static BrowserLauncherService getBrowserLauncher() {
        if (browserLauncherService == null) {
            ServiceReference serviceReference = bundleContext.getServiceReference(BrowserLauncherService.class.getName());
            browserLauncherService = (BrowserLauncherService)bundleContext.getService(serviceReference);
        }
        return browserLauncherService;
    }

    public static CredentialsStorageService getCredentialsService() {
        if (credentialsService == null) {
            ServiceReference serviceReference = bundleContext.getServiceReference(CredentialsStorageService.class.getName());
            credentialsService = (CredentialsStorageService)bundleContext.getService(serviceReference);
        }
        return credentialsService;
    }

    public static ConfigurationService getConfigurationService() {
        if (configService == null) {
            ServiceReference serviceReference = bundleContext.getServiceReference(ConfigurationService.class.getName());
            configService = (ConfigurationService)bundleContext.getService(serviceReference);
        }
        return configService;
    }

    public static CertificateService getCertificateService() {
        if (certService == null) {
            ServiceReference serviceReference = bundleContext.getServiceReference(CertificateService.class.getName());
            certService = (CertificateService)bundleContext.getService(serviceReference);
        }
        return certService;
    }

    public static boolean isAdvancedAccountConfigDisabled() {
        String advancedConfigDisabledDefaultProp = Resources.getSettingsString("impl.gui.main.account.ADVANCED_CONFIG_DISABLED");
        boolean isAdvancedConfigDisabled = false;
        if (advancedConfigDisabledDefaultProp != null) {
            isAdvancedConfigDisabled = Boolean.parseBoolean(advancedConfigDisabledDefaultProp);
        }
        return JabberAccRegWizzActivator.getConfigurationService().getBoolean("net.java.sip.communicator.impl.gui.main.account.ADVANCED_CONFIG_DISABLED", isAdvancedConfigDisabled);
    }

    static {
        logger = Logger.getLogger(JabberAccRegWizzActivator.class);
        credentialsService = null;
    }
}

