/*
 * Decompiled with CFR 0.152.
 */
package net.kano.joscar.ratelim;

import java.util.Collection;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import net.kano.joscar.CopyOnWriteArrayList;
import net.kano.joscar.DefensiveTools;
import net.kano.joscar.flapcmd.SnacCommand;
import net.kano.joscar.logging.Logger;
import net.kano.joscar.logging.LoggingSystem;
import net.kano.joscar.net.ConnProcessor;
import net.kano.joscar.ratelim.RateClassListener;
import net.kano.joscar.ratelim.RateClassMonitor;
import net.kano.joscar.ratelim.RateClassMonitorImpl;
import net.kano.joscar.ratelim.RateListener;
import net.kano.joscar.snac.ClientSnacProcessor;
import net.kano.joscar.snac.CmdType;
import net.kano.joscar.snac.OutgoingSnacRequestListener;
import net.kano.joscar.snac.SnacPacketEvent;
import net.kano.joscar.snac.SnacPacketListener;
import net.kano.joscar.snac.SnacRequestSentEvent;
import net.kano.joscar.snac.SnacRequestTimeoutEvent;
import net.kano.joscar.snac.SnacResponseEvent;
import net.kano.joscar.snac.SnacResponseListener;
import net.kano.joscar.snaccmd.conn.RateChange;
import net.kano.joscar.snaccmd.conn.RateClassInfo;
import net.kano.joscar.snaccmd.conn.RateInfoCmd;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class RateMonitor {
    public static final ConnProcessor.ErrorType ERRTYPE_RATE_LISTENER = new ConnProcessor.ErrorType("ERRTYPE_RATE_LISTENER");
    public static final int ERRORMARGIN_DEFAULT = 200;
    private static final Logger LOGGER = LoggingSystem.getLogger("net.kano.joscar.ratelim");
    private ClientSnacProcessor snacProcessor;
    private final CopyOnWriteArrayList<RateListener> listeners = new CopyOnWriteArrayList();
    private final Object listenerEventLock = new Object();
    private Map<Integer, RateClassMonitorImpl> classToMonitor = new HashMap<Integer, RateClassMonitorImpl>(10);
    private Map<CmdType, RateClassMonitorImpl> typeToMonitor = new HashMap<CmdType, RateClassMonitorImpl>(500);
    private RateClassMonitorImpl defaultMonitor = null;
    private int errorMargin = 200;
    private OutgoingSnacRequestListener requestListener = new OutgoingSnacRequestListener(){

        public void handleSent(SnacRequestSentEvent e) {
            RateMonitor.this.updateRate(e);
        }

        public void handleTimeout(SnacRequestTimeoutEvent event) {
        }
    };
    private SnacResponseListener responseListener = new SnacResponseListener(){

        public void handleResponse(SnacResponseEvent e) {
            SnacCommand cmd = e.getSnacCommand();
            if (cmd instanceof RateInfoCmd) {
                RateInfoCmd ric = (RateInfoCmd)cmd;
                RateMonitor.this.setRateClasses(ric.getRateClassInfos());
            }
        }
    };
    private SnacPacketListener packetListener = new SnacPacketListener(){

        public void handleSnacPacket(SnacPacketEvent e) {
            RateChange rc;
            RateClassInfo rateInfo;
            SnacCommand cmd = e.getSnacCommand();
            if (cmd instanceof RateChange && (rateInfo = (rc = (RateChange)cmd).getRateInfo()) != null) {
                RateMonitor.this.updateRateClass(rc.getChangeCode(), rateInfo);
            }
        }
    };

    public RateMonitor(ClientSnacProcessor processor) {
        DefensiveTools.checkNull(processor, "processor");
        this.snacProcessor = processor;
        processor.addGlobalRequestListener(this.requestListener);
        processor.addPacketListener(this.packetListener);
        processor.addGlobalResponseListener(this.responseListener);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public final void detach() {
        ClientSnacProcessor oldProcessor;
        Object object = this;
        synchronized (object) {
            if (this.snacProcessor == null) {
                return;
            }
            this.snacProcessor.removeGlobalRequestListener(this.requestListener);
            this.snacProcessor.removePacketListener(this.packetListener);
            this.snacProcessor.removeGlobalResponseListener(this.responseListener);
            oldProcessor = this.snacProcessor;
            this.snacProcessor = null;
        }
        object = this.listenerEventLock;
        synchronized (object) {
            for (RateListener l : this.listeners) {
                l.detached(this, oldProcessor);
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public final synchronized void reset() {
        this.typeToMonitor.clear();
        this.classToMonitor.clear();
        this.defaultMonitor = null;
        Object object = this.listenerEventLock;
        synchronized (object) {
            for (RateListener l : this.listeners) {
                l.reset(this);
            }
        }
    }

    public final synchronized ClientSnacProcessor getSnacProcessor() {
        return this.snacProcessor;
    }

    public final void addListener(RateListener l) {
        DefensiveTools.checkNull(l, "l");
        this.listeners.addIfAbsent(l);
    }

    public final void removeListener(RateListener l) {
        DefensiveTools.checkNull(l, "l");
        this.listeners.remove(l);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public final void setRateClasses(Collection<RateClassInfo> rateInfos) {
        List<RateClassInfo> safeRateInfos = DefensiveTools.getSafeNonnullListCopy(rateInfos, "rateInfos");
        if (LOGGER.logFineEnabled()) {
            LOGGER.logFine("Got rate classes for monitor " + this);
        }
        Object object = this;
        synchronized (object) {
            this.reset();
            for (RateClassInfo info : safeRateInfos) {
                this.setRateClass(info);
            }
        }
        object = this.listenerEventLock;
        synchronized (object) {
            for (RateListener listener : this.listeners) {
                try {
                    listener.gotRateClasses(this);
                }
                catch (Throwable t) {
                    this.handleException(ERRTYPE_RATE_LISTENER, t, listener);
                }
            }
        }
    }

    private synchronized void setRateClass(RateClassInfo rateInfo) {
        DefensiveTools.checkNull(rateInfo, "rateInfo");
        RateClassMonitorImpl monitor = new RateClassMonitorImpl(this, rateInfo, new MyRateClassListener());
        this.classToMonitor.put(rateInfo.getRateClass(), monitor);
        List<CmdType> cmdTypes = rateInfo.getCommands();
        if (cmdTypes == null) {
            return;
        }
        if (cmdTypes.size() == 0) {
            if (this.defaultMonitor == null) {
                this.defaultMonitor = monitor;
            }
        } else {
            for (CmdType cmdType : cmdTypes) {
                this.typeToMonitor.put(cmdType, monitor);
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void updateRateClass(int changeCode, RateClassInfo rateInfo) {
        DefensiveTools.checkRange(changeCode, "changeCode", 0);
        DefensiveTools.checkNull(rateInfo, "rateInfo");
        int rateClass = rateInfo.getRateClass();
        RateClassMonitorImpl monitor = this.getMonitor(rateClass);
        if (monitor == null) {
            LOGGER.logWarning("updateRateClass called with unknown rate class " + rateClass + ": changeCode=" + changeCode + " - " + rateInfo);
            return;
        }
        monitor.updateRateInfo(changeCode, rateInfo);
        Object object = this.listenerEventLock;
        synchronized (object) {
            for (RateListener listener : this.listeners) {
                try {
                    listener.rateClassUpdated(this, monitor, rateInfo);
                }
                catch (Throwable t) {
                    this.handleException(ERRTYPE_RATE_LISTENER, t, listener);
                }
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void handleException(ConnProcessor.ErrorType type, Throwable t, RateListener info) {
        ClientSnacProcessor processor;
        RateMonitor rateMonitor = this;
        synchronized (rateMonitor) {
            processor = this.snacProcessor;
        }
        if (processor != null) {
            processor.getFlapProcessor().handleException(type, t, info);
        } else {
            LOGGER.logWarning("Rate monitor couldn't process error because not attached to SNAC processor: " + t.getMessage() + " (reason obj: " + info + ")");
        }
    }

    private void updateRate(SnacRequestSentEvent e) {
        CmdType cmdType = CmdType.ofCmd(e.getRequest().getCommand());
        RateClassMonitorImpl monitor = this.getMonitor(cmdType);
        if (monitor == null) {
            return;
        }
        monitor.updateRate(e.getSentTime());
    }

    public final synchronized void setErrorMargin(int errorMargin) throws IllegalArgumentException {
        DefensiveTools.checkRange(errorMargin, "errorMargin", 0);
        this.errorMargin = errorMargin;
    }

    public final synchronized int getErrorMargin() {
        return this.errorMargin;
    }

    private RateClassMonitorImpl getMonitor(int rateClass) {
        return this.classToMonitor.get(rateClass);
    }

    public final synchronized RateClassMonitorImpl getMonitor(CmdType type) {
        DefensiveTools.checkNull(type, "type");
        RateClassMonitorImpl queue = this.typeToMonitor.get(type);
        if (queue == null) {
            queue = this.defaultMonitor;
        }
        return queue;
    }

    public final synchronized List<RateClassMonitor> getMonitors() {
        return DefensiveTools.getUnmodifiableCopy(this.classToMonitor.values());
    }

    public String toString() {
        return "RateMonitor: classes=" + this.classToMonitor.keySet() + ", errorMargin=" + this.errorMargin + ", snacProcessor=" + this.snacProcessor;
    }

    private class MyRateClassListener
    implements RateClassListener {
        private MyRateClassListener() {
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public void handleLimitedEvent(RateClassMonitor monitor, boolean limited) {
            Object object = RateMonitor.this.listenerEventLock;
            synchronized (object) {
                for (RateListener listener : RateMonitor.this.listeners) {
                    try {
                        listener.rateClassLimited(RateMonitor.this, monitor, limited);
                    }
                    catch (Throwable t) {
                        RateMonitor.this.handleException(ERRTYPE_RATE_LISTENER, t, listener);
                    }
                }
            }
        }
    }
}

