/*
 * Decompiled with CFR 0.152.
 */
package net.kano.joscar;

import java.io.IOException;
import java.io.OutputStream;
import java.io.UnsupportedEncodingException;
import java.net.URLDecoder;
import java.nio.charset.Charset;
import java.nio.charset.IllegalCharsetNameException;
import java.util.Collections;
import java.util.HashMap;
import java.util.Map;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import net.kano.joscar.BinaryTools;
import net.kano.joscar.ByteBlock;
import net.kano.joscar.DefensiveTools;
import net.kano.joscar.DynAsciiCharSequence;
import net.kano.joscar.StringBlock;
import net.kano.joscar.logging.Logger;
import net.kano.joscar.logging.LoggingSystem;
import net.kano.joustsim.Screenname;
import org.jetbrains.annotations.Nullable;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public final class OscarTools {
    private static final Logger logger = LoggingSystem.getLogger("net.kano.joscar");
    private static final Pattern charsetPattern = Pattern.compile("[A-Za-z0-9][A-Za-z0-9-.:_]*");
    private static final Pattern typePattern = Pattern.compile("[;=\\s]*+(\\S+?)\\s*(?:=\\s*(?:\"(.*?)\"|(\\S*?))\\s*)?(?:[=\\s]*;[=\\s]*|\\z)");
    private static final Pattern ucsPattern = Pattern.compile("ucs-2([bl]e)?");
    private static String defaultCharset = null;
    private static Charset defaultCharsetObject = null;
    private static final Object defaultCharsetLock = new Object();
    private static final Pattern htmlRE;
    private static final Pattern httpHeaderRE;
    private static final Pattern roomNameRE;

    private OscarTools() {
    }

    @Nullable
    public static StringBlock readScreenname(ByteBlock data) {
        if (data.getLength() < 1) {
            return null;
        }
        short length = BinaryTools.getUByte(data, 0);
        if (length > data.getLength() - 1) {
            return null;
        }
        String sn = BinaryTools.getAsciiString(data.subBlock(1, length));
        return new StringBlock(sn, length + 1);
    }

    public static void writeScreenname(OutputStream out, String sn) throws IOException {
        byte[] bytes = BinaryTools.getAsciiBytes(sn);
        BinaryTools.writeUByte(out, bytes.length);
        out.write(bytes);
    }

    public static Map<String, String> parseContentTypeString(String str) {
        Matcher matcher = typePattern.matcher(str);
        HashMap<String, String> entries = new HashMap<String, String>();
        while (matcher.find()) {
            String key = matcher.group(1);
            String value = matcher.group(2);
            if (value == null) {
                value = matcher.group(3);
            }
            entries.put(key, value);
        }
        return entries;
    }

    private static boolean isValidCharset(String charset) {
        return charsetPattern.matcher(charset).matches();
    }

    public static void resetDefaultCharset() {
        if (Charset.isSupported("ISO8859-1")) {
            OscarTools.setDefaultCharset("ISO8859-1");
        } else {
            OscarTools.setDefaultCharset("US-ASCII");
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public static void setDefaultCharset(String charset) throws IllegalArgumentException {
        if (!OscarTools.isValidCharset(charset)) throw new IllegalArgumentException("Invalid charset name: " + charset);
        if (!Charset.isSupported(charset)) throw new IllegalArgumentException("Unsupported charset: " + charset);
        Object object = defaultCharsetLock;
        synchronized (object) {
            defaultCharset = charset;
            defaultCharsetObject = null;
            return;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static String getDefaultCharsetName() {
        Object object = defaultCharsetLock;
        synchronized (object) {
            return defaultCharset;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static Charset getDefaultCharset() {
        Object object = defaultCharsetLock;
        synchronized (object) {
            Charset newCharset;
            Charset object2 = defaultCharsetObject;
            if (object2 != null) {
                return object2;
            }
            defaultCharsetObject = newCharset = Charset.forName(defaultCharset);
            return newCharset;
        }
    }

    private static String fixCharset(String charset) {
        String newCharset;
        if (charset == null) {
            return OscarTools.getDefaultCharsetName();
        }
        String lower = charset.toLowerCase();
        if (lower.equals("unicode-2-0")) {
            return "UTF-16BE";
        }
        if (lower.startsWith("unicode-2-0-") && OscarTools.isValidCharset(newCharset = charset.substring(12)) && Charset.isSupported(newCharset)) {
            return newCharset;
        }
        Matcher matcher = ucsPattern.matcher(charset);
        if (matcher.matches()) {
            String type = matcher.group(1);
            String newCharset2 = "utf-16";
            if (type != null) {
                newCharset2 = newCharset2 + type;
            }
            return newCharset2;
        }
        return OscarTools.getDefaultCharsetName();
    }

    public static String getInfoString(ByteBlock infoData, String infoType) {
        String charset;
        if (infoType != null) {
            Map<String, String> type = OscarTools.parseContentTypeString(infoType);
            charset = type.get("charset");
            charset = OscarTools.getValidCharset(charset);
        } else {
            charset = OscarTools.getDefaultCharsetName();
        }
        try {
            return ByteBlock.createString(infoData, charset);
        }
        catch (UnsupportedEncodingException impossible) {
            return null;
        }
    }

    public static String getValidCharset(String charset) {
        String goodCharset = charset;
        if (goodCharset == null || !OscarTools.isValidCharset(goodCharset)) {
            goodCharset = OscarTools.fixCharset(goodCharset);
        } else {
            try {
                if (!Charset.isSupported(goodCharset)) {
                    goodCharset = OscarTools.fixCharset(goodCharset);
                }
            }
            catch (IllegalCharsetNameException e) {
                logger.logWarning("Illegal charset name: " + goodCharset + ": " + e.getMessage());
                goodCharset = OscarTools.fixCharset(goodCharset);
            }
        }
        return goodCharset;
    }

    public static String getString(ByteBlock data, String charset) {
        String realCharset = OscarTools.getValidCharset(charset);
        try {
            return ByteBlock.createString(data, realCharset);
        }
        catch (UnsupportedEncodingException impossible) {
            return null;
        }
    }

    public static boolean equalScreennames(String a, String b) {
        DefensiveTools.checkNull(a, "a");
        DefensiveTools.checkNull(b, "b");
        return Screenname.normalize(a).equals(Screenname.normalize(b));
    }

    public static String stripHtml(String str) {
        return htmlRE.matcher(str).replaceAll("");
    }

    public static HttpHeaderInfo parseHttpHeader(ByteBlock data) {
        DefensiveTools.checkNull(data, "data");
        HashMap<String, String> map = new HashMap<String, String>();
        DynAsciiCharSequence seq = new DynAsciiCharSequence(data);
        Matcher m = httpHeaderRE.matcher(seq);
        int dataStart = -1;
        while (m.find()) {
            if (m.group(1).trim().length() == 0) {
                dataStart = m.end();
                break;
            }
            String key = m.group(2);
            String val = m.group(3);
            map.put(key.toLowerCase(), val);
            map.put(key, val);
        }
        return new HttpHeaderInfo(map, dataStart == -1 ? null : data.subBlock(dataStart));
    }

    @Nullable
    public static String getRoomNameFromCookie(String cookie) {
        Matcher m = roomNameRE.matcher(cookie);
        if (!m.matches()) {
            return null;
        }
        String encodedName = m.group(1);
        String name = null;
        try {
            name = URLDecoder.decode(encodedName, "us-ascii");
        }
        catch (UnsupportedEncodingException impossible) {
            // empty catch block
        }
        return name;
    }

    static {
        OscarTools.resetDefaultCharset();
        htmlRE = Pattern.compile("<[^>]*>");
        httpHeaderRE = Pattern.compile("((.*?)(?:: ?(.*))?)(\r\n|\r|\n)");
        roomNameRE = Pattern.compile("!aol://\\d+:\\d+-\\d+-(.*)");
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    public static final class HttpHeaderInfo {
        private final Map<String, String> headers;
        private final ByteBlock data;

        private HttpHeaderInfo(Map<String, String> headers, ByteBlock data) {
            DefensiveTools.checkNull(headers, "headers");
            DefensiveTools.checkNull(data, "data");
            this.headers = Collections.unmodifiableMap(headers);
            this.data = data;
        }

        public String get(String headerName) {
            return this.headers.get(headerName);
        }

        public Map<String, String> getHeaders() {
            return this.headers;
        }

        public ByteBlock getData() {
            return this.data;
        }

        public String toString() {
            return "HttpHeaderInfo: headers=" + this.headers;
        }
    }
}

