/*
 * Decompiled with CFR 0.152.
 */
package net.java.sip.communicator.impl.ldap;

import java.util.List;
import net.java.sip.communicator.impl.ldap.LdapActivator;
import net.java.sip.communicator.impl.ldap.LdapDirectorySetImpl;
import net.java.sip.communicator.impl.ldap.LdapFactoryImpl;
import net.java.sip.communicator.service.certificate.CertificateService;
import net.java.sip.communicator.service.contactsource.ContactSourceService;
import net.java.sip.communicator.service.credentialsstorage.CredentialsStorageService;
import net.java.sip.communicator.service.ldap.LdapDirectory;
import net.java.sip.communicator.service.ldap.LdapDirectorySet;
import net.java.sip.communicator.service.ldap.LdapDirectorySettings;
import net.java.sip.communicator.service.ldap.LdapFactory;
import net.java.sip.communicator.service.ldap.LdapService;
import net.java.sip.communicator.util.Logger;
import net.java.sip.communicator.util.ServiceUtils;
import org.jitsi.service.configuration.ConfigurationService;
import org.osgi.framework.BundleContext;
import org.osgi.framework.ServiceReference;

public class LdapServiceImpl
implements LdapService {
    private LdapDirectorySet serverSet;
    private LdapFactory factory = new LdapFactoryImpl();
    private static Logger logger = Logger.getLogger(LdapServiceImpl.class);
    private static BundleContext bundleContext;
    private static ConfigurationService configService;
    private static CredentialsStorageService credentialsService;
    private static CertificateService certService;

    public void start(BundleContext bc) {
        logger.trace((Object)"Starting the LDAP implementation.");
        bundleContext = bc;
        this.serverSet = new LdapDirectorySetImpl(LdapServiceImpl.getConfigService());
        this.loadPersistentConfig();
    }

    public void stop(BundleContext bc) {
        logger.trace((Object)"Stopping the LDAP implementation.");
    }

    public static ConfigurationService getConfigService() {
        if (configService == null) {
            ServiceReference confReference = bundleContext.getServiceReference(ConfigurationService.class.getName());
            configService = (ConfigurationService)bundleContext.getService(confReference);
        }
        return configService;
    }

    public static CredentialsStorageService getCredentialsService() {
        if (credentialsService == null) {
            ServiceReference confReference = bundleContext.getServiceReference(CredentialsStorageService.class.getName());
            credentialsService = (CredentialsStorageService)bundleContext.getService(confReference);
        }
        return credentialsService;
    }

    public static CertificateService getCertificateService() {
        if (certService == null) {
            certService = (CertificateService)ServiceUtils.getService((BundleContext)bundleContext, CertificateService.class);
        }
        return certService;
    }

    @Override
    public LdapDirectorySet getServerSet() {
        return this.serverSet;
    }

    @Override
    public LdapFactory getFactory() {
        return this.factory;
    }

    @Override
    public ContactSourceService createContactSource(LdapDirectory ldapDir) {
        return LdapActivator.registerContactSource(ldapDir);
    }

    @Override
    public void removeContactSource(LdapDirectory ldapDir) {
        LdapActivator.unregisterContactSource(ldapDir);
    }

    private void loadPersistentConfig() {
        LdapDirectorySettings settings = this.getFactory().createServerSettings();
        List list = LdapServiceImpl.getConfigService().getPropertyNamesByPrefix("net.java.sip.communicator.impl.ldap.directories", true);
        for (Object configEntry : list) {
            String name = LdapServiceImpl.getConfigService().getString(configEntry.toString());
            if (name == null) continue;
            settings.persistentLoad(name);
            LdapDirectory server = this.getFactory().createServer(settings);
            this.serverSet.addServer(server);
        }
    }

    static {
        certService = null;
    }
}

