/*
 * Decompiled with CFR 0.152.
 */
package net.java.sip.communicator.util;

import java.util.logging.Handler;
import java.util.logging.Level;
import java.util.logging.LogManager;
import net.java.sip.communicator.util.FileHandler;

public class Logger {
    private final java.util.logging.Logger loggerDelegate;

    private Logger(java.util.logging.Logger logger) {
        this.loggerDelegate = logger;
    }

    public static Logger getLogger(Class<?> clazz) throws NullPointerException {
        return Logger.getLogger(clazz.getName());
    }

    public static Logger getLogger(String string) throws NullPointerException {
        return new Logger(java.util.logging.Logger.getLogger(string));
    }

    public void logEntry() {
        if (this.loggerDelegate.isLoggable(Level.FINEST)) {
            StackTraceElement stackTraceElement = new Throwable().getStackTrace()[1];
            this.loggerDelegate.log(Level.FINEST, "[entry] " + stackTraceElement.getMethodName());
        }
    }

    public void logExit() {
        if (this.loggerDelegate.isLoggable(Level.FINEST)) {
            StackTraceElement stackTraceElement = new Throwable().getStackTrace()[1];
            this.loggerDelegate.log(Level.FINEST, "[exit] " + stackTraceElement.getMethodName());
        }
    }

    public boolean isTraceEnabled() {
        return this.loggerDelegate.isLoggable(Level.FINER);
    }

    public void trace(Object object) {
        this.loggerDelegate.finer(object != null ? object.toString() : "null");
    }

    public void trace(Object object, Throwable throwable) {
        this.loggerDelegate.log(Level.FINER, object != null ? object.toString() : "null", throwable);
    }

    public boolean isDebugEnabled() {
        return this.loggerDelegate.isLoggable(Level.FINE);
    }

    public void debug(Object object) {
        this.loggerDelegate.fine(object != null ? object.toString() : "null");
    }

    public void debug(Object object, Throwable throwable) {
        this.loggerDelegate.log(Level.FINE, object != null ? object.toString() : "null", throwable);
    }

    public boolean isInfoEnabled() {
        return this.loggerDelegate.isLoggable(Level.INFO);
    }

    public void info(Object object) {
        this.loggerDelegate.info(object != null ? object.toString() : "null");
    }

    public void info(Object object, Throwable throwable) {
        this.loggerDelegate.log(Level.INFO, object != null ? object.toString() : "null", throwable);
    }

    public void warn(Object object) {
        this.loggerDelegate.warning(object != null ? object.toString() : "null");
    }

    public void warn(Object object, Throwable throwable) {
        this.loggerDelegate.log(Level.WARNING, object != null ? object.toString() : "null", throwable);
    }

    public void error(Object object) {
        this.loggerDelegate.severe(object != null ? object.toString() : "null");
    }

    public void error(Object object, Throwable throwable) {
        this.loggerDelegate.log(Level.SEVERE, object != null ? object.toString() : "null", throwable);
    }

    public void fatal(Object object) {
        this.loggerDelegate.severe(object != null ? object.toString() : "null");
    }

    public void fatal(Object object, Throwable throwable) {
        this.loggerDelegate.log(Level.SEVERE, object != null ? object.toString() : "null", throwable);
    }

    public void setLevelFatal() {
        this.setLevel(Level.SEVERE);
    }

    public void setLevelError() {
        this.setLevel(Level.SEVERE);
    }

    public void setLevelWarn() {
        this.setLevel(Level.WARNING);
    }

    public void setLevelInfo() {
        this.setLevel(Level.INFO);
    }

    public void setLevelDebug() {
        this.setLevel(Level.FINE);
    }

    public void setLevelTrace() {
        this.setLevel(Level.FINER);
    }

    public void setLevelAll() {
        this.setLevel(Level.ALL);
    }

    public void setLevelOff() {
        this.setLevel(Level.OFF);
    }

    private void setLevel(Level level) {
        Handler[] handlerArray;
        for (Handler handler : handlerArray = this.loggerDelegate.getHandlers()) {
            handler.setLevel(level);
        }
        this.loggerDelegate.setLevel(level);
    }

    public void reset() {
        try {
            FileHandler.pattern = null;
            LogManager.getLogManager().reset();
            LogManager.getLogManager().readConfiguration();
        }
        catch (Exception exception) {
            this.loggerDelegate.log(Level.INFO, "Failed to reinit logger.", exception);
        }
    }
}

