/*
 * Decompiled with CFR 0.152.
 */
package net.sf.fmj.media;

import java.awt.Dimension;
import java.util.Vector;
import javax.media.Codec;
import javax.media.Format;
import javax.media.Multiplexer;
import javax.media.NotConfiguredError;
import javax.media.NotRealizedError;
import javax.media.Owned;
import javax.media.PlugIn;
import javax.media.PlugInManager;
import javax.media.Renderer;
import javax.media.Track;
import javax.media.UnsupportedPlugInException;
import javax.media.control.FrameRateControl;
import javax.media.control.TrackControl;
import javax.media.format.AudioFormat;
import javax.media.format.VideoFormat;
import javax.media.protocol.ContentDescriptor;
import javax.media.protocol.DataSource;
import net.sf.fmj.filtergraph.GraphNode;
import net.sf.fmj.filtergraph.SimpleGraphBuilder;
import net.sf.fmj.media.BasicModule;
import net.sf.fmj.media.BasicMuxModule;
import net.sf.fmj.media.BasicProcessor;
import net.sf.fmj.media.BasicSinkModule;
import net.sf.fmj.media.BasicTrackControl;
import net.sf.fmj.media.InputConnector;
import net.sf.fmj.media.Log;
import net.sf.fmj.media.OutputConnector;
import net.sf.fmj.media.PlaybackEngine;
import net.sf.fmj.media.SlowPlugIn;
import net.sf.fmj.media.codec.video.colorspace.RGBScaler;
import net.sf.fmj.media.control.ProgressControl;
import net.sf.fmj.media.util.Resource;

public class ProcessEngine
extends PlaybackEngine {
    protected BasicMuxModule muxModule;
    protected ContentDescriptor outputContentDes = null;
    String prefetchError = "Failed to prefetch: " + this;
    protected Vector targetMuxNames = null;
    protected GraphNode[] targetMuxes = null;
    protected GraphNode targetMux = null;
    protected Format[] targetMuxFormats = null;

    public ProcessEngine(BasicProcessor p) {
        super(p);
    }

    boolean connectMux() {
        BasicTrackControl[] tcs = new BasicTrackControl[this.trackControls.length];
        int total = 0;
        Multiplexer mux = (Multiplexer)this.targetMux.plugin;
        for (int i = 0; i < this.trackControls.length; ++i) {
            if (!this.trackControls[i].isEnabled()) continue;
            tcs[total++] = this.trackControls[i];
        }
        try {
            mux.setContentDescriptor(this.outputContentDes);
        }
        catch (Exception e) {
            Log.comment("Failed to set the output content descriptor on the multiplexer.");
            return false;
        }
        boolean failed = false;
        if (mux.setNumTracks(this.targetMuxFormats.length) != this.targetMuxFormats.length) {
            Log.comment("Failed  to set number of tracks on the multiplexer.");
            return false;
        }
        for (int mf = 0; mf < this.targetMuxFormats.length; ++mf) {
            if (this.targetMuxFormats[mf] != null && mux.setInputFormat(this.targetMuxFormats[mf], mf) != null) continue;
            Log.comment("Failed to set input format on the multiplexer.");
            failed = true;
            break;
        }
        if (failed) {
            return false;
        }
        if (SimpleGraphBuilder.inspector != null && !SimpleGraphBuilder.inspector.verify(mux, this.targetMuxFormats)) {
            return false;
        }
        BasicMuxModule bmm = new BasicMuxModule(mux, this.targetMuxFormats);
        for (int j = 0; j < this.targetMuxFormats.length; ++j) {
            InputConnector ic = bmm.getInputConnector(BasicMuxModule.ConnectorNamePrefix + j);
            if (ic == null) {
                Log.comment("BasicMuxModule: connector mismatched.");
                return false;
            }
            ic.setFormat(this.targetMuxFormats[j]);
            tcs[j].lastOC.setProtocol(ic.getProtocol());
            tcs[j].lastOC.connectTo(ic, this.targetMuxFormats[j]);
        }
        if (!bmm.doRealize()) {
            return false;
        }
        bmm.setModuleListener(this);
        bmm.setController(this);
        this.modules.addElement(bmm);
        this.sinks.addElement(bmm);
        this.muxModule = bmm;
        return true;
    }

    @Override
    protected boolean doConfigure() {
        if (!this.doConfigure1()) {
            return false;
        }
        String[] names = this.source.getOutputConnectorNames();
        this.trackControls = new BasicTrackControl[this.tracks.length];
        for (int i = 0; i < this.tracks.length; ++i) {
            this.trackControls[i] = new ProcTControl(this, this.tracks[i], this.source.getOutputConnector(names[i]));
        }
        if (!this.doConfigure2()) {
            return false;
        }
        this.outputContentDes = new ContentDescriptor("raw");
        this.reenableHintTracks();
        return true;
    }

    @Override
    protected synchronized boolean doPrefetch() {
        if (this.prefetched) {
            return true;
        }
        if (!this.doPrefetch1()) {
            return false;
        }
        if (this.muxModule != null && !this.muxModule.doPrefetch()) {
            Log.error(this.prefetchError);
            Log.error("  Cannot prefetch the multiplexer: " + this.muxModule.getMultiplexer() + "\n");
            return false;
        }
        return this.doPrefetch2();
    }

    @Override
    protected synchronized boolean doRealize() {
        this.targetMuxes = null;
        if (!super.doRealize1()) {
            return false;
        }
        if (this.targetMux != null && !this.connectMux()) {
            Log.error(this.realizeError);
            Log.error("  Cannot connect the multiplexer\n");
            this.player.processError = this.genericProcessorError;
            return false;
        }
        return super.doRealize2();
    }

    @Override
    protected synchronized void doStart() {
        if (this.started) {
            return;
        }
        this.doStart1();
        if (this.muxModule != null) {
            this.muxModule.doStart();
        }
        this.doStart2();
    }

    @Override
    protected synchronized void doStop() {
        if (!this.started) {
            return;
        }
        this.doStop1();
        if (this.muxModule != null) {
            this.muxModule.doStop();
        }
        this.doStop2();
    }

    @Override
    protected BasicSinkModule findMasterSink() {
        if (this.muxModule != null && this.muxModule.getClock() != null) {
            return this.muxModule;
        }
        return super.findMasterSink();
    }

    @Override
    protected long getBitRate() {
        if (this.muxModule != null) {
            return this.muxModule.getBitsWritten();
        }
        return this.source.getBitsRead();
    }

    public ContentDescriptor getContentDescriptor() throws NotConfiguredError {
        if (this.getState() < 180) {
            this.throwError(new NotConfiguredError("getContentDescriptor " + NOT_CONFIGURED_ERROR));
        }
        return this.outputContentDes;
    }

    public DataSource getDataOutput() throws NotRealizedError {
        if (this.getState() < 300) {
            this.throwError(new NotRealizedError("getDataOutput " + NOT_REALIZED_ERROR));
        }
        if (this.muxModule != null) {
            return this.muxModule.getDataOutput();
        }
        return null;
    }

    BasicMuxModule getMuxModule() {
        return this.muxModule;
    }

    @Override
    protected PlugIn getPlugIn(BasicModule m) {
        if (m instanceof BasicMuxModule) {
            return ((BasicMuxModule)m).getMultiplexer();
        }
        return super.getPlugIn(m);
    }

    public ContentDescriptor[] getSupportedContentDescriptors() throws NotConfiguredError {
        int i;
        if (this.getState() < 180) {
            this.throwError(new NotConfiguredError("getSupportedContentDescriptors " + NOT_CONFIGURED_ERROR));
        }
        Vector names = PlugInManager.getPlugInList(null, null, 5);
        Vector<Format> fmts = new Vector<Format>();
        for (i = 0; i < names.size(); ++i) {
            Format[] fs = PlugInManager.getSupportedOutputFormats((String)names.elementAt(i), 5);
            if (fs == null) continue;
            for (int j = 0; j < fs.length; ++j) {
                if (!(fs[j] instanceof ContentDescriptor)) continue;
                boolean duplicate = false;
                for (int k = 0; k < fmts.size(); ++k) {
                    if (!fmts.elementAt(k).equals(fs[j])) continue;
                    duplicate = true;
                    break;
                }
                if (duplicate) continue;
                fmts.addElement(fs[j]);
            }
        }
        ContentDescriptor[] cds = new ContentDescriptor[fmts.size()];
        for (i = 0; i < fmts.size(); ++i) {
            cds[i] = (ContentDescriptor)fmts.elementAt(i);
        }
        return cds;
    }

    public TrackControl[] getTrackControls() throws NotConfiguredError {
        if (this.getState() < 180) {
            this.throwError(new NotConfiguredError("getTrackControls " + NOT_CONFIGURED_ERROR));
        }
        return this.trackControls;
    }

    boolean isRTPFormat(Format fmt) {
        return fmt != null && fmt.getEncoding() != null && fmt.getEncoding().endsWith("rtp") || fmt.getEncoding().endsWith("RTP");
    }

    void reenableHintTracks() {
        for (int i = 0; i < this.trackControls.length; ++i) {
            if (!this.isRTPFormat(this.trackControls[i].getOriginalFormat())) continue;
            this.trackControls[i].setEnabled(true);
            break;
        }
    }

    @Override
    protected void resetBitRate() {
        if (this.muxModule != null) {
            this.muxModule.resetBitsWritten();
        } else {
            this.source.resetBitsRead();
        }
    }

    public ContentDescriptor setContentDescriptor(ContentDescriptor ocd) throws NotConfiguredError {
        Vector cnames;
        if (this.getState() < 180) {
            this.throwError(new NotConfiguredError("setContentDescriptor " + NOT_CONFIGURED_ERROR));
        }
        if (this.getState() > 180) {
            return null;
        }
        if (ocd != null && ((cnames = PlugInManager.getPlugInList(null, ocd, 5)) == null || cnames.size() == 0)) {
            return null;
        }
        this.outputContentDes = ocd;
        return this.outputContentDes;
    }

    class ProcTControl
    extends BasicTrackControl
    implements Owned {
        protected Format formatWanted;
        protected Codec[] codecChainWanted;
        protected Renderer rendererWanted;
        protected ProcGraphBuilder gb;
        protected Format[] supportedFormats;

        public ProcTControl(ProcessEngine engine, Track track, OutputConnector oc) {
            super(engine, track, oc);
            this.formatWanted = null;
            this.codecChainWanted = null;
            this.rendererWanted = null;
            this.supportedFormats = null;
        }

        @Override
        public boolean buildTrack(int trackID, int numTracks) {
            if (this.gb == null) {
                this.gb = new ProcGraphBuilder((ProcessEngine)this.engine);
            } else {
                this.gb.reset();
            }
            boolean rtn = this.gb.buildGraph(this, trackID, numTracks);
            this.gb = null;
            return rtn;
        }

        private Format checkSize(Format fmt) {
            Format ofmt;
            if (!(fmt instanceof VideoFormat)) {
                return fmt;
            }
            VideoFormat vfmt = (VideoFormat)fmt;
            Dimension size = ((VideoFormat)fmt).getSize();
            if (size == null && ((ofmt = this.getOriginalFormat()) == null || (size = ((VideoFormat)ofmt).getSize()) == null)) {
                return fmt;
            }
            int w = size.width;
            int h = size.height;
            if (fmt.matches(new VideoFormat("jpeg/rtp")) || fmt.matches(new VideoFormat("jpeg"))) {
                if (size.width % 8 != 0) {
                    w = size.width / 8 * 8;
                }
                if (size.height % 8 != 0) {
                    h = size.height / 8 * 8;
                }
                if (w == 0 || h == 0) {
                    w = size.width;
                    h = size.height;
                }
            } else if (fmt.matches(new VideoFormat("h263/rtp")) || fmt.matches(new VideoFormat("h263-1998/rtp")) || fmt.matches(new VideoFormat("h263"))) {
                if (size.width >= 352) {
                    w = 352;
                    h = 288;
                } else if (size.width >= 160) {
                    w = 176;
                    h = 144;
                } else {
                    w = 128;
                    h = 96;
                }
            }
            if (w != size.width || h != size.height) {
                Log.comment("setFormat: " + fmt.getEncoding() + ": video aspect ratio mismatched.");
                Log.comment("  Scaled from " + size.width + "x" + size.height + " to " + w + "x" + h + ".\n");
                fmt = new VideoFormat(null, new Dimension(w, h), -1, null, -1.0f).intersects(fmt);
            }
            return fmt;
        }

        @Override
        protected FrameRateControl frameRateControl() {
            this.muxModule = ProcessEngine.this.getMuxModule();
            return ProcessEngine.this.frameRateControl;
        }

        @Override
        public Format getFormat() {
            return this.formatWanted == null ? this.track.getFormat() : this.formatWanted;
        }

        @Override
        public Object getOwner() {
            return ProcessEngine.this.player;
        }

        @Override
        public Format[] getSupportedFormats() {
            if (this.supportedFormats == null && (this.supportedFormats = Resource.getDB(this.track.getFormat())) == null) {
                if (this.gb == null) {
                    this.gb = new ProcGraphBuilder((ProcessEngine)this.engine);
                } else {
                    this.gb.reset();
                }
                this.supportedFormats = this.gb.getSupportedOutputFormats(this.track.getFormat());
                this.supportedFormats = Resource.putDB(this.track.getFormat(), this.supportedFormats);
                PlaybackEngine.needSavingDB = true;
            }
            if (ProcessEngine.this.outputContentDes != null) {
                return this.verifyMuxInputs(ProcessEngine.this.outputContentDes, this.supportedFormats);
            }
            return this.supportedFormats;
        }

        @Override
        public boolean isCustomized() {
            return this.formatWanted != null || this.codecChainWanted != null || this.rendererWanted != null;
        }

        @Override
        public boolean isTimeBase() {
            for (int j = 0; j < this.modules.size(); ++j) {
                if (this.modules.elementAt(j) != ProcessEngine.this.masterSink) continue;
                return true;
            }
            return false;
        }

        @Override
        public void prError() {
            if (!this.isCustomized()) {
                super.prError();
                return;
            }
            Log.error("  Cannot build a flow graph with the customized options:");
            if (this.formatWanted != null) {
                Log.error("    Unable to transcode format: " + this.getOriginalFormat());
                Log.error("      to: " + this.getFormat());
                if (ProcessEngine.this.outputContentDes != null) {
                    Log.error("      outputting to: " + ProcessEngine.this.outputContentDes);
                }
            }
            if (this.codecChainWanted != null) {
                Log.error("    Unable to add customed codecs: ");
                for (int i = 0; i < this.codecChainWanted.length; ++i) {
                    Log.error("      " + this.codecChainWanted[i]);
                }
            }
            if (this.rendererWanted != null) {
                Log.error("    Unable to add customed renderer: " + this.rendererWanted);
            }
            Log.write("\n");
        }

        @Override
        protected ProgressControl progressControl() {
            return ProcessEngine.this.progressControl;
        }

        @Override
        public void setCodecChain(Codec[] codec) throws NotConfiguredError, UnsupportedPlugInException {
            if (this.engine.getState() > 180) {
                ProcessEngine.this.throwError(new NotConfiguredError("Cannot set a PlugIn before reaching the configured state."));
            }
            if (codec.length < 1) {
                throw new UnsupportedPlugInException("No codec specified in the array.");
            }
            this.codecChainWanted = new Codec[codec.length];
            for (int i = 0; i < codec.length; ++i) {
                this.codecChainWanted[i] = codec[i];
            }
        }

        @Override
        public Format setFormat(Format format) {
            if (this.engine.getState() > 180) {
                return this.getFormat();
            }
            if (format == null || format.matches(this.track.getFormat())) {
                return format;
            }
            this.formatWanted = this.checkSize(format);
            return this.formatWanted;
        }

        @Override
        public void setRenderer(Renderer renderer) throws NotConfiguredError {
            if (this.engine.getState() > 180) {
                ProcessEngine.this.throwError(new NotConfiguredError("Cannot set a PlugIn before reaching the configured state."));
            }
            this.rendererWanted = renderer;
            if (renderer instanceof SlowPlugIn) {
                ((SlowPlugIn)((Object)renderer)).forceToUse();
            }
        }

        Format[] verifyMuxInputs(ContentDescriptor cd, Format[] inputs) {
            if (cd == null || "raw".equals(cd.getEncoding())) {
                return inputs;
            }
            Vector cnames = PlugInManager.getPlugInList(null, cd, 5);
            if (cnames == null || cnames.size() == 0) {
                return new Format[0];
            }
            Multiplexer[] mux = new Multiplexer[cnames.size()];
            int total = 0;
            for (int i = 0; i < cnames.size(); ++i) {
                Multiplexer m = (Multiplexer)SimpleGraphBuilder.createPlugIn((String)cnames.elementAt(i), 5);
                if (m == null) continue;
                try {
                    m.setContentDescriptor(ProcessEngine.this.outputContentDes);
                }
                catch (Exception e) {
                    continue;
                }
                if (m.setNumTracks(1) < 1) continue;
                mux[total++] = m;
            }
            Format[] tmp = new Format[inputs.length];
            int vtotal = 0;
            block3: for (int i = 0; i < inputs.length; ++i) {
                Format fmt;
                if (total == 1) {
                    fmt = mux[0].setInputFormat(inputs[i], 0);
                    if (fmt == null) continue;
                    tmp[vtotal++] = fmt;
                    continue;
                }
                for (int j = 0; j < total; ++j) {
                    fmt = mux[j].setInputFormat(inputs[i], 0);
                    if (fmt == null) continue;
                    tmp[vtotal++] = fmt;
                    continue block3;
                }
            }
            Format[] verified = new Format[vtotal];
            System.arraycopy(tmp, 0, verified, 0, vtotal);
            return verified;
        }
    }

    class ProcGraphBuilder
    extends SimpleGraphBuilder {
        protected ProcessEngine engine;
        protected Format targetFormat;
        protected int trackID = 0;
        protected int numTracks = 1;
        protected int nodesVisited = 0;
        Codec[] codecs = null;
        Renderer rend = null;
        Format format = null;

        ProcGraphBuilder(ProcessEngine engine) {
            this.engine = engine;
        }

        GraphNode buildCustomGraph(Format in) {
            Vector<GraphNode> candidates = new Vector<GraphNode>();
            Object n = null;
            GraphNode node = new GraphNode(null, null, in, null, 0);
            candidates.addElement(node);
            Log.comment("Custom options specified.");
            this.indent = 1;
            Log.setIndent(this.indent);
            if (this.codecs != null) {
                this.resetTargets();
                for (int i = 0; i < this.codecs.length; ++i) {
                    if (this.codecs[i] == null) continue;
                    Log.comment("A custom codec is specified: " + this.codecs[i]);
                    this.setTargetPlugin(this.codecs[i], 2);
                    node = this.buildGraph(candidates);
                    if (node == null) {
                        Log.error("The input format is not compatible with the given codec plugin: " + this.codecs[i]);
                        this.indent = 0;
                        Log.setIndent(this.indent);
                        return null;
                    }
                    node.level = 0;
                    candidates = new Vector();
                    candidates.addElement(node);
                }
            }
            if (ProcessEngine.this.outputContentDes != null) {
                this.resetTargets();
                if (this.format != null) {
                    this.targetFormat = this.format;
                    Log.comment("An output format is specified: " + this.format);
                }
                if (!this.setDefaultTargetMux()) {
                    return null;
                }
                node = this.buildGraph(candidates);
                if (node == null) {
                    Log.error("Failed to build a graph for the given custom options.");
                    this.indent = 0;
                    Log.setIndent(this.indent);
                    return null;
                }
            } else {
                if (this.format != null) {
                    this.resetTargets();
                    this.targetFormat = this.format;
                    Log.comment("An output format is specified: " + this.format);
                    node = this.buildGraph(candidates);
                    if (node == null) {
                        Log.error("The input format cannot be transcoded to the specified target format.");
                        this.indent = 0;
                        Log.setIndent(this.indent);
                        return null;
                    }
                    node.level = 0;
                    candidates = new Vector();
                    candidates.addElement(node);
                    this.targetFormat = null;
                }
                if (this.rend != null) {
                    Log.comment("A custom renderer is specified: " + this.rend);
                    this.setTargetPlugin(this.rend, 4);
                    node = this.buildGraph(candidates);
                    if (node == null) {
                        if (this.format != null) {
                            Log.error("The customed transocoded format is not compatible with the given renderer plugin: " + this.rend);
                        } else {
                            Log.error("The input format is not compatible with the given renderer plugin: " + this.rend);
                        }
                        this.indent = 0;
                        Log.setIndent(this.indent);
                        return null;
                    }
                } else {
                    if (!this.setDefaultTargetRenderer(this.format == null ? in : this.format)) {
                        return null;
                    }
                    node = this.buildGraph(candidates);
                    if (node == null) {
                        if (this.format != null) {
                            Log.error("Failed to find a renderer that supports the customed transcoded format.");
                        } else {
                            Log.error("Failed to build a graph to render the input format with the given custom options.");
                        }
                        this.indent = 0;
                        Log.setIndent(this.indent);
                        return null;
                    }
                }
            }
            this.indent = 0;
            Log.setIndent(this.indent);
            return node;
        }

        boolean buildCustomGraph(ProcTControl tc) {
            GraphNode failed;
            GraphNode node;
            this.codecs = tc.codecChainWanted;
            this.rend = tc.rendererWanted;
            this.format = tc.formatWanted;
            if (this.format instanceof VideoFormat && tc.getOriginalFormat() instanceof VideoFormat) {
                Dimension s1 = ((VideoFormat)tc.getOriginalFormat()).getSize();
                Dimension s2 = ((VideoFormat)this.format).getSize();
                if (s1 != null && s2 != null && !s1.equals(s2)) {
                    RGBScaler scaler = new RGBScaler(s2);
                    if (this.codecs == null || this.codecs.length == 0) {
                        this.codecs = new Codec[1];
                        this.codecs[0] = scaler;
                    } else {
                        int i;
                        this.codecs = new Codec[tc.codecChainWanted.length + 1];
                        if (!PlaybackEngine.isRawVideo(this.format)) {
                            this.codecs[0] = scaler;
                            i = 1;
                        } else {
                            this.codecs[tc.codecChainWanted.length] = scaler;
                            i = 0;
                        }
                        for (int j = 0; j < tc.codecChainWanted.length; ++j) {
                            this.codecs[i++] = tc.codecChainWanted[j];
                        }
                    }
                }
            }
            return (node = this.buildCustomGraph(tc.getOriginalFormat())) != null && (failed = this.buildTrackFromGraph(tc, node)) == null;
        }

        boolean buildGraph(BasicTrackControl tc, int trackID, int numTracks) {
            this.trackID = trackID;
            this.numTracks = numTracks;
            if (tc.isCustomized()) {
                Log.comment("Input: " + tc.getOriginalFormat());
                return this.buildCustomGraph((ProcTControl)tc);
            }
            return super.buildGraph(tc);
        }

        @Override
        protected GraphNode buildTrackFromGraph(BasicTrackControl tc, GraphNode node) {
            return this.engine.buildTrackFromGraph(tc, node);
        }

        void doGetSupportedOutputFormats(Vector candidates, Vector collected) {
            Format input;
            Format[] outs;
            GraphNode node = (GraphNode)candidates.firstElement();
            candidates.removeElementAt(0);
            if (!(node.input != null || node.plugin != null && node.plugin instanceof Codec)) {
                Log.error("Internal error: doGetSupportedOutputFormats");
                return;
            }
            if (node.plugin != null && ProcGraphBuilder.verifyInput(node.plugin, node.input) == null) {
                return;
            }
            if (node.plugin != null) {
                outs = node.getSupportedOutputs(node.input);
                if (outs == null || outs.length == 0) {
                    return;
                }
                for (int j = 0; j < outs.length; ++j) {
                    int size = collected.size();
                    boolean found = false;
                    for (int k = 0; k < size; ++k) {
                        Format other = (Format)collected.elementAt(k);
                        if (other != outs[j] && !other.equals(outs[j])) continue;
                        found = true;
                        break;
                    }
                    if (found) continue;
                    collected.addElement(outs[j]);
                }
                input = node.input;
            } else {
                outs = new Format[]{node.input};
                input = null;
            }
            if (node.level >= this.STAGES) {
                return;
            }
            for (int i = 0; i < outs.length; ++i) {
                Vector cnames;
                if (input != null && input.equals(outs[i]) || node.plugin != null && ProcGraphBuilder.verifyOutput(node.plugin, outs[i]) == null || (cnames = PlugInManager.getPlugInList(outs[i], null, 2)) == null || cnames.size() == 0) continue;
                for (int j = 0; j < cnames.size(); ++j) {
                    Format[] ins;
                    Format fmt;
                    GraphNode gn = ProcGraphBuilder.getPlugInNode((String)cnames.elementAt(j), 2, this.plugIns);
                    if (gn == null || gn.checkAttempted(outs[i]) || (fmt = ProcGraphBuilder.matches(outs[i], ins = gn.getSupportedInputs(), null, gn.plugin)) == null) continue;
                    GraphNode n = new GraphNode(gn, fmt, node, node.level + 1);
                    candidates.addElement(n);
                    ++this.nodesVisited;
                }
            }
        }

        @Override
        protected GraphNode findTarget(GraphNode node) {
            GraphNode n;
            Format[] outs;
            if (node.plugin == null) {
                outs = new Format[]{node.input};
            } else if (node.output != null) {
                outs = new Format[]{node.output};
            } else {
                outs = node.getSupportedOutputs(node.input);
                if (outs == null || outs.length == 0) {
                    return null;
                }
            }
            if (this.targetFormat != null) {
                Format matched = null;
                matched = ProcGraphBuilder.matches(outs, this.targetFormat, node.plugin, null);
                if (matched == null) {
                    return null;
                }
                if (inspector != null && !inspector.verify((Codec)node.plugin, node.input, matched)) {
                    return null;
                }
                if (this.targetPlugins == null && ProcessEngine.this.targetMuxes == null) {
                    node.output = matched;
                    return node;
                }
                outs = new Format[]{matched};
            }
            if (this.targetPlugins != null) {
                n = this.verifyTargetPlugins(node, outs);
                if (n != null) {
                    return n;
                }
                return null;
            }
            if (ProcessEngine.this.targetMuxes != null && (n = this.verifyTargetMuxes(node, outs)) != null) {
                return n;
            }
            return null;
        }

        public Format[] getSupportedOutputFormats(Format input) {
            long formatsTime = System.currentTimeMillis();
            Vector<Format> collected = new Vector<Format>();
            Vector<GraphNode> candidates = new Vector<GraphNode>();
            GraphNode node = new GraphNode(null, null, input, null, 0);
            candidates.addElement(node);
            collected.addElement(input);
            ++this.nodesVisited;
            while (!candidates.isEmpty()) {
                this.doGetSupportedOutputFormats(candidates, collected);
            }
            Format[] all = new Format[collected.size()];
            int front = 0;
            int back = all.length - 1;
            AudioFormat mpegAudio = new AudioFormat("mpegaudio/rtp");
            boolean mpegInput = new AudioFormat("mpegaudio").matches(input) || new AudioFormat("mpeglayer3").matches(input) || new VideoFormat("mpeg").matches(input);
            for (int i = 0; i < all.length; ++i) {
                Object obj = collected.elementAt(i);
                if (!mpegInput && ((Format)mpegAudio).matches((Format)obj)) {
                    all[back--] = (Format)obj;
                    continue;
                }
                all[front++] = (Format)obj;
            }
            Log.comment("Getting the supported output formats for:");
            Log.comment("  " + input);
            Log.comment("  # of nodes visited: " + this.nodesVisited);
            Log.comment("  # of formats supported: " + all.length + "\n");
            PlaybackEngine.profile("getSupportedOutputFormats", formatsTime);
            return all;
        }

        @Override
        public void reset() {
            super.reset();
            this.resetTargets();
        }

        void resetTargets() {
            this.targetFormat = null;
            this.targetPlugins = null;
        }

        boolean setDefaultTargetMux() {
            if (ProcessEngine.this.targetMuxes != null) {
                return true;
            }
            Log.comment("An output content type is specified: " + ProcessEngine.this.outputContentDes);
            ProcessEngine.this.targetMuxNames = PlugInManager.getPlugInList(null, ProcessEngine.this.outputContentDes, 5);
            if (ProcessEngine.this.targetMuxNames == null || ProcessEngine.this.targetMuxNames.size() == 0) {
                Log.error("No multiplexer is found for that content type: " + ProcessEngine.this.outputContentDes);
                return false;
            }
            ProcessEngine.this.targetMuxes = new GraphNode[ProcessEngine.this.targetMuxNames.size()];
            ProcessEngine.this.targetMux = null;
            ProcessEngine.this.targetMuxFormats = new Format[this.numTracks];
            this.targetPluginNames = null;
            this.targetPlugins = null;
            return true;
        }

        @Override
        protected boolean setDefaultTargetRenderer(Format in) {
            if (!super.setDefaultTargetRenderer(in)) {
                return false;
            }
            ProcessEngine.this.targetMuxes = null;
            return true;
        }

        @Override
        protected boolean setDefaultTargets(Format in) {
            if (ProcessEngine.this.outputContentDes != null) {
                return this.setDefaultTargetMux();
            }
            return this.setDefaultTargetRenderer(in);
        }

        void setTargetPlugin(PlugIn p, int type) {
            this.targetPlugins = new GraphNode[1];
            this.targetPlugins[0] = new GraphNode(p, null, null, 0);
            this.targetPlugins[0].custom = true;
            this.targetPlugins[0].type = type;
        }

        GraphNode verifyTargetMuxes(GraphNode node, Format[] outs) {
            for (int i = 0; i < ProcessEngine.this.targetMuxes.length; ++i) {
                GraphNode gn = ProcessEngine.this.targetMuxes[i];
                if (gn == null) {
                    String name = (String)ProcessEngine.this.targetMuxNames.elementAt(i);
                    if (name == null) continue;
                    gn = ProcGraphBuilder.getPlugInNode(name, 5, this.plugIns);
                    if (gn == null) {
                        ProcessEngine.this.targetMuxNames.setElementAt(null, i);
                        continue;
                    }
                    Multiplexer mux = (Multiplexer)gn.plugin;
                    if (mux.setContentDescriptor(ProcessEngine.this.outputContentDes) == null) {
                        ProcessEngine.this.targetMuxNames.setElementAt(null, i);
                        continue;
                    }
                    if (mux.setNumTracks(this.numTracks) != this.numTracks) {
                        ProcessEngine.this.targetMuxNames.setElementAt(null, i);
                        continue;
                    }
                    ProcessEngine.this.targetMuxes[i] = gn;
                }
                if (ProcessEngine.this.targetMux != null && gn != ProcessEngine.this.targetMux) continue;
                for (int j = 0; j < outs.length; ++j) {
                    Format fmt = ((Multiplexer)gn.plugin).setInputFormat(outs[j], this.trackID);
                    if (fmt == null || inspector != null && node.plugin != null && !inspector.verify((Codec)node.plugin, node.input, fmt)) continue;
                    ProcessEngine.this.targetMux = gn;
                    ProcessEngine.this.targetMuxFormats[this.trackID] = fmt;
                    node.output = fmt;
                    return node;
                }
            }
            return null;
        }
    }
}

