/*
 * Decompiled with CFR 0.152.
 */
package org.jitsi.impl.neomedia.transform.fec;

import java.util.Comparator;
import java.util.HashSet;
import java.util.Map;
import java.util.Set;
import java.util.SortedMap;
import java.util.TreeMap;
import org.jitsi.impl.neomedia.RawPacket;
import org.jitsi.impl.neomedia.transform.PacketTransformer;
import org.jitsi.service.configuration.ConfigurationService;
import org.jitsi.service.libjitsi.LibJitsi;
import org.jitsi.util.Logger;

class FECReceiver
implements PacketTransformer {
    private static final Logger logger = Logger.getLogger(FECReceiver.class);
    private static final Comparator<? super Integer> seqNumComparator = new Comparator<Integer>(){

        @Override
        public int compare(Integer a, Integer b) {
            if (a.equals(b)) {
                return 0;
            }
            if (a > b) {
                if (a - b < 32768) {
                    return 1;
                }
                return -1;
            }
            if (b - a < 32768) {
                return -1;
            }
            return 1;
        }
    };
    private int nbFec = 0;
    private int nbRecovered = 0;
    private long ssrc;
    private static final int MEDIA_BUF_SIZE;
    private static final int FEC_BUF_SIZE;
    private static final String MEDIA_BUF_SIZE_PNAME;
    private static final String FEC_BUF_SIZE_PNAME;
    private final SortedMap<Integer, RawPacket> mediaPackets = new TreeMap<Integer, RawPacket>(seqNumComparator);
    private final SortedMap<Integer, RawPacket> fecPackets = new TreeMap<Integer, RawPacket>(seqNumComparator);
    private final Reconstructor reconstructor;
    private final Set<RawPacket> packetsToRemove = new HashSet<RawPacket>();
    private boolean handleFec = true;
    private byte ulpfecPT;

    FECReceiver(long ssrc, byte ulpfecPT) {
        this.ssrc = ssrc;
        this.ulpfecPT = ulpfecPT;
        this.reconstructor = new Reconstructor(this.mediaPackets, ssrc);
        if (logger.isInfoEnabled()) {
            logger.info("New FECReceiver for SSRC=" + ssrc);
        }
    }

    @Override
    public RawPacket[] transform(RawPacket[] pkts) {
        return pkts;
    }

    @Override
    public synchronized RawPacket[] reverseTransform(RawPacket[] pkts) {
        for (int i = 0; i < pkts.length; ++i) {
            RawPacket pkt = pkts[i];
            if (pkt == null) continue;
            if (pkt.getPayloadType() == this.ulpfecPT) {
                ++this.nbFec;
                pkts[i] = null;
                if (!this.handleFec) continue;
                this.saveFec(pkt);
                continue;
            }
            if (!this.handleFec) continue;
            this.saveMedia(pkt);
        }
        if (this.handleFec) {
            this.packetsToRemove.clear();
            for (Map.Entry<Integer, RawPacket> entry : this.fecPackets.entrySet()) {
                RawPacket fecPacket = entry.getValue();
                this.reconstructor.setFecPacket(fecPacket);
                if (this.reconstructor.numMissing == 0) {
                    this.packetsToRemove.add(fecPacket);
                    continue;
                }
                if (!this.reconstructor.canRecover()) continue;
                this.packetsToRemove.add(fecPacket);
                RawPacket recovered = this.reconstructor.recover();
                if (recovered == null) continue;
                ++this.nbRecovered;
                this.saveMedia(recovered);
                boolean found = false;
                for (int i = 0; i < pkts.length; ++i) {
                    if (pkts[i] != null) continue;
                    pkts[i] = recovered;
                    found = true;
                    break;
                }
                if (found) continue;
                RawPacket[] pkts2 = new RawPacket[pkts.length + 1];
                System.arraycopy(pkts, 0, pkts2, 0, pkts.length);
                pkts2[pkts.length] = recovered;
                pkts = pkts2;
            }
            for (RawPacket p : this.packetsToRemove) {
                this.fecPackets.remove(p.getSequenceNumber());
            }
        }
        return pkts;
    }

    @Override
    public void close() {
        if (logger.isInfoEnabled()) {
            logger.info("Closing FECReceiver for SSRC=" + this.ssrc + ". Received " + this.nbFec + " ulpfec packets, recovered " + this.nbRecovered + " media packets.");
        }
    }

    public void setUlpfecPT(byte ulpfecPT) {
        this.ulpfecPT = ulpfecPT;
    }

    private void saveFec(RawPacket p) {
        if (this.fecPackets.size() >= FEC_BUF_SIZE) {
            this.fecPackets.remove(this.fecPackets.firstKey());
        }
        this.fecPackets.put(p.getSequenceNumber(), p);
    }

    private void saveMedia(RawPacket p) {
        RawPacket newMedia;
        if (this.mediaPackets.size() < MEDIA_BUF_SIZE) {
            newMedia = new RawPacket();
            newMedia.setBuffer(new byte[1500]);
            newMedia.setOffset(0);
        } else {
            newMedia = (RawPacket)this.mediaPackets.remove(this.mediaPackets.firstKey());
        }
        int pLen = p.getLength();
        if (pLen > newMedia.getBuffer().length) {
            newMedia.setBuffer(new byte[pLen]);
        }
        System.arraycopy(p.getBuffer(), p.getOffset(), newMedia.getBuffer(), 0, pLen);
        newMedia.setLength(pLen);
        this.mediaPackets.put(newMedia.getSequenceNumber(), newMedia);
    }

    static {
        MEDIA_BUF_SIZE_PNAME = FECReceiver.class.getName() + ".MEDIA_BUFF_SIZE";
        FEC_BUF_SIZE_PNAME = FECReceiver.class.getName() + ".FEC_BUFF_SIZE";
        ConfigurationService cfg = LibJitsi.getConfigurationService();
        int fecBufSize = 32;
        int mediaBufSize = 64;
        if (cfg != null) {
            fecBufSize = cfg.getInt(FEC_BUF_SIZE_PNAME, fecBufSize);
            mediaBufSize = cfg.getInt(MEDIA_BUF_SIZE_PNAME, mediaBufSize);
        }
        FEC_BUF_SIZE = fecBufSize;
        MEDIA_BUF_SIZE = mediaBufSize;
    }

    private static class Reconstructor {
        private Set<RawPacket> neededPackets = new HashSet<RawPacket>();
        private RawPacket fecPacket = null;
        private int numMissing = -1;
        private int sequenceNumber = -1;
        private long ssrc;
        private Map<Integer, RawPacket> mediaPackets;

        Reconstructor(Map<Integer, RawPacket> mediaPackets, long ssrc) {
            this.mediaPackets = mediaPackets;
            this.ssrc = ssrc;
        }

        private boolean canRecover() {
            return this.numMissing == 1;
        }

        private void setFecPacket(RawPacket p) {
            this.neededPackets.clear();
            this.numMissing = 0;
            this.sequenceNumber = -1;
            this.fecPacket = p;
            byte[] buf = this.fecPacket.getBuffer();
            int idx = this.fecPacket.getOffset() + this.fecPacket.getHeaderLength();
            int maskLen = (buf[idx] & 0x40) == 0 ? 2 : 6;
            int base = this.fecPacket.readUint16AsInt(this.fecPacket.getHeaderLength() + 2);
            idx += 12;
            block0: for (int i = 0; i < maskLen; ++i) {
                for (int j = 0; j < 8; ++j) {
                    if ((buf[idx + i] & (1 << 7 - j & 0xFF)) != 0) {
                        RawPacket pkt = this.mediaPackets.get(base + i * 8 + j);
                        if (pkt != null) {
                            this.neededPackets.add(pkt);
                        } else {
                            this.sequenceNumber = base + i * 8 + j;
                            ++this.numMissing;
                        }
                    }
                    if (this.numMissing > 1) break block0;
                }
            }
            if (this.numMissing != 1) {
                this.sequenceNumber = -1;
            }
        }

        private RawPacket recover() {
            int protectionLength;
            if (!this.canRecover()) {
                return null;
            }
            byte[] fecBuf = this.fecPacket.getBuffer();
            int idx = this.fecPacket.getOffset() + this.fecPacket.getHeaderLength();
            int lengthRecovery = (fecBuf[idx + 8] & 0xFF) << 8 | fecBuf[idx + 9] & 0xFF;
            for (RawPacket rawPacket : this.neededPackets) {
                lengthRecovery ^= rawPacket.getLength() - 12;
            }
            byte[] recoveredBuf = new byte[(lengthRecovery &= 0xFFFF) + 12];
            System.arraycopy(fecBuf, idx, recoveredBuf, 0, 8);
            for (RawPacket p : this.neededPackets) {
                int pOffset = p.getOffset();
                byte[] pBuf = p.getBuffer();
                for (int i = 0; i < 8; ++i) {
                    int n = i;
                    recoveredBuf[n] = (byte)(recoveredBuf[n] ^ pBuf[pOffset + i]);
                }
            }
            recoveredBuf[0] = (byte)(recoveredBuf[0] & 0x3F);
            recoveredBuf[0] = (byte)(recoveredBuf[0] | 0x80);
            boolean bl = (fecBuf[idx] & 0x40) != 0;
            if ((protectionLength = (fecBuf[idx += 10] & 0xFF) << 8 | fecBuf[idx + 1] & 0xFF) < lengthRecovery) {
                logger.warn("Recovered only a partial RTP packet. Discarding.");
                return null;
            }
            idx += 4;
            if (bl) {
                idx += 4;
            }
            System.arraycopy(fecBuf, idx, recoveredBuf, 12, lengthRecovery);
            for (RawPacket p : this.neededPackets) {
                byte[] pBuf = p.getBuffer();
                int pLen = p.getLength();
                int pOff = p.getOffset();
                for (int i = 12; i < lengthRecovery + 12 && i < pLen; ++i) {
                    int n = i;
                    recoveredBuf[n] = (byte)(recoveredBuf[n] ^ pBuf[pOff + i]);
                }
            }
            RawPacket recovered = new RawPacket(recoveredBuf, 0, lengthRecovery + 12);
            recovered.setSSRC((int)this.ssrc);
            recovered.setSequenceNumber(this.sequenceNumber);
            return recovered;
        }
    }
}

