/*
 * Decompiled with CFR 0.152.
 */
package net.java.sip.communicator.impl.replacement.metacafe;

import java.util.regex.Matcher;
import java.util.regex.Pattern;
import net.java.sip.communicator.service.replacement.ReplacementService;
import net.java.sip.communicator.util.Logger;

public class ReplacementServiceMetacafeImpl
implements ReplacementService {
    private static final Logger logger = Logger.getLogger(ReplacementServiceMetacafeImpl.class);
    public static final String METACAFE_PATTERN = "(https?\\:\\/\\/(www\\.)*?metacafe\\.com\\/watch\\/([a-zA-Z0-9_\\-]+))(\\/[a-zA-Z0-9_\\-\\/]+)*";
    public static final String METACAFE_CONFIG_LABEL = "Metacafe";
    public static final String SOURCE_NAME = "METACAFE";

    public ReplacementServiceMetacafeImpl() {
        logger.trace((Object)"Creating a Metacafe Source.");
    }

    public String getReplacement(String sourceString) {
        Pattern p = Pattern.compile("\\/watch\\/([a-zA-Z0-9_\\-]+)(\\/[a-zA-Z0-9_\\-\\/]+)*", 34);
        Matcher m = p.matcher(sourceString);
        String thumbUrl = sourceString;
        while (m.find()) {
            thumbUrl = "http://www.metacafe.com/thumb/" + m.group(1) + ".jpg";
        }
        return thumbUrl;
    }

    public String getSourceName() {
        return SOURCE_NAME;
    }

    public String getPattern() {
        return METACAFE_PATTERN;
    }
}

