/*
 * Decompiled with CFR 0.152.
 */
package net.java.sip.communicator.slick.protocol.jabber;

import java.util.List;
import java.util.Map;
import junit.framework.Test;
import junit.framework.TestCase;
import junit.framework.TestSuite;
import net.java.sip.communicator.service.protocol.ChatRoom;
import net.java.sip.communicator.service.protocol.OperationSetMultiUserChat;
import net.java.sip.communicator.service.protocol.OperationSetPresence;
import net.java.sip.communicator.service.protocol.event.ChatRoomMemberPresenceChangeEvent;
import net.java.sip.communicator.service.protocol.event.ChatRoomMemberPresenceListener;
import net.java.sip.communicator.slick.protocol.jabber.JabberSlickFixture;
import net.java.sip.communicator.util.Logger;

public class TestOperationSetMultiUserChat
extends TestCase {
    private static final Logger logger = Logger.getLogger(TestOperationSetMultiUserChat.class);
    private JabberSlickFixture fixture = new JabberSlickFixture();
    private OperationSetPresence opSetPresence1 = null;
    private OperationSetPresence opSetPresence2 = null;
    private OperationSetMultiUserChat opSetMultiChat1 = null;
    private OperationSetMultiUserChat opSetMultiChat2 = null;

    public TestOperationSetMultiUserChat(String name) {
        super(name);
    }

    public static Test suite() {
        TestSuite suite = new TestSuite();
        suite.addTest((Test)new TestOperationSetMultiUserChat("testCreateChatRoom"));
        suite.addTest((Test)new TestOperationSetMultiUserChat("testGetExistingChatRooms"));
        suite.addTest((Test)new TestOperationSetMultiUserChat("testFindRoom"));
        suite.addTest((Test)new TestOperationSetMultiUserChat("testOurJoin"));
        suite.addTest((Test)new TestOperationSetMultiUserChat("testGetMembersAfterJoin"));
        suite.addTest((Test)new TestOperationSetMultiUserChat("testParticipantJoin"));
        suite.addTest((Test)new TestOperationSetMultiUserChat("testSendAndReceiveMessages"));
        suite.addTest((Test)new TestOperationSetMultiUserChat("testParticipantLeave"));
        suite.addTest((Test)new TestOperationSetMultiUserChat("testGetMembersAfterParticipantLeave"));
        suite.addTest((Test)new TestOperationSetMultiUserChat("testOurLeave"));
        return suite;
    }

    protected void setUp() throws Exception {
        super.setUp();
        this.fixture.setUp();
        Map supportedOperationSets1 = this.fixture.provider1.getSupportedOperationSets();
        if (supportedOperationSets1 == null || supportedOperationSets1.size() < 1) {
            throw new NullPointerException("No OperationSet implementations are supported by this implementation. ");
        }
        this.opSetMultiChat1 = (OperationSetMultiUserChat)supportedOperationSets1.get(OperationSetMultiUserChat.class.getName());
        if (this.opSetMultiChat1 == null) {
            throw new NullPointerException("No implementation for multi user chat was found");
        }
        this.opSetPresence1 = (OperationSetPresence)supportedOperationSets1.get(OperationSetPresence.class.getName());
        if (this.opSetPresence1 == null) {
            throw new NullPointerException("An implementation of the service must provide an implementation of at least one of the PresenceOperationSets");
        }
        Map supportedOperationSets2 = this.fixture.provider2.getSupportedOperationSets();
        if (supportedOperationSets2 == null || supportedOperationSets2.size() < 1) {
            throw new NullPointerException("No OperationSet implementations are supported by this implementation. ");
        }
        this.opSetMultiChat2 = (OperationSetMultiUserChat)supportedOperationSets2.get(OperationSetMultiUserChat.class.getName());
        if (this.opSetMultiChat2 == null) {
            throw new NullPointerException("No implementation for multi user chat was found");
        }
        this.opSetPresence2 = (OperationSetPresence)supportedOperationSets2.get(OperationSetPresence.class.getName());
        if (this.opSetPresence2 == null) {
            throw new NullPointerException("An implementation of the service must provide an implementation of at least one of the PresenceOperationSets");
        }
    }

    protected void tearDown() throws Exception {
        super.tearDown();
        this.fixture.tearDown();
    }

    public void testCreateChatRoom() throws Exception {
        ChatRoom testChatRoom = this.opSetMultiChat1.createChatRoom(this.fixture.chatRoomName, null);
        TestOperationSetMultiUserChat.assertNotNull((String)"createChatRoom() returned null", (Object)testChatRoom);
        TestOperationSetMultiUserChat.assertEquals((String)"The name of the chat room that was created did not match the name that we wanted to have", (String)this.fixture.chatRoomName, (String)testChatRoom.getName());
        TestOperationSetMultiUserChat.assertSame((String)"The newly created chat room did not had a properly set provider.", (Object)this.fixture.provider1, (Object)testChatRoom.getParentProvider());
    }

    public void testGetExistingChatRooms() throws Exception {
        List existingChatRooms = this.opSetMultiChat1.getExistingChatRooms();
        TestOperationSetMultiUserChat.assertTrue((String)"No chat rooms found on the server, even after we have created one. ", (existingChatRooms.size() > 0 ? 1 : 0) != 0);
        logger.info((Object)("Server returned the following list of chat rooms: " + existingChatRooms));
        boolean testRoomFound = false;
        for (String roomName : existingChatRooms) {
            if (!roomName.equals(this.fixture.chatRoomName)) continue;
            testRoomFound = true;
        }
        TestOperationSetMultiUserChat.assertTrue((String)("The room we created in previous tests " + this.fixture.chatRoomName + " was not among the existing rooms list returned by the provider."), (boolean)testRoomFound);
    }

    public void testFindRoom() throws Exception {
        ChatRoom testChatRoom = this.opSetMultiChat1.findRoom(this.fixture.chatRoomName);
        TestOperationSetMultiUserChat.assertNotNull((String)"Could not find the test chat room on the server", (Object)testChatRoom);
        String roomName = testChatRoom.getName();
        TestOperationSetMultiUserChat.assertEquals((String)"Name of the test chat room did not match the name of the room we created", (String)this.fixture.chatRoomName, (String)roomName);
    }

    public void testOurJoin() throws Exception {
        ChatRoom testChatRoom1 = this.opSetMultiChat1.findRoom(this.fixture.chatRoomName);
        testChatRoom1.join();
        testChatRoom1.getParentProvider();
        testChatRoom1.getUserNickname();
        testChatRoom1.isJoined();
    }

    public void testGetMembersAfterJoin() {
    }

    public void testParticipantJoin() throws Exception {
    }

    public void testSendAndReceiveMessages() throws Exception {
        ChatRoom testChatRoom = this.opSetMultiChat1.findRoom(this.fixture.chatRoomName);
        testChatRoom.sendMessage(testChatRoom.createMessage("opla"));
    }

    public void testParticipantLeave() {
    }

    public void testGetMembersAfterParticipantLeave() {
    }

    public void testOurLeave() {
    }

    private class ParticipantStatusEventCollector
    implements ChatRoomMemberPresenceListener {
        private ParticipantStatusEventCollector() {
        }

        public void memberPresenceChanged(ChatRoomMemberPresenceChangeEvent evt) {
        }
    }
}

