/*
 * Decompiled with CFR 0.152.
 */
package net.kano.joscar.tlv;

import java.util.List;
import net.kano.joscar.BinaryTools;
import net.kano.joscar.ByteBlock;
import net.kano.joscar.DefensiveTools;
import net.kano.joscar.tlv.DefaultMutableTlvChain;
import net.kano.joscar.tlv.ImmutableTlvChain;
import net.kano.joscar.tlv.MutableTlvChain;
import net.kano.joscar.tlv.Tlv;
import net.kano.joscar.tlv.TlvChain;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public final class TlvTools {
    private TlvTools() {
    }

    public static ImmutableTlvChain readChain(ByteBlock block) {
        return TlvTools.readChain(block, -1);
    }

    public static ImmutableTlvChain readChain(ByteBlock block, int maxTlvs) {
        return new ImmutableTlvChain(block, maxTlvs);
    }

    public static ImmutableTlvChain createChain(List<Tlv> tlvs, int offset, int len) {
        DefensiveTools.checkNull(tlvs, "tlvs");
        if (offset < 0 || len < 0 || offset + len > tlvs.size()) {
            throw new ArrayIndexOutOfBoundsException("offset=" + offset + ", len=" + len + ", tlvs.length=" + tlvs.size());
        }
        DefensiveTools.checkNullElements(tlvs, "tlvs", offset, len);
        return new ImmutableTlvChain(tlvs, offset, len);
    }

    public static MutableTlvChain createMutableChain() {
        return new DefaultMutableTlvChain();
    }

    public static MutableTlvChain getMutableCopy(TlvChain other) {
        return new DefaultMutableTlvChain(other);
    }

    public static ImmutableTlvChain getImmutableCopy(TlvChain other) {
        return new ImmutableTlvChain(other);
    }

    public static boolean isCompleteTlvChain(ByteBlock block) {
        int len = block.getLength();
        int i = 0;
        while (i < len) {
            int tlvlen;
            if (i + 3 >= len) {
                return false;
            }
            if ((i += 2 + (tlvlen = BinaryTools.getUShort(block, i + 2))) == len) {
                return true;
            }
            if (i <= len) continue;
            return false;
        }
        throw new IllegalStateException();
    }
}

